/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldHierarchyEvent;
import org.netbeans.api.editor.fold.FoldHierarchyListener;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.netbeans.modules.editor.lib2.view.ViewHierarchy;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyEvent;
import org.netbeans.modules.editor.lib2.view.ViewHierarchyListener;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class CodeFoldingSideBar
extends JComponent
implements Accessible {
    private static final Logger LOG = Logger.getLogger(CodeFoldingSideBar.class.getName());
    protected Color backColor;
    protected Color foreColor;
    protected Font font;
    protected JTextComponent component;
    private volatile AttributeSet attribs;
    private Lookup.Result<? extends FontColorSettings> fcsLookupResult;
    private final LookupListener fcsTracker = new LookupListener(){

        public void resultChanged(LookupEvent ev) {
            CodeFoldingSideBar.this.attribs = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CodeFoldingSideBar.this.updatePreferredSize();
                    CodeFoldingSideBar.this.repaint();
                }
            });
        }
    };
    private final Listener listener = new Listener();
    private boolean enabled = false;
    protected List<Mark> visibleMarks = new ArrayList<Mark>();
    public static final int PAINT_NOOP = 0;
    public static final int PAINT_MARK = 1;
    public static final int PAINT_LINE = 2;
    public static final int PAINT_END_MARK = 3;
    public static final int SINGLE_PAINT_MARK = 4;
    private final Preferences prefs;
    private final PreferenceChangeListener prefsListener = new PreferenceChangeListener(){

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String key;
            String string = key = evt == null ? null : evt.getKey();
            if (key == null || "code-folding-enable".equals(key)) {
                CodeFoldingSideBar.this.updateColors();
                boolean newEnabled = CodeFoldingSideBar.this.prefs.getBoolean("code-folding-enable", true);
                if (CodeFoldingSideBar.this.enabled != newEnabled) {
                    CodeFoldingSideBar.this.enabled = newEnabled;
                    CodeFoldingSideBar.this.updatePreferredSize();
                }
            }
            SettingsConversions.callSettingsChange(CodeFoldingSideBar.this);
        }
    };

    private void checkRepaint(ViewHierarchyEvent vhe) {
        if (!vhe.isChangeY()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeFoldingSideBar.this.updatePreferredSize();
                CodeFoldingSideBar.this.repaint();
            }
        });
    }

    public CodeFoldingSideBar() {
        this.component = null;
        this.prefs = null;
        throw new IllegalStateException("Do not use this constructor!");
    }

    public CodeFoldingSideBar(JTextComponent component) {
        this.component = component;
        this.addMouseListener(this.listener);
        FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)component);
        foldHierarchy.addFoldHierarchyListener((FoldHierarchyListener)WeakListeners.create(FoldHierarchyListener.class, (EventListener)this.listener, (Object)foldHierarchy));
        Document doc = this.getDocument();
        doc.addDocumentListener(WeakListeners.document((DocumentListener)this.listener, (Object)doc));
        this.setOpaque(true);
        this.prefs = (Preferences)MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)component)).lookup(Preferences.class);
        this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this.prefsListener, (Object)this.prefs));
        this.prefsListener.preferenceChange(null);
        ViewHierarchy.get((JTextComponent)component).addViewHierarchyListener(new ViewHierarchyListener(){

            public void viewHierarchyChanged(ViewHierarchyEvent evt) {
                CodeFoldingSideBar.this.checkRepaint(evt);
            }
        });
    }

    private void updatePreferredSize() {
        if (this.enabled) {
            this.setPreferredSize(new Dimension(this.getColoring().getFont().getSize(), this.component.getHeight()));
            this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        } else {
            this.setPreferredSize(new Dimension(0, 0));
            this.setMaximumSize(new Dimension(0, 0));
        }
        this.revalidate();
    }

    private void updateColors() {
        Coloring c = this.getColoring();
        this.backColor = c.getBackColor();
        this.foreColor = c.getForeColor();
        this.font = c.getFont();
    }

    protected Color getBackColor() {
        if (this.backColor == null) {
            this.updateColors();
        }
        return this.backColor;
    }

    protected Color getForeColor() {
        if (this.foreColor == null) {
            this.updateColors();
        }
        return this.foreColor;
    }

    protected Font getColoringFont() {
        if (this.font == null) {
            this.updateColors();
        }
        return this.font;
    }

    @Override
    public void update(Graphics g) {
    }

    protected void collectPaintInfos(View rootView, Fold fold, Map<Integer, PaintInfo> map, int level, int startIndex, int endIndex) throws BadLocationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<? extends PaintInfo> getPaintInfo(Rectangle clip) throws BadLocationException {
        TextUI textUI = this.component.getUI();
        if (!(textUI instanceof BaseTextUI)) {
            return Collections.emptyList();
        }
        BaseTextUI baseTextUI = (BaseTextUI)textUI;
        BaseDocument bdoc = Utilities.getDocument(this.component);
        if (bdoc == null) {
            return Collections.emptyList();
        }
        bdoc.readLock();
        try {
            FoldHierarchy hierarchy;
            block17: {
                TreeMap<Integer, PaintInfo> map;
                block18: {
                    List<PaintInfo> list;
                    int startPos = baseTextUI.getPosFromY(clip.y);
                    int endPos = baseTextUI.viewToModel(this.component, 16383, clip.y + clip.height);
                    if (startPos < 0 || endPos < 0) {
                        List list2 = Collections.emptyList();
                        return list2;
                    }
                    startPos = Utilities.getRowStart(bdoc, startPos);
                    endPos = Utilities.getRowEnd(bdoc, endPos);
                    hierarchy = FoldHierarchy.get((JTextComponent)this.component);
                    hierarchy.lock();
                    try {
                        Fold fold;
                        int i;
                        View rootView = Utilities.getDocumentView(this.component);
                        if (rootView == null) break block17;
                        Object[] arr = CodeFoldingSideBar.getFoldList(hierarchy.getRootFold(), startPos, endPos);
                        List foldList = (List)arr[0];
                        int idxOfFirstFoldStartingInsideClip = (Integer)arr[1];
                        map = new TreeMap<Integer, PaintInfo>();
                        for (i = idxOfFirstFoldStartingInsideClip - 1; i >= 0 && this.traverseBackwards(fold = (Fold)foldList.get(i), bdoc, baseTextUI, startPos, endPos, 0, map); --i) {
                        }
                        for (i = idxOfFirstFoldStartingInsideClip; i < foldList.size() && this.traverseForward(fold = (Fold)foldList.get(i), bdoc, baseTextUI, startPos, endPos, 0, map); ++i) {
                        }
                        if (!map.isEmpty() || foldList.size() <= 0) break block18;
                        assert (foldList.size() == 1);
                        list = Collections.singletonList(new PaintInfo(2, 0, clip.y, clip.height, -1, -1));
                    }
                    catch (Throwable throwable) {
                        hierarchy.unlock();
                        throw throwable;
                    }
                    hierarchy.unlock();
                    return list;
                }
                ArrayList arrayList = new ArrayList(map.values());
                hierarchy.unlock();
                return arrayList;
            }
            List list = Collections.emptyList();
            hierarchy.unlock();
            return list;
        }
        finally {
            bdoc.readUnlock();
        }
    }

    private void addPaintInfo(Map<Integer, PaintInfo> infos, int yOffset, PaintInfo nextInfo) {
        PaintInfo prevInfo = infos.get(yOffset);
        nextInfo.mergeWith(prevInfo);
        infos.put(yOffset, nextInfo);
    }

    private boolean traverseForward(Fold f, BaseDocument doc, BaseTextUI btui, int lowerBoundary, int upperBoundary, int level, Map<Integer, PaintInfo> infos) throws BadLocationException {
        if (f.getStartOffset() > upperBoundary) {
            return false;
        }
        int lineStartOffset1 = Utilities.getRowStart(doc, f.getStartOffset());
        int lineStartOffset2 = Utilities.getRowStart(doc, f.getEndOffset());
        int y1 = btui.getYFromPos(lineStartOffset1);
        int h = btui.getEditorUI().getLineHeight();
        int y2 = btui.getYFromPos(lineStartOffset2);
        if (y1 == y2) {
            this.addPaintInfo(infos, y1, new PaintInfo(4, level, y1, h, f.isCollapsed(), lineStartOffset1, lineStartOffset2));
        } else {
            this.addPaintInfo(infos, y1, new PaintInfo(1, level, y1, h, f.isCollapsed(), lineStartOffset1, lineStartOffset2));
        }
        if (y1 != y2 && !f.isCollapsed() && f.getEndOffset() <= upperBoundary) {
            this.addPaintInfo(infos, y2, new PaintInfo(3, level, y2, h, lineStartOffset1, lineStartOffset2));
        }
        if (!f.isCollapsed()) {
            Fold fold;
            int i;
            Object[] arr = CodeFoldingSideBar.getFoldList(f, lowerBoundary, upperBoundary);
            List foldList = (List)arr[0];
            int idxOfFirstFoldStartingInsideClip = (Integer)arr[1];
            for (i = idxOfFirstFoldStartingInsideClip - 1; i >= 0 && this.traverseBackwards(fold = (Fold)foldList.get(i), doc, btui, lowerBoundary, upperBoundary, level + 1, infos); --i) {
            }
            for (i = idxOfFirstFoldStartingInsideClip; i < foldList.size(); ++i) {
                fold = (Fold)foldList.get(i);
                if (this.traverseForward(fold, doc, btui, lowerBoundary, upperBoundary, level + 1, infos)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean traverseBackwards(Fold f, BaseDocument doc, BaseTextUI btui, int lowerBoundary, int upperBoundary, int level, Map<Integer, PaintInfo> infos) throws BadLocationException {
        int y1;
        if (f.getEndOffset() < lowerBoundary) {
            return false;
        }
        int lineStartOffset1 = Utilities.getRowStart(doc, f.getStartOffset());
        int lineStartOffset2 = Utilities.getRowStart(doc, f.getEndOffset());
        int h = btui.getEditorUI().getLineHeight();
        if (lineStartOffset1 == lineStartOffset2) {
            y1 = btui.getYFromPos(lineStartOffset1);
            this.addPaintInfo(infos, y1, new PaintInfo(4, level, y1, h, f.isCollapsed(), lineStartOffset1, lineStartOffset1));
        } else {
            if (f.getStartOffset() >= upperBoundary) {
                y1 = btui.getYFromPos(lineStartOffset1);
                this.addPaintInfo(infos, y1, new PaintInfo(1, level, y1, h, f.isCollapsed(), lineStartOffset1, lineStartOffset2));
            }
            if (!f.isCollapsed() && f.getEndOffset() <= upperBoundary) {
                int y2 = btui.getYFromPos(lineStartOffset2);
                this.addPaintInfo(infos, y2, new PaintInfo(3, level, y2, h, lineStartOffset1, lineStartOffset2));
            }
        }
        if (!f.isCollapsed()) {
            Fold fold;
            int i;
            Object[] arr = CodeFoldingSideBar.getFoldList(f, lowerBoundary, upperBoundary);
            List foldList = (List)arr[0];
            int idxOfFirstFoldStartingInsideClip = (Integer)arr[1];
            for (i = idxOfFirstFoldStartingInsideClip - 1; i >= 0; --i) {
                fold = (Fold)foldList.get(i);
                if (this.traverseBackwards(fold, doc, btui, lowerBoundary, upperBoundary, level + 1, infos)) continue;
                return false;
            }
            for (i = idxOfFirstFoldStartingInsideClip; i < foldList.size() && this.traverseForward(fold = (Fold)foldList.get(i), doc, btui, lowerBoundary, upperBoundary, level + 1, infos); ++i) {
            }
        }
        return true;
    }

    protected EditorUI getEditorUI() {
        return Utilities.getEditorUI(this.component);
    }

    protected Document getDocument() {
        return this.component.getDocument();
    }

    private Fold getLastLineFold(FoldHierarchy hierarchy, int rowStart, int rowEnd, boolean shift) {
        Fold fold;
        Fold prevFold = fold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)rowStart);
        while (fold != null && fold.getStartOffset() < rowEnd) {
            Fold nextFold = FoldUtilities.findNearestFold((FoldHierarchy)hierarchy, (int)(fold.isCollapsed() ? fold.getEndOffset() : fold.getStartOffset() + 1));
            if (nextFold == fold) {
                return fold;
            }
            if (nextFold != null && nextFold.getStartOffset() < rowEnd) {
                prevFold = shift ? fold : nextFold;
                fold = nextFold;
                continue;
            }
            return prevFold;
        }
        return prevFold;
    }

    protected void performAction(Mark mark) {
        this.performAction(mark, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performActionAt(Mark mark, int mouseY) throws BadLocationException {
        if (mark != null) {
            return;
        }
        BaseDocument bdoc = Utilities.getDocument(this.component);
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        int yOffset = textUI.getPosFromY(mouseY);
        bdoc.readLock();
        try {
            FoldHierarchy hierarchy = FoldHierarchy.get((JTextComponent)this.component);
            hierarchy.lock();
            try {
                Fold f = FoldUtilities.findOffsetFold((FoldHierarchy)hierarchy, (int)yOffset);
                if (f == null) {
                    return;
                }
                if (f.isCollapsed()) {
                    LOG.log(Level.WARNING, "Clicked on a collapsed fold {0} at {1}", new Object[]{f, mouseY});
                    return;
                }
                int startOffset = f.getStartOffset();
                int endOffset = f.getEndOffset();
                int startY = textUI.getYFromPos(startOffset);
                int nextLineOffset = Utilities.getRowStart(bdoc, startOffset, 1);
                int nextY = textUI.getYFromPos(nextLineOffset);
                if (mouseY >= startY && mouseY <= nextY) {
                    LOG.log(Level.FINEST, "Starting line clicked, ignoring. MouseY={0}, startY={1}, nextY={2}", new Object[]{mouseY, startY, nextY});
                    return;
                }
                startY = textUI.getYFromPos(endOffset);
                nextLineOffset = Utilities.getRowStart(bdoc, endOffset, 1);
                nextY = textUI.getYFromPos(nextLineOffset);
                if (mouseY >= startY && mouseY <= nextY) {
                    LOG.log(Level.FINEST, "End line clicked, ignoring. MouseY={0}, startY={1}, nextY={2}", new Object[]{mouseY, startY, nextY});
                    return;
                }
                LOG.log(Level.FINEST, "Collapsing fold: {0}", f);
                hierarchy.collapse(f);
                return;
            }
            finally {
                hierarchy.unlock();
            }
        }
        finally {
            bdoc.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performAction(Mark mark, boolean shiftFold) {
        BaseTextUI textUI = (BaseTextUI)this.component.getUI();
        View rootView = Utilities.getDocumentView(this.component);
        if (rootView == null) {
            return;
        }
        try {
            int startViewIndex = rootView.getViewIndex(textUI.getPosFromY(mark.y + mark.size / 2), Position.Bias.Forward);
            View view = rootView.getView(startViewIndex);
            FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)this.component);
            AbstractDocument adoc = (AbstractDocument)foldHierarchy.getComponent().getDocument();
            adoc.readLock();
            try {
                foldHierarchy.lock();
                try {
                    int viewStartOffset = view.getStartOffset();
                    int rowStart = javax.swing.text.Utilities.getRowStart(this.component, viewStartOffset);
                    int rowEnd = javax.swing.text.Utilities.getRowEnd(this.component, viewStartOffset);
                    Fold clickedFold = this.getLastLineFold(foldHierarchy, rowStart, rowEnd, shiftFold);
                    if (clickedFold != null && clickedFold.getStartOffset() < view.getEndOffset()) {
                        foldHierarchy.toggle(clickedFold);
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                adoc.readUnlock();
            }
        }
        catch (BadLocationException ble) {
            LOG.log(Level.WARNING, null, ble);
        }
    }

    protected int getMarkSize(Graphics g) {
        FontMetrics fm;
        if (g != null && (fm = g.getFontMetrics(this.getColoring().getFont())) != null) {
            int ret = fm.getAscent() - fm.getDescent();
            return ret - ret % 2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        if (!this.enabled) {
            return;
        }
        Rectangle clip = this.getVisibleRect();
        this.visibleMarks.clear();
        Coloring coloring = this.getColoring();
        g.setColor(coloring.getBackColor());
        g.fillRect(clip.x, clip.y, clip.width, clip.height);
        g.setColor(coloring.getForeColor());
        AbstractDocument adoc = (AbstractDocument)this.component.getDocument();
        adoc.readLock();
        try {
            List<? extends PaintInfo> ps = this.getPaintInfo(clip);
            Font defFont = coloring.getFont();
            int markSize = this.getMarkSize(g);
            int halfMarkSize = markSize / 2;
            int markX = (defFont.getSize() - markSize) / 2;
            int plusGap = (int)Math.round((double)markSize / 3.8);
            int lineX = markX + halfMarkSize;
            LOG.fine("CFSBar: PAINT START ------\n");
            int descent = g.getFontMetrics(defFont).getDescent();
            PaintInfo previousInfo = null;
            for (PaintInfo paintInfo : ps) {
                boolean isFolded = paintInfo.isCollapsed();
                int y = paintInfo.getPaintY();
                int height = paintInfo.getPaintHeight();
                int markY = y + descent;
                int paintOperation = paintInfo.getPaintOperation();
                if (previousInfo == null) {
                    if (paintInfo.hasLineIn()) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine("prevInfo=NULL; y=" + y + ", PI:" + paintInfo + "\n");
                        }
                        g.drawLine(lineX, clip.y, lineX, y);
                    }
                } else if (previousInfo.hasLineOut()) {
                    int prevY = previousInfo.getPaintY();
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "prevInfo={0}; y=" + y + ", PI:" + paintInfo + "\n", previousInfo);
                    }
                    g.drawLine(lineX, prevY + previousInfo.getPaintHeight(), lineX, y);
                }
                if (paintInfo.hasSign()) {
                    String opStr;
                    g.drawRect(markX, markY, markSize, markSize);
                    g.drawLine(plusGap + markX, markY + halfMarkSize, markSize + markX - plusGap, markY + halfMarkSize);
                    String string = opStr = paintOperation == 1 ? "PAINT_MARK" : "SINGLE_PAINT_MARK";
                    if (isFolded) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(opStr + ": folded; y=" + y + ", PI:" + paintInfo + "\n");
                        }
                        g.drawLine(lineX, markY + plusGap, lineX, markY + markSize - plusGap);
                    }
                    if (paintOperation != 4 && LOG.isLoggable(Level.FINE)) {
                        LOG.fine(opStr + ": non-single; y=" + y + ", PI:" + paintInfo + "\n");
                    }
                    if (paintInfo.hasLineIn()) {
                        g.drawLine(lineX, y, lineX, markY);
                    }
                    if (paintInfo.hasLineOut()) {
                        g.drawLine(lineX, markY + markSize, lineX, y + height);
                    }
                    this.visibleMarks.add(new Mark(markX, markY, markSize, isFolded));
                } else if (paintOperation == 2) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("PAINT_LINE: y=" + y + ", PI:" + paintInfo + "\n");
                    }
                    g.drawLine(lineX, y, lineX, y + height);
                } else if (paintOperation == 3) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("PAINT_END_MARK: y=" + y + ", PI:" + paintInfo + "\n");
                    }
                    if (previousInfo == null || y != previousInfo.getPaintY()) {
                        g.drawLine(lineX, y, lineX, y + height / 2);
                        g.drawLine(lineX, y + height / 2, lineX + halfMarkSize, y + height / 2);
                        if (paintInfo.getInnerLevel() > 0) {
                            if (LOG.isLoggable(Level.FINE)) {
                                LOG.fine("  PAINT middle-line\n");
                            }
                            g.drawLine(lineX, y + height / 2, lineX, y + height);
                        }
                    }
                }
                previousInfo = paintInfo;
            }
            if (previousInfo != null && (previousInfo.getInnerLevel() > 0 || previousInfo.getPaintOperation() == 1 && !previousInfo.isCollapsed())) {
                g.drawLine(lineX, previousInfo.getPaintY() + previousInfo.getPaintHeight(), lineX, clip.y + clip.height);
            }
        }
        catch (BadLocationException ble) {
            LOG.log(Level.WARNING, null, ble);
        }
        finally {
            LOG.fine("CFSBar: PAINT END ------\n\n");
            adoc.readUnlock();
        }
    }

    private static Object[] getFoldList(Fold parentFold, int start, int end) {
        Fold f;
        ArrayList<Fold> ret = new ArrayList<Fold>();
        int foldCount = parentFold.getFoldCount();
        int idxOfFirstFoldStartingInside = -1;
        for (int index = FoldUtilities.findFoldEndIndex((Fold)parentFold, (int)start); index < foldCount && (f = parentFold.getFold(index)).getStartOffset() <= end; ++index) {
            ret.add(f);
            if (idxOfFirstFoldStartingInside != -1 || f.getStartOffset() < start) continue;
            idxOfFirstFoldStartingInside = ret.size() - 1;
        }
        return new Object[]{ret, idxOfFirstFoldStartingInside != -1 ? idxOfFirstFoldStartingInside : ret.size()};
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                @Override
                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
            this.accessibleContext.setAccessibleName(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSN_CodeFoldingSideBar"));
            this.accessibleContext.setAccessibleDescription(NbBundle.getMessage(CodeFoldingSideBar.class, (String)"ACSD_CodeFoldingSideBar"));
        }
        return this.accessibleContext;
    }

    private Coloring getColoring() {
        if (this.attribs == null) {
            FontColorSettings fcs;
            AttributeSet attr;
            if (this.fcsLookupResult == null) {
                this.fcsLookupResult = MimeLookup.getLookup((String)DocumentUtilities.getMimeType((JTextComponent)this.component)).lookupResult(FontColorSettings.class);
                this.fcsLookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fcsTracker, this.fcsLookupResult));
            }
            attr = (attr = (fcs = (FontColorSettings)this.fcsLookupResult.allInstances().iterator().next()).getFontColors("code-folding-bar")) == null ? fcs.getFontColors("default") : AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{attr, fcs.getFontColors("default")});
            this.attribs = attr;
        }
        return Coloring.fromAttributeSet(this.attribs);
    }

    private final class Listener
    extends MouseAdapter
    implements FoldHierarchyListener,
    DocumentListener,
    Runnable {
        public void foldHierarchyChanged(FoldHierarchyEvent evt) {
            this.refresh();
        }

        @Override
        public void insertUpdate(DocumentEvent evt) {
            if (!(evt instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            if (bevt.getLFCount() > 0) {
                this.refresh();
            }
        }

        @Override
        public void removeUpdate(DocumentEvent evt) {
            if (!(evt instanceof BaseDocumentEvent)) {
                return;
            }
            BaseDocumentEvent bevt = (BaseDocumentEvent)evt;
            if (bevt.getLFCount() > 0) {
                this.refresh();
            }
        }

        @Override
        public void changedUpdate(DocumentEvent evt) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Mark mark = this.getClickedMark(e);
            if (mark != null) {
                e.consume();
                CodeFoldingSideBar.this.performAction(mark, (e.getModifiersEx() & 0x80) > 0);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1) {
                LOG.log(Level.FINEST, "Mouse {0}click at {1}", new Object[]{e.getClickCount(), e.getY()});
                Mark mark = this.getClickedMark(e);
                try {
                    CodeFoldingSideBar.this.performActionAt(mark, e.getY());
                }
                catch (BadLocationException ex) {
                    LOG.log(Level.WARNING, "Error during fold expansion using sideline", ex);
                }
            } else {
                e.consume();
            }
        }

        private Mark getClickedMark(MouseEvent e) {
            if (e == null || !SwingUtilities.isLeftMouseButton(e)) {
                return null;
            }
            int x = e.getX();
            int y = e.getY();
            for (Mark mark : CodeFoldingSideBar.this.visibleMarks) {
                if (x < mark.x || x > mark.x + mark.size || y < mark.y || y > mark.y + mark.size) continue;
                return mark;
            }
            return null;
        }

        private void refresh() {
            SwingUtilities.invokeLater(this);
        }

        @Override
        public void run() {
            CodeFoldingSideBar.this.repaint();
        }
    }

    public class Mark {
        public int x;
        public int y;
        public int size;
        public boolean isFolded;

        public Mark(int x, int y, int size, boolean isFolded) {
            this.x = x;
            this.y = y;
            this.size = size;
            this.isFolded = isFolded;
        }
    }

    public class PaintInfo {
        int paintOperation;
        int innerLevel;
        int paintY;
        int paintHeight;
        boolean isCollapsed;
        boolean allCollapsed;
        int startOffset;
        int endOffset;
        int outgoingLevel;
        boolean lineIn;
        boolean lineOut;

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight, boolean isCollapsed, int startOffset, int endOffset) {
            this.paintOperation = paintOperation;
            this.outgoingLevel = innerLevel;
            this.innerLevel = this.outgoingLevel++;
            this.paintY = paintY;
            this.paintHeight = paintHeight;
            this.isCollapsed = this.allCollapsed = isCollapsed;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            switch (paintOperation) {
                case 1: {
                    this.lineIn = false;
                    this.lineOut = true;
                    break;
                }
                case 4: {
                    this.lineIn = false;
                    this.lineOut = false;
                    break;
                }
                case 3: {
                    this.lineIn = true;
                    this.lineOut = false;
                    isCollapsed = true;
                    this.allCollapsed = true;
                    break;
                }
                case 2: {
                    this.lineOut = true;
                    this.lineIn = true;
                }
            }
        }

        boolean hasLineIn() {
            return this.lineIn || this.innerLevel > 0;
        }

        boolean hasLineOut() {
            return this.lineOut || this.outgoingLevel > 0 || this.paintOperation != 4 && !this.isAllCollapsed();
        }

        public PaintInfo(int paintOperation, int innerLevel, int paintY, int paintHeight, int startOffset, int endOffset) {
            this(paintOperation, innerLevel, paintY, paintHeight, false, startOffset, endOffset);
        }

        public int getPaintOperation() {
            return this.paintOperation;
        }

        public int getInnerLevel() {
            return this.innerLevel;
        }

        public int getPaintY() {
            return this.paintY;
        }

        public int getPaintHeight() {
            return this.paintHeight;
        }

        public boolean isCollapsed() {
            return this.isCollapsed;
        }

        boolean isAllCollapsed() {
            return this.allCollapsed;
        }

        public void setPaintOperation(int paintOperation) {
            this.paintOperation = paintOperation;
        }

        public void setInnerLevel(int innerLevel) {
            this.innerLevel = innerLevel;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            if (this.paintOperation == 1) {
                sb.append("PAINT_MARK");
            } else if (this.paintOperation == 2) {
                sb.append("PAINT_LINE");
            } else if (this.paintOperation == 3) {
                sb.append("PAINT_END_MARK");
            } else if (this.paintOperation == 4) {
                sb.append("SINGLE_PAINT_MARK");
            }
            sb.append(",L:").append(this.innerLevel).append("/").append(this.outgoingLevel);
            sb.append(',').append(this.isCollapsed ? "C" : "E");
            sb.append(", start=").append(this.startOffset).append(", end=").append(this.endOffset);
            sb.append(", lineIn=").append(this.lineIn).append(", lineOut=").append(this.lineOut);
            return sb.toString();
        }

        boolean hasSign() {
            return this.paintOperation == 1 || this.paintOperation == 4;
        }

        void mergeWith(PaintInfo prevInfo) {
            if (prevInfo == null) {
                return;
            }
            int operation = this.paintOperation;
            boolean lineIn = prevInfo.lineIn;
            boolean lineOut = prevInfo.lineOut;
            LOG.log(Level.FINE, "Merging {0} with {1}: ", new Object[]{this, prevInfo});
            if (prevInfo.getPaintOperation() == 3) {
                lineIn = true;
            } else {
                operation = 1;
            }
            int level1 = Math.min(prevInfo.innerLevel, this.innerLevel);
            int level2 = prevInfo.outgoingLevel;
            if (this.getPaintOperation() == 3 && this.innerLevel == prevInfo.outgoingLevel) {
                level2 = this.outgoingLevel;
            } else if (!this.isCollapsed) {
                level2 = Math.max(prevInfo.outgoingLevel, this.outgoingLevel);
            }
            if (prevInfo.getInnerLevel() < this.getInnerLevel()) {
                int paintFrom = Math.min(prevInfo.paintY, this.paintY);
                int paintTo = Math.max(prevInfo.paintY + prevInfo.paintHeight, this.paintY + this.paintHeight);
                boolean collapsed = prevInfo.isCollapsed() || this.isCollapsed();
                int offsetFrom = Math.min(prevInfo.startOffset, this.startOffset);
                int offsetTo = Math.max(prevInfo.endOffset, this.endOffset);
                this.paintY = paintFrom;
                this.paintHeight = paintTo - paintFrom;
                this.isCollapsed = collapsed;
                this.startOffset = offsetFrom;
                this.endOffset = offsetTo;
            }
            this.paintOperation = operation;
            this.allCollapsed = prevInfo.allCollapsed && this.allCollapsed;
            this.innerLevel = level1;
            this.outgoingLevel = level2;
            this.lineIn |= lineIn;
            this.lineOut |= lineOut;
            LOG.log(Level.FINE, "Merged result: {0}", this);
        }
    }
}

