/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class ServerCommand {
    public static final char QUERY_SEPARATOR = '?';
    public static final char PARAM_SEPARATOR = '&';
    protected final String command;
    protected String query = null;
    protected boolean retry = false;
    private String serverMessage = "";
    protected boolean silentFailureAllowed = false;

    public String getServerMessage() {
        return this.serverMessage;
    }

    public ServerCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public String getQuery() {
        return this.query;
    }

    public String getRequestMethod() {
        return "GET";
    }

    public boolean getDoOutput() {
        return false;
    }

    public String getContentType() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    public String getInputName() {
        return null;
    }

    public String getLastModified() {
        return null;
    }

    public boolean retry() {
        return this.retry;
    }

    public boolean handleResponse(int responseCode) {
        return responseCode == 200;
    }

    public boolean readResponse(InputStream in, HttpURLConnection hconn) throws IOException {
        boolean result = false;
        Manifest m = new Manifest();
        m.read(in);
        String outputCode = m.getMainAttributes().getValue("exit-code");
        if (null == outputCode || !"FAILURE".equals(outputCode.toUpperCase(Locale.ENGLISH))) {
            this.readManifest(m);
            result = true;
        } else {
            String message = null;
            try {
                String tmp = m.getMainAttributes().getValue("message");
                if (null != tmp) {
                    message = tmp;
                    message = URLDecoder.decode(tmp, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Could not URL decode with UTF-8");
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            if (message != null && message.contains("please wait")) {
                this.retry = true;
            } else {
                this.serverMessage = null != message ? message.replaceAll("%%%EOL%%%", "\n") : "";
            }
            Logger.getLogger("glassfish").log(Level.WARNING, message);
        }
        return result;
    }

    public void readManifest(Manifest manifest) throws IOException {
    }

    public boolean processResponse() {
        return true;
    }

    public String toString() {
        return this.query == null ? this.command : this.command + '?' + this.query;
    }

    public String getSrc() {
        return "/__asadmin/";
    }

    public boolean acceptsGzip() {
        return false;
    }

    public boolean isSilentFailureAllowed() {
        return this.silentFailureAllowed;
    }

    public static final class GetPropertyCommand
    extends ServerCommand {
        private Manifest info;
        private Map<String, String> propertyMap;

        public GetPropertyCommand(String property, boolean allowSilentFail) {
            super("get");
            this.query = "pattern=" + property;
            this.propertyMap = new HashMap<String, String>();
            this.silentFailureAllowed = allowSilentFail;
        }

        public GetPropertyCommand(String property) {
            this(property, false);
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            if (this.info == null) {
                Logger.getLogger("glassfish").log(Level.WARNING, "info is null for GetProperty command with \"{0}\"", this.query);
                return false;
            }
            for (String encodedkey : this.info.getEntries().keySet()) {
                String key = "";
                try {
                    if (null != encodedkey) {
                        key = encodedkey;
                        key = URLDecoder.decode(encodedkey, "UTF-8");
                    }
                }
                catch (UnsupportedEncodingException uee) {
                    Logger.getLogger("glassfish").log(Level.INFO, encodedkey, uee);
                }
                catch (IllegalArgumentException iae) {
                    // empty catch block
                }
                int equalsIndex = key.indexOf(61);
                if (equalsIndex >= 0) {
                    String keyPart = key.substring(0, equalsIndex);
                    String valuePart = key.substring(equalsIndex + 1);
                    Level logLevel = Level.WARNING;
                    try {
                        this.propertyMap.put(keyPart, valuePart);
                        this.propertyMap.put(keyPart, URLDecoder.decode(valuePart, "UTF-8"));
                        logLevel = Level.FINE;
                        this.propertyMap.put(keyPart, URLDecoder.decode(this.propertyMap.get(keyPart), "UTF-8"));
                    }
                    catch (UnsupportedEncodingException ex) {
                        Logger.getLogger("glassfish").log(Level.WARNING, "UnsupportedEncodingException for value \"{0}\"", this.propertyMap.get(keyPart));
                    }
                    catch (IllegalArgumentException iae) {
                        Logger.getLogger("glassfish").log(logLevel, "IllegalArgumentException for value \"{0}\" : inserted into propertyMap as \"{1}\"", new Object[]{valuePart, this.propertyMap.get(keyPart)});
                    }
                    continue;
                }
                Logger.getLogger("glassfish").log(Level.WARNING, "Inserting empty string as value for key=\"{0}\"", key);
                this.propertyMap.put(key, "");
            }
            return true;
        }

        public Map<String, String> getData() {
            return this.propertyMap;
        }
    }

    public static final class SetPropertyCommand
    extends ServerCommand {
        private Manifest info;

        public SetPropertyCommand(String property, String value, String format) {
            super("set");
            this.query = MessageFormat.format(format, property, value);
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            return this.info != null;
        }
    }
}

