/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.modules.glassfish.common.EnableComet;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class InstanceCustomizer
extends JPanel {
    private GlassfishModule commonSupport;
    private boolean cometEnabledChanged = false;
    private boolean monitorEnabledChanged = false;
    private boolean jdbcDriverDeployEnabledChanged = false;
    private boolean sessionEnabledChanged = false;
    private boolean startDerbyChanged = false;
    private JCheckBox cometCheckBox;
    private JCheckBox enableSessionsCheckBox;
    private JCheckBox jdbcDriverDeployCheckBox;
    private JLabel labelDomainName;
    private JLabel labelDomainsFolder;
    private JLabel labelLocation;
    private JCheckBox monitorCheckBox;
    private JCheckBox startDerby;
    private JTextField textDomainName;
    private JTextField textDomainsFolder;
    private JTextField textLocation;

    public InstanceCustomizer(GlassfishModule commonSupport) {
        this.commonSupport = commonSupport;
        this.initComponents();
    }

    private void initFields() {
        Map<String, String> ip = this.commonSupport.getInstanceProperties();
        String host = ip.get("httphostname");
        if (null == host) {
            host = ip.get("host");
        }
        this.textLocation.setText(host + ":" + ip.get("httpportnumber"));
        this.textDomainsFolder.setText(ip.get("domainsfolder"));
        this.textDomainName.setText(ip.get("domainname"));
        String cometFlag = ip.get("v3.grizzly.cometSupport");
        if (cometFlag == null) {
            cometFlag = System.getProperty("v3.grizzly.cometSupport");
        }
        boolean cometEnabled = Boolean.parseBoolean(cometFlag);
        this.cometCheckBox.setSelected(cometEnabled);
        String monitorFlag = ip.get("httpMonitorOn");
        boolean monitorEnabled = Boolean.parseBoolean(monitorFlag);
        this.monitorCheckBox.setSelected(monitorEnabled);
        String driverDeployFlag = ip.get("driverDeployOn");
        boolean driverDeployEnabled = Boolean.parseBoolean(driverDeployFlag);
        this.jdbcDriverDeployCheckBox.setSelected(driverDeployEnabled);
        String sessionFlag = ip.get("preserveSessionsOn");
        boolean sessionEnabled = Boolean.parseBoolean(sessionFlag);
        this.enableSessionsCheckBox.setSelected(sessionEnabled);
        String derbyFlag = ip.get("derbyStartOn");
        boolean derbyEnabled = Boolean.parseBoolean(derbyFlag);
        this.startDerby.setSelected(derbyEnabled);
        boolean isLocalDomain = ip.get("domainsfolder") != null;
        this.cometCheckBox.setEnabled(isLocalDomain);
        this.monitorCheckBox.setEnabled(isLocalDomain);
        this.jdbcDriverDeployCheckBox.setEnabled(isLocalDomain);
        this.startDerby.setEnabled(isLocalDomain);
    }

    private void persistFields() {
        if (this.cometEnabledChanged) {
            String cometEnabled = Boolean.toString(this.cometCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("v3.grizzly.cometSupport", cometEnabled, true);
            RequestProcessor.getDefault().post((Runnable)new EnableComet(this.commonSupport));
        }
        if (this.monitorEnabledChanged) {
            String monitorEnabled = Boolean.toString(this.monitorCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("httpMonitorOn", monitorEnabled, true);
        }
        if (this.jdbcDriverDeployEnabledChanged) {
            String driverDeployEnabled = Boolean.toString(this.jdbcDriverDeployCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("driverDeployOn", driverDeployEnabled, true);
        }
        if (this.sessionEnabledChanged) {
            String sessionsEnabled = Boolean.toString(this.enableSessionsCheckBox.isSelected());
            this.commonSupport.setEnvironmentProperty("preserveSessionsOn", sessionsEnabled, true);
        }
        if (this.startDerbyChanged) {
            String derbyEnabled = Boolean.toString(this.startDerby.isSelected());
            this.commonSupport.setEnvironmentProperty("derbyStartOn", derbyEnabled, true);
        }
        if ((this.cometEnabledChanged || this.monitorEnabledChanged || this.jdbcDriverDeployEnabledChanged || this.sessionEnabledChanged || this.startDerbyChanged) && !this.commonSupport.isWritable()) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(this.getClass(), (String)"WRN_CouldNotWrite"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            Logger.getLogger("glassfish").warning("Could not write changed property");
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.initFields();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.persistFields();
    }

    private void initComponents() {
        this.labelLocation = new JLabel();
        this.textLocation = new JTextField();
        this.labelDomainsFolder = new JLabel();
        this.textDomainsFolder = new JTextField();
        this.labelDomainName = new JLabel();
        this.textDomainName = new JTextField();
        this.cometCheckBox = new JCheckBox();
        this.monitorCheckBox = new JCheckBox();
        this.jdbcDriverDeployCheckBox = new JCheckBox();
        this.enableSessionsCheckBox = new JCheckBox();
        this.startDerby = new JCheckBox();
        this.setName(NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_Common"));
        this.labelLocation.setLabelFor(this.textLocation);
        Mnemonics.setLocalizedText((JLabel)this.labelLocation, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_Location"));
        this.textLocation.setEditable(false);
        this.labelDomainsFolder.setLabelFor(this.textDomainsFolder);
        Mnemonics.setLocalizedText((JLabel)this.labelDomainsFolder, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_DomainsFolder"));
        this.textDomainsFolder.setEditable(false);
        this.labelDomainName.setLabelFor(this.textDomainName);
        Mnemonics.setLocalizedText((JLabel)this.labelDomainName, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_DomainName"));
        this.textDomainName.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.cometCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableCometSupport"));
        this.cometCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.cometCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.monitorCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableHttpMonitor"));
        this.monitorCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.monitorCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.jdbcDriverDeployCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_EnableJDBCDiverDeployment"));
        this.jdbcDriverDeployCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.jdbcDriverDeployCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.enableSessionsCheckBox, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_PreserverSessions"));
        this.enableSessionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.enableSessionsCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.startDerby, (String)NbBundle.getMessage(InstanceCustomizer.class, (String)"LBL_START_DERBY"));
        this.startDerby.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstanceCustomizer.this.startDerby(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.startDerby).addComponent(this.jdbcDriverDeployCheckBox).addComponent(this.monitorCheckBox).addComponent(this.cometCheckBox, -1, 404, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelLocation).addComponent(this.labelDomainsFolder).addComponent(this.labelDomainName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textLocation, -1, 293, Short.MAX_VALUE).addComponent(this.textDomainsFolder, -1, 293, Short.MAX_VALUE).addComponent(this.textDomainName, -1, 293, Short.MAX_VALUE))).addComponent(this.enableSessionsCheckBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelLocation).addComponent(this.textLocation, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDomainsFolder).addComponent(this.textDomainsFolder, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelDomainName).addComponent(this.textDomainName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cometCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.monitorCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jdbcDriverDeployCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.enableSessionsCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startDerby).addContainerGap(-1, Short.MAX_VALUE)));
        this.textLocation.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_InstanceLocation"));
        this.textDomainsFolder.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_DomainFolder"));
        this.textDomainName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_DomainName"));
        this.cometCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_CometSupport"));
        this.monitorCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_HttpMonitor"));
        this.jdbcDriverDeployCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_DriverDeployment"));
        this.enableSessionsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_SessionPreservation"));
        this.startDerby.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_StartDerby"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstanceCustomizer.class, (String)"A11Y_DESC_CommonPanel"));
    }

    private void cometCheckBoxActionPerformed(ActionEvent evt) {
        this.cometEnabledChanged = true;
    }

    private void monitorCheckBoxActionPerformed(ActionEvent evt) {
        this.monitorEnabledChanged = true;
        if (this.monitorCheckBox.isSelected()) {
            NotifyDescriptor dd = new NotifyDescriptor((Object)NbBundle.getMessage(this.getClass(), (String)"TXT_WARNING_HTTP_MONITOR_ON"), NbBundle.getMessage(this.getClass(), (String)"TITLE_WARNING_HTTP_MONITOR_ON"), -1, 2, null, null);
            if (DialogDisplayer.getDefault().notify(dd).equals(NotifyDescriptor.CANCEL_OPTION)) {
                this.monitorCheckBox.setSelected(false);
                this.monitorEnabledChanged = false;
            }
        } else {
            NotifyDescriptor dd = new NotifyDescriptor((Object)NbBundle.getMessage(this.getClass(), (String)"TXT_WARNING_HTTP_MONITOR_OFF"), NbBundle.getMessage(this.getClass(), (String)"TITLE_WARNING_HTTP_MONITOR_OFF"), -1, 2, null, null);
            if (DialogDisplayer.getDefault().notify(dd).equals(NotifyDescriptor.CANCEL_OPTION)) {
                this.monitorCheckBox.setSelected(true);
                this.monitorEnabledChanged = false;
            }
        }
    }

    private void jdbcDriverDeployCheckBoxActionPerformed(ActionEvent evt) {
        this.jdbcDriverDeployEnabledChanged = true;
    }

    private void enableSessionsCheckBoxActionPerformed(ActionEvent evt) {
        this.sessionEnabledChanged = true;
    }

    private void startDerby(ActionEvent evt) {
        this.startDerbyChanged = true;
    }
}

