/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.Commands;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.netbeans.modules.glassfish.common.NoopTask;
import org.netbeans.modules.glassfish.common.RestartTask;
import org.netbeans.modules.glassfish.common.StartTask;
import org.netbeans.modules.glassfish.common.StopProfilingTask;
import org.netbeans.modules.glassfish.common.StopTask;
import org.netbeans.modules.glassfish.common.Util;
import org.netbeans.modules.glassfish.common.nodes.actions.RefreshModulesCookie;
import org.netbeans.modules.glassfish.spi.AppDesc;
import org.netbeans.modules.glassfish.spi.CommandFactory;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.GlassfishModule3;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.Recognizer;
import org.netbeans.modules.glassfish.spi.RecognizerCookie;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.modules.glassfish.spi.VMIntrospector;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class CommonServerSupport
implements GlassfishModule3,
RefreshModulesCookie {
    private final transient Lookup lookup;
    private final Map<String, String> properties = Collections.synchronizedMap(new HashMap(37));
    private volatile GlassfishModule.ServerState serverState = GlassfishModule.ServerState.UNKNOWN;
    private final Object stateMonitor = new Object();
    private ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private FileObject instanceFO;
    private volatile boolean startedByIde = false;
    private transient boolean isRemote = false;
    private GlassfishInstanceProvider instanceProvider;
    private boolean stopDisabled = false;
    private Process localStartProcess;
    private static final RequestProcessor RP = new RequestProcessor("CommonServerSupport - start/stop/refresh", 5);
    private final AtomicBoolean refreshRunning = new AtomicBoolean(false);
    private long latestWarningDisplayTime = System.currentTimeMillis();

    CommonServerSupport(Lookup lookup, Map<String, String> ip, GlassfishInstanceProvider instanceProvider) {
        this.lookup = lookup;
        this.instanceProvider = instanceProvider;
        this.isRemote = ip.get("domainsfolder") == null;
        String hostName = CommonServerSupport.updateString(ip, "host", "localhost");
        String glassfishRoot = CommonServerSupport.updateString(ip, "homefolder", "");
        int httpPort = CommonServerSupport.updateInt(ip, "httpportnumber", 8080);
        CommonServerSupport.updateString(ip, "displayName", "Bogus display name");
        int adminPort = CommonServerSupport.updateInt(ip, "adminPort", 4848);
        CommonServerSupport.updateString(ip, "preserveSessionsOn", "true");
        CommonServerSupport.updateString(ip, "derbyStartOn", this.isRemote ? "false" : "true");
        CommonServerSupport.updateString(ip, "useIDEProxyOn", "true");
        CommonServerSupport.updateString(ip, "driverDeployOn", "true");
        CommonServerSupport.updateString(ip, "httphostname", "localhost");
        String deployerUri = ip.get("url");
        ip.put("jvmMode", this.isRemote && !deployerUri.contains("deployer:gfv3ee6wc") ? "debugMode" : "normalMode");
        this.properties.putAll(ip);
        this.properties.put("username", "admin");
        this.properties.put("password", "adminadmin");
        this.instanceFO = this.getInstanceFileObject();
        if (!this.isRemote) {
            this.refresh();
        }
    }

    private static String updateString(Map<String, String> map, String key, String defaultValue) {
        String result = map.get(key);
        if (result == null) {
            map.put(key, defaultValue);
            result = defaultValue;
        }
        return result;
    }

    private static int updateInt(Map<String, String> map, String key, int defaultValue) {
        int result;
        String value = map.get(key);
        try {
            result = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            map.put(key, Integer.toString(defaultValue));
            result = defaultValue;
        }
        return result;
    }

    private FileObject getInstanceFileObject() {
        String instanceFN;
        FileObject dir = FileUtil.getConfigFile((String)this.instanceProvider.getInstancesDirName());
        if (dir != null && (instanceFN = this.properties.get("InstanceFOPath")) != null) {
            return dir.getFileObject(instanceFN);
        }
        return null;
    }

    public String getInstallRoot() {
        return this.properties.get("installfolder");
    }

    public String getGlassfishRoot() {
        return this.properties.get("homefolder");
    }

    public String getDisplayName() {
        return this.properties.get("displayName");
    }

    public String getDeployerUri() {
        return this.properties.get("url");
    }

    public String getUserName() {
        return this.properties.get("username");
    }

    @Override
    public String getPassword() {
        String retVal = this.properties.get("password");
        String key = this.properties.get("url");
        char[] retChars = Keyring.read((String)key);
        if (null == retChars || retChars.length < 1 || !"this really long string is used to identify a password that has been stored in the Keyring".equals(retVal)) {
            retChars = retVal.toCharArray();
            if (null != key) {
                Keyring.save((String)key, (char[])retChars, (String)"a Glassfish/SJSAS passord");
                this.properties.put("password", "this really long string is used to identify a password that has been stored in the Keyring");
            }
        } else {
            retVal = String.copyValueOf(retChars);
        }
        return retVal;
    }

    public String getAdminPort() {
        return this.properties.get("adminPort");
    }

    public String getHttpPort() {
        return this.properties.get("httpportnumber");
    }

    public int getHttpPortNumber() {
        int httpPort = -1;
        try {
            httpPort = Integer.parseInt(this.properties.get("httpportnumber"));
        }
        catch (NumberFormatException ex) {
            Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        return httpPort;
    }

    public int getAdminPortNumber() {
        int adminPort = -1;
        try {
            adminPort = Integer.parseInt(this.properties.get("adminPort"));
        }
        catch (NumberFormatException ex) {
            Logger.getLogger("glassfish").log(Level.WARNING, ex.getLocalizedMessage(), ex);
        }
        return adminPort;
    }

    public String getHostName() {
        return this.properties.get("host");
    }

    public synchronized String getDomainsRoot() {
        String retVal = this.properties.get("domainsfolder");
        if (null == retVal) {
            return null;
        }
        File candidate = new File(retVal);
        if (candidate.exists() && !Utils.canWrite(candidate)) {
            String foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)"GF3");
            FileObject destdir = null;
            try {
                destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not create a writable domain dir", ex);
            }
            if (null != destdir) {
                candidate = new File(candidate, this.properties.get("domainname"));
                FileObject source = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)candidate));
                try {
                    Utils.doCopy(source, destdir);
                    retVal = FileUtil.toFile((FileObject)destdir).getAbsolutePath();
                    this.properties.put("domainsfolder", retVal);
                }
                catch (IOException ex) {
                    foldername = FileUtil.findFreeFolderName((FileObject)FileUtil.getConfigRoot(), (String)"GF3");
                    destdir = null;
                    try {
                        destdir = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)foldername);
                    }
                    catch (IOException ioe) {
                        Logger.getLogger("glassfish").log(Level.INFO, "could not create a writable second domain dir", ioe);
                        return retVal;
                    }
                    File destdirFile = FileUtil.toFile((FileObject)destdir);
                    this.properties.put("domainsfolder", destdirFile.getAbsolutePath());
                    retVal = destdirFile.getAbsolutePath();
                    RequestProcessor.getDefault().post(new Runnable(){

                        @Override
                        public void run() {
                            CreateDomain cd = new CreateDomain("anonymous", "", new File((String)CommonServerSupport.this.properties.get("homefolder")), CommonServerSupport.this.properties, GlassfishInstanceProvider.getEe6(), false, true, "INSTALL_ROOT_KEY");
                            cd.start();
                        }
                    }, 100);
                }
            }
        }
        return retVal;
    }

    public String getDomainName() {
        String retVal = this.properties.get("domainname");
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerState(GlassfishModule.ServerState newState) {
        boolean fireChange = false;
        Object object = this.stateMonitor;
        synchronized (object) {
            if (this.serverState != newState) {
                this.serverState = newState;
                fireChange = true;
            }
        }
        if (fireChange) {
            this.changeSupport.fireChange();
        }
    }

    boolean isStartedByIde() {
        return this.startedByIde;
    }

    @Override
    public Map<String, String> getInstanceProperties() {
        this.getDomainsRoot();
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public GlassfishInstanceProvider getInstanceProvider() {
        return this.instanceProvider;
    }

    @Override
    public boolean isRemote() {
        return this.isRemote;
    }

    @Override
    public Future<GlassfishModule.OperationState> startServer(OperationStateListener stateListener, GlassfishModule.ServerState endState) {
        String[] stringArray;
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.startServer called on thread \"{0}\"", Thread.currentThread().getName());
        StartOperationStateListener startServerListener = new StartOperationStateListener(endState);
        VMIntrospector vmi = (VMIntrospector)Lookups.forPath((String)"Servers/GlassFish").lookup(VMIntrospector.class);
        List<Recognizer> list = this.getRecognizers();
        FileObject fileObject = null;
        if (endState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = null;
        }
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new StartTask(this, list, vmi, fileObject, stringArray, startServerListener, stateListener));
        RP.post(task);
        return task;
    }

    private List<Recognizer> getRecognizers() {
        List<Recognizer> recognizers;
        Collection cookies = this.lookup.lookupAll(RecognizerCookie.class);
        if (!cookies.isEmpty()) {
            recognizers = new LinkedList();
            for (RecognizerCookie cookie : cookies) {
                recognizers.addAll(cookie.getRecognizers());
            }
            recognizers = Collections.unmodifiableList(recognizers);
        } else {
            recognizers = Collections.emptyList();
        }
        return recognizers;
    }

    @Override
    public Future<GlassfishModule.OperationState> stopServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.stopServer called on thread \"{0}\"", Thread.currentThread().getName());
        OperationStateListener stopServerListener = new OperationStateListener(){

            @Override
            public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                if (newState == GlassfishModule.OperationState.RUNNING) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPING);
                } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                } else if (newState == GlassfishModule.OperationState.FAILED) {
                    CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                }
            }
        };
        FutureTask<GlassfishModule.OperationState> task = null;
        task = !this.isRemote() || !Util.isDefaultOrServerTarget(this.properties) ? (this.getServerState() == GlassfishModule.ServerState.STOPPED_JVM_PROFILER ? new FutureTask<GlassfishModule.OperationState>(new StopProfilingTask(this, stateListener)) : new FutureTask<GlassfishModule.OperationState>(new StopTask(this, stopServerListener, stateListener))) : new FutureTask<GlassfishModule.OperationState>(new NoopTask(this, stopServerListener, stateListener));
        if (this.stopDisabled) {
            stopServerListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            if (null != stateListener) {
                stateListener.operationStateChanged(GlassfishModule.OperationState.COMPLETED, "");
            }
            return task;
        }
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> restartServer(OperationStateListener stateListener) {
        Logger.getLogger("glassfish").log(Level.FINEST, "CSS.restartServer called on thread \"{0}\"", Thread.currentThread().getName());
        FutureTask<GlassfishModule.OperationState> task = new FutureTask<GlassfishModule.OperationState>(new RestartTask(this, stateListener));
        RP.post(task);
        return task;
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name) {
        return this.deploy(stateListener, application, name, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot) {
        return this.deploy(stateListener, application, name, contextRoot, null);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties) {
        return this.deploy(stateListener, application, name, contextRoot, null, new File[0]);
    }

    @Override
    public Future<GlassfishModule.OperationState> deploy(OperationStateListener stateListener, File application, String name, String contextRoot, Map<String, String> properties, File[] libraries) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.deploy(application, name, contextRoot, properties, libraries);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, null, resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, String contextRoot, boolean resourcesChanged) {
        return this.redeploy(stateListener, name, contextRoot, new File[0], resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> redeploy(OperationStateListener stateListener, String name, String contextRoot, File[] libraries, boolean resourcesChanged) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.redeploy(name, contextRoot, libraries, resourcesChanged);
    }

    @Override
    public Future<GlassfishModule.OperationState> undeploy(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.undeploy(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> enable(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.enable(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> disable(OperationStateListener stateListener, String name) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), stateListener);
        return mgr.disable(name);
    }

    @Override
    public Future<GlassfishModule.OperationState> execute(ServerCommand command) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        return mgr.execute(command);
    }

    private Future<GlassfishModule.OperationState> execute(boolean irr, ServerCommand command) {
        CommandRunner mgr = new CommandRunner(irr, this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        return mgr.execute(command);
    }

    private Future<GlassfishModule.OperationState> execute(boolean irr, ServerCommand command, OperationStateListener ... osl) {
        CommandRunner mgr = new CommandRunner(irr, this.getCommandFactory(), this.getInstanceProperties(), osl);
        return mgr.execute(command);
    }

    @Override
    public AppDesc[] getModuleList(String container) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        int total = 0;
        Map<String, List<AppDesc>> appMap = mgr.getApplications(container);
        Collection<List<AppDesc>> appLists = appMap.values();
        for (List<AppDesc> appList : appLists) {
            total += appList.size();
        }
        AppDesc[] result = new AppDesc[total];
        int index = 0;
        for (List<AppDesc> appList : appLists) {
            for (AppDesc app : appList) {
                result[index++] = app;
            }
        }
        return result;
    }

    @Override
    public Map<String, ResourceDesc> getResourcesMap(String type) {
        CommandRunner mgr = new CommandRunner(this.isReallyRunning(), this.getCommandFactory(), this.getInstanceProperties(), new OperationStateListener[0]);
        HashMap<String, ResourceDesc> resourcesMap = new HashMap<String, ResourceDesc>();
        List<ResourceDesc> resourcesList = mgr.getResources(type);
        for (ResourceDesc resource : resourcesList) {
            resourcesMap.put(resource.getName(), resource);
        }
        return resourcesMap;
    }

    @Override
    public GlassfishModule.ServerState getServerState() {
        if (this.serverState == GlassfishModule.ServerState.UNKNOWN) {
            this.refresh();
        }
        return this.serverState;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String setEnvironmentProperty(String name, String value, boolean overwrite) {
        String result = null;
        Map<String, String> map = this.properties;
        synchronized (map) {
            result = this.properties.get(name);
            if (result == null || overwrite) {
                this.properties.put(name, value);
                this.setInstanceAttr(name, value);
                result = value;
            }
        }
        return result;
    }

    void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    void getProperty(String key) {
        this.properties.get(key);
    }

    boolean setInstanceAttr(String name, String value) {
        boolean retVal = false;
        if (this.instanceFO == null || !this.instanceFO.isValid()) {
            this.instanceFO = this.getInstanceFileObject();
        }
        if (this.instanceFO != null && this.instanceFO.canWrite()) {
            try {
                Object currentValue = this.instanceFO.getAttribute(name);
                if (null == currentValue || !currentValue.equals(value)) {
                    this.instanceFO.setAttribute(name, (Object)value);
                }
                retVal = true;
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute " + name + " in " + this.instanceFO.getPath() + " for " + this.getDeployerUri(), ex);
            }
        } else if (null == this.instanceFO) {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), false, "null"});
        } else {
            Logger.getLogger("glassfish").log(Level.WARNING, "Unable to save attribute {0} for {1} in {3}. Instance file is writable? {2}", new Object[]{name, this.getDeployerUri(), this.instanceFO.canWrite(), this.instanceFO.getPath()});
        }
        return retVal;
    }

    void setFileObject(FileObject fo) {
        this.instanceFO = fo;
    }

    public static boolean isRunning(String host, int port, String name) {
        if (null == host) {
            return false;
        }
        try {
            InetSocketAddress isa = new InetSocketAddress(host, port);
            Socket socket = new Socket();
            int timeout = 2000;
            if ("localhost".equals(host) || "127.0.0.1".equals(host)) {
                timeout = 2000;
            }
            Logger.getLogger("glassfish-socket-connect-diagnostic").log(Level.FINE, "Using socket.connect", new Exception());
            socket.connect(isa, timeout);
            socket.setSoTimeout(timeout);
            try {
                socket.close();
            }
            catch (IOException ioe) {
                Logger.getLogger("glassfish").log(Level.INFO, "closing after test", ioe);
            }
            return true;
        }
        catch (ConnectException ex) {
            return false;
        }
        catch (SocketTimeoutException ste) {
            return false;
        }
        catch (IOException ioe) {
            String message = null;
            message = name == null || "".equals(name.trim()) ? NbBundle.getMessage(CommonServerSupport.class, (String)"MSG_FLAKEY_NETWORK", (Object)host, (Object)("" + port), (Object)ioe.getLocalizedMessage()) : NbBundle.getMessage(CommonServerSupport.class, (String)"MSG_FLAKEY_NETWORK2", (Object)host, (Object)("" + port), (Object)ioe.getLocalizedMessage(), (Object)name, (Object[])new Object[0]);
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            Logger.getLogger("glassfish").log(Level.INFO, "evidence of network flakiness", ioe);
            return false;
        }
    }

    public boolean isReallyRunning() {
        return this.isReady(false, 30, TimeUnit.SECONDS);
    }

    public boolean isReady(boolean retry, int timeout, TimeUnit units) {
        boolean isReady = false;
        int maxtries = retry ? 3 : 1;
        int tries = 0;
        while (!isReady && tries++ < maxtries) {
            if (tries > 1) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, null, ex);
                }
            }
            long start = System.nanoTime();
            Commands.LocationCommand command = new Commands.LocationCommand();
            try {
                boolean suspended;
                Future<GlassfishModule.OperationState> result = null;
                if (this.isRemote) {
                    final CommonServerSupport css = this;
                    result = this.execute(true, command, new OperationStateListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
                            CommonServerSupport commonServerSupport = css;
                            synchronized (commonServerSupport) {
                                long lastDisplayed = css.getLatestWarningDisplayTime();
                                long currentTime = System.currentTimeMillis();
                                if (GlassfishModule.OperationState.FAILED == newState && !"".equals(message) && currentTime - lastDisplayed > 5000L) {
                                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
                                    DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
                                    css.setLatestWarningDisplayTime(currentTime);
                                    Logger.getLogger("glassfish").log(Level.INFO, message);
                                }
                            }
                        }
                    });
                } else {
                    result = this.execute(true, command);
                }
                if (result.get(timeout, units) == GlassfishModule.OperationState.COMPLETED) {
                    long end = System.nanoTime();
                    Logger.getLogger("glassfish").log(Level.FINE, "{0} responded in {1}ms", new Object[]{command.getCommand(), (end - start) / 1000000L});
                    String domainRoot = this.getDomainsRoot() + File.separator + this.getDomainName();
                    String targetDomainRoot = command.getDomainRoot();
                    if (this.getDomainsRoot() != null && targetDomainRoot != null) {
                        File installDir = FileUtil.normalizeFile((File)new File(domainRoot));
                        File targetInstallDir = FileUtil.normalizeFile((File)new File(targetDomainRoot));
                        isReady = installDir.equals(targetInstallDir);
                    } else {
                        boolean bl = isReady = null != targetDomainRoot;
                    }
                    if (!isReady) break;
                    this.updateHttpPort();
                    break;
                }
                if (!command.retry()) {
                    result = this.execute(true, new Commands.VersionCommand());
                    isReady = result.get(timeout, units) == GlassfishModule.OperationState.COMPLETED;
                    break;
                }
                VMIntrospector vmi = (VMIntrospector)Lookups.forPath((String)"Servers/GlassFish").lookup(VMIntrospector.class);
                boolean bl = suspended = null == vmi ? false : vmi.isSuspended(this.getHostName(), this.properties.get("debugPort"));
                if (suspended) {
                    --tries;
                } else if (maxtries < 20) {
                    ++maxtries;
                }
                long end = System.nanoTime();
                Logger.getLogger("glassfish").log(Level.INFO, "{0} returned from server after {1}ms. The server is still getting ready", new Object[]{command.getCommand(), (end - start) / 1000000L});
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, command.getCommand() + " timed out. " + tries + " of " + maxtries, ex);
                isReady = false;
            }
            catch (Exception ex) {
                Logger.getLogger("glassfish").log(Level.INFO, command.getCommand() + " failed at  " + tries + " of " + maxtries, ex);
                isReady = false;
                break;
            }
        }
        return isReady;
    }

    @Override
    public void refresh() {
        this.refresh(null, null);
    }

    @Override
    public void refresh(String expected, String unexpected) {
        if (this.refreshRunning.compareAndSet(false, true)) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    GlassfishModule.ServerState currentState;
                    boolean isRunning = CommonServerSupport.this.isReallyRunning();
                    if (isRunning && !Util.isDefaultOrServerTarget(CommonServerSupport.this.properties)) {
                        isRunning = CommonServerSupport.this.pingHttp(1);
                    }
                    if (((currentState = CommonServerSupport.this.getServerState()) == GlassfishModule.ServerState.STOPPED || currentState == GlassfishModule.ServerState.UNKNOWN) && isRunning) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    } else if (!(currentState != GlassfishModule.ServerState.RUNNING && currentState != GlassfishModule.ServerState.UNKNOWN || isRunning)) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                    } else if (currentState == GlassfishModule.ServerState.STOPPED_JVM_PROFILER && isRunning) {
                        CommonServerSupport.this.setServerState(GlassfishModule.ServerState.RUNNING);
                    }
                    CommonServerSupport.this.refreshRunning.set(false);
                }
            });
        }
    }

    void disableStop() {
        this.stopDisabled = true;
    }

    void setLocalStartProcess(Process process) {
        this.localStartProcess = process;
    }

    Process getLocalStartProcess() {
        return this.localStartProcess;
    }

    void stopLocalStartProcess() {
        this.localStartProcess.destroy();
        this.localStartProcess = null;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.instanceProvider.getCommandFactory();
    }

    @Override
    public String getResourcesXmlName() {
        return Utils.useGlassfishPrefix(this.getDeployerUri()) ? "glassfish-resources" : "sun-resources";
    }

    @Override
    public boolean supportsRestartInDebug() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isRestfulLogAccessSupported() {
        return this.getDeployerUri().contains("deployer:gfv3ee6wc");
    }

    @Override
    public boolean isWritable() {
        return null == this.instanceFO ? false : this.instanceFO.canWrite();
    }

    private long getLatestWarningDisplayTime() {
        return this.latestWarningDisplayTime;
    }

    private void setLatestWarningDisplayTime(long currentTime) {
        this.latestWarningDisplayTime = currentTime;
    }

    void updateHttpPort() {
        String target = Util.computeTarget(this.properties);
        ServerCommand.GetPropertyCommand gpc = null;
        if (Util.isDefaultOrServerTarget(this.properties)) {
            gpc = new ServerCommand.GetPropertyCommand("*.server-config.*.http-listener-1.port");
            this.setEnvironmentProperty("httphostname", this.properties.get("host"), true);
        } else {
            String server = this.getServerFromTarget(target);
            String adminHost = this.properties.get("host");
            this.setEnvironmentProperty("httphostname", this.getHttpHostFromServer(server, adminHost), true);
            gpc = new ServerCommand.GetPropertyCommand("servers.server." + server + ".system-property.HTTP_LISTENER_PORT.value", true);
        }
        Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
        try {
            boolean didSet = false;
            if (result2.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                Map<String, String> retVal = gpc.getData();
                for (Map.Entry<String, String> entry : retVal.entrySet()) {
                    String val = entry.getValue();
                    try {
                        if (null == val || val.trim().length() <= 0) continue;
                        Integer.parseInt(val);
                        this.setEnvironmentProperty("httpportnumber", val, true);
                        didSet = true;
                    }
                    catch (NumberFormatException nfe) {}
                }
            }
            if (!didSet && !Util.isDefaultOrServerTarget(this.properties)) {
                this.setEnvironmentProperty("httpportnumber", "28080", true);
            }
        }
        catch (InterruptedException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (ExecutionException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, null, ex);
        }
        catch (TimeoutException ex) {
            Logger.getLogger("glassfish").log(Level.INFO, "could not get http port value in 10 seconds from the server", ex);
        }
    }

    private String getServerFromTarget(String target) {
        String retVal;
        block5: {
            retVal = target;
            ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("clusters.cluster." + target + ".server-ref.*.ref", true);
            Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
            try {
                if (result2.get(10L, TimeUnit.SECONDS) != GlassfishModule.OperationState.COMPLETED) break block5;
                Map<String, String> data = gpc.getData();
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    String val = entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    retVal = val;
                    break;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not get http port value in 10 seconds from the server", ex);
            }
        }
        return retVal;
    }

    private String getHttpHostFromServer(String server, String nameOfLocalhost) {
        String retVal;
        block7: {
            retVal = "localhostFAIL";
            ServerCommand.GetPropertyCommand gpc = new ServerCommand.GetPropertyCommand("servers.server." + server + ".node-ref");
            String refVal = null;
            Future<GlassfishModule.OperationState> result2 = this.execute(true, gpc);
            try {
                String val;
                Map<String, String> data;
                if (result2.get(10L, TimeUnit.SECONDS) == GlassfishModule.OperationState.COMPLETED) {
                    data = gpc.getData();
                    for (Map.Entry<String, String> entry : data.entrySet()) {
                        val = entry.getValue();
                        if (null == val || val.trim().length() <= 0) continue;
                        refVal = val;
                        break;
                    }
                }
                if ((result2 = this.execute(true, gpc = new ServerCommand.GetPropertyCommand("nodes.node." + refVal + ".node-host"))).get(10L, TimeUnit.SECONDS) != GlassfishModule.OperationState.COMPLETED) break block7;
                data = gpc.getData();
                for (Map.Entry<String, String> entry : data.entrySet()) {
                    val = entry.getValue();
                    if (null == val || val.trim().length() <= 0) continue;
                    retVal = val;
                    break;
                }
            }
            catch (InterruptedException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (ExecutionException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, null, ex);
            }
            catch (TimeoutException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "could not get http port value in 10 seconds from the server", ex);
            }
        }
        return "localhost".equals(retVal) ? nameOfLocalhost : retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean pingHttp(int maxTries) {
        boolean retVal = false;
        URL url = null;
        int tries = 0;
        while (!retVal && tries < maxTries) {
            ++tries;
            HttpURLConnection httpConn = null;
            try {
                url = new URL("http://" + this.getInstanceProperties().get("httphostname") + ":" + this.getInstanceProperties().get("httpportnumber") + "/");
                httpConn = (HttpURLConnection)url.openConnection();
                retVal = httpConn.getResponseCode() > 0;
            }
            catch (MalformedURLException mue) {
                Logger.getLogger("glassfish").log(Level.INFO, null, mue);
            }
            catch (ConnectException ce) {
                Logger.getLogger("glassfish").log(Level.FINE, url.toString(), ce);
            }
            catch (IOException ioe) {
                Logger.getLogger("glassfish").log(Level.INFO, url.toString(), ioe);
            }
            finally {
                if (null != httpConn) {
                    httpConn.disconnect();
                }
            }
            try {
                if (tries >= maxTries) continue;
                Thread.sleep(300L);
            }
            catch (InterruptedException ex) {}
        }
        Logger.getLogger("glassfish").log(Level.FINE, "pingHttp returns {0}", retVal);
        return retVal;
    }

    class StartOperationStateListener
    implements OperationStateListener {
        private GlassfishModule.ServerState endState;

        StartOperationStateListener(GlassfishModule.ServerState endState) {
            this.endState = endState;
        }

        @Override
        public void operationStateChanged(GlassfishModule.OperationState newState, String message) {
            if (newState == GlassfishModule.OperationState.RUNNING) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STARTING);
            } else if (newState == GlassfishModule.OperationState.COMPLETED) {
                CommonServerSupport.this.startedByIde = CommonServerSupport.this.isRemote ? false : CommonServerSupport.this.isReady(false, 300, TimeUnit.MILLISECONDS);
                CommonServerSupport.this.setServerState(this.endState);
            } else if (newState == GlassfishModule.OperationState.FAILED) {
                CommonServerSupport.this.setServerState(GlassfishModule.ServerState.STOPPED);
                NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)message);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)nd);
            }
        }
    }
}

