/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.netbeans.modules.glassfish.spi.ServerCommand;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.util.NbBundle;

public class Commands {
    public static final ServerCommand START = new ServerCommand("start-domain"){};
    public static final ServerCommand STOP = new ServerCommand("stop-domain"){};
    public static final ServerCommand RESTART = new ServerCommand("restart-domain"){};

    private static void appendLibraries(StringBuilder cmd, File[] libraries) {
        cmd.append('&').append("libraries=");
        boolean firstOne = true;
        for (File f : libraries) {
            if (!firstOne) {
                cmd.append(",");
            }
            cmd.append(f.getPath());
            firstOne = false;
        }
    }

    private static void addProperties(StringBuilder cmd, Boolean preserveSessions, boolean resourcesChanged) {
        if (Boolean.TRUE.equals(preserveSessions) || !resourcesChanged) {
            cmd.append('&').append("properties=");
        }
        if (Boolean.TRUE.equals(preserveSessions)) {
            cmd.append("keepSessions=true");
            if (!resourcesChanged) {
                cmd.append(":");
            }
        }
        if (!resourcesChanged) {
            cmd.append("preserveAppScopedResources=true");
        }
    }

    public static final class DeployCommand
    extends ServerCommand {
        private final boolean isDirDeploy;
        private final File path;

        public DeployCommand(File path, String name, String contextRoot, Boolean preserveSessions, Map<String, String> properties, File[] libraries, String target) {
            super("deploy");
            this.isDirDeploy = path.isDirectory();
            this.path = path;
            StringBuilder cmd = new StringBuilder(128);
            cmd.append("DEFAULT=");
            cmd.append(path.getAbsolutePath());
            if (name != null && name.length() > 0) {
                cmd.append('&').append("name=");
                cmd.append(Utils.sanitizeName(name));
            }
            if (contextRoot != null && contextRoot.length() > 0) {
                cmd.append('&').append("contextroot=");
                cmd.append(contextRoot);
            }
            if (libraries.length > 0) {
                Commands.appendLibraries(cmd, libraries);
            }
            cmd.append('&').append("force=true");
            this.addProperties(cmd, properties);
            if (null != target) {
                cmd.append('&').append("target=" + target);
            }
            this.query = cmd.toString();
        }

        @Override
        public String getContentType() {
            return this.isDirDeploy ? null : "application/zip";
        }

        @Override
        public boolean getDoOutput() {
            return !this.isDirDeploy;
        }

        @Override
        public InputStream getInputStream() {
            if (this.isDirDeploy) {
                return null;
            }
            try {
                return new FileInputStream(this.path);
            }
            catch (FileNotFoundException fnfe) {
                Logger.getLogger("glassfish").log(Level.INFO, this.path.getPath(), fnfe);
                return null;
            }
        }

        @Override
        public String getRequestMethod() {
            return this.isDirDeploy ? super.getRequestMethod() : "POST";
        }

        @Override
        public String getInputName() {
            return this.path.getName();
        }

        @Override
        public String getLastModified() {
            return Long.toString(this.path.lastModified());
        }

        private void addProperties(StringBuilder cmd, Map<String, String> properties) {
            if (null != properties && properties.size() > 0) {
                cmd.append('&').append("properties=");
                int i = 0;
                for (Map.Entry<String, String> e : properties.entrySet()) {
                    String k = e.getKey();
                    String v = e.getValue();
                    if (i > 0) {
                        cmd.append(":");
                    }
                    cmd.append(k).append("=").append(v);
                }
            }
        }
    }

    public static final class DisableCommand
    extends ServerCommand {
        public DisableCommand(String name, String target) {
            super("disable");
            this.query = "DEFAULT=" + Utils.sanitizeName(name);
            if (null != target) {
                this.query = this.query + "&target=" + target;
            }
        }
    }

    public static final class EnableCommand
    extends ServerCommand {
        public EnableCommand(String name, String target) {
            super("enable");
            this.query = "DEFAULT=" + Utils.sanitizeName(name);
            if (null != target) {
                this.query = this.query + "&target=" + target;
            }
        }
    }

    public static final class FetchLogData
    extends ServerCommand {
        private String lines = "";
        private String nextURL = "";

        public FetchLogData(String query) {
            super("view-log");
            this.query = query;
        }

        public String getLines() {
            return this.lines;
        }

        public String getNextQuery() {
            return this.nextURL;
        }

        @Override
        public boolean acceptsGzip() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean readResponse(InputStream in, HttpURLConnection hconn) {
            StringWriter sw = new StringWriter();
            try {
                InputStream cooked = in;
                String ce = hconn.getContentEncoding();
                if (null != ce && ce.contains("gzip")) {
                    cooked = new GZIPInputStream(in);
                }
                InputStreamReader isr = new InputStreamReader(cooked);
                BufferedReader br = new BufferedReader(isr);
                while (br.ready()) {
                    sw.write(br.readLine());
                    sw.write("\n");
                }
            }
            catch (IOException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, "", ex);
            }
            finally {
                try {
                    sw.close();
                }
                catch (IOException ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, "", ex);
                }
            }
            this.lines = sw.toString();
            this.nextURL = hconn.getHeaderField("X-Text-Append-Next");
            int delim = this.nextURL.lastIndexOf("?");
            if (-1 != delim) {
                this.nextURL = this.nextURL.substring(delim + 1);
            }
            return -1 != delim;
        }

        @Override
        public String getSrc() {
            return "/management/domain/";
        }
    }

    public static final class ListComponentsCommand
    extends ServerCommand {
        private final String container;
        private Manifest list;
        private Map<String, List<String>> appMap;
        private static final List<String> engineBias = Arrays.asList("ear", "jruby", "web", "ejb", "appclient", "connector");

        public ListComponentsCommand() {
            this(null, null);
        }

        public ListComponentsCommand(String container, String target) {
            super("list-components");
            if (null != target) {
                this.query = "DEFAULT=" + target;
            }
            this.container = container;
        }

        public String[] getContainers() {
            String[] result = null;
            if (this.appMap != null && this.appMap.size() > 0) {
                Set<String> containers = this.appMap.keySet();
                result = containers.toArray(new String[containers.size()]);
            }
            return result != null ? result : new String[]{};
        }

        public Map<String, List<String>> getApplicationMap() {
            if (this.appMap != null) {
                return Collections.unmodifiableMap(this.appMap);
            }
            return Collections.emptyMap();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] apps;
            if (this.list == null) {
                return false;
            }
            String appsList = null;
            try {
                String tmp = this.list.getMainAttributes().getValue("children");
                if (null != tmp) {
                    appsList = tmp;
                    appsList = URLDecoder.decode(tmp, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger("glassfish").log(Level.WARNING, "Could not URL decode with UTF-8");
            }
            catch (IllegalArgumentException iae) {
                // empty catch block
            }
            if (appsList == null || appsList.length() == 0) {
                return true;
            }
            for (String appKey : apps = appsList.split(";")) {
                List<String> appList;
                if ("null".equals(appKey)) {
                    Logger.getLogger("glassfish").log(Level.WARNING, "list-components contains an invalid result.  Check server log for possible exceptions.");
                    continue;
                }
                String[] keys = appKey.split("[<>]");
                String name = keys[0];
                if (name == null || name.length() == 0) {
                    Logger.getLogger("glassfish").log(Level.FINE, "Skipping application with no name...");
                    continue;
                }
                String engine = this.getPreferredEngine(keys[1]);
                if (this.appMap == null) {
                    this.appMap = new HashMap<String, List<String>>();
                }
                if ((appList = this.appMap.get(engine)) == null) {
                    appList = new ArrayList<String>();
                    this.appMap.put(engine, appList);
                }
                appList.add(name);
            }
            return true;
        }

        private String getPreferredEngine(String engineList) {
            String[] engines = engineList.split(",");
            String engine = null;
            int bias = -1;
            for (int i = 0; i < engines.length; ++i) {
                if (this.skipContainer(engines[i])) continue;
                engines[i] = engines[i].trim();
                int newBias = engineBias.indexOf(engines[i]);
                if (newBias >= 0 && (bias == -1 || newBias < bias)) {
                    bias = newBias;
                }
                if (engine != null) continue;
                engine = engines[i];
            }
            if (bias != -1) {
                engine = engineBias.get(bias);
            } else if (engine == null) {
                engine = "unknown";
            }
            return engine;
        }

        private boolean skipContainer(String currentContainer) {
            return this.container != null ? !this.container.equals(currentContainer) : "security_ContractProvider".equals(currentContainer);
        }
    }

    public static final class ListResourcesCommand
    extends ServerCommand {
        private final String cmdSuffix;
        private Manifest list;
        private List<ResourceDesc> resList;

        public ListResourcesCommand(String resourceCmdSuffix, String target) {
            super("list-" + resourceCmdSuffix + "s");
            this.cmdSuffix = resourceCmdSuffix;
            if (null != target) {
                this.query = "DEFAULT=" + target;
            }
        }

        public List<ResourceDesc> getResourceList() {
            if (this.resList != null) {
                return Collections.unmodifiableList(this.resList);
            }
            return Collections.emptyList();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.list = manifest;
        }

        @Override
        public boolean processResponse() {
            String[] resources;
            if (this.list == null) {
                return false;
            }
            String resourceList = this.list.getMainAttributes().getValue("children");
            if (resourceList == null || resourceList.length() == 0) {
                return true;
            }
            for (String r : resources = resourceList.split("[,;]")) {
                if (r == null || this.skipResource(r)) continue;
                Attributes resourceAttr = this.list.getAttributes(r);
                if (resourceAttr != null) {
                    String name = null;
                    String tmp = null;
                    try {
                        tmp = resourceAttr.getValue("message");
                        if (null != tmp) {
                            name = URLDecoder.decode(tmp, "UTF-8");
                        }
                        if (null == name || name.length() < 1) {
                            name = URLDecoder.decode(r.trim(), "UTF-8");
                        }
                    }
                    catch (UnsupportedEncodingException uee) {
                        Logger.getLogger("glassfish").log(Level.INFO, "", uee);
                    }
                    if (name == null || name.length() <= 0) continue;
                    if (this.resList == null) {
                        this.resList = new ArrayList<ResourceDesc>();
                    }
                    this.resList.add(new ResourceDesc(name, this.cmdSuffix));
                    continue;
                }
                Logger.getLogger("glassfish").log(Level.FINE, "No resource attributes returned for {0}", r);
            }
            return true;
        }

        private boolean skipResource(String r) {
            return r.equals(NbBundle.getMessage(Commands.class, (String)"nothingToList"));
        }
    }

    static class ListWebservicesCommand
    extends ServerCommand {
        private Manifest manifest;
        private List<String> wsList;

        public ListWebservicesCommand() {
            super("__list-webservices");
        }

        public List<String> getWebserviceList() {
            if (this.wsList != null) {
                return Collections.unmodifiableList(this.wsList);
            }
            return Collections.emptyList();
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.manifest = manifest;
        }

        @Override
        public boolean processResponse() {
            if (this.manifest == null) {
                return false;
            }
            HashMap<String, String> filter = new HashMap<String, String>();
            for (String k : this.manifest.getEntries().keySet()) {
                String a;
                if (!k.contains("address:/") || k.contains("address:/wsat-wsat") || k.contains("address:/__wstx-services") || filter.containsKey(a = k.replaceFirst(".* address:/", "").replaceFirst("\\. .*", ""))) continue;
                filter.put(a, a);
                if (this.wsList == null) {
                    this.wsList = new ArrayList<String>();
                }
                this.wsList.add(a);
            }
            return true;
        }
    }

    public static final class LocationCommand
    extends ServerCommand {
        private Manifest info;
        private String installRoot;
        private String domainRoot;

        public LocationCommand() {
            super("__locations");
        }

        public String getInstallRoot() {
            return this.installRoot;
        }

        public String getDomainRoot() {
            return this.domainRoot;
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            if (this.info == null) {
                return false;
            }
            Attributes mainAttrs = this.info.getMainAttributes();
            if (mainAttrs != null) {
                this.installRoot = mainAttrs.getValue("Base-Root_value");
                this.domainRoot = mainAttrs.getValue("Domain-Root_value");
            }
            return true;
        }
    }

    public static final class RedeployCommand
    extends ServerCommand {
        public RedeployCommand(String name, String contextRoot, Boolean preserveSessions, File[] libraries, boolean resourcesChanged, String additionalparam, String target) {
            super("redeploy");
            StringBuilder cmd = new StringBuilder(128);
            cmd.append("name=");
            cmd.append(Utils.sanitizeName(name));
            if (contextRoot != null && contextRoot.length() > 0) {
                cmd.append('&').append("contextroot=");
                cmd.append(contextRoot);
            }
            if (libraries.length > 0) {
                Commands.appendLibraries(cmd, libraries);
            }
            if (null != additionalparam && !"".equals(additionalparam.trim())) {
                cmd.append('&').append(additionalparam);
            }
            Commands.addProperties(cmd, preserveSessions, resourcesChanged);
            if (null != target) {
                cmd.append('&').append("target=" + target);
            }
            this.query = cmd.toString();
        }
    }

    public static final class StartCluster
    extends ServerCommand {
        public StartCluster(String target) {
            super("start-cluster");
            this.query = "DEFAULT=" + target;
        }
    }

    public static final class StartInstance
    extends ServerCommand {
        public StartInstance(String target) {
            super("start-instance");
            this.query = "DEFAULT=" + target;
        }
    }

    public static final class StopCluster
    extends ServerCommand {
        public StopCluster(String target) {
            super("stop-cluster");
            this.query = "DEFAULT=" + target;
        }
    }

    public static final class StopInstance
    extends ServerCommand {
        public StopInstance(String target) {
            super("stop-instance");
            this.query = "DEFAULT=" + target;
        }
    }

    public static final class UndeployCommand
    extends ServerCommand {
        public UndeployCommand(String name, String target) {
            super("undeploy");
            this.query = "DEFAULT=" + Utils.sanitizeName(name);
            if (null != target) {
                this.query = this.query + "&target=" + target;
            }
        }
    }

    public static final class UnregisterCommand
    extends ServerCommand {
        public UnregisterCommand(String name, String resourceCmdSuffix, String cmdPropertyName, boolean cascade, String target) {
            super("delete-" + resourceCmdSuffix);
            StringBuilder cmd = new StringBuilder(128);
            if (cascade) {
                cmd.append("cascade=true");
                cmd.append('&');
            }
            cmd.append(cmdPropertyName);
            cmd.append('=');
            cmd.append(name);
            this.query = cmd.toString();
            if (null != target) {
                this.query = this.query + "&target=" + target;
            }
        }
    }

    public static final class VersionCommand
    extends ServerCommand {
        private Manifest info;

        public VersionCommand() {
            super("version");
        }

        @Override
        public void readManifest(Manifest manifest) throws IOException {
            this.info = manifest;
        }

        @Override
        public boolean processResponse() {
            return true;
        }
    }
}

