/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.web.connector.grizzly;

import com.sun.enterprise.web.connector.grizzly.CoyoteConnectorLauncher;
import com.sun.grizzly.http.Management;
import com.sun.grizzly.http.SelectorThread;
import com.sun.grizzly.http.portunif.HttpProtocolFinder;
import com.sun.grizzly.ssl.SSLSelectorThread;
import com.sun.grizzly.util.net.SSLImplementation;
import com.sun.grizzly.util.net.ServerSocketFactory;
import com.sun.logging.LogDomains;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;
import org.apache.tomcat.util.modeler.Registry;

public class GrizzlyConnectorLauncher
extends CoyoteConnectorLauncher {
    private static final Logger logger = LogDomains.getLogger(GrizzlyConnectorLauncher.class, (String)"javax.enterprise.system.container.web");
    private static final ResourceBundle rb = logger.getResourceBundle();
    private int socketBuffer = 9000;
    private SelectorThread selectorThread;
    private Management jmxManagement = null;
    private String compression = "off";
    private String noCompressionUserAgents = null;
    private String restrictedUserAgents = null;
    private String compressableMimeTypes = "text/html,text/xml,text/plain";
    private int compressionMinSize = 2048;
    private String proxiedProtocols;
    private static final ConcurrentLinkedQueue<String> supportedHandlers = new ConcurrentLinkedQueue();
    private static final ConcurrentHashMap<String, String> supportedProtocols = new ConcurrentHashMap();
    private static final String TLS = "tls";
    private static final String HTTP = "http";

    public GrizzlyConnectorLauncher(boolean secure, boolean blocking, String selectorThreadImpl) {
        super(secure, blocking, selectorThreadImpl);
        this.create();
    }

    protected void create() {
        this.selectorThread = !this.secure ? new SelectorThread() : new SSLSelectorThread();
        this.setSoLinger(-1);
        this.setSoTimeout(30000);
        this.setServerSoTimeout(0);
        this.setTcpNoDelay(true);
    }

    public void init() throws Exception {
        try {
            this.checkSocketFactory();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.socketfactory.initerror", ex);
            throw ex;
        }
        if (this.socketFactory != null) {
            Enumeration attE = this.attributes.keys();
            while (attE.hasMoreElements()) {
                String key = (String)attE.nextElement();
                Object v = this.attributes.get(key);
                this.socketFactory.setAttribute(key, v);
            }
        }
        if (this.secure && !this.blocking) {
            this.socketFactory.init();
            ((SSLSelectorThread)this.selectorThread).setSSLContext(this.socketFactory.getSSLContext());
        }
        try {
            this.selectorThread.setAdapter(this.adapter);
            this.selectorThread.initEndpoint();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.initerror", ex);
            throw ex;
        }
    }

    public void start() throws Exception {
        try {
            if (this.oname != null) {
                this.jmxManagement = new ModelerManagement();
                this.selectorThread.setManagement(this.jmxManagement);
                try {
                    ObjectName sname = new ObjectName(this.domain + ":type=Selector,name=http" + this.selectorThread.getPort());
                    this.jmxManagement.registerComponent((Object)this.selectorThread, sname, null);
                }
                catch (Exception ex) {
                    String msg = rb.getString("grizzlyHttpProtocol.selectorRegistrationFailed");
                    msg = MessageFormat.format(msg, this.oname);
                    logger.log(Level.SEVERE, msg, ex);
                }
            }
            this.selectorThread.start();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "grizzlyHttpProtocol.endpoint.starterror", ex);
            throw ex;
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "grizzlyHttpProtocol.start", String.valueOf(this.getPort()));
        }
    }

    public void destroy() throws Exception {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, "grizzlyHttpProtocol.stop", String.valueOf(this.getPort()));
        }
        if (this.domain != null) {
            this.jmxManagement.unregisterComponent(new ObjectName(this.domain, "type", "Selector"));
        }
        this.selectorThread.stopEndpoint();
    }

    public int getMaxThreads() {
        return this.selectorThread.getMaxThreads();
    }

    public void setMaxThreads(int maxThreads) {
        this.selectorThread.setMaxThreads(maxThreads);
        this.setAttribute("maxThreads", "" + maxThreads);
    }

    public void setMaxPostSize(int maxPostSize) {
        this.selectorThread.setMaxPostSize(maxPostSize);
        this.setAttribute("maxPostSize", maxPostSize);
    }

    public int getProcessorThreadsIncrement() {
        return 0;
    }

    public void setProcessorThreadsIncrement(int threadsIncrement) {
        this.setAttribute("threadsIncrement", "" + threadsIncrement);
    }

    public void setProcessorWorkerThreadsTimeout(int timeout) {
        this.setAttribute("threadsTimeout", "" + timeout);
    }

    public int getProcessorWorkerThreadsTimeout() {
        return 0;
    }

    public int getBacklog() {
        return this.selectorThread.getSsBackLog();
    }

    public void setBacklog(int i) {
    }

    public int getPort() {
        return this.selectorThread.getPort();
    }

    public void setPort(int port) {
        this.selectorThread.setPort(port);
        this.setAttribute("port", "" + port);
    }

    public InetAddress getAddress() {
        return this.selectorThread.getAddress();
    }

    public void setAddress(InetAddress ia) {
        this.selectorThread.setAddress(ia);
        this.setAttribute("address", "" + ia);
    }

    public String getName() {
        String encodedAddr = "";
        if (this.getAddress() != null) {
            encodedAddr = "" + this.getAddress();
            if (encodedAddr.startsWith("/")) {
                encodedAddr = encodedAddr.substring(1);
            }
            encodedAddr = URLEncoder.encode(encodedAddr) + "-";
        }
        return "http-" + encodedAddr + this.selectorThread.getPort();
    }

    public boolean getTcpNoDelay() {
        return this.selectorThread.getTcpNoDelay();
    }

    public void setTcpNoDelay(boolean b) {
        this.selectorThread.setTcpNoDelay(b);
        this.setAttribute("tcpNoDelay", "" + b);
    }

    public boolean getDisableUploadTimeout() {
        return this.disableUploadTimeout;
    }

    public void setDisableUploadTimeout(boolean isDisabled) {
        this.disableUploadTimeout = isDisabled;
    }

    public int getSocketBuffer() {
        return this.socketBuffer;
    }

    public void setSocketBuffer(int valueI) {
        this.socketBuffer = valueI;
    }

    public void setMaxHttpHeaderSize(int maxHttpHeaderSize) {
        super.setMaxHttpHeaderSize(maxHttpHeaderSize);
        this.selectorThread.setMaxHttpHeaderSize(maxHttpHeaderSize);
    }

    public String getCompression() {
        return this.compression;
    }

    public void setCompression(String valueS) {
        this.compression = valueS;
        this.selectorThread.setCompression(this.compression);
    }

    public String getRestrictedUserAgents() {
        return this.restrictedUserAgents;
    }

    public void setRestrictedUserAgents(String valueS) {
        this.restrictedUserAgents = valueS;
        this.selectorThread.setRestrictedUserAgents(valueS);
    }

    public String getNoCompressionUserAgents() {
        return this.noCompressionUserAgents;
    }

    public void setNoCompressionUserAgents(String valueS) {
        this.noCompressionUserAgents = valueS;
        this.selectorThread.setNoCompressionUserAgents(valueS);
    }

    public String getCompressableMimeType() {
        return this.compressableMimeTypes;
    }

    public void setCompressableMimeType(String valueS) {
        this.compressableMimeTypes = valueS;
        this.selectorThread.setCompressableMimeTypes(valueS);
    }

    public int getCompressionMinSize() {
        return this.compressionMinSize;
    }

    public void setCompressionMinSize(int valueI) {
        this.compressionMinSize = valueI;
        this.selectorThread.setCompressionMinSize(valueI);
    }

    public int getSoLinger() {
        return this.selectorThread.getLinger();
    }

    public void setSoLinger(int i) {
        this.selectorThread.setLinger(i);
        this.setAttribute("soLinger", "" + i);
    }

    public int getSoTimeout() {
        return 0;
    }

    public void setSoTimeout(int i) {
        this.setAttribute("soTimeout", "" + i);
    }

    public int getServerSoTimeout() {
        return 0;
    }

    public void setServerSoTimeout(int i) {
        this.setAttribute("serverSoTimeout", "" + i);
    }

    public void setSecure(boolean b) {
        super.setSecure(b);
    }

    public void setMaxKeepAliveRequests(int mkar) {
        this.selectorThread.setMaxKeepAliveRequests(mkar);
    }

    public void setKeepAliveTimeoutInSeconds(int timeout) {
        this.selectorThread.setKeepAliveTimeoutInSeconds(timeout);
    }

    public void setKeepAliveThreadCount(int threadCount) {
        this.selectorThread.setMaxKeepAliveRequests(threadCount);
    }

    public void setMinThreads(int minThreads) {
    }

    public void setBufferSize(int requestBufferSize) {
        super.setBufferSize(requestBufferSize);
        this.selectorThread.setBufferSize(requestBufferSize);
    }

    public void setSelectorTimeout(int selectorTimeout) {
        this.selectorThread.setSelectorTimeout(selectorTimeout);
    }

    public int getSelectorTimeout() {
        return this.selectorThread.getSelectorTimeout();
    }

    public void setMaxReadWorkerThreads(int maxReadWorkerThreads) {
    }

    public int getMaxReadWorkerThreads() {
        return 0;
    }

    public void setDisplayConfiguration(boolean displayConfiguration) {
        this.selectorThread.setDisplayConfiguration(displayConfiguration);
    }

    public boolean getDisplayConfiguration() {
        return false;
    }

    public void setRecycleTasks(boolean recycleTasks) {
    }

    public boolean getRecycleTasks() {
        return false;
    }

    public void setUseByteBufferView(boolean useByteBufferView) {
        this.selectorThread.setUseByteBufferView(useByteBufferView);
    }

    public boolean getUseByteBufferView() {
        return this.selectorThread.isUseByteBufferView();
    }

    public void setMaxProcessorWorkerThreads(int maxProcessorWorkerThreads) {
        this.selectorThread.setMaxThreads(maxProcessorWorkerThreads);
    }

    public int getMaxProcessorWorkerThreads() {
        return this.selectorThread.getMaxThreads();
    }

    public void setMinReadQueueLength(int minReadQueueLength) {
    }

    public int getMinReadQueueLength() {
        return 0;
    }

    public void setMinProcessorQueueLength(int minProcessorQueueLength) {
    }

    public int getMinProcessorQueueLength() {
        return 0;
    }

    public void setUseDirectByteBuffer(boolean useDirectByteBuffer) {
        this.selectorThread.setUseDirectByteBuffer(useDirectByteBuffer);
    }

    public boolean getUseDirectByteBuffer() {
        return this.selectorThread.isUseDirectByteBuffer();
    }

    public void setQueueSizeInBytes(int maxQueueSizeInBytes) {
    }

    public void setSocketServerBacklog(int ssBackLog) {
        this.selectorThread.setSsBackLog(ssBackLog);
    }

    public void setSelectorReadThreadsCount(int selectorReadThreadsCount) {
        this.selectorThread.setSelectorReadThreadsCount(selectorReadThreadsCount);
    }

    public void setDefaultResponseType(String defaultResponseType) {
        this.selectorThread.setDefaultResponseType(defaultResponseType);
    }

    public String getDefaultResponseType() {
        return this.selectorThread.getDefaultResponseType();
    }

    public void setForcedRequestType(String forcedResponseType) {
        this.selectorThread.setForcedRequestType(forcedResponseType);
    }

    public String getForcedRequestType() {
        return this.selectorThread.getForcedRequestType();
    }

    public void setSecondsMaxAge(int sMaxAges) {
        this.selectorThread.setSecondsMaxAge(sMaxAges);
    }

    public void setMaxCacheEntries(int mEntries) {
        this.selectorThread.setMaxCacheEntries(mEntries);
    }

    public int getMaxCacheEntries() {
        return this.selectorThread.getMaxCacheEntries();
    }

    public void setMinEntrySize(long mSize) {
        this.selectorThread.setMinEntrySize(mSize);
    }

    public long getMinEntrySize() {
        return this.selectorThread.getMinEntrySize();
    }

    public void setMaxEntrySize(long mEntrySize) {
        this.selectorThread.setMaxEntrySize(mEntrySize);
    }

    public long getMaxEntrySize() {
        return this.selectorThread.getMaxEntrySize();
    }

    public void setMaxLargeCacheSize(long mCacheSize) {
        this.selectorThread.setMaxLargeCacheSize(mCacheSize);
    }

    public long getMaxLargeCacheSize() {
        return this.selectorThread.getMaxLargeCacheSize();
    }

    public void setMaxSmallCacheSize(long mCacheSize) {
        this.selectorThread.setMaxSmallCacheSize(mCacheSize);
    }

    public long getMaxSmallCacheSize() {
        return this.selectorThread.getMaxSmallCacheSize();
    }

    public boolean isFileCacheEnabled() {
        return this.selectorThread.isFileCacheEnabled();
    }

    public void setFileCacheEnabled(boolean isFileCacheEnabled) {
        this.selectorThread.setFileCacheIsEnabled(isFileCacheEnabled);
    }

    public void setLargeFileCacheEnabled(boolean isLargeEnabled) {
        this.selectorThread.setLargeFileCacheEnabled(isLargeEnabled);
    }

    public boolean getLargeFileCacheEnabled() {
        return this.selectorThread.getLargeFileCacheEnabled();
    }

    public void setWebAppRootPath(String rootFolder) {
        this.selectorThread.setWebAppRootPath(rootFolder);
    }

    public String getWebAppRootPath() {
        return this.selectorThread.getWebAppRootPath();
    }

    public SelectorThread selectorThread() {
        return this.selectorThread;
    }

    public void setCometSupport(boolean cometSupport) {
    }

    public void setRcmSupport(boolean rcmSupport) {
        this.selectorThread.enableRcmSupport(rcmSupport);
    }

    private void checkSocketFactory() throws Exception {
        if (!this.blocking && !this.secure) {
            return;
        }
        SSLSelectorThread secureSel = (SSLSelectorThread)this.selectorThread;
        if (this.secure) {
            this.sslImplementation = SSLImplementation.getInstance(this.sslImplementationName);
            this.socketFactory = this.sslImplementation.getServerSocketFactory();
            secureSel.setSSLImplementation(this.sslImplementation);
            secureSel.setEnabledCipherSuites(GrizzlyConnectorLauncher.toStringArray(this.getCiphers()));
            secureSel.setEnabledProtocols(GrizzlyConnectorLauncher.toStringArray(this.getProtocols()));
            String clientAuthStr = (String)this.getAttribute("clientauth");
            if (clientAuthStr != null) {
                secureSel.setNeedClientAuth(Boolean.valueOf(clientAuthStr).booleanValue());
            }
        } else if (this.socketFactoryName != null) {
            this.socketFactory = GrizzlyConnectorLauncher.string2SocketFactory(this.socketFactoryName);
        }
        if (this.socketFactory == null) {
            this.socketFactory = ServerSocketFactory.getDefault();
        }
    }

    private static final String[] toStringArray(String list) {
        if (list == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(list, ",");
        String[] array = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            array[i++] = st.nextToken();
        }
        return array;
    }

    public void setReuseAddress(boolean reuseAddress) {
        this.selectorThread.setReuseAddress(reuseAddress);
    }

    public boolean getReuseAddress() {
        return this.selectorThread.getReuseAddress();
    }

    public String getProxiedProtocols() {
        return this.proxiedProtocols;
    }

    public void setProxiedProtocols(String proxiedProtocols) {
        this.proxiedProtocols = proxiedProtocols;
    }

    static {
        supportedProtocols.put(HTTP, HttpProtocolFinder.class.getName());
        supportedProtocols.put("ws/tcp", "com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolFinder");
        supportedHandlers.add("com.sun.xml.ws.transport.tcp.grizzly.WSTCPProtocolHandler");
    }

    static class ModelerManagement
    implements Management {
        ModelerManagement() {
        }

        public void registerComponent(Object bean, ObjectName oname, String type) throws Exception {
            Registry.getRegistry(null, null).registerComponent(bean, oname, type);
        }

        public void unregisterComponent(ObjectName oname) throws Exception {
            Registry.getRegistry(null, null).unregisterComponent(oname);
        }
    }
}

