/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.netbeans.modules.db.util.DataComboBoxModel;

public final class DataComboBoxSupport {
    private final DataComboBoxModel dataModel;
    private final boolean allowAdding;
    private Object previousItem = null;
    private Object previousNonSpecialItem = null;
    private boolean performingNewItemAction = false;
    final Object NEW_ITEM = new Object(){

        public String toString() {
            return DataComboBoxSupport.this.dataModel.getNewItemDisplayName();
        }
    };

    DataComboBoxSupport(JComboBox comboBox, DataComboBoxModel dataModel, boolean allowAdding) {
        this.dataModel = dataModel;
        this.allowAdding = allowAdding;
        comboBox.setEditable(false);
        comboBox.setModel(new ItemComboBoxModel());
        comboBox.setRenderer(new ItemListCellRenderer());
        comboBox.addActionListener(new ItemActionListener());
        comboBox.addPopupMenuListener(new ItemPopupMenuListener());
    }

    public static void connect(JComboBox comboBox, DataComboBoxModel dataModel) {
        DataComboBoxSupport.connect(comboBox, dataModel, true);
    }

    public static void connect(JComboBox comboBox, DataComboBoxModel dataModel, boolean allowAdding) {
        new DataComboBoxSupport(comboBox, dataModel, allowAdding);
    }

    private boolean isSpecialItem(Object item) {
        return item == this.NEW_ITEM;
    }

    private void setPreviousNonSpecialItem(JComboBox comboBox) {
        if (comboBox.getSelectedItem() == this.NEW_ITEM) {
            comboBox.setSelectedItem(this.previousNonSpecialItem);
        }
    }

    private final class ItemActionListener
    implements ActionListener {
        private ItemActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            final JComboBox comboBox = (JComboBox)e.getSource();
            Object selectedItem = comboBox.getSelectedItem();
            if (selectedItem == DataComboBoxSupport.this.NEW_ITEM) {
                DataComboBoxSupport.this.performingNewItemAction = true;
                try {
                    comboBox.setPopupVisible(false);
                    DataComboBoxSupport.this.dataModel.newItemActionPerformed();
                }
                finally {
                    DataComboBoxSupport.this.performingNewItemAction = false;
                }
                DataComboBoxSupport.this.setPreviousNonSpecialItem(comboBox);
                final Object newSelectedItem = comboBox.getSelectedItem();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        comboBox.setSelectedItem(newSelectedItem);
                    }
                });
            }
        }
    }

    private class ItemComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel,
    ListDataListener {
        public ItemComboBoxModel() {
            this.getDelegate().addListDataListener(this);
        }

        @Override
        public Object getElementAt(int index) {
            if (DataComboBoxSupport.this.allowAdding) {
                if (this.getSize() == 1) {
                    if (index == 0) {
                        return DataComboBoxSupport.this.NEW_ITEM;
                    }
                    throw new IllegalStateException("Index out of bounds: " + index);
                }
                if (index >= 0 && index < this.getDelegate().getSize()) {
                    return this.getDelegate().getElementAt(index);
                }
                if (index == this.getSize() - 1) {
                    return DataComboBoxSupport.this.NEW_ITEM;
                }
                throw new IllegalStateException("Index out of bounds: " + index);
            }
            return this.getDelegate().getElementAt(index);
        }

        @Override
        public int getSize() {
            if (DataComboBoxSupport.this.allowAdding) {
                return this.getDelegate().getSize() == 0 ? 1 : this.getDelegate().getSize() + 1;
            }
            return this.getDelegate().getSize();
        }

        @Override
        public void setSelectedItem(Object anItem) {
            DataComboBoxSupport.this.previousItem = this.getDelegate().getSelectedItem();
            if (!DataComboBoxSupport.this.isSpecialItem(DataComboBoxSupport.this.previousItem)) {
                DataComboBoxSupport.this.previousNonSpecialItem = DataComboBoxSupport.this.previousItem;
            }
            this.getDelegate().setSelectedItem(anItem);
        }

        @Override
        public Object getSelectedItem() {
            return this.getDelegate().getSelectedItem();
        }

        public Object getPreviousItem() {
            return DataComboBoxSupport.this.previousItem;
        }

        private ComboBoxModel getDelegate() {
            return DataComboBoxSupport.this.dataModel.getListModel();
        }

        private int getItemIndex(Object item) {
            if (item == null) {
                return -1;
            }
            for (int i = 0; i < this.getSize(); ++i) {
                if (!this.getElementAt(i).equals(item)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            throw new UnsupportedOperationException("This is currently not supported.");
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireContentsChanged(this, 0, this.getSize());
        }
    }

    private class ItemListCellRenderer
    extends DefaultListCellRenderer {
        private ItemListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            JLabel label = (JLabel)component;
            if (value != null && !DataComboBoxSupport.this.isSpecialItem(value)) {
                String displayName = DataComboBoxSupport.this.dataModel.getItemDisplayName(value);
                label.setText(DataComboBoxSupport.this.dataModel.getItemDisplayName(value));
                label.setToolTipText(DataComboBoxSupport.this.dataModel.getItemTooltipText(value));
            } else if (value != null) {
                label.setText(value.toString());
                label.setToolTipText(null);
            }
            return label;
        }
    }

    private final class ItemPopupMenuListener
    implements PopupMenuListener {
        private ItemPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)e.getSource());
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            if (!DataComboBoxSupport.this.performingNewItemAction) {
                DataComboBoxSupport.this.setPreviousNonSpecialItem((JComboBox)e.getSource());
            }
        }
    }
}

