/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.explorer.node.TableNode;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class TableNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private MetadataElementHandle<Schema> schemaHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private TableNodeProvider(Lookup lookup) {
        super(lookup, new TableComparator());
    }

    @Override
    protected void initialize() {
        final ArrayList<Node> newList = new ArrayList<Node>();
        boolean connected = !this.connection.getConnector().isDisconnected();
        MetadataModel metaDataModel = this.connection.getMetadataModel();
        if (connected && metaDataModel != null) {
            try {
                metaDataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metaData) {
                        Schema schema = (Schema)TableNodeProvider.this.schemaHandle.resolve(metaData);
                        if (schema != null) {
                            Collection tables = schema.getTables();
                            for (Table table : tables) {
                                MetadataElementHandle handle = MetadataElementHandle.create((MetadataElement)table);
                                Collection matches = TableNodeProvider.this.getNodes(handle);
                                if (matches.size() > 0) {
                                    newList.addAll(matches);
                                    continue;
                                }
                                NodeDataLookup lookup = new NodeDataLookup();
                                lookup.add(TableNodeProvider.this.connection);
                                lookup.add(handle);
                                newList.add(TableNode.create(lookup, TableNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException e) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, e, true);
            }
        }
        this.setNodes(newList);
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public TableNodeProvider createInstance(Lookup lookup) {
                TableNodeProvider provider = new TableNodeProvider(lookup);
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }

    static class TableComparator
    implements Comparator<Node> {
        TableComparator() {
        }

        @Override
        public int compare(Node node1, Node node2) {
            return node1.getDisplayName().compareTo(node2.getDisplayName());
        }
    }
}

