/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import javax.swing.SwingUtilities;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ConnectionNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ConnectionNodeProvider
extends NodeProvider {
    private final ConnectionList connectionList = (ConnectionList)this.getLookup().lookup(ConnectionList.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ConnectionNodeProvider(Lookup lookup) {
        super(lookup, new ConnectionComparator());
    }

    private void setup() {
        this.connectionList.addConnectionListener(new ConnectionListener(){

            @Override
            public void connectionsChanged() {
                ConnectionNodeProvider.this.initialize();
            }
        });
    }

    @Override
    protected synchronized void initialize() {
        DatabaseConnection[] connections;
        ArrayList<Node> newList = new ArrayList<Node>();
        DatabaseConnection newConnection = null;
        for (DatabaseConnection connection : connections = this.connectionList.getConnections()) {
            Collection<Node> matches = this.getNodes(connection);
            if (matches.size() > 0) {
                newList.addAll(matches);
                continue;
            }
            NodeDataLookup lookup = new NodeDataLookup();
            lookup.add(connection);
            newConnection = connection;
            newList.add((Node)ConnectionNode.create(lookup, this));
        }
        this.setNodes(newList);
        final DatabaseConnection newConnectionFinal = newConnection;
        if (newConnection != null) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        newConnectionFinal.selectInExplorer(false);
                    }
                });
            } else {
                newConnectionFinal.selectInExplorer(false);
            }
        }
    }

    static class ConnectionComparator
    implements Comparator<Node> {
        ConnectionComparator() {
        }

        @Override
        public int compare(Node model1, Node model2) {
            return model1.getDisplayName().compareToIgnoreCase(model2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            @Override
            public ConnectionNodeProvider createInstance(Lookup lookup) {
                ConnectionNodeProvider provider = new ConnectionNodeProvider(lookup);
                provider.setup();
                return provider;
            }
        };

        private FactoryHolder() {
        }
    }
}

