/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.action;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.action.BaseAction;
import org.netbeans.modules.db.explorer.dlg.AddConnectionWizard;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.node.DriverNode;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ConnectUsingDriverAction
extends BaseAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectUsingDriverAction.class.getName());

    public String getName() {
        return NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ConnectUsing");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectUsingDriverAction.class);
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1;
    }

    public void performAction(Node[] activatedNodes) {
        Lookup lookup = activatedNodes[0].getLookup();
        DriverNode node = (DriverNode)((Object)lookup.lookup(DriverNode.class));
        if (node != null) {
            JDBCDriver driver = node.getDatabaseDriver().getJDBCDriver();
            new NewConnectionDialogDisplayer().showDialog(driver.getName(), driver.getClassName());
        }
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        RequestProcessor.Task activeTask = null;
        private DatabaseConnection cinfo = null;

        public void showDialog(String driverName, String driverClass) {
            this.showDialog(driverName, driverClass, null, null, null);
        }

        public DatabaseConnection showDialog(JDBCDriver driver, String databaseUrl, String user, String password) {
            String driverName = driver != null ? driver.getName() : null;
            String driverClass = driver != null ? driver.getClassName() : null;
            return this.showDialog(driverName, driverClass, databaseUrl, user, password);
        }

        private DatabaseConnection showDialog(String driverName, String driverClass, String databaseUrl, String user, String password) {
            AddConnectionWizard.showWizard(driverName, driverClass, databaseUrl, user, password);
            return null;
        }

        @Override
        public void closeConnection() {
            Connection conn;
            if (this.cinfo != null && (conn = this.cinfo.getConnection()) != null) {
                try {
                    conn.close();
                    this.cinfo.setConnection(null);
                }
                catch (SQLException e) {
                    this.cinfo.setConnection(null);
                }
            }
            this.setConnected(false);
        }

        @Override
        protected RequestProcessor.Task retrieveSchemasAsync(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.activeTask = super.retrieveSchemasAsync(schemaPanel, dbcon, defaultSchema);
            return this.activeTask;
        }

        @Override
        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection dbcon, String defaultSchema) {
            this.fireConnectionStep(NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ConnectionProgress_Schemas"));
            ArrayList<String> schemas = new ArrayList<String>();
            try {
                ResultSet rs;
                DatabaseMetaData dbMetaData = dbcon.getConnection().getMetaData();
                if (dbMetaData.supportsSchemasInTableDefinitions() && (rs = dbMetaData.getSchemas()) != null) {
                    while (rs.next()) {
                        schemas.add(rs.getString(1).trim());
                    }
                }
            }
            catch (SQLException exc) {
                String message = NbBundle.getMessage(ConnectUsingDriverAction.class, (String)"ERR_UnableObtainSchemas", (Object)exc.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
            }
            return schemaPanel.setSchemas(schemas, defaultSchema);
        }
    }
}

