/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.explorer;

import java.net.URL;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Arrays;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.modules.db.explorer.DbDriverManager;

public final class JDBCDriver {
    private URL[] urls;
    private String clazz;
    private String displayName;
    private String name;

    JDBCDriver(String name, String displayName, String clazz, URL[] urls) {
        assert (name != null && displayName != null && clazz != null && urls != null);
        this.name = name;
        this.displayName = displayName;
        this.clazz = clazz;
        this.urls = urls;
    }

    public static JDBCDriver create(String name, String displayName, String clazz, URL[] urls) {
        if (name == null || displayName == null || clazz == null || urls == null) {
            throw new NullPointerException();
        }
        return new JDBCDriver(name, displayName, clazz, urls);
    }

    public URL[] getURLs() {
        return this.urls;
    }

    public String getClassName() {
        return this.clazz;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getName() {
        return this.name;
    }

    public Driver getDriver() throws DatabaseException {
        try {
            return DbDriverManager.getDefault().getDriver(this);
        }
        catch (SQLException sqle) {
            throw new DatabaseException(sqle);
        }
    }

    public String toString() {
        return "JDBCDriver[name='" + this.name + "',displayName='" + this.displayName + "',className='" + this.clazz + "',urls=" + Arrays.asList(this.urls) + "]";
    }
}

