/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.derby;

import java.beans.IntrospectionException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.derby.DerbyActivator;
import org.netbeans.modules.derby.DerbyDatabasesImpl;
import org.netbeans.modules.derby.RegisterDerby;
import org.netbeans.modules.derby.Util;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.BeanNode;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class DerbyOptions {
    private static final Logger LOGGER = Logger.getLogger(DerbyOptions.class.getName());
    private static final DerbyOptions INSTANCE = new DerbyOptions();
    public static final String NETBEANS_DERBY_SYSTEM_HOME = "netbeans.derby.system.home";
    static final String PROP_DERBY_LOCATION = "location";
    static final String PROP_DERBY_SYSTEM_HOME = "systemHome";
    static final String INST_DIR = "db-derby-10.1.1.0";
    public static final String DRIVER_CLASS_NET = "org.apache.derby.jdbc.ClientDriver";
    public static final String DRIVER_CLASS_EMBEDDED = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DRIVER_PATH_NET = "lib/derbyclient.jar";
    private static final String DRIVER_PATH_EMBEDDED = "lib/derby.jar";
    public static final String DRIVER_DISP_NAME_NET = "Java DB (Network)";
    public static final String DRIVER_DISP_NAME_EMBEDDED = "Java DB (Embedded)";
    private static final String DRIVER_NAME_NET = "apache_derby_net";
    private static final String DRIVER_NAME_EMBEDDED = "apache_derby_embedded";

    public static DerbyOptions getDefault() {
        return INSTANCE;
    }

    protected final String putProperty(String key, String value, boolean notify) {
        String retval = NbPreferences.forModule(DerbyOptions.class).get(key, null);
        if (value != null) {
            NbPreferences.forModule(DerbyOptions.class).put(key, value);
        } else {
            NbPreferences.forModule(DerbyOptions.class).remove(key);
        }
        return retval;
    }

    protected final String getProperty(String key) {
        return NbPreferences.forModule(DerbyOptions.class).get(key, null);
    }

    public String displayName() {
        return NbBundle.getMessage(DerbyOptions.class, (String)"LBL_DerbyOptions");
    }

    public String getLocation() {
        DerbyActivator.activate();
        String location = this.getProperty(PROP_DERBY_LOCATION);
        if (location == null) {
            location = "";
        }
        Logger.getLogger(DerbyOptions.class.getName()).finest("Derby location is " + location);
        return location;
    }

    private String getCurrentLocation() {
        String location = this.getProperty(PROP_DERBY_LOCATION);
        if (location == null) {
            location = "";
        }
        return location;
    }

    public boolean isLocationNull() {
        return this.getProperty(PROP_DERBY_LOCATION) == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocation(String location) {
        if (location != null && location.length() > 0) {
            File locationFile = new File(location).getAbsoluteFile();
            if (!locationFile.exists()) {
                String message = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)locationFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                Exceptions.attachLocalizedMessage((Throwable)e, (String)message);
                throw e;
            }
            if (!Util.isDerbyInstallLocation(locationFile)) {
                String message = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_InvalidDerbyLocation", (Object)locationFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                Exceptions.attachLocalizedMessage((Throwable)e, (String)message);
                throw e;
            }
        }
        DerbyOptions derbyOptions = this;
        synchronized (derbyOptions) {
            DerbyOptions.stopDerbyServer();
            if (location != null && location.length() <= 0) {
                location = DerbyOptions.getDefaultInstallLocation();
            }
            DerbyOptions.registerDrivers(location);
            this.registerLibrary(location);
            LOGGER.log(Level.FINE, "Setting location to {0}", location);
            this.putProperty(PROP_DERBY_LOCATION, location, true);
        }
    }

    public synchronized boolean trySetLocation(String location) {
        LOGGER.log(Level.FINE, "trySetLocation: Trying to set location to {0}", location);
        String current = this.getCurrentLocation();
        if (current.length() == 0) {
            this.setLocation(location);
            LOGGER.fine("trysetLocation: Succeeded");
            return true;
        }
        File currentFile = new File(current);
        if (!currentFile.exists() || currentFile.isFile()) {
            this.setLocation(location);
            LOGGER.fine("trysetLocation: correcting");
            return true;
        }
        LOGGER.fine("trySetLocation: Another location already set");
        return false;
    }

    public String getSystemHome() {
        String systemHome = this.getProperty(PROP_DERBY_SYSTEM_HOME);
        if (systemHome == null) {
            systemHome = System.getProperty(NETBEANS_DERBY_SYSTEM_HOME);
        }
        if (systemHome == null) {
            systemHome = "";
        }
        return systemHome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSystemHome(String derbySystemHome) {
        if (derbySystemHome != null && derbySystemHome.length() > 0) {
            File derbySystemHomeFile = new File(derbySystemHome).getAbsoluteFile();
            if (!derbySystemHomeFile.exists() || !derbySystemHomeFile.isDirectory()) {
                String message = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryDoesNotExist", (Object)derbySystemHomeFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                Exceptions.attachLocalizedMessage((Throwable)e, (String)message);
                throw e;
            }
            if (!derbySystemHomeFile.canWrite()) {
                String message = NbBundle.getMessage(DerbyOptions.class, (String)"ERR_DirectoryIsNotWritable", (Object)derbySystemHomeFile);
                IllegalArgumentException e = new IllegalArgumentException(message);
                Exceptions.attachLocalizedMessage((Throwable)e, (String)message);
                throw e;
            }
        }
        DerbyOptions derbyOptions = this;
        synchronized (derbyOptions) {
            DerbyOptions.stopDerbyServer();
            this.putProperty(PROP_DERBY_SYSTEM_HOME, derbySystemHome, true);
            DerbyDatabasesImpl.getDefault().notifyChange();
        }
    }

    static String getDefaultInstallLocation() {
        File location = InstalledFileLocator.getDefault().locate(INST_DIR, null, false);
        if (location == null) {
            return null;
        }
        if (!Util.isDerbyInstallLocation(location)) {
            return null;
        }
        return location.getAbsolutePath();
    }

    private static void stopDerbyServer() {
        RegisterDerby.getDefault().stop();
    }

    private static void registerDrivers(final String newLocation) {
        try {
            FileUtil.runAtomicAction((FileSystem.AtomicAction)new FileSystem.AtomicAction(){

                public void run() {
                    DerbyOptions.registerDriver(DerbyOptions.DRIVER_NAME_NET, DerbyOptions.DRIVER_DISP_NAME_NET, DerbyOptions.DRIVER_CLASS_NET, DerbyOptions.DRIVER_PATH_NET, newLocation);
                    DerbyOptions.registerDriver(DerbyOptions.DRIVER_NAME_EMBEDDED, DerbyOptions.DRIVER_DISP_NAME_EMBEDDED, DerbyOptions.DRIVER_CLASS_EMBEDDED, DerbyOptions.DRIVER_PATH_EMBEDDED, newLocation);
                }
            });
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    private static void registerDriver(String driverName, String driverDisplayName, String driverClass, String driverRelativeFile, String newLocation) {
        File newDriverFile;
        JDBCDriver[] drivers = JDBCDriverManager.getDefault().getDrivers(driverClass);
        for (int i = 0; i < drivers.length; ++i) {
            JDBCDriver driver = drivers[i];
            URL[] urls = driver.getURLs();
            String currentLocation = DerbyOptions.getDefault().getLocation();
            if (currentLocation == null) continue;
            boolean fromCurrentLocation = true;
            for (int j = 0; j < urls.length; ++j) {
                String driverFile;
                File file = null;
                if ("file".equals(urls[j].getProtocol())) {
                    try {
                        file = new File(urls[j].toURI());
                    }
                    catch (URISyntaxException e) {
                        LOGGER.log(Level.WARNING, null, e);
                    }
                } else {
                    FileObject fo = URLMapper.findFileObject((URL)urls[j]);
                    if (fo != null) {
                        file = FileUtil.toFile((FileObject)fo);
                    }
                }
                if (file != null && (driverFile = file.getAbsolutePath()).startsWith(currentLocation)) continue;
                fromCurrentLocation = false;
                break;
            }
            if (!fromCurrentLocation) continue;
            try {
                JDBCDriverManager.getDefault().removeDriver(driver);
                continue;
            }
            catch (DatabaseException e) {
                LOGGER.log(Level.WARNING, null, e);
                return;
            }
        }
        if (newLocation != null && newLocation.length() >= 0 && (newDriverFile = new File(newLocation, driverRelativeFile)).exists()) {
            try {
                JDBCDriver newDriver = JDBCDriver.create((String)driverName, (String)driverDisplayName, (String)driverClass, (URL[])new URL[]{newDriverFile.toURI().toURL()});
                JDBCDriverManager.getDefault().addDriver(newDriver);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
            catch (DatabaseException e) {
                LOGGER.log(Level.WARNING, null, e);
            }
        }
    }

    private void registerLibrary(String newLocation) {
        FileObject libsFolder = FileUtil.getConfigFile((String)"org-netbeans-api-project-libraries/Libraries");
        if (libsFolder != null && newLocation != null) {
            try {
                File location = new File(newLocation);
                if (location.exists() && location.isDirectory()) {
                    libsFolder.getFileSystem().runAtomicAction((FileSystem.AtomicAction)new DerbyLibraryRegistrar(location, libsFolder));
                }
            }
            catch (FileStateInvalidException ex) {
                LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
            catch (IOException ex) {
                LOGGER.log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
    }

    private static BeanNode createViewNode() throws IntrospectionException {
        return new BeanNode((Object)DerbyOptions.getDefault());
    }

    static class DerbyLibraryRegistrar
    implements FileSystem.AtomicAction {
        private File location;
        private FileObject libsFolder;

        DerbyLibraryRegistrar(File location, FileObject libsFolder) {
            this.location = location;
            this.libsFolder = libsFolder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock ld = null;
            OutputStream outStreamd = null;
            Writer outd = null;
            OutputStreamWriter osw = null;
            try {
                FileObject derbyLib = null;
                derbyLib = this.libsFolder.getFileObject("JavaDB", "xml");
                if (null == derbyLib) {
                    derbyLib = this.libsFolder.createData("JavaDB", "xml");
                    ld = derbyLib.lock();
                    outStreamd = derbyLib.getOutputStream(ld);
                    osw = new OutputStreamWriter(outStreamd);
                    outd = new BufferedWriter(osw);
                    outd.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<!DOCTYPE library PUBLIC \"-//NetBeans//DTD Library Declaration 1.0//EN\" \"http://www.netbeans.org/dtds/library-declaration-1_0.dtd\">\n");
                    outd.write("<library version=\"1.0\">\n<name>JAVADB_DRIVER_LABEL</name>\n");
                    outd.write("<type>j2se</type>\n");
                    outd.write("<localizing-bundle>org.netbeans.modules.derby.Bundle</localizing-bundle>\n");
                    outd.write("<volume>\n<type>classpath</type>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derby.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbyclient.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("<resource>jar:" + new File(this.location.getAbsolutePath() + "/lib/derbynet.jar").toURI().toURL() + "!/</resource>\n");
                    outd.write("</volume>\n<volume>\n<type>src</type>\n</volume>\n");
                    outd.write("<volume>\n<type>javadoc</type>\n");
                    outd.write("</volume>\n</library>");
                }
            }
            finally {
                if (null != outd) {
                    try {
                        outd.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                }
                if (null != outStreamd) {
                    try {
                        outStreamd.close();
                    }
                    catch (IOException ioe) {
                        LOGGER.log(Level.INFO, ioe.getLocalizedMessage(), ioe);
                    }
                }
                if (null != ld) {
                    ld.releaseLock();
                }
            }
        }
    }
}

