/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FreeformProjectGenerator {
    private static final String[] rootElementsOrder = new String[]{"name", "properties", "folders", "ide-actions", "export", "view", "subprojects"};
    private static final String[] viewElementsOrder = new String[]{"items", "context-menu"};
    private static final String[] viewItemElementsOrder = new String[]{"source-folder", "source-file"};
    private static final String[] contextMenuElementsOrder = new String[]{"ide-action", "separator", "action"};

    private FreeformProjectGenerator() {
    }

    public static AntProjectHelper createProject(File location, File dir, String name, File antScript) throws IOException {
        FileObject dirFO = FreeformProjectGenerator.createProjectDir(dir);
        FileObject locationFO = FileUtil.toFileObject((File)location);
        AntProjectHelper h = FreeformProjectGenerator.createProject(locationFO, dirFO, name, antScript);
        Project p = ProjectManager.getDefault().findProject(dirFO);
        ProjectManager.getDefault().saveProject(p);
        return h;
    }

    private static AntProjectHelper createProject(final FileObject locationFO, final FileObject dirFO, final String name, final File antScript) throws IOException {
        final AntProjectHelper[] h = new AntProjectHelper[1];
        final IOException[] ioe = new IOException[1];
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Project p;
                try {
                    h[0] = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.ant.freeform");
                    p = ProjectManager.getDefault().findProject(dirFO);
                }
                catch (IOException e) {
                    ioe[0] = e;
                    return;
                }
                AuxiliaryConfiguration aux = (AuxiliaryConfiguration)p.getLookup().lookup(AuxiliaryConfiguration.class);
                assert (aux != null);
                Element data = Util.getPrimaryConfigurationData(h[0]);
                Document doc = data.getOwnerDocument();
                Comment comment = doc.createComment(" " + NbBundle.getMessage(FreeformProjectGenerator.class, (String)"LBL_Manual_Editing_Warning") + " ");
                data.appendChild(comment);
                Element nm = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "name");
                nm.appendChild(doc.createTextNode(name));
                data.appendChild(nm);
                Element props = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "properties");
                File locationF = FileUtil.toFile((FileObject)locationFO);
                File dirF = FileUtil.toFile((FileObject)dirFO);
                HashMap<String, String> properties = new HashMap<String, String>();
                if (!locationFO.equals(dirFO)) {
                    Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
                    property.setAttribute("name", "project.dir");
                    String path = CollocationQuery.areCollocated((File)dirF, (File)locationF) ? PropertyUtils.relativizeFile((File)dirF, (File)locationF) : locationF.getAbsolutePath();
                    property.appendChild(doc.createTextNode(path));
                    props.appendChild(property);
                    properties.put("project.dir", path);
                }
                String antPath = "build.xml";
                if (antScript != null) {
                    Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
                    property.setAttribute("name", "ant.script");
                    antPath = Util.relativizeLocation(locationF, dirF, antScript);
                    property.appendChild(doc.createTextNode(antPath));
                    properties.put("ant.script", antPath);
                    antPath = "${ant.script}";
                    props.appendChild(property);
                }
                data.appendChild(props);
                Util.putPrimaryConfigurationData(h[0], data);
                FreeformProjectGenerator.putBuildXMLSourceFile(h[0], antPath);
            }
        });
        if (ioe[0] != null) {
            throw ioe[0];
        }
        return h[0];
    }

    private static FileObject createProjectDir(File dir) throws IOException {
        if (!dir.exists()) {
            FreeformProjectGenerator.refreshFileSystem(dir);
            dir.mkdirs();
            FreeformProjectGenerator.refreshFileSystem(dir);
        }
        FileObject dirFO = FileUtil.toFileObject((File)dir);
        assert (dirFO != null) : "No such dir on disk: " + dir;
        assert (dirFO.isFolder()) : "Not really a dir: " + dir;
        return dirFO;
    }

    private static void refreshFileSystem(File dir) throws FileStateInvalidException {
        File rootF = dir;
        while (rootF.getParentFile() != null) {
            rootF = rootF.getParentFile();
        }
        FileObject dirFO = FileUtil.toFileObject((File)rootF);
        assert (dirFO != null) : "At least disk roots must be mounted! " + rootF;
        dirFO.getFileSystem().refresh(false);
    }

    public static List<TargetMapping> getTargetMappings(AntProjectHelper helper) {
        ArrayList<TargetMapping> list = new ArrayList<TargetMapping>();
        Element genldata = Util.getPrimaryConfigurationData(helper);
        Element actionsEl = XMLUtil.findElement((Element)genldata, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (actionsEl == null) {
            return list;
        }
        for (Element actionEl : XMLUtil.findSubElements((Element)actionsEl)) {
            TargetMapping tm = new TargetMapping();
            tm.name = actionEl.getAttribute("name");
            ArrayList<String> targetNames = new ArrayList<String>();
            EditableProperties props = new EditableProperties(false);
            for (Element subEl : XMLUtil.findSubElements((Element)actionEl)) {
                if (subEl.getLocalName().equals("target")) {
                    targetNames.add(XMLUtil.findText((Node)subEl));
                    continue;
                }
                if (subEl.getLocalName().equals("script")) {
                    tm.script = XMLUtil.findText((Node)subEl);
                    continue;
                }
                if (subEl.getLocalName().equals("context")) {
                    TargetMapping.Context ctx = new TargetMapping.Context();
                    for (Element contextSubEl : XMLUtil.findSubElements((Element)subEl)) {
                        Element sepFilesEl;
                        if (contextSubEl.getLocalName().equals("property")) {
                            ctx.property = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("format")) {
                            ctx.format = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("folder")) {
                            ctx.folder = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (contextSubEl.getLocalName().equals("pattern")) {
                            ctx.pattern = XMLUtil.findText((Node)contextSubEl);
                            continue;
                        }
                        if (!contextSubEl.getLocalName().equals("arity") || (sepFilesEl = XMLUtil.findElement((Element)contextSubEl, (String)"separated-files", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) continue;
                        ctx.separator = XMLUtil.findText((Node)sepFilesEl);
                    }
                    tm.context = ctx;
                }
                if (!subEl.getLocalName().equals("property")) continue;
                FreeformProjectGenerator.readProperty(subEl, props);
            }
            tm.targets = targetNames;
            if (props.keySet().size() > 0) {
                tm.properties = props;
            }
            list.add(tm);
        }
        return list;
    }

    private static void readProperty(Element propertyElement, EditableProperties props) {
        String key = propertyElement.getAttribute("name");
        String value = XMLUtil.findText((Node)propertyElement);
        props.setProperty(key, value);
    }

    public static void putTargetMappings(AntProjectHelper helper, List<TargetMapping> mappings) {
        Element data = Util.getPrimaryConfigurationData(helper);
        Document doc = data.getOwnerDocument();
        Element actions = XMLUtil.findElement((Element)data, (String)"ide-actions", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (actions != null) {
            data.removeChild(actions);
        }
        actions = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-actions");
        for (TargetMapping tm : mappings) {
            Element action = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
            assert (tm.name != null && tm.name.length() > 0);
            action.setAttribute("name", tm.name);
            if (tm.script != null) {
                Element script = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
                script.appendChild(doc.createTextNode(tm.script));
                action.appendChild(script);
            }
            if (tm.targets != null) {
                for (String targetName : tm.targets) {
                    Element target = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
                    target.appendChild(doc.createTextNode(targetName));
                    action.appendChild(target);
                }
            }
            if (tm.properties != null) {
                FreeformProjectGenerator.writeProperties(tm.properties, doc, action);
            }
            if (tm.context != null) {
                Element context = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context");
                TargetMapping.Context ctx = tm.context;
                assert (ctx.property != null);
                Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
                property.appendChild(doc.createTextNode(ctx.property));
                context.appendChild(property);
                assert (ctx.folder != null);
                Element folder = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "folder");
                folder.appendChild(doc.createTextNode(ctx.folder));
                context.appendChild(folder);
                if (ctx.pattern != null) {
                    Element pattern = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "pattern");
                    pattern.appendChild(doc.createTextNode(ctx.pattern));
                    context.appendChild(pattern);
                }
                assert (ctx.format != null);
                Element format = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "format");
                format.appendChild(doc.createTextNode(ctx.format));
                context.appendChild(format);
                Element arity = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "arity");
                if (ctx.separator != null) {
                    Element sepFilesEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "separated-files");
                    sepFilesEl.appendChild(doc.createTextNode(ctx.separator));
                    arity.appendChild(sepFilesEl);
                } else {
                    arity.appendChild(doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "one-file-only"));
                }
                context.appendChild(arity);
                action.appendChild(context);
            }
            actions.appendChild(action);
        }
        XMLUtil.appendChildElement((Element)data, (Element)actions, (String[])rootElementsOrder);
        Util.putPrimaryConfigurationData(helper, data);
    }

    private static void writeProperties(EditableProperties props, Document doc, Element element) {
        for (Map.Entry entry : props.entrySet()) {
            Element property = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "property");
            property.setAttribute("name", (String)entry.getKey());
            property.appendChild(doc.createTextNode((String)entry.getValue()));
            element.appendChild(property);
        }
    }

    public static void putContextMenuAction(AntProjectHelper helper, List<TargetMapping> mappings) {
        Element contextMenuEl;
        Element data = Util.getPrimaryConfigurationData(helper);
        Document doc = data.getOwnerDocument();
        Element viewEl = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            XMLUtil.appendChildElement((Element)data, (Element)viewEl, (String[])rootElementsOrder);
        }
        if ((contextMenuEl = XMLUtil.findElement((Element)viewEl, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) {
            contextMenuEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context-menu");
            XMLUtil.appendChildElement((Element)viewEl, (Element)contextMenuEl, (String[])viewElementsOrder);
        }
        for (Element ideActionEl : XMLUtil.findSubElements((Element)contextMenuEl)) {
            if (!ideActionEl.getLocalName().equals("ide-action")) continue;
            contextMenuEl.removeChild(ideActionEl);
        }
        for (TargetMapping tm : FreeformProjectGenerator.sortMappings(mappings)) {
            if (tm.context != null) continue;
            Element ideAction = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "ide-action");
            ideAction.setAttribute("name", tm.name);
            XMLUtil.appendChildElement((Element)contextMenuEl, (Element)ideAction, (String[])contextMenuElementsOrder);
        }
        Util.putPrimaryConfigurationData(helper, data);
    }

    public static List<CustomTarget> getCustomContextMenuActions(AntProjectHelper helper) {
        ArrayList<CustomTarget> list = new ArrayList<CustomTarget>();
        Element genldata = Util.getPrimaryConfigurationData(helper);
        Element viewEl = XMLUtil.findElement((Element)genldata, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            return list;
        }
        Element contextMenuEl = XMLUtil.findElement((Element)viewEl, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (contextMenuEl == null) {
            return list;
        }
        for (Element actionEl : XMLUtil.findSubElements((Element)contextMenuEl)) {
            if (!actionEl.getLocalName().equals("action")) continue;
            CustomTarget ct = new CustomTarget();
            ArrayList<String> targetNames = new ArrayList<String>();
            EditableProperties props = new EditableProperties(false);
            for (Element subEl : XMLUtil.findSubElements((Element)actionEl)) {
                if (subEl.getLocalName().equals("target")) {
                    targetNames.add(XMLUtil.findText((Node)subEl));
                    continue;
                }
                if (subEl.getLocalName().equals("script")) {
                    ct.script = XMLUtil.findText((Node)subEl);
                    continue;
                }
                if (subEl.getLocalName().equals("label")) {
                    ct.label = XMLUtil.findText((Node)subEl);
                    continue;
                }
                if (!subEl.getLocalName().equals("property")) continue;
                FreeformProjectGenerator.readProperty(subEl, props);
            }
            ct.targets = targetNames;
            if (props.keySet().size() > 0) {
                ct.properties = props;
            }
            list.add(ct);
        }
        return list;
    }

    public static void putCustomContextMenuActions(AntProjectHelper helper, List<CustomTarget> customTargets) {
        Element contextMenuEl;
        Element data = Util.getPrimaryConfigurationData(helper);
        Document doc = data.getOwnerDocument();
        Element viewEl = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            XMLUtil.appendChildElement((Element)data, (Element)viewEl, (String[])rootElementsOrder);
        }
        if ((contextMenuEl = XMLUtil.findElement((Element)viewEl, (String)"context-menu", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) {
            contextMenuEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "context-menu");
            XMLUtil.appendChildElement((Element)viewEl, (Element)contextMenuEl, (String[])viewElementsOrder);
        }
        for (Element actionEl : XMLUtil.findSubElements((Element)contextMenuEl)) {
            if (!actionEl.getLocalName().equals("action")) continue;
            contextMenuEl.removeChild(actionEl);
        }
        for (CustomTarget ct : customTargets) {
            Element action = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "action");
            if (ct.script != null) {
                Element script = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "script");
                script.appendChild(doc.createTextNode(ct.script));
                action.appendChild(script);
            }
            Element label = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "label");
            label.appendChild(doc.createTextNode(ct.label));
            action.appendChild(label);
            if (ct.targets != null) {
                for (String targetName : ct.targets) {
                    Element target = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "target");
                    target.appendChild(doc.createTextNode(targetName));
                    action.appendChild(target);
                }
            }
            if (ct.properties != null) {
                FreeformProjectGenerator.writeProperties(ct.properties, doc, action);
            }
            XMLUtil.appendChildElement((Element)contextMenuEl, (Element)action, (String[])contextMenuElementsOrder);
        }
        Util.putPrimaryConfigurationData(helper, data);
    }

    private static void putBuildXMLSourceFile(AntProjectHelper helper, String antPath) {
        Element itemsEl;
        Element data = Util.getPrimaryConfigurationData(helper);
        Document doc = data.getOwnerDocument();
        Element viewEl = XMLUtil.findElement((Element)data, (String)"view", (String)"http://www.netbeans.org/ns/freeform-project/2");
        if (viewEl == null) {
            viewEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "view");
            XMLUtil.appendChildElement((Element)data, (Element)viewEl, (String[])rootElementsOrder);
        }
        if ((itemsEl = XMLUtil.findElement((Element)viewEl, (String)"items", (String)"http://www.netbeans.org/ns/freeform-project/2")) == null) {
            itemsEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "items");
            XMLUtil.appendChildElement((Element)viewEl, (Element)itemsEl, (String[])viewElementsOrder);
        }
        Element fileEl = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "source-file");
        Element el = doc.createElementNS("http://www.netbeans.org/ns/freeform-project/2", "location");
        el.appendChild(doc.createTextNode(antPath));
        fileEl.appendChild(el);
        XMLUtil.appendChildElement((Element)itemsEl, (Element)fileEl, (String[])viewItemElementsOrder);
        Util.putPrimaryConfigurationData(helper, data);
    }

    public static FileObject getAntScript(AntProjectHelper helper, PropertyEvaluator ev) {
        String antScript = ev.getProperty("ant.script");
        if (antScript != null) {
            File f = helper.resolveFile(antScript);
            if (!f.exists()) {
                return null;
            }
            FileObject fo = FileUtil.toFileObject((File)f);
            return fo;
        }
        FileObject fo = helper.getProjectDirectory().getFileObject("build.xml");
        return fo;
    }

    private static List<TargetMapping> sortMappings(List<TargetMapping> toSort) {
        ArrayList<TargetMapping> list2Sort = new ArrayList<TargetMapping>(toSort);
        String[] sortedActions = new String[]{"build", "rebuild", "clean", "javadoc", "run", "deploy", "redeploy", "test"};
        ArrayList<TargetMapping> sortedList = new ArrayList<TargetMapping>(list2Sort.size());
        block0: for (String actionName : sortedActions) {
            for (TargetMapping mapping : list2Sort) {
                if (!actionName.equals(mapping.name)) continue;
                sortedList.add(mapping);
                list2Sort.remove(mapping);
                continue block0;
            }
        }
        for (TargetMapping mapping : list2Sort) {
            sortedList.add(mapping);
        }
        return sortedList;
    }

    public static final class CustomTarget {
        public List<String> targets;
        public String label;
        public String script;
        public EditableProperties properties;
    }

    public static final class TargetMapping {
        public String script;
        public List<String> targets;
        public String name;
        public EditableProperties properties;
        public Context context;

        public static final class Context {
            public String property;
            public String format;
            public String folder;
            public String pattern;
            public String separator;
        }
    }
}

