/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner;

import java.awt.Toolkit;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.testrunner.CommonTestUtil;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Utilities;

public final class Utils {
    private final Project project;
    private boolean sourceGroupsOnly = true;
    private SourceGroup[] javaSourceGroups;
    private Map<SourceGroup, Object[]> sourcesToTestsMap;
    private Map<FileObject, Object> foldersToSourceGroupsMap;

    public Utils(Project project) {
        this.project = project;
    }

    static FileObject findTestsRoot(Project project) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        for (int i = 0; i < sourceGroups.length; ++i) {
            FileObject root = sourceGroups[i].getRootFolder();
            if (!root.getName().equals("java")) continue;
            return root;
        }
        return null;
    }

    static FileObject getPackageFolder(FileObject root, String pkgName) throws IOException {
        String relativePathName = pkgName.replace('.', '/');
        FileObject folder = root.getFileObject(relativePathName);
        if (folder == null) {
            folder = FileUtil.createFolder((FileObject)root, (String)relativePathName);
        }
        return folder;
    }

    static Collection getTestTargets(Project project, boolean sourceGroupsOnly) {
        Utils utils = new Utils(project);
        return utils.getTestTargets(sourceGroupsOnly);
    }

    public static Collection<FileObject> getTestFolders(Project project) {
        return new Utils(project).getTestFolders();
    }

    static Map getSourcesToTestsMap(Project project, boolean sourceGroupsOnly) {
        Utils utils = new Utils(project);
        return utils.getSourcesToTestsMap(sourceGroupsOnly);
    }

    Project getProject() {
        return this.project;
    }

    private Collection<FileObject> getTestFolders() {
        SourceGroup[] sourceGroups = this.getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> result = null;
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject srcFolder = sourceGroup.getRootFolder();
            FileObject[] tstFoldersRaw = this.getTestFoldersRaw(srcFolder);
            if (tstFoldersRaw.length == 0) continue;
            for (FileObject tstFolder : tstFoldersRaw) {
                if (tstFolder == null) continue;
                if (result == null) {
                    result = new ArrayList<FileObject>(2);
                }
                if (result.contains(tstFolder)) continue;
                result.add(tstFolder);
            }
        }
        if (result == null) {
            return Collections.emptyList();
        }
        assert (!result.isEmpty());
        return result.size() == 1 ? Collections.singleton(result.get(0)) : result;
    }

    private Collection<Object> getTestTargets(boolean sourceGroupsOnly) {
        SourceGroup[] sourceGroups = this.getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.emptyList();
        }
        this.createFoldersToSourceGroupsMap(sourceGroups);
        Object[] testTargetsUnion = new Object[sourceGroups.length];
        int size = 0;
        for (int i = 0; i < sourceGroups.length; ++i) {
            Object[] testTargets = this.getTestTargets(sourceGroups[i], sourceGroupsOnly);
            size = Utils.merge(testTargets, testTargetsUnion, size);
        }
        if (size != testTargetsUnion.length) {
            testTargetsUnion = CommonTestUtil.skipNulls(testTargetsUnion, new Object[0]);
        }
        return Collections.unmodifiableCollection(Arrays.asList(testTargetsUnion));
    }

    Map<SourceGroup, Object[]> getSourcesToTestsMap() {
        if (this.sourcesToTestsMap == null) {
            this.sourcesToTestsMap = this.createSourcesToTestsMap(this.sourceGroupsOnly);
        }
        return this.sourcesToTestsMap;
    }

    Map<SourceGroup, Object[]> getSourcesToTestsMap(boolean sourceGroupsOnly) {
        if (sourceGroupsOnly != this.sourceGroupsOnly) {
            this.sourcesToTestsMap = null;
            this.sourceGroupsOnly = sourceGroupsOnly;
        }
        return this.getSourcesToTestsMap();
    }

    private Map<SourceGroup, Object[]> createSourcesToTestsMap(boolean sourceGroupsOnly) {
        SourceGroup[] sourceGroups = this.getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.emptyMap();
        }
        this.createFoldersToSourceGroupsMap(sourceGroups);
        Object[] testTargetsUnion = new Object[sourceGroups.length];
        HashMap<SourceGroup, Object[]> map = new HashMap<SourceGroup, Object[]>((int)((float)sourceGroups.length * 1.33f + 0.5f), 0.75f);
        for (int i = 0; i < sourceGroups.length; ++i) {
            Object[] testTargets = this.getTestTargets(sourceGroups[i], sourceGroupsOnly);
            if (testTargets.length == 0) continue;
            map.put(sourceGroups[i], testTargets);
        }
        if (map.isEmpty()) {
            return Collections.emptyMap();
        }
        if (map.size() == 1) {
            Map.Entry entry = map.entrySet().iterator().next();
            return Collections.singletonMap(entry.getKey(), entry.getValue());
        }
        int finalMapSize = map.size();
        if (finalMapSize >= sourceGroups.length - 5) {
            return map;
        }
        HashMap<SourceGroup, Object[]> targetMap = new HashMap<SourceGroup, Object[]>((int)((float)finalMapSize * 1.25f + 0.5f), 0.8f);
        targetMap.putAll(map);
        return targetMap;
    }

    private static int merge(Object[] setToAdd, Object[] targetSet, int currTargetSetSize) {
        if (setToAdd.length == 0) {
            return currTargetSetSize;
        }
        if (currTargetSetSize == 0) {
            System.arraycopy(setToAdd, 0, targetSet, 0, setToAdd.length);
            return setToAdd.length;
        }
        int targetSetSize = currTargetSetSize;
        block0: for (int i = 0; i < setToAdd.length; ++i) {
            Object objToAdd = setToAdd[i];
            for (int j = 0; j < targetSetSize; ++j) {
                Object chosen = Utils.chooseTarget(targetSet[j], objToAdd);
                if (chosen == null) continue;
                targetSet[j] = chosen;
                continue block0;
            }
            targetSet[targetSetSize++] = objToAdd;
        }
        return targetSetSize;
    }

    private static Object chooseTarget(Object target1, Object target2) {
        FileObject folder2;
        boolean isGroup1 = target1 instanceof SourceGroup;
        boolean isGroup2 = target2 instanceof SourceGroup;
        assert (isGroup1 || target1 instanceof FileObject);
        assert (isGroup2 || target2 instanceof FileObject);
        if (isGroup1 && isGroup2 && target1.equals(target2)) {
            return target1;
        }
        FileObject folder1 = isGroup1 ? ((SourceGroup)target1).getRootFolder() : (FileObject)target1;
        FileObject fileObject = folder2 = isGroup2 ? ((SourceGroup)target2).getRootFolder() : (FileObject)target2;
        if (!folder1.isFolder()) {
            throw new IllegalArgumentException("target1: not a folder");
        }
        if (!folder2.isFolder()) {
            throw new IllegalArgumentException("target2: not a folder");
        }
        if (folder1.equals(folder2)) {
            return isGroup1 == isGroup2 ? target1 : (isGroup1 ? target1 : target2);
        }
        return null;
    }

    public Object[] getTestTargets(SourceGroup sourceGroup, boolean sourceGroupsOnly) {
        FileObject[] testFolders = this.getTestFoldersRaw(sourceGroup.getRootFolder());
        if (testFolders.length == 0) {
            return new Object[0];
        }
        Object[] targets = new Object[testFolders.length];
        for (int i = 0; i < targets.length; ++i) {
            FileObject testFolder = testFolders[i];
            if (testFolder == null) continue;
            Object srcGroup = this.foldersToSourceGroupsMap.get(testFolder);
            targets[i] = srcGroup != null ? srcGroup : (sourceGroupsOnly ? null : testFolder);
        }
        return CommonTestUtil.skipNulls(targets, new Object[0]);
    }

    public FileObject[] getTestFoldersRaw(FileObject srcFolder) {
        return this.getFileObjects(UnitTestForSourceQuery.findUnitTests((FileObject)srcFolder), true);
    }

    public FileObject[] getSourceFoldersRaw(FileObject testFolder) {
        return this.getFileObjects(UnitTestForSourceQuery.findSources((FileObject)testFolder), true);
    }

    private FileObject[] getFileObjects(URL[] rootURLs, boolean srcToTest) {
        if (rootURLs.length == 0) {
            return new FileObject[0];
        }
        FileObject[] sourceRoots = new FileObject[rootURLs.length];
        for (int i = 0; i < rootURLs.length; ++i) {
            sourceRoots[i] = URLMapper.findFileObject((URL)rootURLs[i]);
            if (sourceRoots[i] == null) {
                boolean severity = true;
                if (!ErrorManager.getDefault().isLoggable(1)) continue;
                ErrorManager.getDefault().log(1, (srcToTest ? "Test" : "Source") + " directory " + rootURLs[i] + " declared by project " + ProjectUtils.getInformation((Project)this.project).getName() + " does not exist.");
                continue;
            }
            Project sourceRootOwner = FileOwnerQuery.getOwner((FileObject)sourceRoots[i]);
            if (this.project.equals(sourceRootOwner)) continue;
            sourceRoots[i] = null;
            int severity = 1;
            if (!ErrorManager.getDefault().isNotifiable(severity)) continue;
            ErrorManager.getDefault().notify(severity, (Throwable)new IllegalStateException("Malformed project: Found test root (" + rootURLs[i] + ')' + ' ' + (sourceRootOwner == null ? "does not belong to any" : "belongs to a different") + " project."));
        }
        return sourceRoots;
    }

    public static FileObject[] skipNulls(FileObject[] fileObjs) {
        if (fileObjs.length == 0) {
            return fileObjs;
        }
        int nullsCount = 0;
        for (int i = 0; i < fileObjs.length; ++i) {
            if (fileObjs[i] != null) continue;
            ++nullsCount;
        }
        if (nullsCount == 0) {
            return fileObjs;
        }
        if (nullsCount == fileObjs.length) {
            return new FileObject[0];
        }
        FileObject[] fileObjsNew = new FileObject[fileObjs.length - nullsCount];
        int index = 0;
        int indexNew = 0;
        while (indexNew < fileObjsNew.length) {
            FileObject fileObj;
            if ((fileObj = fileObjs[index++]) == null) continue;
            fileObjsNew[indexNew++] = fileObj;
        }
        return fileObjsNew;
    }

    private void createFoldersToSourceGroupsMap(SourceGroup[] sourceGroups) {
        Map<FileObject, SourceGroup> result;
        if (sourceGroups.length == 0) {
            result = Collections.emptyMap();
        } else {
            result = new HashMap(2 * sourceGroups.length, 0.5f);
            for (SourceGroup sourceGroup : sourceGroups) {
                result.put(sourceGroup.getRootFolder(), sourceGroup);
            }
        }
        this.foldersToSourceGroupsMap = result;
    }

    public SourceGroup[] getJavaSourceGroups() {
        if (this.javaSourceGroups == null) {
            this.javaSourceGroups = ProjectUtils.getSources((Project)this.project).getSourceGroups("java");
        }
        return this.javaSourceGroups;
    }

    private static SourceGroup findSourceGroup(SourceGroup[] sourceGroups, FileObject rootFolder) {
        for (int i = 0; i < sourceGroups.length; ++i) {
            if (!sourceGroups[i].getRootFolder().equals(rootFolder)) continue;
            return sourceGroups[i];
        }
        return null;
    }

    static boolean isValidClassName(String className) {
        int i;
        if (className.length() == 0) {
            return false;
        }
        char[] chars = className.toCharArray();
        int segmentStart = 0;
        for (i = 0; i < chars.length; ++i) {
            if (chars[i] != '.') continue;
            if (i == segmentStart) {
                return false;
            }
            if (!Utilities.isJavaIdentifier((String)className.substring(segmentStart, i))) {
                return false;
            }
            segmentStart = i + 1;
        }
        if (i == segmentStart) {
            return false;
        }
        return Utilities.isJavaIdentifier((String)className.substring(segmentStart, chars.length));
    }

    public static void openFile(FileObject file, int lineNum) {
        block9: {
            if (file == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dob = DataObject.find((FileObject)file);
                EditorCookie ed = (EditorCookie)dob.getCookie(EditorCookie.class);
                if (ed != null && file == dob.getPrimaryFile()) {
                    if (lineNum == -1) {
                        ed.open();
                        break block9;
                    }
                    ed.openDocument();
                    try {
                        Line l = ed.getLineSet().getOriginal(lineNum - 1);
                        if (!l.isDeleted()) {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                        break block9;
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        ed.open();
                    }
                    break block9;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (DataObjectNotFoundException ex1) {
                ErrorManager.getDefault().notify(16, (Throwable)ex1);
            }
            catch (IOException ex2) {
                ErrorManager.getDefault().notify(16, (Throwable)ex2);
            }
        }
    }
}

