/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.testrunner;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.gsf.testrunner.plugin.CommonPlugin;
import org.netbeans.modules.java.testrunner.CommonSettings;
import org.netbeans.modules.java.testrunner.Utils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public class CommonTestUtil {
    private static final String JAVA_SOURCES_SUFFIX = "java";

    public static boolean isJavaFile(FileObject fileObj) {
        return JAVA_SOURCES_SUFFIX.equals(fileObj.getExt()) || "text/x-java".equals(FileUtil.getMIMEType((FileObject)fileObj));
    }

    public static FileObject getFileObjectFromNode(Node node) {
        DataObject dO = (DataObject)node.getLookup().lookup(DataObject.class);
        if (null != dO) {
            return dO.getPrimaryFile();
        }
        DataFolder df = (DataFolder)node.getLookup().lookup(DataFolder.class);
        if (null != df) {
            return df.getPrimaryFile();
        }
        return null;
    }

    public static Collection<SourceGroup> findSourceGroupOwners(Project project, String className) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.emptyList();
        }
        String relativePath = className.replace('.', '/') + ".java";
        ArrayList<SourceGroup> result = new ArrayList<SourceGroup>(4);
        for (int i = 0; i < sourceGroups.length; ++i) {
            SourceGroup srcGroup = sourceGroups[i];
            FileObject root = srcGroup.getRootFolder();
            FileObject file = root.getFileObject(relativePath);
            if (file == null || !FileUtil.isParentOf((FileObject)root, (FileObject)file) || !srcGroup.contains(file)) continue;
            result.add(srcGroup);
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        result.trimToSize();
        return Collections.unmodifiableList(result);
    }

    public static Object[] getTestTargets(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return new Object[0];
        }
        SourceGroup sourceGroupOwner = CommonTestUtil.findSourceGroupOwner(fileObject);
        if (sourceGroupOwner == null) {
            return new Object[0];
        }
        URL[] rootURLs = UnitTestForSourceQuery.findUnitTests((FileObject)sourceGroupOwner.getRootFolder());
        if (rootURLs.length == 0) {
            return new Object[0];
        }
        boolean someSkipped = false;
        FileObject[] sourceRoots = new FileObject[rootURLs.length];
        for (int i = 0; i < rootURLs.length; ++i) {
            sourceRoots[i] = URLMapper.findFileObject((URL)rootURLs[i]);
            if (sourceRoots[i] == null) {
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("No FileObject found for the following URL: " + rootURLs[i]));
                someSkipped = true;
                continue;
            }
            if (FileOwnerQuery.getOwner((FileObject)sourceRoots[i]) == project) continue;
            ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Source root found by FileOwnerQuery points to a different project for the following URL: " + rootURLs[i]));
            sourceRoots[i] = null;
            someSkipped = true;
        }
        if (someSkipped) {
            FileObject[] roots = CommonTestUtil.skipNulls(sourceRoots, new FileObject[0]);
            if (roots.length == 0) {
                return new Object[0];
            }
            sourceRoots = roots;
        }
        Object[] targets = new Object[sourceRoots.length];
        Map<FileObject, SourceGroup> map = CommonTestUtil.getFileObject2SourceGroupMap(project);
        for (int i = 0; i < sourceRoots.length; ++i) {
            SourceGroup srcGroup = map.get(sourceRoots[i]);
            targets[i] = srcGroup != null ? srcGroup : sourceRoots[i];
        }
        return targets;
    }

    public static SourceGroup findSourceGroupOwner(FileObject file) {
        Project project = FileOwnerQuery.getOwner((FileObject)file);
        return CommonTestUtil.findSourceGroupOwner(project, file);
    }

    public static SourceGroup findSourceGroupOwner(Project project, FileObject file) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        for (int i = 0; i < sourceGroups.length; ++i) {
            SourceGroup srcGroup = sourceGroups[i];
            FileObject root = srcGroup.getRootFolder();
            if (file != root && !FileUtil.isParentOf((FileObject)root, (FileObject)file) || !srcGroup.contains(file)) continue;
            return srcGroup;
        }
        return null;
    }

    public static <T> T[] skipNulls(T[] objs, T[] type) {
        ArrayList<T> resultList = new ArrayList<T>(objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            resultList.add(objs[i]);
        }
        return resultList.toArray(type);
    }

    public static Map<FileObject, SourceGroup> getFileObject2SourceGroupMap(Project project) {
        SourceGroup[] sourceGroups = new Utils(project).getJavaSourceGroups();
        if (sourceGroups.length == 0) {
            return Collections.emptyMap();
        }
        if (sourceGroups.length == 1) {
            return Collections.singletonMap(sourceGroups[0].getRootFolder(), sourceGroups[0]);
        }
        HashMap<FileObject, SourceGroup> map = new HashMap<FileObject, SourceGroup>(Math.round((float)sourceGroups.length * 1.4f + 0.5f), 0.75f);
        for (int i = 0; i < sourceGroups.length; ++i) {
            map.put(sourceGroups[i].getRootFolder(), sourceGroups[i]);
        }
        return map;
    }

    public static Map<CommonPlugin.CreateTestParam, Object> getSettingsMap(boolean multipleFiles) {
        CommonSettings settings = CommonSettings.getDefault();
        HashMap<CommonPlugin.CreateTestParam, Object> params = new HashMap<CommonPlugin.CreateTestParam, Object>(17);
        params.put(CommonPlugin.CreateTestParam.INC_PUBLIC, settings.isMembersPublic());
        params.put(CommonPlugin.CreateTestParam.INC_PROTECTED, settings.isMembersProtected());
        params.put(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE, settings.isMembersPackage());
        params.put(CommonPlugin.CreateTestParam.INC_CODE_HINT, settings.isBodyComments());
        params.put(CommonPlugin.CreateTestParam.INC_METHOD_BODIES, settings.isBodyContent());
        params.put(CommonPlugin.CreateTestParam.INC_JAVADOC, settings.isJavaDoc());
        if (multipleFiles) {
            params.put(CommonPlugin.CreateTestParam.INC_GENERATE_SUITE, settings.isGenerateSuiteClasses());
            params.put(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS, settings.isIncludePackagePrivateClasses());
            params.put(CommonPlugin.CreateTestParam.INC_ABSTRACT_CLASS, settings.isGenerateAbstractImpl());
            params.put(CommonPlugin.CreateTestParam.INC_EXCEPTION_CLASS, settings.isGenerateExceptionClasses());
        } else {
            params.put(CommonPlugin.CreateTestParam.INC_PKG_PRIVATE_CLASS, true);
            params.put(CommonPlugin.CreateTestParam.INC_ABSTRACT_CLASS, true);
            params.put(CommonPlugin.CreateTestParam.INC_EXCEPTION_CLASS, true);
        }
        params.put(CommonPlugin.CreateTestParam.INC_SETUP, settings.isGenerateSetUp());
        params.put(CommonPlugin.CreateTestParam.INC_TEAR_DOWN, settings.isGenerateTearDown());
        params.put(CommonPlugin.CreateTestParam.INC_CLASS_SETUP, settings.isGenerateClassSetUp());
        params.put(CommonPlugin.CreateTestParam.INC_CLASS_TEAR_DOWN, settings.isGenerateClassTearDown());
        return params;
    }
}

