/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.serverplugin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.netbeans.modules.cloud.amazon.AmazonInstanceManager;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEInstance;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEServerInstanceImplementation;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceCreationException;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.spi.server.ServerInstanceFactory;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;

public final class AmazonJ2EEServerInstanceProvider
implements ServerInstanceProvider,
ChangeListener {
    private ChangeSupport listeners = new ChangeSupport((Object)this);
    private List<ServerInstance> instances = Collections.emptyList();
    private static AmazonJ2EEServerInstanceProvider instance;
    private static Logger LOG;

    private AmazonJ2EEServerInstanceProvider() {
    }

    public static synchronized AmazonJ2EEServerInstanceProvider getProvider() {
        if (instance == null) {
            instance = new AmazonJ2EEServerInstanceProvider();
            AmazonInstanceManager.getDefault().addChangeListener(instance);
        }
        return instance;
    }

    public List<ServerInstance> getInstances() {
        return this.instances;
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeChangeListener(listener);
    }

    private void refreshServersSynchronously() {
        ArrayList<ServerInstance> servers = new ArrayList<ServerInstance>();
        for (AmazonInstance ai : AmazonInstanceManager.getDefault().getInstances()) {
            for (AmazonJ2EEInstance inst : ai.readJ2EEServerInstances()) {
                ServerInstance si = ServerInstanceFactory.createServerInstance((ServerInstanceImplementation)new AmazonJ2EEServerInstanceImplementation(inst));
                InstanceProperties ip = InstanceProperties.getInstanceProperties((String)inst.getId());
                if (ip == null) {
                    HashMap<String, String> props = new HashMap<String, String>();
                    props.put("environment--id", inst.getEnvironmentId());
                    props.put("application-name", inst.getApplicationName());
                    props.put("access-key-id", ai.getKeyId());
                    props.put("access-key", ai.getKey());
                    props.put("container-type", inst.getContainerType());
                    props.put("url", inst.getId());
                    try {
                        ip = InstanceProperties.createInstancePropertiesNonPersistent((String)inst.getId(), (String)ai.getKeyId(), (String)ai.getKey(), (String)inst.getDisplayName(), props);
                    }
                    catch (InstanceCreationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                inst.setInstance(si);
                servers.add(si);
            }
        }
        this.instances = servers;
        this.listeners.fireChange();
    }

    public final Future<Void> refreshServers() {
        return AmazonInstance.runAsynchronously(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    AmazonJ2EEServerInstanceProvider.this.refreshServersSynchronously();
                }
                catch (RuntimeException e) {
                    LOG.log(Level.INFO, "refreshServers failed. perhaps AWS is not accessible?", e);
                }
                return null;
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.refreshServers();
    }

    static {
        LOG = Logger.getLogger(AmazonJ2EEServerInstanceProvider.class.getName());
    }
}

