/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.api.server.properties.InstanceProperties;
import org.netbeans.api.server.properties.InstancePropertiesManager;
import org.netbeans.modules.cloud.amazon.AmazonInstance;
import org.openide.util.ChangeSupport;

public class AmazonInstanceManager {
    private static final String AMAZON_IP_NAMESPACE = "cloud.amazon";
    private static final String PREFIX = "org.netbeans.modules.cloud.amazon.";
    private static final String KEY_ID = "access-key-id";
    private static final String KEY = "secret-access-key";
    private static AmazonInstanceManager instance;
    private List<AmazonInstance> instances = new ArrayList<AmazonInstance>();
    private ChangeSupport listeners = new ChangeSupport((Object)this);
    private static final Logger LOG;

    public static synchronized AmazonInstanceManager getDefault() {
        if (instance == null) {
            instance = new AmazonInstanceManager();
        }
        return instance;
    }

    private AmazonInstanceManager() {
        this.init();
    }

    private void init() {
        this.instances.addAll(AmazonInstanceManager.load());
        this.notifyChange();
    }

    private void notifyChange() {
        this.listeners.fireChange();
    }

    public List<AmazonInstance> getInstances() {
        return this.instances;
    }

    public void add(AmazonInstance ai) {
        this.store(ai);
        this.instances.add(ai);
        this.notifyChange();
    }

    private void store(AmazonInstance ai) {
        InstanceProperties props = InstancePropertiesManager.getInstance().createProperties(AMAZON_IP_NAMESPACE);
        Keyring.save((String)("org.netbeans.modules.cloud.amazon.access-key-id." + ai.getName()), (char[])ai.getKeyId().toCharArray(), (String)"Amazon Access Key ID");
        Keyring.save((String)("org.netbeans.modules.cloud.amazon.secret-access-key." + ai.getName()), (char[])ai.getKey().toCharArray(), (String)"Amazon Secret Access Key");
        props.putString("name", ai.getName());
    }

    private static List<AmazonInstance> load() {
        ArrayList<AmazonInstance> result = new ArrayList<AmazonInstance>();
        for (InstanceProperties props : InstancePropertiesManager.getInstance().getProperties(AMAZON_IP_NAMESPACE)) {
            String name = props.getString("name", null);
            assert (name != null) : "Instance without name";
            char[] ch = Keyring.read((String)("org.netbeans.modules.cloud.amazon.access-key-id." + name));
            if (ch == null) {
                LOG.log(Level.WARNING, "no access key id found for " + name);
                continue;
            }
            String keyId = new String(ch);
            assert (keyId != null) : "key ID is missing for " + name;
            ch = Keyring.read((String)("org.netbeans.modules.cloud.amazon.secret-access-key." + name));
            if (ch == null) {
                LOG.log(Level.WARNING, "no secret access key found for " + name);
                continue;
            }
            String key = new String(ch);
            assert (key != null) : "secret access key is missing for " + name;
            result.add(new AmazonInstance(name, keyId, key));
        }
        return result;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.removeChangeListener(l);
    }

    void remove(AmazonInstance ai) {
        for (InstanceProperties props : InstancePropertiesManager.getInstance().getProperties(AMAZON_IP_NAMESPACE)) {
            if (!ai.getName().equals(props.getString("name", null))) continue;
            props.remove();
            break;
        }
        this.instances.remove(ai);
        this.notifyChange();
    }

    static {
        LOG = Logger.getLogger(AmazonInstanceManager.class.getSimpleName());
    }
}

