/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.elasticbeanstalk.AWSElasticBeanstalkClient;
import com.amazonaws.services.elasticbeanstalk.model.ApplicationDescription;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityRequest;
import com.amazonaws.services.elasticbeanstalk.model.CheckDNSAvailabilityResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionRequest;
import com.amazonaws.services.elasticbeanstalk.model.CreateApplicationVersionResult;
import com.amazonaws.services.elasticbeanstalk.model.CreateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsRequest;
import com.amazonaws.services.elasticbeanstalk.model.DescribeEnvironmentsResult;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentDescription;
import com.amazonaws.services.elasticbeanstalk.model.EnvironmentStatus;
import com.amazonaws.services.elasticbeanstalk.model.S3Location;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentRequest;
import com.amazonaws.services.elasticbeanstalk.model.UpdateEnvironmentResult;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEInstance;
import org.netbeans.modules.cloud.common.spi.support.serverplugin.DeploymentStatus;
import org.netbeans.modules.cloud.common.spi.support.serverplugin.ProgressObjectImpl;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class AmazonInstance {
    private static final RequestProcessor AMAZON_RP = new RequestProcessor("amazon aws", 1);
    private static final Logger LOG = Logger.getLogger(AmazonInstance.class.getSimpleName());
    public static final String DEFAULT_EMPTY_APPLICATION = "empty-nb-app-1.0.war";
    private final String keyId;
    private final String key;
    private final String name;
    private ServerInstance serverInstance;

    public AmazonInstance(String name, String keyId, String key) {
        this.keyId = keyId;
        this.key = key;
        this.name = name;
    }

    void setServerInstance(ServerInstance serverInstance) {
        this.serverInstance = serverInstance;
    }

    public ServerInstance getServerInstance() {
        return this.serverInstance;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    private AWSCredentials getCredentials() {
        return new BasicAWSCredentials(this.keyId, this.key);
    }

    private static AWSCredentials getCredentials(String keyId, String key) {
        return new BasicAWSCredentials(keyId, key);
    }

    public void testConnection() {
        assert (!SwingUtilities.isEventDispatchThread());
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        client.createStorageLocation();
    }

    public List<AmazonJ2EEInstance> readJ2EEServerInstances() {
        assert (!SwingUtilities.isEventDispatchThread());
        ArrayList<AmazonJ2EEInstance> res = new ArrayList<AmazonJ2EEInstance>();
        LOG.log(Level.INFO, "read AWS environments");
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        for (EnvironmentDescription ed : client.describeEnvironments().getEnvironments()) {
            AmazonJ2EEInstance inst = new AmazonJ2EEInstance(this, ed.getApplicationName(), ed.getEnvironmentName(), ed.getEnvironmentId(), ed.getSolutionStackName());
            inst.updateState(ed.getStatus());
            res.add(inst);
        }
        LOG.log(Level.INFO, "environments available: " + res);
        return res;
    }

    public List<String> readApplicationNames() {
        assert (!SwingUtilities.isEventDispatchThread());
        ArrayList<String> res = new ArrayList<String>();
        try {
            LOG.log(Level.INFO, "read AWS applications");
            AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
            for (ApplicationDescription ad : client.describeApplications().getApplications()) {
                res.add(ad.getApplicationName());
            }
            LOG.log(Level.INFO, "applications available: " + res);
        }
        catch (AmazonClientException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res;
    }

    public Map<String, List<String>> readApplicationTemplates() {
        assert (!SwingUtilities.isEventDispatchThread());
        HashMap<String, List<String>> res = new HashMap<String, List<String>>();
        try {
            LOG.log(Level.INFO, "read AWS application templates");
            AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
            for (ApplicationDescription ad : client.describeApplications().getApplications()) {
                res.put(ad.getApplicationName(), ad.getConfigurationTemplates());
            }
            LOG.log(Level.INFO, "applications templates available: " + res);
        }
        catch (AmazonClientException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res;
    }

    public List<String> readContainerTypes() {
        assert (!SwingUtilities.isEventDispatchThread());
        List<String> res = new ArrayList<String>();
        try {
            LOG.log(Level.INFO, "read AWS solution stacks");
            AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
            res = client.listAvailableSolutionStacks().getSolutionStacks();
            LOG.log(Level.INFO, "solution stacks available: " + res);
        }
        catch (AmazonClientException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return res;
    }

    public boolean checkURLValidity(String url) {
        assert (!SwingUtilities.isEventDispatchThread());
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        CheckDNSAvailabilityResult res = client.checkDNSAvailability(new CheckDNSAvailabilityRequest(url));
        return res.isAvailable();
    }

    public void createApplication(String appName) {
        assert (!SwingUtilities.isEventDispatchThread());
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        CreateApplicationRequest req = new CreateApplicationRequest(appName);
        client.createApplication(req).getApplication();
    }

    public S3Location createDefaultEmptyApplication() {
        assert (!SwingUtilities.isEventDispatchThread());
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        AmazonS3Client s3 = new AmazonS3Client(AmazonInstance.getCredentials(this.keyId, this.key));
        String bucket = client.createStorageLocation().getS3Bucket();
        boolean exist = false;
        try {
            s3.getObjectMetadata(bucket, DEFAULT_EMPTY_APPLICATION);
            exist = true;
        }
        catch (AmazonS3Exception ex) {
            // empty catch block
        }
        if (!exist) {
            InputStream is = AmazonInstance.class.getResourceAsStream("resources/empty.war");
            s3.putObject(new PutObjectRequest(bucket, DEFAULT_EMPTY_APPLICATION, is, new ObjectMetadata()));
            try {
                is.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return new S3Location().withS3Bucket(bucket).withS3Key(DEFAULT_EMPTY_APPLICATION);
    }

    public void createInitialEmptyApplication(String appName) {
        assert (!SwingUtilities.isEventDispatchThread());
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        S3Location slocation = this.createDefaultEmptyApplication();
        CreateApplicationVersionRequest req = new CreateApplicationVersionRequest(appName, "blank application from NetBeans").withSourceBundle(slocation);
        client.createApplicationVersion(req);
    }

    public String createEnvironment(String appName, String envName, String url, String containerType, String template) {
        assert (!SwingUtilities.isEventDispatchThread());
        AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(this.getCredentials());
        CreateEnvironmentRequest req = new CreateEnvironmentRequest(appName, envName).withCNAMEPrefix(url).withSolutionStackName(containerType);
        if (template != null) {
            req = req.withTemplateName(template);
        }
        return client.createEnvironment(req).getEnvironmentId();
    }

    public static Future<DeploymentStatus> deployAsync(final File f, final String applicationName, final String environmentId, final String keyId, final String key, final ProgressObjectImpl po) {
        return AmazonInstance.runAsynchronously(new Callable<DeploymentStatus>(){

            @Override
            public DeploymentStatus call() throws Exception {
                String[] url = new String[1];
                DeploymentStatus ds = AmazonInstance.deploy(f, applicationName, environmentId, keyId, key, po, url);
                LOG.log(Level.INFO, "deployment result: " + ds);
                po.updateDepoymentResult(ds, url[0]);
                return ds;
            }
        });
    }

    public static DeploymentStatus deploy(File f, String applicationName, String environmentId, String keyId, String key, ProgressObjectImpl po, String[] url) {
        assert (!SwingUtilities.isEventDispatchThread());
        try {
            EnvironmentDescription env;
            if (po != null) {
                try {
                    po.updateDepoymentStage(NbBundle.getMessage(AmazonInstance.class, (String)"MSG_DEPLOY_AUTH"));
                }
                catch (Throwable tt) {
                    tt.printStackTrace();
                }
            }
            LOG.log(Level.INFO, "deploy to AWS[" + environmentId + "] " + f);
            AWSElasticBeanstalkClient client = new AWSElasticBeanstalkClient(AmazonInstance.getCredentials(keyId, key));
            AmazonS3Client s3 = new AmazonS3Client(AmazonInstance.getCredentials(keyId, key));
            if (po != null) {
                po.updateDepoymentStage(NbBundle.getMessage(AmazonInstance.class, (String)"MSG_DEPLOY_UPLOAD"));
            }
            String label = f.getName().toLowerCase();
            assert (label.endsWith(".war") || label.endsWith(".ear") || label.endsWith(".jar")) : "war/jar/ear archive expected: " + f;
            String version = new SimpleDateFormat("yyyyMMdd-HHmmss-SSSS").format(new Date());
            label = label.substring(0, label.length() - 4) + "-" + version + "." + label.substring(label.length() - 3);
            String bucket = client.createStorageLocation().getS3Bucket();
            LOG.log(Level.INFO, "using bucket " + bucket);
            LOG.log(Level.INFO, "label " + label);
            s3.putObject(new PutObjectRequest(bucket, label, f));
            S3Location slocation = new S3Location().withS3Bucket(bucket).withS3Key(label);
            if (po != null) {
                po.updateDepoymentStage(NbBundle.getMessage(AmazonInstance.class, (String)"MSG_DEPLOY_UPDATE"));
            }
            CreateApplicationVersionRequest newApp = new CreateApplicationVersionRequest().withVersionLabel(label).withApplicationName(applicationName).withDescription(NbBundle.getMessage(AmazonInstance.class, (String)"MSG_DEPLOY_NB")).withAutoCreateApplication(Boolean.FALSE).withSourceBundle(slocation);
            CreateApplicationVersionResult res = client.createApplicationVersion(newApp);
            UpdateEnvironmentRequest updateReq = new UpdateEnvironmentRequest().withEnvironmentId(environmentId).withVersionLabel(label);
            try {
                UpdateEnvironmentResult result = client.updateEnvironment(updateReq);
                url[0] = "http://" + result.getEndpointURL();
                LOG.log(Level.INFO, "environment updated " + result);
            }
            catch (AmazonServiceException as) {
                LOG.log(Level.INFO, "environment update failed", as);
                if (po != null) {
                    po.updateDepoymentStage(as.toString());
                }
                return DeploymentStatus.FAILED;
            }
            if (po != null) {
                po.updateDepoymentStage(NbBundle.getMessage(AmazonInstance.class, (String)"MSG_DEPLOY_REDEPLOY"));
            }
            DescribeEnvironmentsRequest request = new DescribeEnvironmentsRequest().withEnvironmentIds(new String[]{environmentId});
            do {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                DescribeEnvironmentsResult envir = client.describeEnvironments(request);
                if (envir.getEnvironments().size() != 1) {
                    return DeploymentStatus.UNKNOWN;
                }
                env = (EnvironmentDescription)envir.getEnvironments().get(0);
                LOG.log(Level.INFO, "AWS[" + environmentId + "] status: " + env.getStatus() + " and health:" + env.getHealth());
                if (EnvironmentStatus.fromValue((String)env.getStatus()) != EnvironmentStatus.Ready) continue;
                return DeploymentStatus.SUCCESS;
            } while (EnvironmentStatus.fromValue((String)env.getStatus()) != EnvironmentStatus.Terminated && EnvironmentStatus.fromValue((String)env.getStatus()) != EnvironmentStatus.Terminating);
            return DeploymentStatus.UNKNOWN;
        }
        catch (AmazonClientException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return DeploymentStatus.UNKNOWN;
        }
    }

    public static <T> Future<T> runAsynchronously(Callable<T> callable) {
        return AmazonInstance.runAsynchronously(callable, null);
    }

    public static synchronized <T> Future<T> runAsynchronously(Callable<T> callable, AmazonInstance ai) {
        Future f = AMAZON_RP.submit(callable);
        return f;
    }
}

