/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.apache.maven.DefaultMaven;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.MavenEmbedder;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.hints.pom.spi.SelectionPOMFixProvider;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.POMModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.spi.editor.errorstripe.UpToDateStatus;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProvider;
import org.netbeans.spi.editor.errorstripe.UpToDateStatusProviderFactory;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.HintsController;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class StatusProvider
implements UpToDateStatusProviderFactory {
    private static final String LAYER_POM = "pom";
    private static final String LAYER_POM_SELECTION = "pom-selection";
    private static final RequestProcessor RP = new RequestProcessor("StatusProvider");
    private static final Logger LOG = Logger.getLogger(StatusProvider.class.getName());

    public UpToDateStatusProvider createUpToDateStatusProvider(Document document) {
        return new StatusProviderImpl(document);
    }

    private static void runMavenValidation(POMModel model, List<ErrorDescription> err) {
        File pom = (File)model.getModelSource().getLookup().lookup(File.class);
        if (pom == null) {
            return;
        }
        List<ModelProblem> problems = StatusProvider.runMavenValidationImpl(pom);
        for (ModelProblem problem : problems) {
            if (!problem.getSource().equals(pom.getAbsolutePath())) {
                LOG.log(Level.FINE, "found problem not in {0}: {1}", new Object[]{pom, problem.getSource()});
                continue;
            }
            int line = problem.getLineNumber();
            if (line <= 0 || problem.getException() instanceof UnresolvableModelException) continue;
            try {
                err.add(ErrorDescriptionFactory.createErrorDescription((Severity)(problem.getSeverity() == ModelProblem.Severity.WARNING ? Severity.WARNING : Severity.ERROR), (String)problem.getMessage(), (Document)model.getBaseDocument(), (int)line));
            }
            catch (IndexOutOfBoundsException x) {
                LOG.log(Level.WARNING, "improper line number: {0}", problem);
            }
        }
    }

    static List<ModelProblem> runMavenValidationImpl(File pom) {
        ArrayList<ModelProblem> problems;
        block4: {
            MavenEmbedder embedder = EmbedderFactory.getProjectEmbedder();
            MavenExecutionRequest meReq = embedder.createMavenExecutionRequest();
            ProjectBuildingRequest req = meReq.getProjectBuildingRequest();
            req.setValidationLevel(31);
            req.setLocalRepository(embedder.getLocalRepository());
            List remoteRepos = RepositoryPreferences.getInstance().remoteRepositories(embedder);
            req.setRemoteRepositories(remoteRepos);
            req.setRepositorySession(((DefaultMaven)embedder.lookupComponent(Maven.class)).newRepositorySession(meReq));
            try {
                problems = ((ProjectBuilder)embedder.lookupComponent(ProjectBuilder.class)).build(pom, req).getProblems();
            }
            catch (ProjectBuildingException x) {
                problems = new ArrayList();
                List results = x.getResults();
                if (results != null) {
                    for (ProjectBuildingResult result : results) {
                        problems.addAll(result.getProblems());
                    }
                }
                Throwable cause = x.getCause();
                if (!(cause instanceof ModelBuildingException)) break block4;
                problems.addAll(((ModelBuildingException)cause).getProblems());
            }
        }
        return problems;
    }

    static class StatusProviderImpl
    extends UpToDateStatusProvider {
        private Document document;
        @NullAllowed
        private POMModel model;
        private Project project;
        private FileChangeListener listener;

        StatusProviderImpl(Document doc) {
            this.document = doc;
            this.listener = new FileChangeAdapter(){

                public void fileChanged(FileEvent fe) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            StatusProviderImpl.this.checkHints();
                        }
                    });
                }
            };
            RP.post(new Runnable(){

                @Override
                public void run() {
                    StatusProviderImpl.this.initializeModel();
                    StatusProviderImpl.this.checkHints();
                }
            });
        }

        private void checkHints() {
            if (this.model == null) {
                return;
            }
            HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM, StatusProviderImpl.findHints(this.model, this.project, -1, -1));
        }

        static List<ErrorDescription> findHints(final @NonNull POMModel model, final Project project, final int selectionStart, final int selectionEnd) {
            assert (model != null);
            if (!model.getModelSource().isEditable()) {
                return new ArrayList<ErrorDescription>();
            }
            try {
                model.getBaseDocument();
                model.sync();
            }
            catch (IOException ex) {
                LOG.log(Level.FINE, "Error while syncing pom model.", ex);
            }
            final ArrayList<ErrorDescription> err = new ArrayList<ErrorDescription>();
            if (!model.getState().equals((Object)Model.State.VALID)) {
                LOG.log(Level.FINE, "Pom model document is not valid, is {0}", model.getState());
                return err;
            }
            if (model.getProject() == null) {
                LOG.log(Level.FINE, "Pom model root element missing");
                return err;
            }
            StatusProvider.runMavenValidation(model, err);
            return (List)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<List<ErrorDescription>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public List<ErrorDescription> run() {
                    boolean isInTransaction = model.isIntransaction();
                    if (!isInTransaction && !model.startTransaction()) {
                        return err;
                    }
                    try {
                        Lookup.Result res;
                        Lookup lkp = Lookups.forPath((String)"org-netbeans-modules-maven-hints");
                        if (selectionStart == -1 && selectionEnd == -1) {
                            res = lkp.lookupResult(POMErrorFixProvider.class);
                            for (POMErrorFixProvider prov : res.allInstances()) {
                                List<ErrorDescription> lst;
                                if (!prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences()) || (lst = prov.getErrorsForDocument(model, project)) == null) continue;
                                err.addAll(lst);
                            }
                        } else {
                            res = lkp.lookupResult(SelectionPOMFixProvider.class);
                            for (SelectionPOMFixProvider prov : res.allInstances()) {
                                List<ErrorDescription> lst;
                                if (!prov.getConfiguration().isEnabled(prov.getConfiguration().getPreferences()) || (lst = prov.getErrorsForDocument(model, project, selectionStart, selectionEnd)) == null) continue;
                                err.addAll(lst);
                            }
                        }
                        List list = err;
                        return list;
                    }
                    finally {
                        if (!isInTransaction && model.isIntransaction()) {
                            try {
                                model.endTransaction();
                            }
                            catch (IllegalStateException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                }
            });
        }

        private void initializeModel() {
            FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
            if (fo != null) {
                ModelSource ms = Utilities.createModelSource((FileObject)fo);
                this.model = POMModelFactory.getDefault().getModel(ms);
                this.model.setAutoSyncActive(false);
                this.project = FileOwnerQuery.getOwner((FileObject)fo);
                fo.addFileChangeListener(FileUtil.weakFileChangeListener((FileChangeListener)this.listener, (Object)fo));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UpToDateStatus getUpToDate() {
            if (this.model == null) {
                return UpToDateStatus.UP_TO_DATE_OK;
            }
            FileObject fo = NbEditorUtilities.getFileObject((Document)this.document);
            boolean ok = false;
            try {
                int selectionEnd;
                int selectionStart;
                JEditorPane[] panes;
                DataObject dobj;
                EditorCookie ed;
                if (fo.isValid() && (ed = (EditorCookie)(dobj = DataObject.find((FileObject)fo)).getLookup().lookup(EditorCookie.class)) != null && (panes = ed.getOpenedPanes()) != null && panes.length > 0 && (selectionStart = panes[0].getSelectionStart()) != (selectionEnd = panes[0].getSelectionEnd())) {
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            if (!StatusProviderImpl.this.model.isIntransaction()) {
                                HintsController.setErrors((Document)StatusProviderImpl.this.document, (String)StatusProvider.LAYER_POM_SELECTION, StatusProviderImpl.findHints(StatusProviderImpl.this.model, StatusProviderImpl.this.project, selectionStart, selectionEnd));
                            } else {
                                HintsController.setErrors((Document)StatusProviderImpl.this.document, (String)StatusProvider.LAYER_POM_SELECTION, Collections.emptyList());
                            }
                        }
                    });
                    ok = true;
                    UpToDateStatus upToDateStatus = UpToDateStatus.UP_TO_DATE_PROCESSING;
                    return upToDateStatus;
                }
            }
            catch (DataObjectNotFoundException ex) {
                LOG.log(Level.INFO, "Touched somehow invalidated FileObject", ex);
            }
            finally {
                if (!ok) {
                    HintsController.setErrors((Document)this.document, (String)StatusProvider.LAYER_POM_SELECTION, Collections.emptyList());
                }
            }
            return UpToDateStatus.UP_TO_DATE_OK;
        }
    }
}

