/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.Bundle;
import org.netbeans.modules.maven.hints.pom.ParentVersionErrorCustomizer;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Parent;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.filesystems.FileObject;
import org.openide.text.Line;
import org.openide.util.Exceptions;

public class ParentVersionError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("ParentVersionError", Bundle.TIT_ParentVersionError(), Bundle.DESC_ParentVersionError(), true, Configuration.HintSeverity.WARNING);
    static final String PROP_SOURCES = "sources";
    static final String PROP_SNAPSHOT = "snapshot";

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return null;
        }
        Parent par = model.getProject().getPomParent();
        if (par == null) {
            return toRet;
        }
        boolean useSources = this.getConfiguration().getPreferences().getBoolean(PROP_SOURCES, true);
        boolean useSnapshot = this.getConfiguration().getPreferences().getBoolean(PROP_SNAPSHOT, false);
        String declaredVersion = par.getVersion();
        String relPath = par.getRelativePath();
        if (relPath == null) {
            relPath = "../pom.xml";
        }
        FileObject relPathFO = prj.getProjectDirectory().getFileObject(relPath);
        String currentVersion = null;
        boolean usedSources = false;
        if (useSources && relPathFO != null && relPathFO.getNameExt().equals("pom.xml")) {
            String parGr = par.getGroupId();
            String parArt = par.getArtifactId();
            if (parArt != null && parGr != null) {
                try {
                    MavenProject mav;
                    NbMavenProject nbprj;
                    Project parentPrj = ProjectManager.getDefault().findProject(relPathFO.getParent());
                    if (parentPrj != null && (nbprj = (NbMavenProject)parentPrj.getLookup().lookup(NbMavenProject.class)) != null && parGr.equals((mav = nbprj.getMavenProject()).getGroupId()) && parArt.equals(mav.getArtifactId())) {
                        currentVersion = mav.getVersion();
                        usedSources = true;
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        if (!(useSources && currentVersion != null || declaredVersion == null)) {
            DefaultArtifactVersion currentAV = new DefaultArtifactVersion(declaredVersion);
            RepositoryQueries.Result result = RepositoryQueries.getVersionsResult((String)par.getGroupId(), (String)par.getArtifactId(), null);
            if (!result.isPartial()) {
                for (NBVersionInfo info : result.getResults()) {
                    DefaultArtifactVersion av;
                    if (!useSnapshot && info.getVersion().contains("SNAPSHOT") || currentAV.compareTo((Object)(av = new DefaultArtifactVersion(info.getVersion()))) >= 0) continue;
                    currentAV = av;
                }
                currentVersion = currentAV.toString();
            }
        }
        if (currentVersion != null && !currentVersion.equals(declaredVersion)) {
            int position = par.findChildElementPosition(model.getPOMQNames().VERSION.getQName());
            Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)position, (boolean)false);
            String message = usedSources ? Bundle.TXT_ParentVersionError(currentVersion) : Bundle.TXT_ParentVersionError2(currentVersion);
            toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)message, Collections.singletonList(new SynchronizeFix(par, currentVersion, usedSources)), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
        }
        return toRet;
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return new ParentVersionErrorCustomizer(preferences);
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private static class SynchronizeFix
    implements Fix,
    Runnable {
        private Parent parent;
        private String version;
        private String message;

        SynchronizeFix(Parent par, String version, boolean usedSources) {
            this.parent = par;
            this.version = version;
            this.message = usedSources ? Bundle.TEXT_ParentVersionFix(version) : Bundle.TEXT_ParentVersionFix2(version);
        }

        public String getText() {
            return this.message;
        }

        @Override
        public void run() {
            this.parent.setVersion(this.version);
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            POMModel mdl = this.parent.getModel();
            if (!mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            PomModelUtils.implementInTransaction((Model)mdl, this);
            return info;
        }
    }
}

