/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.pom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.JComponent;
import javax.swing.text.Document;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginManagement;
import org.netbeans.api.project.Project;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.pom.PomModelUtils;
import org.netbeans.modules.maven.hints.pom.spi.Configuration;
import org.netbeans.modules.maven.hints.pom.spi.POMErrorFixProvider;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.BuildBase;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Profile;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.ErrorDescriptionFactory;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.text.Line;
import org.openide.util.NbBundle;

public class OverridePluginManagementError
implements POMErrorFixProvider {
    private Configuration configuration = new Configuration("OverridePluginManagementError", NbBundle.getMessage(OverridePluginManagementError.class, (String)"TIT_OverridePluginManagementError"), NbBundle.getMessage(OverridePluginManagementError.class, (String)"DESC_OverridePluginManagementError"), true, Configuration.HintSeverity.WARNING);

    @Override
    public List<ErrorDescription> getErrorsForDocument(POMModel model, Project prj) {
        List profiles;
        assert (model != null);
        ArrayList<ErrorDescription> toRet = new ArrayList<ErrorDescription>();
        if (prj == null) {
            return toRet;
        }
        Map<String, String> managed = this.collectManaged(prj);
        if (managed.isEmpty()) {
            return toRet;
        }
        Build bld = model.getProject().getBuild();
        if (bld != null) {
            this.checkPluginList(bld.getPlugins(), model, toRet, managed);
        }
        if ((profiles = model.getProject().getProfiles()) != null) {
            for (Profile prof : profiles) {
                BuildBase base = prof.getBuildBase();
                if (base == null) continue;
                this.checkPluginList(base.getPlugins(), model, toRet, managed);
            }
        }
        return toRet;
    }

    private void checkPluginList(List<org.netbeans.modules.maven.model.pom.Plugin> plugins, POMModel model, List<ErrorDescription> toRet, Map<String, String> managed) {
        if (plugins != null) {
            for (org.netbeans.modules.maven.model.pom.Plugin plg : plugins) {
                String ver = plg.getVersion();
                if (ver == null) continue;
                String art = plg.getArtifactId();
                String gr = plg.getGroupId();
                gr = gr != null ? gr : "org.apache.maven.plugins";
                String key = gr + ":" + art;
                if (!managed.keySet().contains(key)) continue;
                int position = plg.findChildElementPosition(model.getPOMQNames().VERSION.getQName());
                Line line = NbEditorUtilities.getLine((Document)model.getBaseDocument(), (int)position, (boolean)false);
                String managedver = managed.get(key);
                toRet.add(ErrorDescriptionFactory.createErrorDescription((Severity)this.configuration.getSeverity(this.configuration.getPreferences()).toEditorSeverity(), (String)NbBundle.getMessage(OverridePluginManagementError.class, (String)"TXT_OverridePluginManagementError", (Object)managedver), Collections.singletonList(new OverrideFix(plg)), (Document)model.getBaseDocument(), (int)(line.getLineNumber() + 1)));
            }
        }
    }

    @Override
    public JComponent getCustomizer(Preferences preferences) {
        return null;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private Map<String, String> collectManaged(Project prj) {
        NbMavenProject project = (NbMavenProject)prj.getLookup().lookup(NbMavenProject.class);
        HashMap<String, String> toRet = new HashMap<String, String>();
        if (project == null) {
            return toRet;
        }
        PluginManagement pluginManagement = project.getMavenProject().getPluginManagement();
        if (pluginManagement == null) {
            return toRet;
        }
        for (Plugin plg : pluginManagement.getPlugins()) {
            if (plg.getGroupId().equals("org.apache.maven.plugins")) continue;
            toRet.put(plg.getKey(), plg.getVersion());
        }
        return toRet;
    }

    private static class OverrideFix
    implements Fix,
    Runnable {
        private org.netbeans.modules.maven.model.pom.Plugin plugin;

        OverrideFix(org.netbeans.modules.maven.model.pom.Plugin plg) {
            this.plugin = plg;
        }

        public String getText() {
            return NbBundle.getMessage(OverridePluginManagementError.class, (String)"TEXT_OverridePluginFix");
        }

        @Override
        public void run() {
            this.plugin.setVersion(null);
        }

        public ChangeInfo implement() throws Exception {
            ChangeInfo info = new ChangeInfo();
            POMModel mdl = this.plugin.getModel();
            if (!mdl.getState().equals((Object)Model.State.VALID)) {
                return info;
            }
            PomModelUtils.implementInTransaction((Model)mdl, this);
            return info;
        }
    }
}

