/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hints.errors;

import com.sun.source.tree.ArrayTypeTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Name;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.hints.errors.Bundle;
import org.netbeans.modules.maven.hints.errors.SearchClassDependencyHint;
import org.netbeans.modules.maven.hints.ui.SearchDependencyUI;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.EnhancedFix;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

public class SearchClassDependencyInRepo
implements ErrorRule<Void> {
    private AtomicBoolean cancel = new AtomicBoolean(false);

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve", "compiler.err.cant.resolve.location", "compiler.err.doesnt.exist", "compiler.err.not.stmt"));
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        File testdir;
        FileObject fo;
        MavenProject mp;
        String testSourceDirectory;
        TreePath parent;
        this.cancel.set(false);
        if (!SearchClassDependencyHint.isHintEnabled()) {
            return Collections.emptyList();
        }
        int errorPosition = offset + 1;
        if (errorPosition == -1) {
            return Collections.emptyList();
        }
        FileObject fileObject = info.getFileObject();
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return Collections.emptyList();
        }
        NbMavenProject mavProj = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (mavProj == null) {
            return Collections.emptyList();
        }
        TreePath path = info.getTreeUtilities().pathFor(errorPosition);
        if (path.getParentPath() == null) {
            return Collections.emptyList();
        }
        Tree leaf = path.getParentPath().getLeaf();
        switch (leaf.getKind()) {
            case METHOD_INVOCATION: {
                MethodInvocationTree mit = (MethodInvocationTree)leaf;
                if (!mit.getTypeArguments().contains(path.getLeaf())) {
                    return Collections.emptyList();
                }
            }
            case PARAMETERIZED_TYPE: {
                leaf = path.getParentPath().getParentPath().getLeaf();
                break;
            }
            case ARRAY_TYPE: {
                leaf = path.getParentPath().getParentPath().getLeaf();
            }
        }
        switch (leaf.getKind()) {
            case VARIABLE: {
                Name typeName = null;
                VariableTree variableTree = (VariableTree)leaf;
                if (variableTree.getType() != null) {
                    switch (variableTree.getType().getKind()) {
                        case IDENTIFIER: {
                            typeName = ((IdentifierTree)variableTree.getType()).getName();
                            break;
                        }
                        case PARAMETERIZED_TYPE: {
                            Tree ptt = (ParameterizedTypeTree)variableTree.getType();
                            if (ptt.getType() == null || ptt.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                            typeName = ((IdentifierTree)ptt.getType()).getName();
                            break;
                        }
                        case ARRAY_TYPE: {
                            Tree ptt = (ArrayTypeTree)variableTree.getType();
                            if (ptt.getType() == null || ptt.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                            typeName = ((IdentifierTree)ptt.getType()).getName();
                        }
                    }
                }
                ExpressionTree initializer = variableTree.getInitializer();
                if (typeName == null || initializer == null) break;
                Name itName = null;
                switch (initializer.getKind()) {
                    case NEW_CLASS: {
                        NewClassTree classTree = (NewClassTree)initializer;
                        ExpressionTree identifier = classTree.getIdentifier();
                        if (identifier != null) {
                            switch (identifier.getKind()) {
                                case IDENTIFIER: {
                                    itName = ((IdentifierTree)identifier).getName();
                                    break;
                                }
                                case PARAMETERIZED_TYPE: {
                                    ParameterizedTypeTree ptt = (ParameterizedTypeTree)((Object)identifier);
                                    if (ptt.getType() == null || ptt.getType().getKind() != Tree.Kind.IDENTIFIER) break;
                                    itName = ((IdentifierTree)ptt.getType()).getName();
                                }
                            }
                        }
                        break;
                    }
                    case NEW_ARRAY: {
                        NewArrayTree arrayTree = (NewArrayTree)initializer;
                        Tree type = arrayTree.getType();
                        if (type == null || !type.getKind().equals((Object)Tree.Kind.IDENTIFIER)) break;
                        itName = ((IdentifierTree)type).getName();
                    }
                }
                if (!((Object)typeName).equals(itName)) break;
                return Collections.emptyList();
            }
        }
        String simpleOrQualifiedName = null;
        TreePath p = path;
        while (p != null && (parent = p.getParentPath()) != null) {
            Tree.Kind parentKind = parent.getLeaf().getKind();
            if (parentKind == Tree.Kind.IMPORT) {
                simpleOrQualifiedName = p.getLeaf().toString();
                break;
            }
            if (parentKind != Tree.Kind.MEMBER_SELECT && parentKind != Tree.Kind.IDENTIFIER) break;
            p = parent;
        }
        if (simpleOrQualifiedName == null) {
            try {
                Token ident = SearchClassDependencyInRepo.findUnresolvedElementToken(info, offset);
                if (ident == null) {
                    return Collections.emptyList();
                }
                simpleOrQualifiedName = ((Object)ident.text()).toString();
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
                return Collections.emptyList();
            }
        }
        if (this.cancel.get()) {
            return Collections.emptyList();
        }
        boolean isTestSource = false;
        if (simpleOrQualifiedName.endsWith(".*")) {
            simpleOrQualifiedName = simpleOrQualifiedName.substring(0, simpleOrQualifiedName.length() - ".*".length());
        }
        if ((testSourceDirectory = (mp = mavProj.getMavenProject()).getBuild().getTestSourceDirectory()) != null && (fo = FileUtil.toFileObject((File)(testdir = new File(testSourceDirectory)))) != null) {
            isTestSource = FileUtil.isParentOf((FileObject)fo, (FileObject)fileObject);
        }
        ArrayList<Fix> fixes = new ArrayList<Fix>();
        if (SearchClassDependencyHint.isSearchDialog()) {
            fixes.add((Fix)new MavenSearchFix(project, simpleOrQualifiedName, isTestSource));
        } else {
            Collection<NBVersionInfo> findVersionsByClass = this.filter(mavProj, RepositoryQueries.findVersionsByClassResult((String)simpleOrQualifiedName, (List)RepositoryPreferences.getInstance().getRepositoryInfos()).getResults(), isTestSource);
            for (NBVersionInfo nbvi : findVersionsByClass) {
                fixes.add((Fix)new MavenFixImport(project, nbvi, isTestSource));
            }
        }
        return fixes;
    }

    private Collection<NBVersionInfo> filter(NbMavenProject mavProj, List<NBVersionInfo> nbvis, boolean test) {
        HashMap<String, NBVersionInfo> items = new HashMap<String, NBVersionInfo>();
        ArrayList dependencies = new ArrayList();
        MavenProject prj = mavProj.getMavenProject();
        if (test) {
            dependencies.addAll(prj.getTestDependencies());
        } else {
            dependencies.addAll(prj.getDependencies());
        }
        for (NBVersionInfo info : nbvis) {
            String key = info.getGroupId() + ":" + info.getArtifactId();
            boolean b = items.containsKey(key);
            if (!b) {
                items.put(key, info);
            }
            for (Dependency dependency : dependencies) {
                if (dependency.getGroupId() == null || !dependency.getGroupId().equals(info.getGroupId()) || dependency.getArtifactId() == null || !dependency.getArtifactId().equals(info.getArtifactId()) || test || dependency.getScope() == null || !"compile".equals(dependency.getScope())) continue;
                return Collections.emptyList();
            }
        }
        ArrayList<NBVersionInfo> filterd = new ArrayList<NBVersionInfo>(items.values());
        return filterd;
    }

    private static Token findUnresolvedElementToken(CompilationInfo info, int offset) throws IOException {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.LT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.NEW) {
                boolean cont = ts.moveNext();
                while (cont && ts.token().id() == JavaTokenId.WHITESPACE) {
                    cont = ts.moveNext();
                }
                if (!cont) {
                    return null;
                }
                t = ts.token();
            }
            if (t.id() == JavaTokenId.IDENTIFIER) {
                return ts.offsetToken();
            }
        }
        return null;
    }

    public String getId() {
        return "MAVEN_MISSING_CLASS";
    }

    public String getDisplayName() {
        return Bundle.LBL_Class_Search_DisplayName();
    }

    public void cancel() {
        this.cancel.set(true);
    }

    static final class MavenFixImport
    implements EnhancedFix {
        private Project mavProj;
        private NBVersionInfo nbvi;
        private boolean test;

        public MavenFixImport(Project mavProj, NBVersionInfo nbvi, boolean test) {
            this.mavProj = mavProj;
            this.nbvi = nbvi;
            this.test = test;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public String getText() {
            return Bundle.LBL_Class_Search_Fix(this.nbvi.getGroupId() + " : " + this.nbvi.getArtifactId() + " : " + this.nbvi.getVersion());
        }

        public ChangeInfo implement() throws Exception {
            ModelUtils.addDependency((FileObject)this.mavProj.getProjectDirectory().getFileObject("pom.xml"), (String)this.nbvi.getGroupId(), (String)this.nbvi.getArtifactId(), (String)this.nbvi.getVersion(), (String)this.nbvi.getType(), (String)(this.test ? "test" : null), null, (boolean)true);
            RequestProcessor.getDefault().post(new Runnable(){

                @Override
                public void run() {
                    ((NbMavenProject)MavenFixImport.this.mavProj.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
                }
            });
            return null;
        }
    }

    static final class MavenSearchFix
    implements EnhancedFix {
        private Project mavProj;
        private String clazz;
        private boolean test;

        public MavenSearchFix(Project mavProj, String clazz, boolean test) {
            this.mavProj = mavProj;
            this.clazz = clazz;
            this.test = test;
        }

        public CharSequence getSortText() {
            return this.getText();
        }

        public String getText() {
            return Bundle.LBL_Class_Search_ALL_Fix(this.clazz);
        }

        public ChangeInfo implement() throws Exception {
            NBVersionInfo nbvi = null;
            SearchDependencyUI dependencyUI = new SearchDependencyUI(this.clazz, this.mavProj);
            DialogDescriptor dd = new DialogDescriptor((Object)dependencyUI, Bundle.LBL_Search_Repo());
            dd.setClosingOptions(new Object[]{dependencyUI.getAddButton(), DialogDescriptor.CANCEL_OPTION});
            dd.setOptions(new Object[]{dependencyUI.getAddButton(), DialogDescriptor.CANCEL_OPTION});
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            if (dependencyUI.getAddButton() == ret) {
                nbvi = dependencyUI.getSelectedVersion();
            }
            if (nbvi != null) {
                ModelUtils.addDependency((FileObject)this.mavProj.getProjectDirectory().getFileObject("pom.xml"), (String)nbvi.getGroupId(), (String)nbvi.getArtifactId(), (String)nbvi.getVersion(), (String)nbvi.getType(), (String)(this.test ? "test" : null), null, (boolean)true);
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ((NbMavenProject)MavenSearchFix.this.mavProj.getLookup().lookup(NbMavenProject.class)).triggerDependencyDownload();
                    }
                });
            }
            return null;
        }
    }
}

