/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.selector.ui;

import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.selector.ui.Bundle;
import org.openide.util.NbPreferences;
import org.openide.util.Utilities;

public abstract class SearchPanel
extends JPanel {
    private static final String SEARCHPANEL_PERMANENT = "searchPanel.shownDefault";
    private static final String SEARCH_NEXT_NAME = "search.next";
    private static final String SEARCH_PREV_NAME = "search.prev";
    private final JTextField searchField = new JTextField("");
    private final int findKeyEvent = 114;
    private final int closeKeyEvent = 27;
    private boolean permanent;
    private Action nextAction = new AbstractAction("", Icons.getIcon((String)"GeneralIcons.FindNext")){
        {
            KeyStroke ks = KeyStroke.getKeyStroke(114, 0);
            this.putValue("AcceleratorKey", ks);
            this.putValue("ShortDescription", Bundle.DSC_FindNext(SearchPanel.this.getAcceleratorDesc(ks)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.performNext();
        }
    };
    private Action prevAction = new AbstractAction("", Icons.getIcon((String)"GeneralIcons.FindPrevious")){
        {
            KeyStroke ks = KeyStroke.getKeyStroke(114, 64);
            this.putValue("AcceleratorKey", ks);
            this.putValue("ShortDescription", Bundle.DSC_FindPrevious(SearchPanel.this.getAcceleratorDesc(ks)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.performPrevious();
        }
    };
    private Action closeAction = new AbstractAction("", Icons.getIcon((String)"GeneralIcons.Stop")){
        {
            KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
            this.putValue("AcceleratorKey", ks);
            this.putValue("ShortDescription", Bundle.DSC_Close(SearchPanel.this.getAcceleratorDesc(ks)));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SearchPanel.this.setVisible(false);
            SearchPanel.this.onClose();
        }
    };
    private JButton prev = new JButton(this.prevAction);
    private JButton next = new JButton(this.nextAction);
    private JButton close = new JButton(this.closeAction);

    SearchPanel(@NonNull JComponent buddy) {
        this.permanent = NbPreferences.forModule(SearchPanel.class).getBoolean(SEARCHPANEL_PERMANENT, true);
        this.setLayout(new BoxLayout(this, 2));
        this.add(new JLabel(Bundle.LBL_Find()));
        this.add(this.searchField);
        this.searchField.setOpaque(false);
        this.prev.setBorderPainted(false);
        this.next.setBorderPainted(false);
        this.close.setBorderPainted(false);
        this.add(this.prev);
        this.add(this.next);
        this.add(this.close);
        buddy.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() || e.isAltGraphDown() || e.isControlDown() || e.isMetaDown() || e.isActionKey()) {
                    return;
                }
                if (!Character.isUnicodeIdentifierStart(e.getKeyChar())) {
                    return;
                }
                if (e.getKeyCode() != 10 && e.getKeyCode() != 32 && e.getKeyCode() != 27) {
                    if (!SearchPanel.this.isVisible()) {
                        SearchPanel.this.open();
                    } else {
                        SearchPanel.this.searchField.requestFocus();
                    }
                    SearchPanel.this.setSearchText(String.valueOf(e.getKeyChar()));
                    e.consume();
                } else if (SearchPanel.this.isVisible() && e.getKeyCode() == 27) {
                    SearchPanel.this.onCancel();
                    SearchPanel.this.setVisible(false);
                    e.consume();
                }
            }
        });
        buddy.getInputMap().put((KeyStroke)this.nextAction.getValue("AcceleratorKey"), SEARCH_NEXT_NAME);
        buddy.getInputMap().put((KeyStroke)this.prevAction.getValue("AcceleratorKey"), SEARCH_PREV_NAME);
        buddy.getActionMap().put(SEARCH_NEXT_NAME, this.nextAction);
        buddy.getActionMap().put(SEARCH_PREV_NAME, this.prevAction);
        this.searchField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int code;
                if (SearchPanel.this.isVisible() && ((code = e.getKeyCode()) == 10 || code == 27)) {
                    e.consume();
                    if (code == 10) {
                        SearchPanel.this.performFind();
                    } else {
                        SearchPanel.this.onCancel();
                    }
                    if (!SearchPanel.this.permanent || code == 27) {
                        SearchPanel.this.setVisible(false);
                        SearchPanel.this.onClose();
                    }
                }
            }
        });
        this.setVisible(this.permanent);
    }

    void reset() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SearchPanel.this.searchField.setText("");
                SearchPanel.this.setVisible(SearchPanel.this.permanent);
            }
        });
    }

    void open() {
        this.setVisible(true);
        this.searchField.requestFocus();
        this.onOpen();
    }

    void setSearchText(String text) {
        this.searchField.setText(text);
    }

    String getSearchText() {
        return this.searchField.getText();
    }

    void setPermanent(boolean permanent) {
        this.permanent = permanent;
        NbPreferences.forModule(SearchPanel.class).putBoolean(SEARCHPANEL_PERMANENT, permanent);
    }

    KeyStroke getNextShortcut() {
        return (KeyStroke)this.nextAction.getValue("AcceleratorKey");
    }

    KeyStroke getPrevShortcut() {
        return (KeyStroke)this.prevAction.getValue("AcceleratorKey");
    }

    protected abstract void performFind();

    protected abstract void performNext();

    protected abstract void performPrevious();

    protected void onCancel() {
    }

    protected void onClose() {
    }

    protected void onOpen() {
    }

    private String getAcceleratorDesc(KeyStroke ks) {
        String emacs = Utilities.keyToString((KeyStroke)ks);
        StringTokenizer st = new StringTokenizer(emacs, "-");
        if (st.countTokens() == 1) {
            return st.nextToken();
        }
        String mods = st.nextToken();
        String key = st.nextToken();
        StringBuilder sb = new StringBuilder();
        block6: for (char c : mods.toCharArray()) {
            switch (c) {
                case 'S': {
                    sb.append("Shift+");
                    continue block6;
                }
                case 'A': 
                case 'O': {
                    sb.append("Alt+");
                    continue block6;
                }
                case 'C': 
                case 'D': {
                    sb.append("Ctrl+");
                    continue block6;
                }
                case 'M': {
                    sb.append("Meta+");
                }
            }
        }
        sb.append(key);
        return sb.toString();
    }
}

