/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.ui;

import java.awt.Color;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.CharConversionException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ui.LogicalViewProvider2;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public class J2SELogicalViewProvider
implements LogicalViewProvider2 {
    private static final RequestProcessor RP = new RequestProcessor(J2SELogicalViewProvider.class);
    private final J2SEProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final PropertyChangeListener pcl;
    private Map<URL, Object[]> activeLibManLocs;
    private volatile boolean listenersInited;
    private final RequestProcessor.Task task = RP.create(new Runnable(){

        @Override
        public void run() {
            boolean _compileOnSaveDisabled;
            boolean _illegalState;
            boolean _broken;
            boolean old = J2SELogicalViewProvider.this.broken;
            if (old != (_broken = J2SELogicalViewProvider.this.hasBrokenLinks())) {
                J2SELogicalViewProvider.this.setBroken(_broken);
            }
            if ((old = J2SELogicalViewProvider.this.illegalState) != (_illegalState = J2SELogicalViewProvider.this.hasInvalidJdkVersion())) {
                J2SELogicalViewProvider.this.setIllegalState(_illegalState);
            }
            if ((old = J2SELogicalViewProvider.this.compileOnSaveDisabled) != (_compileOnSaveDisabled = J2SELogicalViewProvider.this.isCompileOnSaveDisabled())) {
                J2SELogicalViewProvider.this.setCompileOnSaveDisabled(_compileOnSaveDisabled);
            }
        }
    });
    private static final String[] BREAKABLE_PROPERTIES = new String[]{"javac.classpath", "run.classpath", "debug.classpath", "run.test.classpath", "debug.test.classpath", "endorsed.classpath", "javac.test.classpath"};
    private static Image brokenProjectBadge = ImageUtilities.loadImage((String)"org/netbeans/modules/java/j2seproject/ui/resources/brokenProjectBadge.gif", (boolean)true);
    private static final String COMPILE_ON_SAVE_DISABLED_BADGE_PATH = "org/netbeans/modules/java/j2seproject/ui/resources/compileOnSaveDisabledBadge.gif";
    private static final Image compileOnSaveDisabledBadge;
    private boolean broken;
    private boolean illegalState;
    private boolean compileOnSaveDisabled;

    public J2SELogicalViewProvider(J2SEProject project, UpdateHelper helper, PropertyEvaluator evaluator, ReferenceHelper resolver) {
        this.project = project;
        assert (project != null);
        this.helper = helper;
        assert (helper != null);
        this.evaluator = evaluator;
        assert (evaluator != null);
        this.resolver = resolver;
        assert (resolver != null);
        this.pcl = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("openManagers".equals(evt.getPropertyName())) {
                    J2SELogicalViewProvider.this.addLibraryManagerListener();
                }
                J2SELogicalViewProvider.this.testBroken();
            }
        };
    }

    private void initListeners() {
        if (this.listenersInited) {
            return;
        }
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Class<J2SELogicalViewProvider> clazz = J2SELogicalViewProvider.class;
                synchronized (J2SELogicalViewProvider.class) {
                    if (!J2SELogicalViewProvider.this.listenersInited) {
                        J2SELogicalViewProvider.this.evaluator.addPropertyChangeListener(J2SELogicalViewProvider.this.pcl);
                        JavaPlatformManager.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)J2SELogicalViewProvider.this.pcl, (Object)JavaPlatformManager.getDefault()));
                        LibraryManager.addOpenManagersPropertyChangeListener((PropertyChangeListener)new OpenManagersWeakListener(J2SELogicalViewProvider.this.pcl));
                        J2SELogicalViewProvider.this.addLibraryManagerListener();
                        J2SELogicalViewProvider.this.listenersInited = true;
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLibraryManagerListener() {
        HashMap<URL, Object[]> oldLMs;
        boolean attachToDefault;
        J2SELogicalViewProvider j2SELogicalViewProvider = this;
        synchronized (j2SELogicalViewProvider) {
            boolean bl = attachToDefault = this.activeLibManLocs == null;
            if (attachToDefault) {
                this.activeLibManLocs = new HashMap<URL, Object[]>();
            }
            oldLMs = new HashMap<URL, Object[]>(this.activeLibManLocs);
        }
        if (attachToDefault) {
            LibraryManager manager = LibraryManager.getDefault();
            manager.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)manager));
        }
        Collection managers = LibraryManager.getOpenManagers();
        HashMap<URL, LibraryManager> managerByLocation = new HashMap<URL, LibraryManager>();
        for (LibraryManager manager : managers) {
            URL url = manager.getLocation();
            if (url == null) continue;
            managerByLocation.put(url, manager);
        }
        HashMap<URL, Object[]> toRemove = new HashMap<URL, Object[]>(oldLMs);
        toRemove.keySet().removeAll(managerByLocation.keySet());
        for (Object[] pair : toRemove.values()) {
            ((LibraryManager)pair[0]).removePropertyChangeListener((PropertyChangeListener)pair[1]);
        }
        managerByLocation.keySet().removeAll(oldLMs.keySet());
        HashMap toAdd = new HashMap();
        for (Map.Entry e : managerByLocation.entrySet()) {
            LibraryManager manager = (LibraryManager)e.getValue();
            PropertyChangeListener listener = WeakListeners.propertyChange((PropertyChangeListener)this.pcl, (Object)manager);
            manager.addPropertyChangeListener(listener);
            toAdd.put(e.getKey(), new Object[]{manager, listener});
        }
        J2SELogicalViewProvider j2SELogicalViewProvider2 = this;
        synchronized (j2SELogicalViewProvider2) {
            this.activeLibManLocs.keySet().removeAll(toRemove.keySet());
            this.activeLibManLocs.putAll(toAdd);
        }
    }

    public Node createLogicalView() {
        this.initListeners();
        return new J2SELogicalViewRootNode();
    }

    public PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    public Node findPath(Node root, Object target) {
        Project prj = (Project)root.getLookup().lookup(Project.class);
        if (prj == null) {
            return null;
        }
        if (target instanceof FileObject) {
            FileObject fo = (FileObject)target;
            Project owner = FileOwnerQuery.getOwner((FileObject)fo);
            if (!prj.equals(owner)) {
                return null;
            }
            for (Node n : root.getChildren().getNodes(true)) {
                Node result = PackageView.findPath((Node)n, (Object)target);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public void testBroken() {
        this.task.schedule(500);
    }

    public boolean hasBrokenLinks() {
        return BrokenReferencesSupport.isBroken((AntProjectHelper)this.helper.getAntProjectHelper(), (ReferenceHelper)this.resolver, (String[])this.getBreakableProperties(), (String[])new String[]{"platform.active"});
    }

    private boolean hasInvalidJdkVersion() {
        String javaSource = this.evaluator.getProperty("javac.source");
        String javaTarget = this.evaluator.getProperty("javac.target");
        if (javaSource == null && javaTarget == null) {
            return false;
        }
        String platformId = this.evaluator.getProperty("platform.active");
        JavaPlatform activePlatform = CommonProjectUtils.getActivePlatform((String)platformId);
        if (activePlatform == null) {
            return true;
        }
        SpecificationVersion platformVersion = activePlatform.getSpecification().getVersion();
        try {
            return javaSource != null && new SpecificationVersion(javaSource).compareTo((Object)platformVersion) > 0 || javaTarget != null && new SpecificationVersion(javaTarget).compareTo((Object)platformVersion) > 0;
        }
        catch (NumberFormatException nfe) {
            ErrorManager.getDefault().log("Invalid javac.source: " + javaSource + " or javac.target: " + javaTarget + " of project:" + this.project.getProjectDirectory().getPath());
            return true;
        }
    }

    private boolean isCompileOnSaveDisabled() {
        return !J2SEProjectUtil.isCompileOnSaveEnabled(this.project) && J2SEProjectUtil.isCompileOnSaveSupported(this.project);
    }

    public String[] getBreakableProperties() {
        SourceRoots roots = this.project.getSourceRoots();
        String[] srcRootProps = roots.getRootProperties();
        roots = this.project.getTestSourceRoots();
        String[] testRootProps = roots.getRootProperties();
        String[] result = new String[BREAKABLE_PROPERTIES.length + srcRootProps.length + testRootProps.length];
        System.arraycopy(BREAKABLE_PROPERTIES, 0, result, 0, BREAKABLE_PROPERTIES.length);
        System.arraycopy(srcRootProps, 0, result, BREAKABLE_PROPERTIES.length, srcRootProps.length);
        System.arraycopy(testRootProps, 0, result, BREAKABLE_PROPERTIES.length + srcRootProps.length, testRootProps.length);
        return result;
    }

    public String[] getPlatformProperties() {
        return new String[]{"platform.active"};
    }

    private void setBroken(boolean broken) {
        this.broken = broken;
        this.changeSupport.fireChange();
    }

    private void setIllegalState(boolean illegalState) {
        this.illegalState = illegalState;
        this.changeSupport.fireChange();
    }

    private void setCompileOnSaveDisabled(boolean value) {
        this.compileOnSaveDisabled = value;
        this.changeSupport.fireChange();
    }

    @NonNull
    private static Color getErrorForeground() {
        Color result = UIManager.getDefaults().getColor("nb.errorForeground");
        if (result == null) {
            result = Color.RED;
        }
        return result;
    }

    static {
        URL errorBadgeIconURL = J2SELogicalViewProvider.class.getClassLoader().getResource(COMPILE_ON_SAVE_DISABLED_BADGE_PATH);
        String compileOnSaveDisabledTP = "<img src=\"" + errorBadgeIconURL + "\">&nbsp;" + NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"TP_CompileOnSaveDisabled");
        compileOnSaveDisabledBadge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)COMPILE_ON_SAVE_DISABLED_BADGE_PATH), (String)compileOnSaveDisabledTP);
    }

    private class BrokenLinksAction
    extends AbstractAction {
        public BrokenLinksAction() {
            this.putValue("Name", NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            this.setEnabled(J2SELogicalViewProvider.this.broken);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                J2SELogicalViewProvider.this.helper.requestUpdate();
                BrokenReferencesSupport.showCustomizer((AntProjectHelper)J2SELogicalViewProvider.this.helper.getAntProjectHelper(), (ReferenceHelper)J2SELogicalViewProvider.this.resolver, (String[])J2SELogicalViewProvider.this.getBreakableProperties(), (String[])J2SELogicalViewProvider.this.getPlatformProperties());
                J2SELogicalViewProvider.this.testBroken();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify((Throwable)ioe);
            }
        }
    }

    public static final class BrokenLinksActionFactory
    extends AbstractAction
    implements ContextAwareAction {
        public BrokenLinksActionFactory() {
            this.putValue("Name", NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"LBL_Fix_Broken_Links_Action"));
            this.setEnabled(false);
            this.putValue("hideWhenDisabled", true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            Collection p = actionContext.lookupAll(Project.class);
            if (p.size() != 1) {
                return this;
            }
            J2SELogicalViewProvider lvp = (J2SELogicalViewProvider)((Project)p.iterator().next()).getLookup().lookup(J2SELogicalViewProvider.class);
            if (lvp == null) {
                return this;
            }
            return lvp.new BrokenLinksAction();
        }
    }

    private final class J2SELogicalViewRootNode
    extends AbstractNode
    implements ChangeListener,
    PropertyChangeListener {
        private final ProjectInformation info;

        public J2SELogicalViewRootNode() {
            super(NodeFactorySupport.createCompositeChildren((Project)J2SELogicalViewProvider.this.project, (String)"Projects/org-netbeans-modules-java-j2seproject/Nodes"), Lookups.singleton((Object)J2SELogicalViewProvider.this.project));
            this.info = ProjectUtils.getInformation((Project)J2SELogicalViewProvider.this.project);
            this.setIconBaseWithExtension("org/netbeans/modules/java/j2seproject/ui/resources/j2seProject.png");
            if (J2SELogicalViewProvider.this.hasBrokenLinks()) {
                J2SELogicalViewProvider.this.broken = true;
            } else if (J2SELogicalViewProvider.this.hasInvalidJdkVersion()) {
                J2SELogicalViewProvider.this.illegalState = true;
            }
            J2SELogicalViewProvider.this.compileOnSaveDisabled = J2SELogicalViewProvider.this.isCompileOnSaveDisabled();
            J2SELogicalViewProvider.this.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)J2SELogicalViewProvider.this));
            this.info.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.info));
        }

        public String getShortDescription() {
            String prjDirDispName = FileUtil.getFileDisplayName((FileObject)J2SELogicalViewProvider.this.project.getProjectDirectory());
            return NbBundle.getMessage(J2SELogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }

        public String getHtmlDisplayName() {
            String dispName = super.getDisplayName();
            try {
                dispName = XMLUtil.toElementContent((String)dispName);
            }
            catch (CharConversionException ex) {
                return dispName;
            }
            return J2SELogicalViewProvider.this.broken || J2SELogicalViewProvider.this.illegalState ? "<font color=\"#" + Integer.toHexString(J2SELogicalViewProvider.getErrorForeground().getRGB() & 0xFFFFFF) + "\">" + dispName + "</font>" : null;
        }

        public Image getIcon(int type) {
            Image original = super.getIcon(type);
            if (J2SELogicalViewProvider.this.broken || J2SELogicalViewProvider.this.illegalState) {
                return ImageUtilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            return J2SELogicalViewProvider.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)original, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : original;
        }

        public Image getOpenedIcon(int type) {
            Image original = super.getOpenedIcon(type);
            if (J2SELogicalViewProvider.this.broken || J2SELogicalViewProvider.this.illegalState) {
                return ImageUtilities.mergeImages((Image)original, (Image)brokenProjectBadge, (int)8, (int)0);
            }
            return J2SELogicalViewProvider.this.compileOnSaveDisabled ? ImageUtilities.mergeImages((Image)original, (Image)compileOnSaveDisabledBadge, (int)8, (int)0) : original;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.fireIconChange();
            this.fireOpenedIconChange();
            this.fireDisplayNameChange(null, null);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    J2SELogicalViewRootNode.this.fireNameChange(null, null);
                    J2SELogicalViewRootNode.this.fireDisplayNameChange(null, null);
                }
            });
        }

        public Action[] getActions(boolean context) {
            return CommonProjectActions.forType((String)"org-netbeans-modules-java-j2seproject");
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return this.info.getDisplayName();
        }

        public void setName(String s) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)J2SELogicalViewProvider.this.project, (String)s);
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(J2SELogicalViewRootNode.class);
        }
    }

    private static class OpenManagersWeakListener
    extends WeakReference<PropertyChangeListener>
    implements Runnable,
    PropertyChangeListener {
        public OpenManagersWeakListener(PropertyChangeListener listener) {
            super(listener, Utilities.activeReferenceQueue());
        }

        @Override
        public void run() {
            LibraryManager.removeOpenManagersPropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            PropertyChangeListener listener = (PropertyChangeListener)this.get();
            if (listener != null) {
                listener.propertyChange(evt);
            }
        }
    }
}

