/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.api;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectGenerator;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class J2SEProjectBuilder {
    private static final String PLATFORM_ANT_NAME = "platform.ant.name";
    private static final String DEFAULT_PLATFORM_ID = "default_platform";
    private final File projectDirectory;
    private final String name;
    private final Collection<File> sourceRoots;
    private final Collection<File> testRoots;
    private final Collection<Library> compileLibraries;
    private final Collection<Library> runtimeLibraries;
    private final StringBuilder jvmArgs;
    private boolean hasDefaultRoots;
    private boolean skipTests;
    private SpecificationVersion defaultSourceLevel;
    private String mainClass;
    private String manifest;
    private String librariesDefinition;
    private String buildXmlName;
    private String distFolder;
    private String mainClassTemplate;
    private JavaPlatform platform;
    private static final String loggerName = "org.netbeans.ui.metrics.j2se";
    private static final String loggerKey = "USG_PROJECT_CREATE_J2SE";

    public J2SEProjectBuilder(@NonNull File projectDirectory, @NonNull String name) {
        Parameters.notNull((CharSequence)"projectDirectory", (Object)projectDirectory);
        Parameters.notNull((CharSequence)"name", (Object)name);
        this.projectDirectory = projectDirectory;
        this.name = name;
        this.sourceRoots = new ArrayList<File>();
        this.testRoots = new ArrayList<File>();
        this.jvmArgs = new StringBuilder();
        this.compileLibraries = new ArrayList<Library>();
        this.runtimeLibraries = new ArrayList<Library>();
        this.platform = JavaPlatformManager.getDefault().getDefaultPlatform();
    }

    public J2SEProjectBuilder addDefaultSourceRoots() {
        this.hasDefaultRoots = true;
        return this;
    }

    public J2SEProjectBuilder skipTests(boolean skipTests) {
        this.skipTests = skipTests;
        return this;
    }

    public J2SEProjectBuilder addSourceRoots(File ... sourceRoots) {
        Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
        this.sourceRoots.addAll(Arrays.asList(sourceRoots));
        return this;
    }

    public J2SEProjectBuilder addTestRoots(File ... testRoots) {
        Parameters.notNull((CharSequence)"testRoots", (Object)testRoots);
        this.testRoots.addAll(Arrays.asList(testRoots));
        return this;
    }

    public J2SEProjectBuilder addCompileLibraries(Library ... libraries) {
        Parameters.notNull((CharSequence)"libraries", (Object)libraries);
        this.compileLibraries.addAll(Arrays.asList(libraries));
        return this;
    }

    public J2SEProjectBuilder addRuntimeLibraries(Library ... libraries) {
        Parameters.notNull((CharSequence)"libraries", (Object)libraries);
        this.runtimeLibraries.addAll(Arrays.asList(libraries));
        return this;
    }

    public J2SEProjectBuilder setMainClass(@NullAllowed String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public J2SEProjectBuilder setManifest(@NullAllowed String manifest) {
        this.manifest = manifest;
        return this;
    }

    public J2SEProjectBuilder setLibrariesDefinitionFile(@NullAllowed String librariesDefinition) {
        this.librariesDefinition = librariesDefinition;
        return this;
    }

    public J2SEProjectBuilder setSourceLevel(@NullAllowed SpecificationVersion sourceLevel) {
        this.defaultSourceLevel = sourceLevel;
        return this;
    }

    public J2SEProjectBuilder setBuildXmlName(@NullAllowed String name) {
        this.buildXmlName = name;
        return this;
    }

    @NonNull
    public J2SEProjectBuilder setDistFolder(@NullAllowed String distFolderName) {
        this.distFolder = distFolderName;
        return this;
    }

    public J2SEProjectBuilder setMainClassTemplate(@NullAllowed String mainClassTemplatePath) {
        this.mainClassTemplate = mainClassTemplatePath;
        return this;
    }

    public J2SEProjectBuilder addJVMArguments(@NonNull String jvmArgs) {
        Parameters.notNull((CharSequence)"jvmArgs", (Object)jvmArgs);
        if (this.jvmArgs.length() != 0) {
            this.jvmArgs.append(' ');
        }
        this.jvmArgs.append(jvmArgs);
        return this;
    }

    public J2SEProjectBuilder setJavaPlatform(@NonNull JavaPlatform platform) {
        Parameters.notNull((CharSequence)"platform", (Object)platform);
        if (platform.getProperties().get(PLATFORM_ANT_NAME) == null) {
            throw new IllegalArgumentException("Invalid platform, the platform has no platform.ant.name");
        }
        this.platform = platform;
        return this;
    }

    public AntProjectHelper build() throws IOException {
        final FileObject dirFO = FileUtil.createFolder((File)this.projectDirectory);
        final AntProjectHelper[] h = new AntProjectHelper[1];
        dirFO.getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                SpecificationVersion sourceLevel = J2SEProjectBuilder.this.getSourceLevel();
                h[0] = J2SEProjectBuilder.createProject(dirFO, J2SEProjectBuilder.this.name, sourceLevel, J2SEProjectBuilder.this.hasDefaultRoots ? "src" : null, J2SEProjectBuilder.this.hasDefaultRoots ? "test" : null, J2SEProjectBuilder.this.skipTests, J2SEProjectBuilder.this.buildXmlName, J2SEProjectBuilder.this.distFolder, J2SEProjectBuilder.this.mainClass, J2SEProjectBuilder.this.manifest, J2SEProjectBuilder.this.manifest == null, J2SEProjectBuilder.this.librariesDefinition, J2SEProjectBuilder.this.jvmArgs.toString(), J2SEProjectBuilder.this.toClassPathElements(J2SEProjectBuilder.this.compileLibraries, new String[0]), J2SEProjectBuilder.this.toClassPathElements(J2SEProjectBuilder.this.runtimeLibraries, new String[]{"${javac.classpath}:", "${build.classes.dir}"}), (String)J2SEProjectBuilder.this.platform.getProperties().get(J2SEProjectBuilder.PLATFORM_ANT_NAME));
                final J2SEProject p = (J2SEProject)ProjectManager.getDefault().findProject(dirFO);
                ProjectManager.getDefault().saveProject((Project)p);
                final ReferenceHelper refHelper = p.getReferenceHelper();
                try {
                    ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                        public Void run() throws Exception {
                            J2SEProjectBuilder.registerRoots(h[0], refHelper, J2SEProjectBuilder.this.sourceRoots, false);
                            J2SEProjectBuilder.registerRoots(h[0], refHelper, J2SEProjectBuilder.this.testRoots, true);
                            ProjectManager.getDefault().saveProject((Project)p);
                            ArrayList libsToCopy = new ArrayList();
                            libsToCopy.addAll(J2SEProjectBuilder.getMandatoryLibraries(J2SEProjectBuilder.this.skipTests));
                            libsToCopy.addAll(J2SEProjectBuilder.this.compileLibraries);
                            libsToCopy.addAll(J2SEProjectBuilder.this.runtimeLibraries);
                            J2SEProjectBuilder.copyRequiredLibraries(h[0], refHelper, libsToCopy);
                            ProjectUtils.getSources((Project)p).getSourceGroups("java");
                            return null;
                        }
                    });
                }
                catch (MutexException ex) {
                    Exceptions.printStackTrace((Throwable)ex.getException());
                }
                FileObject srcFolder = null;
                if (J2SEProjectBuilder.this.hasDefaultRoots) {
                    srcFolder = dirFO.createFolder("src");
                    if (!J2SEProjectBuilder.this.skipTests) {
                        dirFO.createFolder("test");
                    }
                } else if (!J2SEProjectBuilder.this.sourceRoots.isEmpty()) {
                    srcFolder = FileUtil.toFileObject((File)((File)J2SEProjectBuilder.this.sourceRoots.iterator().next()));
                }
                if (J2SEProjectBuilder.this.mainClass != null && srcFolder != null) {
                    J2SEProjectBuilder.createMainClass(J2SEProjectBuilder.this.mainClass, srcFolder, J2SEProjectBuilder.this.mainClassTemplate);
                }
            }
        });
        return h[0];
    }

    private static AntProjectHelper createProject(FileObject dirFO, String name, SpecificationVersion sourceLevel, String srcRoot, String testRoot, boolean skipTests, String buildXmlName, String distFolder, String mainClass, String manifestFile, boolean isLibrary, String librariesDefinition, String jvmArgs, String[] compileClassPath, String[] runtimeClassPath, @NonNull String platformId) throws IOException {
        String[] stringArray;
        AntProjectHelper h = ProjectGenerator.createProject((FileObject)dirFO, (String)"org.netbeans.modules.java.j2seproject", (String)librariesDefinition);
        Element data = h.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        Element nameEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "name");
        nameEl.appendChild(doc.createTextNode(name));
        data.appendChild(nameEl);
        EditableProperties ep = h.getProperties("nbproject/project.properties");
        if (!DEFAULT_PLATFORM_ID.equals(platformId)) {
            Element platformEl = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "explicit-platform");
            SpecificationVersion jdk13 = new SpecificationVersion("1.3");
            boolean supportsExplicitSource = jdk13.compareTo((Object)sourceLevel) < 0;
            platformEl.setAttribute("explicit-source-supported", Boolean.toString(supportsExplicitSource));
            data.appendChild(platformEl);
        }
        Element sourceRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "source-roots");
        if (srcRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "src.dir");
            sourceRoots.appendChild(root);
            ep.setProperty("src.dir", srcRoot);
        }
        data.appendChild(sourceRoots);
        Element testRoots = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "test-roots");
        if (testRoot != null) {
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", "test.src.dir");
            testRoots.appendChild(root);
            ep.setProperty("test.src.dir", testRoot);
        }
        data.appendChild(testRoots);
        h.putPrimaryConfigurationData(data, true);
        ep.setProperty("annotation.processing.enabled", "true");
        ep.setProperty("annotation.processing.enabled.in.editor", "false");
        ep.setProperty("annotation.processing.run.all.processors", "true");
        ep.setProperty("annotation.processing.processors.list", "");
        ep.setProperty("annotation.processing.source.output", "${build.generated.sources.dir}/ap-source-output");
        ep.setProperty("annotation.processing.processor.options", "");
        ep.setProperty("dist.dir", distFolder != null ? distFolder : "dist");
        ep.setComment("dist.dir", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_dist.dir")}, false);
        ep.setProperty("dist.jar", "${dist.dir}/" + PropertyUtils.getUsablePropertyName((String)name) + ".jar");
        ep.setProperty("javac.classpath", compileClassPath);
        ep.setProperty("javac.processorpath", new String[]{"${javac.classpath}"});
        ep.setProperty("javac.test.processorpath", new String[]{"${javac.test.classpath}"});
        ep.setProperty("build.sysclasspath", "ignore");
        ep.setComment("build.sysclasspath", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_build.sysclasspath")}, false);
        ep.setProperty("run.classpath", runtimeClassPath);
        ep.setProperty("debug.classpath", new String[]{"${run.classpath}"});
        ep.setComment("debug.classpath", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_debug.transport"), "#debug.transport=dt_socket"}, false);
        ep.setProperty("jar.compress", "false");
        if (mainClass != null) {
            ep.setProperty("main.class", mainClass);
        } else if (!isLibrary) {
            ep.setProperty("main.class", "");
        }
        ep.setProperty("javac.compilerargs", "");
        ep.setComment("javac.compilerargs", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_javac.compilerargs")}, false);
        ep.setProperty("javac.source", sourceLevel.toString());
        ep.setProperty("javac.target", sourceLevel.toString());
        ep.setProperty("javac.deprecation", "false");
        if (skipTests) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "${javac.classpath}:";
            stringArray = stringArray2;
            stringArray2[1] = "${build.classes.dir}";
        } else {
            String[] stringArray3 = new String[4];
            stringArray3[0] = "${javac.classpath}:";
            stringArray3[1] = "${build.classes.dir}:";
            stringArray3[2] = "${libs.junit.classpath}:";
            stringArray = stringArray3;
            stringArray3[3] = "${libs.junit_4.classpath}";
        }
        ep.setProperty("javac.test.classpath", stringArray);
        ep.setProperty("run.test.classpath", new String[]{"${javac.test.classpath}:", "${build.test.classes.dir}"});
        ep.setProperty("debug.test.classpath", new String[]{"${run.test.classpath}"});
        ep.setProperty("build.generated.dir", "${build.dir}/generated");
        ep.setProperty("meta.inf.dir", "${src.dir}/META-INF");
        ep.setProperty("build.dir", "build");
        ep.setComment("build.dir", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_build.dir")}, false);
        ep.setProperty("build.classes.dir", "${build.dir}/classes");
        ep.setProperty("build.generated.sources.dir", "${build.dir}/generated-sources");
        ep.setProperty("build.test.classes.dir", "${build.dir}/test/classes");
        ep.setProperty("build.test.results.dir", "${build.dir}/test/results");
        ep.setProperty("build.classes.excludes", "**/*.java,**/*.form");
        ep.setProperty("dist.javadoc.dir", "${dist.dir}/javadoc");
        ep.setProperty("platform.active", platformId);
        ep.setProperty("run.jvmargs", jvmArgs);
        ep.setComment("run.jvmargs", new String[]{"# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs"), "# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs_2"), "# " + NbBundle.getMessage(J2SEProjectGenerator.class, (String)"COMMENT_run.jvmargs_3")}, false);
        ep.setProperty("javadoc.private", "false");
        ep.setProperty("javadoc.notree", "false");
        ep.setProperty("javadoc.use", "true");
        ep.setProperty("javadoc.nonavbar", "false");
        ep.setProperty("javadoc.noindex", "false");
        ep.setProperty("javadoc.splitindex", "true");
        ep.setProperty("javadoc.author", "false");
        ep.setProperty("javadoc.version", "false");
        ep.setProperty("javadoc.windowtitle", "");
        ep.setProperty("javadoc.encoding", "${source.encoding}");
        ep.setProperty("javadoc.additionalparam", "");
        Charset enc = FileEncodingQuery.getDefaultEncoding();
        ep.setProperty("source.encoding", enc.name());
        if (manifestFile != null) {
            ep.setProperty("manifest.file", manifestFile);
        }
        if (buildXmlName != null) {
            ep.put("buildfile", buildXmlName);
        }
        ep.setProperty("mkdist.disabled", isLibrary ? "true" : "false");
        h.putProperties("nbproject/project.properties", ep);
        ep = h.getProperties("nbproject/private/private.properties");
        ep.setProperty("compile.on.save", "true");
        h.putProperties("nbproject/private/private.properties", ep);
        J2SEProjectBuilder.logUsage();
        return h;
    }

    private static void registerRoots(AntProjectHelper helper, ReferenceHelper refHelper, Collection<? extends File> sourceFolders, boolean tests) {
        if (sourceFolders.isEmpty()) {
            return;
        }
        Element data = helper.getPrimaryConfigurationData(true);
        Document doc = data.getOwnerDocument();
        NodeList nl = data.getElementsByTagNameNS("http://www.netbeans.org/ns/j2se-project/3", tests ? "test-roots" : "source-roots");
        assert (nl.getLength() == 1);
        Element sourceRoots = (Element)nl.item(0);
        boolean first = true;
        for (File file : sourceFolders) {
            String name;
            if (first) {
                name = "src";
                first = false;
            } else {
                name = file.getName();
            }
            String propName = (tests ? "test." : "") + name + ".dir";
            int rootIndex = 1;
            EditableProperties props = helper.getProperties("nbproject/project.properties");
            while (props.containsKey((Object)propName)) {
                propName = (tests ? "test." : "") + name + ++rootIndex + ".dir";
            }
            String srcReference = refHelper.createForeignFileReference(file, "java");
            Element root = doc.createElementNS("http://www.netbeans.org/ns/j2se-project/3", "root");
            root.setAttribute("id", propName);
            sourceRoots.appendChild(root);
            props = helper.getProperties("nbproject/project.properties");
            props.put(propName, srcReference);
            helper.putProperties("nbproject/project.properties", props);
        }
        helper.putPrimaryConfigurationData(data, true);
    }

    private static void logUsage() {
        LogRecord logRecord = new LogRecord(Level.INFO, loggerKey);
        logRecord.setLoggerName(loggerName);
        Logger.getLogger(loggerName).log(logRecord);
    }

    private SpecificationVersion getSourceLevel() {
        if (this.defaultSourceLevel != null) {
            return this.defaultSourceLevel;
        }
        SpecificationVersion v = this.platform.getSpecification().getVersion();
        return v;
    }

    private String[] toClassPathElements(@NonNull Collection<? extends Library> libraries, String ... additionalEntries) {
        String[] result = new String[libraries.size() + additionalEntries.length];
        Iterator<? extends Library> it = libraries.iterator();
        int i = 0;
        while (it.hasNext()) {
            Library lib = it.next();
            result[i] = "${libs." + lib.getName() + ".classpath}" + (it.hasNext() || additionalEntries.length != 0 ? ":" : "");
            ++i;
        }
        System.arraycopy(additionalEntries, 0, result, libraries.size(), additionalEntries.length);
        return result;
    }

    private static void createMainClass(@NonNull String mainClassName, @NonNull FileObject srcFolder, @NullAllowed String mainClassTemplate) throws IOException {
        FileObject mainTemplate;
        String pName;
        String mName;
        int lastDotIdx = mainClassName.lastIndexOf(46);
        if (lastDotIdx == -1) {
            mName = mainClassName.trim();
            pName = null;
        } else {
            mName = mainClassName.substring(lastDotIdx + 1).trim();
            pName = mainClassName.substring(0, lastDotIdx).trim();
        }
        if (mName.length() == 0) {
            return;
        }
        if (mainClassTemplate == null) {
            mainClassTemplate = "Templates/Classes/Main.java";
        }
        if ((mainTemplate = FileUtil.getConfigFile((String)mainClassTemplate)) == null) {
            return;
        }
        DataObject mt = DataObject.find((FileObject)mainTemplate);
        FileObject pkgFolder = srcFolder;
        if (pName != null) {
            String fName = pName.replace('.', '/');
            pkgFolder = FileUtil.createFolder((FileObject)srcFolder, (String)fName);
        }
        DataFolder pDf = DataFolder.findFolder((FileObject)pkgFolder);
        mt.createFromTemplate(pDf, mName);
    }

    private static void copyRequiredLibraries(AntProjectHelper h, ReferenceHelper rh, Collection<? extends Library> libraries) throws IOException {
        if (!h.isSharableProject()) {
            return;
        }
        for (Library library : libraries) {
            String libName = library.getName();
            if (rh.getProjectLibraryManager().getLibrary(libName) != null || LibraryManager.getDefault().getLibrary(libName) == null) continue;
            rh.copyLibrary(LibraryManager.getDefault().getLibrary(libName));
        }
    }

    private static Collection<? extends Library> getMandatoryLibraries(boolean skipTests) {
        String[] stringArray;
        ArrayList<Library> result = new ArrayList<Library>();
        LibraryManager manager = LibraryManager.getDefault();
        if (skipTests) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "CopyLibs";
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = "junit";
            stringArray3[1] = "junit_4";
            stringArray = stringArray3;
            stringArray3[2] = "CopyLibs";
        }
        for (String mandatoryLib : stringArray) {
            Library lib = manager.getLibrary(mandatoryLib);
            if (lib == null) continue;
            result.add(lib);
        }
        return result;
    }
}

