/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.test.AbstractSingleSpringContextTests;
import org.springframework.test.AbstractSpringContextTests;
import org.springframework.util.Assert;

@Deprecated
public abstract class AbstractDependencyInjectionSpringContextTests
extends AbstractSingleSpringContextTests {
    public static final int AUTOWIRE_NO = 0;
    public static final int AUTOWIRE_BY_NAME = 1;
    public static final int AUTOWIRE_BY_TYPE = 2;
    private boolean populateProtectedVariables = false;
    private int autowireMode = 2;
    private boolean dependencyCheck = true;
    private String[] managedVariableNames;

    public AbstractDependencyInjectionSpringContextTests() {
    }

    public AbstractDependencyInjectionSpringContextTests(String name) {
        super(name);
    }

    public final void setPopulateProtectedVariables(boolean populateFields) {
        this.populateProtectedVariables = populateFields;
    }

    public final boolean isPopulateProtectedVariables() {
        return this.populateProtectedVariables;
    }

    public final void setAutowireMode(int autowireMode) {
        this.autowireMode = autowireMode;
    }

    public final int getAutowireMode() {
        return this.autowireMode;
    }

    public final void setDependencyCheck(boolean dependencyCheck) {
        this.dependencyCheck = dependencyCheck;
    }

    public final boolean isDependencyCheck() {
        return this.dependencyCheck;
    }

    protected void prepareTestInstance() throws Exception {
        if (this.getApplicationContext() == null) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("ApplicationContext has not been configured for test [" + ((Object)((Object)this)).getClass().getName() + "]: dependency injection will NOT be performed."));
            }
        } else {
            this.injectDependencies();
        }
    }

    protected void injectDependencies() throws Exception {
        Assert.state((this.getApplicationContext() != null ? 1 : 0) != 0, (String)"injectDependencies() called without first configuring an ApplicationContext");
        if (this.isPopulateProtectedVariables()) {
            if (this.managedVariableNames == null) {
                this.initManagedVariableNames();
            }
            this.populateProtectedVariables();
        }
        this.getApplicationContext().getBeanFactory().autowireBeanProperties((Object)this, this.getAutowireMode(), this.isDependencyCheck());
    }

    private void initManagedVariableNames() throws IllegalAccessException {
        LinkedList<String> managedVarNames = new LinkedList<String>();
        Class<?> clazz = ((Object)((Object)this)).getClass();
        do {
            Field[] fields = clazz.getDeclaredFields();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found " + fields.length + " fields on " + clazz));
            }
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                field.setAccessible(true);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Candidate field: " + field));
                }
                if (this.isProtectedInstanceField(field)) {
                    Object oldValue = field.get((Object)this);
                    if (oldValue == null) {
                        managedVarNames.add(field.getName());
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)("Added managed variable '" + field.getName() + "'"));
                        }
                    } else if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Rejected managed variable '" + field.getName() + "'"));
                    }
                }
                ++i;
            }
        } while (!(clazz = clazz.getSuperclass()).equals(AbstractDependencyInjectionSpringContextTests.class));
        this.managedVariableNames = managedVarNames.toArray(new String[managedVarNames.size()]);
    }

    private boolean isProtectedInstanceField(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && Modifier.isProtected(modifiers);
    }

    private void populateProtectedVariables() throws IllegalAccessException {
        int i = 0;
        while (i < this.managedVariableNames.length) {
            block6: {
                String varName = this.managedVariableNames[i];
                Object bean = null;
                try {
                    Field field = this.findField(((Object)((Object)this)).getClass(), varName);
                    bean = this.getApplicationContext().getBean(varName, field.getType());
                    field.setAccessible(true);
                    field.set((Object)this, bean);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Populated field: " + field));
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    if (this.logger.isWarnEnabled()) {
                        this.logger.warn((Object)("No field with name '" + varName + "'"));
                    }
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    if (!this.logger.isWarnEnabled()) break block6;
                    this.logger.warn((Object)("No bean with name '" + varName + "'"));
                }
            }
            ++i;
        }
    }

    private Field findField(Class clazz, String name) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException ex) {
            Class superclass = clazz.getSuperclass();
            if (superclass != AbstractSpringContextTests.class) {
                return this.findField(superclass, name);
            }
            throw ex;
        }
    }
}

