/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.ui.history;

import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Action;
import org.netbeans.modules.versioning.ui.history.HistoryEntry;
import org.netbeans.modules.versioning.ui.history.HistorySettings;
import org.netbeans.modules.versioning.ui.history.RevisionNode;
import org.netbeans.modules.versioning.ui.history.TableEntry;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class HistoryRootNode
extends AbstractNode {
    static final String NODE_LOAD_NEXT = "getmoreno";
    static final String NODE_WAIT = "waitnode";
    static final String NODE_ROOT = "rootnode";
    static final Action[] NO_ACTION = new Action[0];
    private static DateFormat dateFormat = DateFormat.getDateInstance();
    private Map<Long, HistoryEntry> revisionEntries = new HashMap<Long, HistoryEntry>();
    private LoadNextNode loadNextNode;
    private WaitNode waitNode;
    private final String vcsName;
    private int vcsCount = 0;
    private final Action loadNextAction;
    private final Action[] actions;

    HistoryRootNode(String vcsName, Action loadNextAction, Action ... actions) {
        super((Children)new Children.SortedArray());
        this.vcsName = vcsName;
        this.loadNextAction = loadNextAction;
        this.actions = actions;
    }

    static boolean isLoadNext(Object n) {
        return n instanceof LoadNextNode;
    }

    static boolean isWait(Object n) {
        return n instanceof WaitNode;
    }

    synchronized void addLHEntries(HistoryEntry[] entries) {
        this.addEntries(entries, false);
    }

    synchronized void addVCSEntries(HistoryEntry[] entries) {
        this.addEntries(entries, true);
    }

    synchronized HistoryEntry getPreviousEntry(HistoryEntry entry) {
        Enumeration en = this.getChildren().nodes();
        boolean hit = false;
        while (en.hasMoreElements()) {
            Node n = (Node)en.nextElement();
            HistoryEntry he = (HistoryEntry)n.getLookup().lookup(HistoryEntry.class);
            if (he == null || !entry.isLocalHistory() && he.isLocalHistory()) continue;
            if (hit) {
                return he;
            }
            if (he != entry) continue;
            hit = true;
        }
        return null;
    }

    private void addEntries(HistoryEntry[] entries, boolean vcs) {
        LinkedList<RevisionNode> nodes = new LinkedList<RevisionNode>();
        for (HistoryEntry e : entries) {
            if (this.revisionEntries.containsKey(e.getDateTime().getTime())) continue;
            this.revisionEntries.put(e.getDateTime().getTime(), e);
            if (vcs) {
                ++this.vcsCount;
            }
            nodes.add(RevisionNode.create(e));
        }
        if (this.loadNextNode != null) {
            this.loadNextNode.refreshMessage();
        }
        this.getChildren().add(nodes.toArray(new Node[nodes.size()]));
    }

    public synchronized void addWaitNode() {
        if (this.waitNode != null) {
            this.getChildren().remove(new Node[]{this.waitNode});
        }
        this.waitNode = new WaitNode();
        this.getChildren().add(new Node[]{this.waitNode});
    }

    public synchronized void removeWaitNode() {
        if (this.waitNode != null) {
            this.getChildren().remove(new Node[]{this.waitNode});
            this.waitNode = null;
        }
    }

    synchronized void loadingVCSStarted() {
        Children children = this.getChildren();
        if (this.loadNextNode != null) {
            children.remove(new Node[]{this.loadNextNode});
        }
        this.addWaitNode();
    }

    synchronized void loadingVCSFinished(Date dateFrom) {
        Children children = this.getChildren();
        this.removeWaitNode();
        if (this.loadNextNode != null) {
            children.remove(new Node[]{this.loadNextNode});
        }
        if (dateFrom != null && !HistorySettings.getInstance().getLoadAll()) {
            this.loadNextNode = new LoadNextNode(dateFrom);
            children.add(new Node[]{this.loadNextNode});
        }
    }

    public String getName() {
        return NODE_ROOT;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(HistoryRootNode.class, (String)"LBL_LocalHistory_Column_Version");
    }

    public Action[] getActions(boolean context) {
        return NO_ACTION;
    }

    synchronized void refreshLoadNextName() {
        if (this.loadNextNode != null) {
            this.loadNextNode.nameChanged();
        }
    }

    private class BaseProperty
    extends PropertySupport.ReadOnly<TableEntry> {
        private final TableEntry te;

        public BaseProperty(String name, Class<TableEntry> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
            this.te = new TableEntry(){

                @Override
                public String getDisplayValue() {
                    return BaseProperty.this.getDisplayValue();
                }

                @Override
                public String getTooltip() {
                    return BaseProperty.this.getDisplayValue();
                }

                @Override
                public Integer order() {
                    return -1;
                }
            };
        }

        public BaseProperty(String name) {
            this(name, TableEntry.class, "", "");
        }

        String getDisplayValue() {
            return "";
        }

        public TableEntry getValue() throws IllegalAccessException, InvocationTargetException {
            return this.te;
        }
    }

    class LoadNextNode
    extends AbstractNode
    implements Comparable<Node> {
        LoadNextNode(Date dateFrom) {
            super((Children)new Children.SortedArray());
            Sheet sheet = Sheet.createDefault();
            Sheet.Set ps = Sheet.createPropertiesSet();
            ps.put((Node.Property)new BaseProperty("version"));
            ps.put((Node.Property)new BaseProperty("user"));
            ps.put((Node.Property)new MessageProperty(dateFrom));
            sheet.put(ps);
            this.setSheet(sheet);
        }

        public Action getPreferredAction() {
            return HistoryRootNode.this.loadNextAction;
        }

        public Action[] getActions(boolean context) {
            if (!HistorySettings.getInstance().getLoadAll()) {
                return HistoryRootNode.this.actions;
            }
            return new Action[0];
        }

        public String getDisplayName() {
            return (String)HistoryRootNode.this.loadNextAction.getValue("Name");
        }

        @Override
        public int compareTo(Node n) {
            return n instanceof WaitNode ? 0 : 1;
        }

        public String getName() {
            return HistoryRootNode.NODE_LOAD_NEXT;
        }

        private void refreshMessage() {
            this.firePropertyChange("label", null, null);
        }

        private void nameChanged() {
            this.fireDisplayNameChange(null, null);
        }

        class MessageProperty
        extends BaseProperty {
            private final Date dateFrom;

            public MessageProperty(Date dateFrom) {
                super("label", TableEntry.class, NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Name"), NbBundle.getMessage(RevisionNode.class, (String)"LBL_LabelProperty_Desc"));
                this.dateFrom = dateFrom;
            }

            @Override
            public String getDisplayValue() {
                if (this.dateFrom != null) {
                    return NbBundle.getMessage(HistoryRootNode.class, (String)"LBL_ShowingVCSRevisions", (Object)HistoryRootNode.this.vcsName, (Object)dateFormat.format(this.dateFrom), (Object)HistoryRootNode.this.vcsCount);
                }
                return NbBundle.getMessage(HistoryRootNode.class, (String)"LBL_ShowingAllVCSRevisions", (Object)HistoryRootNode.this.vcsName);
            }

            public String toString() {
                return this.getDisplayValue();
            }
        }
    }

    private class WaitNode
    extends AbstractNode
    implements Comparable<Node> {
        public WaitNode() {
            super(Children.LEAF);
            this.setDisplayName(NbBundle.getMessage(HistoryRootNode.class, (String)"LBL_LoadingPleaseWait"));
            this.setIconBaseWithExtension("org/netbeans/modules/versioning/ui/resources/icons/wait.gif");
            Sheet sheet = Sheet.createDefault();
            Sheet.Set ps = Sheet.createPropertiesSet();
            ps.put((Node.Property)new BaseProperty("version"));
            ps.put((Node.Property)new BaseProperty("user"));
            ps.put((Node.Property)new BaseProperty("label"));
            sheet.put(ps);
            this.setSheet(sheet);
        }

        @Override
        public int compareTo(Node n) {
            return n instanceof LoadNextNode ? 0 : 1;
        }

        public String getName() {
            return HistoryRootNode.NODE_WAIT;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

