/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.options;

import java.awt.Cursor;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.swing.JFrame;
import org.netbeans.modules.options.CategoryModel;
import org.netbeans.modules.options.OptionsDisplayerImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class OptionsDisplayer {
    private static final OptionsDisplayer INSTANCE = new OptionsDisplayer();
    private final OptionsDisplayerImpl impl = new OptionsDisplayerImpl(false);
    private static Logger log = Logger.getLogger(OptionsDisplayer.class.getName());
    public static final String ADVANCED = "Advanced";

    private OptionsDisplayer() {
    }

    public static OptionsDisplayer getDefault() {
        return INSTANCE;
    }

    public boolean open() {
        OptionsDisplayer.showWaitCursor();
        return this.open(CategoryModel.getInstance().getCurrentCategoryID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open(String string) {
        log.fine("Open Options Dialog: " + string);
        OptionsDisplayer.showWaitCursor();
        try {
            boolean bl = this.openImpl(string);
            return bl;
        }
        finally {
            OptionsDisplayer.hideWaitCursor();
        }
    }

    private boolean openImpl(String string) {
        if (string == null) {
            log.warning("Category to open is null.");
            return false;
        }
        final String string2 = string.indexOf(47) == -1 ? string : string.substring(0, string.indexOf(47));
        final String string3 = string.indexOf(47) == -1 ? null : string.substring(string.indexOf(47) + 1);
        Boolean bl = (Boolean)Mutex.EVENT.readAccess((Mutex.Action)new Mutex.Action<Boolean>(){

            public Boolean run() {
                boolean bl;
                Boolean bl2 = OptionsDisplayer.this.impl.isOpen();
                boolean bl3 = bl = bl2 == false;
                if (bl) {
                    bl = Arrays.asList(CategoryModel.getInstance().getCategoryIDs()).contains(string2);
                    if (!bl) {
                        log.warning("Unknown categoryId: " + string2);
                    }
                } else {
                    log.warning("Options Dialog is opened");
                }
                if (bl) {
                    OptionsDisplayer.this.impl.showOptionsDialog(string2, string3);
                }
                return bl;
            }
        });
        return bl;
    }

    private static void showWaitCursor() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                jFrame.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
                jFrame.getGlassPane().setVisible(true);
                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(OptionsDisplayerImpl.class, (String)"CTL_Loading_Options"));
            }
        });
    }

    private static void hideWaitCursor() {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                StatusDisplayer.getDefault().setStatusText("");
                JFrame jFrame = (JFrame)WindowManager.getDefault().getMainWindow();
                jFrame.getGlassPane().setVisible(false);
                jFrame.getGlassPane().setCursor(null);
            }
        });
    }
}

