/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.Rule;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;

class First {
    private Language language;
    private List<Rule> rules;
    private F[] maps;
    private Fl[] follow;

    static First create(List<Rule> rules, Language language) throws ParseException {
        return new First(language, rules);
    }

    private First(Language language, List<Rule> rules) throws ParseException {
        this.language = language;
        this.rules = rules;
        this.compute();
    }

    private void compute() throws ParseException {
        HashMap<String, List<Integer>> ntToIndexes = new HashMap<String, List<Integer>>();
        int k = this.rules.size();
        for (int i = 0; i < k; ++i) {
            Rule cr = this.rules.get(i);
            String nt = cr.getNT();
            ArrayList<Integer> l = (ArrayList<Integer>)ntToIndexes.get(nt);
            if (l == null) {
                l = new ArrayList<Integer>();
                ntToIndexes.put(nt, l);
            }
            l.add(new Integer(i));
            this.language.getNTID(nt);
        }
        int maxDepth = 3;
        this.maps = new F[this.language.getNTCount()];
        block1: for (String nt : ntToIndexes.keySet()) {
            F firstForNT = new F();
            int count = 0;
            int ntid = this.language.getNTID(nt);
            this.maps[ntid] = firstForNT;
            List indexes = (List)ntToIndexes.get(nt);
            for (int depthLimit = 1; depthLimit <= maxDepth; ++depthLimit) {
                String conflict;
                boolean changed = false;
                Iterator it3 = indexes.iterator();
                while (it3.hasNext()) {
                    int ruleIndex = (Integer)it3.next();
                    Stack<String> ntPath = new Stack<String>();
                    ntPath.push(nt);
                    HashSet<String> pathSet = new HashSet<String>();
                    pathSet.add(nt);
                    changed |= this.first(this.rules.get(ruleIndex).getRight(), 0, ruleIndex, depthLimit, firstForNT, ntToIndexes, new Stack<List>(), pathSet, ntPath, ntid, new HashSet<Integer>(), new int[]{count});
                }
                if (!changed) continue block1;
                if (depthLimit != maxDepth || (conflict = this.findConflict(firstForNT, depthLimit)) == null) continue;
                System.out.println("Conflict: " + conflict);
            }
        }
        for (int j = 0; j < this.maps.length; ++j) {
            if (this.maps[j] == null) continue;
            this.maps[j] = this.s(this.maps[j]);
        }
    }

    private boolean first(List rightSide, int indexInRightSide, Integer ruleIndex, int depthLimit, F firstForNT, Map<String, List<Integer>> ntToIndexes, Stack<List> rightSidesStack, Set<String> absNTSet, Stack<String> ntPath, int fNT, Set<Integer> followABS, int[] count) throws ParseException {
        if (firstForNT.amp == null) {
            firstForNT.amp = new HashSet<Integer>();
        }
        firstForNT.amp.add(ruleIndex);
        if (rightSide.size() <= indexInRightSide) {
            if (rightSidesStack.empty()) {
                if (firstForNT.hash == null) {
                    firstForNT.hash = new HashSet<Integer>();
                }
                firstForNT.hash.add(ruleIndex);
                return false;
            }
            List newRightSide = rightSidesStack.pop();
            String nt = ntPath.pop();
            absNTSet.remove(nt);
            boolean r = this.first(newRightSide, 0, ruleIndex, depthLimit, firstForNT, ntToIndexes, rightSidesStack, absNTSet, ntPath, fNT, followABS, count);
            rightSidesStack.push(newRightSide);
            ntPath.push(nt);
            absNTSet.add(nt);
            return r;
        }
        if (depthLimit < 1) {
            return firstForNT.amp.size() > 1;
        }
        Object e = rightSide.get(indexInRightSide);
        if (e instanceof ASTToken) {
            LLSyntaxAnalyser.T t = new LLSyntaxAnalyser.T((ASTToken)e);
            if (firstForNT.find(t.type, t.identifier) == null) {
                count[0] = count[0] + 1;
            }
            F newInFirst = firstForNT.get(t.type, t.identifier);
            boolean r = this.first(rightSide, indexInRightSide + 1, ruleIndex, depthLimit - 1, newInFirst, ntToIndexes, rightSidesStack, new HashSet<String>(), ntPath, fNT, followABS.isEmpty() ? followABS : new HashSet<Integer>(), count);
            return r;
        }
        String nt = (String)e;
        if (absNTSet.contains(nt)) {
            return firstForNT.amp.size() > 1;
        }
        List<Integer> newRuleIndexes = ntToIndexes.get(nt);
        if (newRuleIndexes == null) {
            throw new ParseException(nt + " grammar rule not defined!");
        }
        rightSidesStack.push(rightSide.subList(indexInRightSide + 1, rightSide.size()));
        ntPath.push(nt);
        absNTSet.add(nt);
        boolean r = false;
        for (Integer rn : newRuleIndexes) {
            List newRightSide = this.rules.get(rn).getRight();
            r |= this.first(newRightSide, 0, ruleIndex, depthLimit, firstForNT, ntToIndexes, rightSidesStack, absNTSet, ntPath, fNT, followABS, count);
        }
        rightSidesStack.pop();
        ntPath.pop();
        absNTSet.remove(nt);
        return r;
    }

    int getRule(int nt, TokenInput input, Set<Integer> skipTokens) {
        F node = this.maps[nt];
        int i = 1;
        while (true) {
            ASTToken token = input.next(i);
            while (token != null && skipTokens.contains(token.getTypeID())) {
                token = input.next(++i);
            }
            F newNode = null;
            newNode = token != null ? node.find(token.getTypeID(), token.getIdentifier()) : node.find(-1, null);
            if (newNode == null) {
                Set<Integer> s = node.hash;
                if (s == null) {
                    s = node.amp;
                }
                if (s == null) {
                    return -1;
                }
                if (s.size() > 1) {
                    return -2;
                }
                return s.iterator().next();
            }
            node = newNode;
            ++i;
        }
    }

    private F s(F m) {
        if (m.amp == null || m.amp.size() < 2) {
            F f = new F();
            f.amp = m.amp;
            return f;
        }
        if (m.ff != null) {
            for (int i = 0; i < m.ff.length; ++i) {
                if (m.ff[i] == null) continue;
                F.FF ff = m.ff[i];
                if (ff.f != null) {
                    ff.f = this.s(ff.f);
                }
                if (ff.map == null) continue;
                for (String id : ff.map.keySet()) {
                    ff.map.put(id, this.s((F)ff.map.get(id)));
                }
            }
        }
        return m;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("First:\n");
        for (int i = 0; i < this.maps.length; ++i) {
            sb.append(this.language.getNT(i));
            F f = this.maps[i];
            if (f == null) {
                sb.append("null");
                continue;
            }
            sb.append(" :");
            f.printSets(sb);
            sb.append('\n');
            f.toString(sb, "  ");
        }
        return sb.toString();
    }

    public String printFollow() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.follow.length; ++i) {
            if (this.follow[i] == null) continue;
            sb.append(this.language.getNT(i)).append(":\n");
            List<int[]> list = this.follow[i].fl;
            for (int[] is : list) {
                Rule rule = this.rules.get(is[0]);
                sb.append("  ").append(rule).append(":").append(is[1]).append("\n");
            }
        }
        return sb.toString();
    }

    private int optimizeFollow() {
        int count = 0;
        for (int i = 0; i < this.follow.length; ++i) {
            if (this.follow[i] == null) continue;
            List<int[]> list = this.follow[i].fl;
            HashMap<Integer, Set<Integer>> n = new HashMap<Integer, Set<Integer>>();
            Iterator<int[]> it = list.iterator();
            while (it.hasNext()) {
                this.addToFollow(it.next(), n, new HashSet<Integer>());
            }
            this.follow[i].fl = this.convertFollow(n);
            count += this.follow[i].fl.size();
        }
        return count;
    }

    private void addToFollow(int[] is, Map<Integer, Set<Integer>> n, Set<Integer> abs) {
        Rule rule = this.rules.get(is[0]);
        if (is[1] < rule.getRight().size()) {
            Set<Integer> s = n.get(is[0]);
            if (s == null) {
                s = new HashSet<Integer>();
                n.put(is[0], s);
            }
            s.add(is[1]);
            return;
        }
        int ntId = this.language.getNTID(rule.getNT());
        if (abs.contains(ntId)) {
            return;
        }
        abs.add(ntId);
        if (this.follow[ntId] == null) {
            return;
        }
        Iterator<int[]> it = this.follow[ntId].fl.iterator();
        while (it.hasNext()) {
            this.addToFollow(it.next(), n, abs);
        }
        abs.remove(ntId);
    }

    private List<int[]> convertFollow(Map<Integer, Set<Integer>> n) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int r : n.keySet()) {
            Iterator<Integer> it2 = n.get(r).iterator();
            while (it2.hasNext()) {
                list.add(new int[]{r, it2.next()});
            }
        }
        return list;
    }

    private String findConflict(F f, int depth) {
        String result;
        if (f.amp == null || f.amp.size() < 2) {
            return null;
        }
        if (depth == 0) {
            return "";
        }
        if (f.ff[0] != null && f.ff[0].f != null && (result = this.findConflict(f.ff[0].f, depth - 1)) != null) {
            return "EOF " + result;
        }
        if (f.ff[0] != null && f.ff[0].map != null) {
            for (String identifier : f.ff[0].map.keySet()) {
                F newF = (F)f.ff[0].map.get(identifier);
                String result2 = this.findConflict(newF, depth - 1);
                if (result2 == null) continue;
                return "\"" + identifier + "\" " + result2;
            }
        }
        for (int i = 1; i < f.ff.length; ++i) {
            String result3;
            if (f.ff[i] == null) continue;
            if (f.ff[i].f != null && (result3 = this.findConflict(f.ff[i].f, depth - 1)) != null) {
                return "<" + this.language.getTokenType(i) + "> " + result3;
            }
            if (f.ff[i].map == null) continue;
            for (String identifier : f.ff[i].map.keySet()) {
                F newF = (F)f.ff[i].map.get(identifier);
                String result4 = this.findConflict(newF, depth - 1);
                if (result4 == null) continue;
                return "<" + this.language.getTokenType(i) + ",\"" + identifier + "\"> " + result4;
            }
        }
        return null;
    }

    static class Debug {
        private List<String> messages;

        Debug(Debug debug, String message) {
            this.messages = new ArrayList<String>(debug.messages);
            this.add(message);
        }

        Debug(String message) {
            this.messages = new ArrayList<String>();
            this.add(message);
        }

        Debug add(String message) {
            this.messages.add(message);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = this.messages.iterator();
            if (it.hasNext()) {
                sb.append(it.next()).append('\n');
            }
            while (it.hasNext()) {
                sb.append("  ").append(it.next()).append('\n');
            }
            return sb.toString();
        }
    }

    private class F {
        FF[] ff;
        Set<Integer> amp;
        Set<Integer> hash;

        private F() {
        }

        F find(int type, String id) {
            if (this.ff == null) {
                return null;
            }
            FF fff = this.ff[type + 1];
            if (fff == null) {
                fff = this.ff[0];
            }
            if (fff == null) {
                return null;
            }
            if (fff.map == null) {
                return fff.f;
            }
            F result = (F)fff.map.get(id);
            if (result == null) {
                return fff.f;
            }
            return result;
        }

        F get(int type, String id) {
            F result;
            FF fff;
            if (this.ff == null) {
                this.ff = new FF[First.this.language.getTokenTypeCount() + 1];
            }
            if ((fff = this.ff[type + 1]) == null) {
                this.ff[type + 1] = fff = new FF();
            }
            if (id == null) {
                if (fff.f == null) {
                    fff.f = new F();
                }
                return fff.f;
            }
            if (fff.map == null) {
                fff.map = new HashMap();
            }
            if ((result = (F)fff.map.get(id)) == null) {
                result = new F();
                fff.map.put(id, result);
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.printSets(sb);
            sb.append('\n');
            this.toString(sb, "  ");
            return sb.toString();
        }

        void toString(StringBuilder sb, String indent) {
            if (this.ff == null) {
                return;
            }
            if (this.ff[0] != null && this.ff[0].f != null) {
                F f = this.ff[0].f;
                sb.append(indent).append("<").append("EOF").append("> ");
                f.printSets(sb);
                sb.append("\n");
                f.toString(sb, indent + "  ");
            }
            if (this.ff[0] != null && this.ff[0].map != null) {
                for (String id : this.ff[0].map.keySet()) {
                    F f = (F)this.ff[0].map.get(id);
                    sb.append(indent).append("<\"").append(id).append("\"> ");
                    f.printSets(sb);
                    sb.append("\n");
                    f.toString(sb, indent + "  ");
                }
            }
            for (int i = 1; i < this.ff.length; ++i) {
                if (this.ff[i] == null) continue;
                String type = First.this.language.getTokenType(i - 1);
                if (this.ff[i].f != null) {
                    sb.append(indent).append("<").append(type).append("> ");
                    this.ff[i].f.printSets(sb);
                    sb.append("\n");
                    this.ff[i].f.toString(sb, indent + "  ");
                }
                if (this.ff[i].map == null) continue;
                for (String id : this.ff[i].map.keySet()) {
                    F f = (F)this.ff[i].map.get(id);
                    sb.append(indent).append("<").append(type).append(",\"").append(id).append("\"> ");
                    f.printSets(sb);
                    sb.append("\n");
                    f.toString(sb, indent + "  ");
                }
            }
        }

        void printSets(StringBuilder sb) {
            Iterator<Integer> it;
            if (this.amp != null) {
                sb.append("[");
                it = this.amp.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("] ");
            }
            if (this.hash != null) {
                sb.append("#[");
                it = this.hash.iterator();
                while (it.hasNext()) {
                    sb.append(it.next());
                    if (!it.hasNext()) continue;
                    sb.append(",");
                }
                sb.append("]");
            }
        }

        private class FF {
            private F f;
            private Map<String, F> map;

            private FF() {
            }
        }
    }

    static class Fl {
        List<int[]> fl = new ArrayList<int[]>();

        Fl() {
        }
    }
}

