/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CompletionItem;
import org.netbeans.api.languages.Context;
import org.netbeans.api.languages.LanguageDefinitionNotFoundException;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.ParserManagerListener;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.database.DatabaseContext;
import org.netbeans.api.languages.database.DatabaseDefinition;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.LanguagesManager;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.Utils;
import org.netbeans.modules.languages.features.CompletionSupport;
import org.netbeans.modules.languages.features.DatabaseManager;
import org.netbeans.modules.languages.features.FileNotParsedException;
import org.netbeans.modules.languages.features.Index;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.openide.filesystems.FileObject;

public class CompletionProviderImpl
implements CompletionProvider {
    static final String COMPLETION = "COMPLETION";
    static final String COMPLETION_APPEND = "append";
    static final String COMPLETION_INSERT = "insert";
    static final String COMPLETION_COMPLETE = "complete";

    public CompletionTask createTask(int queryType, JTextComponent component) {
        return new CompletionTaskImpl(component);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        if (".".equals(typedText)) {
            Document doc = component.getDocument();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)doc);
            if (doc instanceof NbEditorDocument) {
                ((NbEditorDocument)doc).readLock();
            }
            try {
                int offset = component.getCaret().getDot();
                if (offset <= 1) {
                    int n = 0;
                    return n;
                }
                List sequences = tokenHierarchy.embeddedTokenSequences(offset -= 2, true);
                if (sequences.isEmpty()) {
                    int n = 0;
                    return n;
                }
                TokenSequence tokenSequence = (TokenSequence)sequences.get(sequences.size() - 1);
                tokenSequence.move(offset);
                if (!tokenSequence.moveNext() && !tokenSequence.movePrevious()) {
                    int n = 0;
                    return n;
                }
                Token token = tokenSequence.token();
                if (token.id().name().indexOf("identifier") > -1) {
                    int n = 1;
                    return n;
                }
            }
            finally {
                if (doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)doc).readUnlock();
                }
            }
        }
        return 0;
    }

    List<CompletionItem> query(JTextComponent component) {
        ListResult r = new ListResult();
        CompletionTaskImpl task = new CompletionTaskImpl(component);
        task.compute(r);
        r.waitFinished();
        return r.getList();
    }

    private static TokenSequence getDeepestTokenSequence(TokenHierarchy tokenHierarchy, int offset) {
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence != null) {
            tokenSequence.move(offset - 1);
            if (!tokenSequence.moveNext()) break;
            TokenSequence ts = tokenSequence.embedded();
            if (ts == null) {
                return tokenSequence;
            }
            tokenSequence = ts;
        }
        return tokenSequence;
    }

    private static class CompletionResult
    implements Result {
        private CompletionResultSet resultSet;

        CompletionResult(CompletionResultSet resultSet) {
            this.resultSet = resultSet;
        }

        @Override
        public void addItem(CompletionItem item) {
            this.resultSet.addItem(item);
        }

        @Override
        public void finish() {
            this.resultSet.finish();
        }

        @Override
        public boolean isFinished() {
            return this.resultSet.isFinished();
        }
    }

    private static class CompletionTaskImpl
    implements CompletionTask {
        private JTextComponent component;
        private Document doc;
        private FileObject fileObject;
        private boolean ignoreCase;
        private List<CompletionItem> items = new ArrayList<CompletionItem>();
        private String fileName;

        CompletionTaskImpl(JTextComponent component) {
            this.component = component;
        }

        public void query(CompletionResultSet resultSet) {
            this.compute(new CompletionResult(resultSet));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refresh(CompletionResultSet resultSet) {
            if (resultSet == null) {
                return;
            }
            this.doc = this.component.getDocument();
            this.fileObject = NbEditorUtilities.getFileObject((Document)this.doc);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            try {
                Token token;
                int offset = this.component.getCaret().getDot();
                TokenSequence tokenSequence = CompletionProviderImpl.getDeepestTokenSequence(tokenHierarchy, offset);
                Token token2 = token = tokenSequence != null ? tokenSequence.token() : null;
                if (token != null) {
                    String start = ((Object)token.text()).toString();
                    String completionType = this.getCompletionType(null, token.id().name());
                    int tokenOffset = tokenSequence.offset();
                    start = completionType == null || CompletionProviderImpl.COMPLETION_APPEND.equals(completionType) && offset < tokenOffset + token.length() ? start.substring(0, offset - tokenOffset).trim() : (CompletionProviderImpl.COMPLETION_COMPLETE.equals(completionType) ? start.substring(0, offset - tokenOffset).trim() : "");
                    for (CompletionItem completionItem : this.items) {
                        String text = ((Object)completionItem.getInsertPrefix()).toString();
                        if (!text.startsWith(start)) continue;
                        resultSet.addItem(completionItem);
                    }
                }
            }
            finally {
                if (this.doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)this.doc).readUnlock();
                }
            }
            resultSet.finish();
        }

        public void cancel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void compute(Result resultSet) {
            this.doc = this.component.getDocument();
            this.fileObject = NbEditorUtilities.getFileObject((Document)this.doc);
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
            boolean finishSet = true;
            if (this.doc instanceof NbEditorDocument) {
                ((NbEditorDocument)this.doc).readLock();
            }
            try {
                int offset = this.component.getCaret().getDot();
                TokenSequence tokenSequence = CompletionProviderImpl.getDeepestTokenSequence(tokenHierarchy, this.component.getCaret().getDot());
                if (tokenSequence == null || !tokenSequence.isEmpty() && tokenSequence.offset() > offset) {
                    return;
                }
                String mimeType = tokenSequence.language().mimeType();
                Language language = LanguagesManager.getDefault().getLanguage(mimeType);
                if (!tokenSequence.isEmpty()) {
                    this.compute(tokenSequence, offset, resultSet, this.doc, language);
                }
                finishSet = this.addParserTags(resultSet, language);
            }
            catch (LanguageDefinitionNotFoundException ex) {
            }
            finally {
                if (this.doc instanceof NbEditorDocument) {
                    ((NbEditorDocument)this.doc).readUnlock();
                }
            }
            if (finishSet) {
                resultSet.finish();
            }
        }

        private String getCompletionType(Feature feature, String tokenType) {
            if (feature != null) {
                String completionType;
                String projectType = (String)feature.getValue("project_type");
                if (projectType != null) {
                    if (this.fileObject == null) {
                        return null;
                    }
                    if (!Utils.isOfProjectType(this.fileObject, projectType)) {
                        return null;
                    }
                }
                if ((completionType = (String)feature.getValue("type")) != null) {
                    return completionType;
                }
            }
            if (tokenType == null) {
                return CompletionProviderImpl.COMPLETION_COMPLETE;
            }
            if (tokenType.indexOf("whitespace") >= 0 || tokenType.indexOf("operator") >= 0 || tokenType.indexOf("separator") >= 0) {
                return CompletionProviderImpl.COMPLETION_INSERT;
            }
            if (tokenType.indexOf("comment") >= 0) {
                return CompletionProviderImpl.COMPLETION_APPEND;
            }
            return CompletionProviderImpl.COMPLETION_COMPLETE;
        }

        private void compute(TokenSequence tokenSequence, int offset, Result resultSet, Document doc, Language language) {
            String start = null;
            Token token = tokenSequence.token();
            start = ((Object)token.text()).toString();
            String tokenType = language.getTokenType(token.id().ordinal());
            List<Feature> features = language.getFeatureList().getFeatures(CompletionProviderImpl.COMPLETION, tokenType);
            for (Feature feature : features) {
                String completionType = this.getCompletionType(feature, token.id().name());
                int tokenOffset = tokenSequence.offset();
                if (completionType == null || CompletionProviderImpl.COMPLETION_APPEND.equals(completionType) && offset < tokenOffset + token.length()) continue;
                start = CompletionProviderImpl.COMPLETION_COMPLETE.equals(completionType) ? start.substring(0, offset - tokenOffset).trim() : "";
                this.ignoreCase = false;
                Feature f = language.getFeatureList().getFeature("PROPERTIES");
                if (f != null) {
                    this.ignoreCase = f.getBoolean("ignoreCase", false);
                }
                if (this.ignoreCase) {
                    start = start.toLowerCase();
                }
                this.addTags(feature, start, Context.create(doc, offset), resultSet);
            }
        }

        private boolean addParserTags(final Result resultSet, final Language language) {
            final ParserManager parserManager = ParserManager.get(this.doc);
            if (parserManager.getState() == ParserManager.State.PARSING) {
                parserManager.addListener(new ParserManagerListener(){

                    @Override
                    public void parsed(ParserManager.State state, ASTNode ast) {
                        parserManager.removeListener(this);
                        if (resultSet.isFinished()) {
                            return;
                        }
                        CompletionTaskImpl.this.addParserTags(ast, resultSet, language);
                        resultSet.finish();
                    }
                });
                return false;
            }
            this.addParserTags(ParserManagerImpl.getImpl(this.doc).getAST(), resultSet, language);
            return true;
        }

        private void addParserTags(ASTNode node, Result resultSet, Language language) {
            if (node == null) {
                return;
            }
            int offset = this.component.getCaret().getDot();
            ASTPath path = node.findPath(offset - 1);
            if (path == null) {
                return;
            }
            ASTItem item = path.getLeaf();
            if (item instanceof ASTNode) {
                return;
            }
            ASTToken token = (ASTToken)item;
            if (token.getLength() != token.getIdentifier().length()) {
                return;
            }
            int tokenOffset = token.getOffset();
            for (int i = path.size() - 1; i >= 0 && (item = path.get(i)).getLanguage() != language; --i) {
                List<Feature> features = language.getFeatureList().getFeatures(CompletionProviderImpl.COMPLETION, path.subPath(i));
                for (Feature feature : features) {
                    String completionType = this.getCompletionType(feature, token.getTypeName());
                    if (completionType == null || CompletionProviderImpl.COMPLETION_APPEND.equals(completionType) && offset < tokenOffset + token.getLength()) continue;
                    String start = CompletionProviderImpl.COMPLETION_COMPLETE.equals(completionType) ? token.getIdentifier().substring(0, offset - tokenOffset).trim() : "";
                    this.addTags(feature, start, SyntaxContext.create(this.doc, path.subPath(i)), resultSet);
                }
            }
            DatabaseContext context = DatabaseManager.getRoot(node);
            if (context == null) {
                return;
            }
            List<DatabaseDefinition> definitions = context.getAllVisibleDefinitions(offset);
            String completionType = this.getCompletionType(null, token.getTypeName());
            String start = null;
            start = completionType == null || CompletionProviderImpl.COMPLETION_APPEND.equals(completionType) && offset < tokenOffset + token.getLength() ? token.getIdentifier().substring(0, offset - tokenOffset).trim() : (CompletionProviderImpl.COMPLETION_COMPLETE.equals(completionType) ? token.getIdentifier().substring(0, offset - tokenOffset).trim() : "");
            HashSet<String> names = new HashSet<String>();
            for (DatabaseDefinition definition : definitions) {
                names.add(definition.getName());
                CompletionSupport cs = CompletionTaskImpl.createCompletionItem(definition, this.getFileName(), start);
                this.items.add(cs);
                if (!definition.getName().startsWith(start)) continue;
                resultSet.addItem(cs);
            }
            try {
                if (this.fileObject != null) {
                    String mimeType = language.getMimeType();
                    Map<FileObject, List<DatabaseDefinition>> globals = Index.getGlobalItems(this.fileObject, true);
                    for (FileObject fo : globals.keySet()) {
                        if (!mimeType.equals(fo.getMIMEType())) continue;
                        List<DatabaseDefinition> l = globals.get(fo);
                        for (DatabaseDefinition definition : l) {
                            if (names.contains(definition.getName())) continue;
                            CompletionSupport cs = CompletionTaskImpl.createCompletionItem(definition, fo.getNameExt(), start);
                            this.items.add(cs);
                            if (!definition.getName().startsWith(start)) continue;
                            resultSet.addItem(cs);
                        }
                    }
                }
            }
            catch (FileNotParsedException ex) {
                ex.printStackTrace();
            }
        }

        private String getFileName() {
            if (this.fileName == null) {
                this.fileName = (String)this.doc.getProperty("title");
                if (this.fileName == null) {
                    return null;
                }
                int i = this.fileName.lastIndexOf(File.separatorChar);
                if (i > 0) {
                    this.fileName = this.fileName.substring(i + 1);
                }
            }
            return this.fileName;
        }

        private void addTags(Feature feature, String start, Context context, Result resultSet) {
            int j = 1;
            while (true) {
                if (context instanceof SyntaxContext && feature.getType("text" + j) == Feature.Type.STRING && ((SyntaxContext)context).getASTPath().getLeaf() instanceof ASTToken) {
                    ++j;
                    continue;
                }
                Object o = feature.getValue("text" + j, context);
                if (o == null) break;
                if (o instanceof String) {
                    this.addTags((String)o, feature, j, start, resultSet);
                } else {
                    this.addMethodCallTags((List)o, context, resultSet, start);
                }
                ++j;
            }
        }

        private void addMethodCallTags(List keys, Context context, Result resultSet, String start) {
            for (Object o : keys) {
                String s;
                if (o instanceof org.netbeans.api.languages.CompletionItem) {
                    o = new CompletionSupport((org.netbeans.api.languages.CompletionItem)o, start);
                }
                CompletionItem item = (CompletionItem)o;
                this.items.add(item);
                CharSequence chs = item.getInsertPrefix();
                String string = s = chs instanceof String ? (String)chs : ((Object)chs).toString();
                if (this.ignoreCase) {
                    s = s.toLowerCase();
                }
                if (!s.startsWith(start)) continue;
                resultSet.addItem(item);
            }
        }

        private void addTags(String text, Feature feature, int j, String start, Result resultSet) {
            String description;
            if (this.ignoreCase) {
                text = text.toLowerCase();
            }
            if ((description = (String)feature.getValue("description" + j)) == null) {
                description = text;
            }
            String icon = (String)feature.getValue("icon" + j);
            CompletionSupport item = new CompletionSupport(text, start, description, null, icon, 2);
            this.items.add(item);
            if (!text.startsWith(start)) {
                return;
            }
            resultSet.addItem(item);
        }

        private static CompletionSupport createCompletionItem(DatabaseDefinition definition, String fileName, String start) {
            CompletionItem.Type type = null;
            if ("local".equals(definition.getType())) {
                type = CompletionItem.Type.LOCAL;
            } else if ("parameter".equals(definition.getType())) {
                type = CompletionItem.Type.PARAMETER;
            } else if ("field".equals(definition.getType())) {
                type = CompletionItem.Type.FIELD;
            } else if ("method".equals(definition.getType())) {
                type = CompletionItem.Type.METHOD;
            }
            return new CompletionSupport(new org.netbeans.api.languages.CompletionItem(definition.getName(), null, fileName, type, 100), start);
        }
    }

    private static class ListResult
    implements Result {
        private List<CompletionItem> result = new ArrayList<CompletionItem>();
        private boolean finished = false;
        private Object LOCK = new Object();

        private ListResult() {
        }

        @Override
        public void addItem(CompletionItem item) {
            this.result.add(item);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish() {
            this.finished = true;
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notify();
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void waitFinished() {
            if (this.finished) {
                return;
            }
            Object object = this.LOCK;
            synchronized (object) {
                try {
                    this.LOCK.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public List<CompletionItem> getList() {
            return this.result;
        }
    }

    private static interface Result {
        public void addItem(CompletionItem var1);

        public void finish();

        public boolean isFinished();
    }
}

