/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.HighlighterSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class ASTBrowserTopComponent
extends TopComponent {
    private static final long serialVersionUID = 1L;
    private static ASTBrowserTopComponent instance;
    private static final String PREFERRED_ID = "ASTBrowserTopComponent";
    private JTree tree;
    private Listener listener;
    private HighlighterSupport highlighting = new HighlighterSupport(Color.yellow);
    private CaretListener caretListener;
    private JEditorPane lastPane;
    private ASTNode rootNode;

    private ASTBrowserTopComponent() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        this.tree = new JTree();
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ASTBrowserTopComponent.this.mark();
            }
        });
        this.tree.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ASTBrowserTopComponent.this.mark();
            }

            @Override
            public void focusLost(FocusEvent e) {
                ASTBrowserTopComponent.this.mark();
            }
        });
        this.tree.setShowsRootHandles(true);
        this.tree.setModel(new DefaultTreeModel(new TNode(null, null)));
        this.tree.setCellRenderer(new Renderer());
        this.add(new JScrollPane(this.tree), "Center");
        this.setName(NbBundle.getMessage(ASTBrowserTopComponent.class, (String)"CTL_ASTBrowserTopComponent"));
        this.setToolTipText(NbBundle.getMessage(ASTBrowserTopComponent.class, (String)"HINT_ASTBrowserTopComponent"));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public static synchronized ASTBrowserTopComponent getDefault() {
        if (instance == null) {
            instance = new ASTBrowserTopComponent();
        }
        return instance;
    }

    public static synchronized ASTBrowserTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find ASTBrowser component. It will not be located properly in the window system.");
            return ASTBrowserTopComponent.getDefault();
        }
        if (win instanceof ASTBrowserTopComponent) {
            return (ASTBrowserTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'ASTBrowserTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return ASTBrowserTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentShowing() {
        this.refresh();
        if (this.listener == null) {
            this.listener = new Listener(this);
        }
    }

    public void componentHidden() {
        if (this.listener != null) {
            this.listener.remove();
            this.listener = null;
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    private void mark() {
        TNode tn;
        EditorCookie editorCookie;
        Node[] ns;
        if (this.tree.isFocusOwner() && (ns = TopComponent.getRegistry().getActivatedNodes()).length == 1 && (editorCookie = (EditorCookie)ns[0].getLookup().lookup(EditorCookie.class)) != null && (tn = (TNode)this.tree.getLastSelectedPathComponent()) != null) {
            ASTItem item = tn.getASTItem();
            if (item == null) {
                return;
            }
            this.highlighting.highlight(editorCookie.getDocument(), item.getOffset(), item.getEndOffset());
            return;
        }
        this.highlighting.removeHighlight();
    }

    private void refresh() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ASTNode nr = ASTBrowserTopComponent.this.getCurrentRootNode();
                if (nr == ASTBrowserTopComponent.this.rootNode) {
                    return;
                }
                ASTBrowserTopComponent.this.rootNode = nr;
                DefaultTreeModel model = new DefaultTreeModel(new TNode(null, ASTBrowserTopComponent.this.rootNode));
                ASTBrowserTopComponent.this.tree.setModel(model);
            }
        });
    }

    private ASTNode getCurrentRootNode() {
        StyledDocument document;
        Node[] ns = TopComponent.getRegistry().getActivatedNodes();
        if (ns.length != 1) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)ns[0].getLookup().lookup(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes() == null) {
            return null;
        }
        if (editorCookie.getOpenedPanes().length < 1) {
            return null;
        }
        JEditorPane pane = editorCookie.getOpenedPanes()[0];
        if (this.caretListener == null) {
            this.caretListener = new CListener();
        }
        if (this.lastPane != null && this.lastPane != pane) {
            this.lastPane.removeCaretListener(this.caretListener);
            this.lastPane = null;
        }
        if (this.lastPane == null) {
            pane.addCaretListener(this.caretListener);
            this.lastPane = pane;
        }
        if ((document = editorCookie.getDocument()) == null || !(document instanceof NbEditorDocument)) {
            return null;
        }
        return ParserManagerImpl.getImpl(document).getAST();
    }

    class CListener
    implements CaretListener {
        CListener() {
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (ASTBrowserTopComponent.this.rootNode == null) {
                return;
            }
            ASTPath path = ASTBrowserTopComponent.this.rootNode.findPath(e.getDot());
            if (path == null) {
                return;
            }
            TreeNode tNode = (TreeNode)ASTBrowserTopComponent.this.tree.getModel().getRoot();
            ArrayList<TreeNode> treePath = new ArrayList<TreeNode>();
            ListIterator<ASTItem> it = path.listIterator();
            if (!it.hasNext()) {
                return;
            }
            it.next();
            treePath.add(tNode);
            while (tNode instanceof TNode && it.hasNext()) {
                if ((tNode = ((TNode)tNode).getTreeNode(it.next())) == null) {
                    throw new NullPointerException();
                }
                treePath.add(tNode);
            }
            TreePath treePath2 = new TreePath(treePath.toArray());
            DefaultTreeModel model = new DefaultTreeModel((TreeNode)ASTBrowserTopComponent.this.tree.getModel().getRoot());
            ASTBrowserTopComponent.this.tree.setModel(model);
            ASTBrowserTopComponent.this.tree.setSelectionPath(treePath2);
            ASTBrowserTopComponent.this.tree.scrollPathToVisible(treePath2);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private WeakReference<ASTBrowserTopComponent> component;

        Listener(ASTBrowserTopComponent c) {
            this.component = new WeakReference<ASTBrowserTopComponent>(c);
            TopComponent.getRegistry().addPropertyChangeListener((PropertyChangeListener)this);
        }

        ASTBrowserTopComponent getComponent() {
            ASTBrowserTopComponent c = (ASTBrowserTopComponent)((Object)this.component.get());
            if (c != null) {
                return c;
            }
            this.remove();
            return null;
        }

        void remove() {
            TopComponent.getRegistry().removePropertyChangeListener((PropertyChangeListener)this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            ASTBrowserTopComponent c = this.getComponent();
            if (c == null) {
                return;
            }
            c.refresh();
        }
    }

    private static class Renderer
    extends DefaultTreeCellRenderer {
        private Renderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            return super.getTreeCellRendererComponent(tree, ((TNode)value).getName(), sel, expanded, leaf, row, hasFocus);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return ASTBrowserTopComponent.getDefault();
        }
    }

    static class TNode
    implements TreeNode {
        private TNode parent;
        private ASTItem astItem;
        private List<TreeNode> children;
        private Map<ASTItem, TreeNode> map;

        TNode(TNode parent, ASTItem astItem) {
            this.parent = parent;
            this.astItem = astItem;
        }

        private void initChildren() {
            if (this.children != null) {
                return;
            }
            this.children = new ArrayList<TreeNode>();
            this.map = new HashMap<ASTItem, TreeNode>();
            if (this.astItem == null) {
                return;
            }
            List<ASTItem> chList = this.astItem.getChildren();
            if (chList != null) {
                for (ASTItem item : chList) {
                    TNode tn = new TNode(this, item);
                    this.children.add(tn);
                    this.map.put(item, tn);
                }
            }
        }

        String getName() {
            if (this.astItem == null) {
                return "No syntax definition.";
            }
            if (this.astItem instanceof ASTNode) {
                String nt = ((ASTNode)this.astItem).getNT();
                if (nt.equals("S")) {
                    nt = nt + " (" + this.astItem.getMimeType() + ")";
                }
                return nt;
            }
            return this.astItem.toString();
        }

        ASTItem getASTItem() {
            return this.astItem;
        }

        TreeNode getTreeNode(Object o) {
            this.initChildren();
            return this.map.get(o);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            this.initChildren();
            return this.children.get(childIndex);
        }

        @Override
        public int getChildCount() {
            this.initChildren();
            return this.children.size();
        }

        @Override
        public TreeNode getParent() {
            return this.parent;
        }

        @Override
        public int getIndex(TreeNode node) {
            this.initChildren();
            return this.children.indexOf(node);
        }

        @Override
        public boolean getAllowsChildren() {
            return true;
        }

        @Override
        public boolean isLeaf() {
            if (this.astItem == null) {
                return false;
            }
            return this.astItem.getChildren().isEmpty();
        }

        public Enumeration children() {
            return new Enumeration(){
                private Iterator it;
                {
                    this.it = TNode.this.children.iterator();
                }

                @Override
                public boolean hasMoreElements() {
                    return this.it.hasNext();
                }

                public Object nextElement() {
                    return this.it.next();
                }
            };
        }
    }
}

