/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.charts.ChartComponent;
import org.netbeans.lib.profiler.charts.ChartConfigurationListener;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ChartSelectionListener;
import org.netbeans.lib.profiler.charts.ChartSelectionModel;
import org.netbeans.lib.profiler.charts.ItemPainter;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.ItemsModel;
import org.netbeans.lib.profiler.charts.PaintersModel;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineIconPainter;

class TimelineSelectionManager
implements ChartSelectionModel {
    private ChartComponent chart;
    private ChartListener chartListener = new ChartListener();
    private MouseListener mouseListener = new MouseListener();
    private int selectionMode;
    private int moveMode;
    private int dragMode;
    private int hoverMode;
    private int hoverDistanceLimit;
    private int mouseX = -1;
    private int mouseY = -1;
    private boolean inChart = false;
    private Rectangle selectionBounds;
    private List<ItemSelection> highlightedSelection;
    private List<ItemSelection> selectedSelection;
    private boolean mousePanningBackup;
    private boolean enabled = true;
    private List<ChartSelectionListener> selectionListeners;
    private int startIndex = -1;
    private int endIndex = -1;

    public TimelineSelectionManager() {
        this.setMoveMode(0);
        this.setDragMode(0);
        this.setSelectionMode(this.moveMode);
        this.setHoverMode(100);
        this.setHoverDistanceLimit(-1);
    }

    void registerChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = chart;
        this.registerListener();
    }

    void unregisterChart(ChartComponent chart) {
        this.unregisterListener();
        this.chart = null;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public final void setMoveMode(int mode) {
        this.moveMode = mode;
        if (this.selectionMode != this.moveMode) {
            this.setSelectionMode(this.moveMode);
        }
    }

    public final int getMoveMode() {
        return this.moveMode;
    }

    public final void setDragMode(int mode) {
        this.dragMode = mode;
    }

    public final int getDragMode() {
        return this.dragMode;
    }

    public final int getSelectionMode() {
        return this.selectionMode;
    }

    public final void setHoverMode(int mode) {
        this.hoverMode = mode;
        this.updateHighlightedItems();
    }

    public final int getHoverMode() {
        return this.hoverMode;
    }

    public final void setHoverDistanceLimit(int limit) {
        this.hoverDistanceLimit = limit;
    }

    public final int getHoverDistanceLimit() {
        return this.hoverDistanceLimit;
    }

    public final void setSelectionBounds(int x, int y, int w, int h) {
        this.setSelectionBounds(new Rectangle(x, y, w, h));
    }

    public void selectAll() {
        Rectangle oldSelectionBounds = this.selectionBounds == null ? null : new Rectangle(this.selectionBounds);
        this.selectionBounds = new Rectangle(new Point(0, 0), this.chart.getSize());
        this.startIndex = 0;
        ChartItem item = this.chart.getItemsModel().getItem(0);
        this.endIndex = ((XYItem)item).getValuesCount() - 1;
        this.fireSelectionBoundsChanged(this.selectionBounds, oldSelectionBounds);
    }

    public final void setSelectionBounds(Rectangle selectionBounds) {
        Rectangle oldSelectionBounds;
        if (selectionBounds == null && this.selectionBounds == null) {
            return;
        }
        this.normalizeBounds(selectionBounds);
        if (this.selectionBounds != null && this.selectionBounds.equals(selectionBounds) || selectionBounds != null && selectionBounds.equals(this.selectionBounds)) {
            return;
        }
        Rectangle rectangle = oldSelectionBounds = this.selectionBounds == null ? null : new Rectangle(this.selectionBounds);
        if (selectionBounds == null) {
            this.selectionBounds = null;
        } else if (this.selectionBounds == null) {
            this.selectionBounds = new Rectangle(selectionBounds);
        } else {
            this.selectionBounds.setBounds(selectionBounds);
        }
        this.fireSelectionBoundsChanged(this.selectionBounds, oldSelectionBounds);
    }

    public final Rectangle getSelectionBounds() {
        return this.selectionBounds == null ? new Rectangle() : new Rectangle(this.selectionBounds);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    private void normalizeBounds(Rectangle bounds) {
        if (bounds == null) {
            return;
        }
        ItemSelection sel = this.getClosestSelection(bounds.x, bounds.y);
        if (!(sel instanceof XYItemSelection)) {
            return;
        }
        ChartContext context = this.chart.getChartContext();
        XYItemSelection xySel = (XYItemSelection)sel;
        XYItem item = xySel.getItem();
        this.endIndex = this.startIndex = xySel.getValueIndex();
        long valX = item.getXValue(this.startIndex);
        bounds.x = Utils.checkedInt((double)context.getViewX((double)valX));
        if (bounds.width == 0) {
            return;
        }
        sel = this.getClosestSelection(bounds.x + bounds.width, bounds.y + bounds.height);
        if (!(sel instanceof XYItemSelection)) {
            return;
        }
        xySel = (XYItemSelection)sel;
        item = xySel.getItem();
        this.endIndex = xySel.getValueIndex();
        valX = item.getXValue(this.endIndex);
        bounds.width = Utils.checkedInt((double)context.getViewX((double)valX)) - bounds.x;
    }

    public final void setHighlightedItems(List<ItemSelection> items) {
        if (this.highlightedSelection == null) {
            if (items.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(items);
            this.fireHighlightedItemsChanged(items, items, Collections.EMPTY_LIST);
        } else {
            ArrayList<ItemSelection> addedItems = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> removedItems = new ArrayList<ItemSelection>();
            for (ItemSelection item : items) {
                if (this.highlightedSelection.contains(item)) continue;
                addedItems.add(item);
            }
            for (ItemSelection item : this.highlightedSelection) {
                if (items.contains(item)) continue;
                removedItems.add(item);
            }
            if (addedItems.isEmpty() && removedItems.isEmpty()) {
                return;
            }
            this.highlightedSelection = new ArrayList<ItemSelection>(items);
            this.fireHighlightedItemsChanged(items, addedItems, removedItems);
        }
    }

    public final List<ItemSelection> getHighlightedItems() {
        return this.highlightedSelection == null ? Collections.EMPTY_LIST : new ArrayList<ItemSelection>(this.highlightedSelection);
    }

    public final void setSelectedItems(List<ItemSelection> items) {
        if (this.selectedSelection == null) {
            if (items.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(items);
            this.fireSelectedItemsChanged(items, items, Collections.EMPTY_LIST);
        } else {
            ArrayList<ItemSelection> addedItems = new ArrayList<ItemSelection>();
            ArrayList<ItemSelection> removedItems = new ArrayList<ItemSelection>();
            for (ItemSelection item : items) {
                if (this.selectedSelection.contains(item)) continue;
                addedItems.add(item);
            }
            for (ItemSelection item : this.selectedSelection) {
                if (items.contains(item)) continue;
                removedItems.add(item);
            }
            if (addedItems.isEmpty() && removedItems.isEmpty()) {
                return;
            }
            this.selectedSelection = new ArrayList<ItemSelection>(items);
            this.fireSelectedItemsChanged(items, addedItems, removedItems);
        }
    }

    public final List<ItemSelection> getSelectedItems() {
        return this.selectedSelection == null ? Collections.EMPTY_LIST : new ArrayList<ItemSelection>(this.selectedSelection);
    }

    public final void addSelectionListener(ChartSelectionListener listener) {
        if (this.selectionListeners == null) {
            this.selectionListeners = new ArrayList<ChartSelectionListener>();
        }
        this.selectionListeners.add(listener);
    }

    public final void removeSelectionListener(ChartSelectionListener listener) {
        if (this.selectionListeners == null) {
            return;
        }
        this.selectionListeners.remove(listener);
    }

    private void setSelectionMode(int selectionMode) {
        if (this.selectionMode == selectionMode) {
            return;
        }
        int oldSelectionMode = this.selectionMode;
        this.selectionMode = selectionMode;
        this.fireSelectionModeChanged(this.selectionMode, oldSelectionMode);
    }

    private void registerListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.addMouseListener((java.awt.event.MouseListener)this.mouseListener);
        this.chart.addMouseMotionListener((MouseMotionListener)this.mouseListener);
        this.chart.addConfigurationListener((ChartConfigurationListener)this.chartListener);
    }

    private void unregisterListener() {
        if (this.chart == null) {
            return;
        }
        this.chart.removeMouseListener((java.awt.event.MouseListener)this.mouseListener);
        this.chart.removeMouseMotionListener((MouseMotionListener)this.mouseListener);
        this.chart.removeConfigurationListener((ChartConfigurationListener)this.chartListener);
    }

    private void updateHighlightedItems() {
        final int x = this.mouseX;
        final int y = this.mouseY;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (TimelineSelectionManager.this.hoverMode == 100 || !TimelineSelectionManager.this.inChart) {
                    TimelineSelectionManager.this.setHighlightedItems(Collections.EMPTY_LIST);
                    return;
                }
                ItemsModel itemsModel = TimelineSelectionManager.this.chart.getItemsModel();
                PaintersModel paintersModel = TimelineSelectionManager.this.chart.getPaintersModel();
                int itemsCount = itemsModel.getItemsCount();
                ArrayList<ItemSelection> closestSelection = new ArrayList<ItemSelection>(itemsCount);
                for (int i = 0; i < itemsCount; ++i) {
                    ChartItem item = itemsModel.getItem(i);
                    ItemPainter painter = paintersModel.getPainter(item);
                    ItemSelection selection = painter.getClosestSelection(item, x, y, TimelineSelectionManager.this.chart.getChartContext());
                    if (selection == null) continue;
                    int distance = selection.getDistance();
                    if (TimelineSelectionManager.this.hoverMode == 102 || closestSelection.isEmpty()) {
                        if (TimelineSelectionManager.this.hoverDistanceLimit != -1 && distance > TimelineSelectionManager.this.hoverDistanceLimit) continue;
                        closestSelection.add(selection);
                        continue;
                    }
                    if (((ItemSelection)closestSelection.get(0)).getDistance() <= distance || TimelineSelectionManager.this.hoverDistanceLimit != -1 && distance > TimelineSelectionManager.this.hoverDistanceLimit) continue;
                    closestSelection.set(0, selection);
                }
                TimelineSelectionManager.this.setHighlightedItems(closestSelection);
            }
        });
    }

    private ItemSelection getClosestSelection(int x, int y) {
        ItemPainter painter;
        ChartItem item;
        ItemsModel itemsModel = this.chart.getItemsModel();
        int itemsCount = itemsModel.getItemsCount();
        if (itemsCount == 0) {
            return null;
        }
        PaintersModel paintersModel = this.chart.getPaintersModel();
        for (int itemIndex = 0; itemIndex < itemsCount; ++itemIndex) {
            item = itemsModel.getItem(itemIndex);
            painter = paintersModel.getPainter(item);
            if (painter instanceof TimelineIconPainter) continue;
            return painter.getClosestSelection(item, x, y, this.chart.getChartContext());
        }
        item = itemsModel.getItem(0);
        painter = paintersModel.getPainter(item);
        return painter.getClosestSelection(item, x, y, this.chart.getChartContext());
    }

    private void fireSelectionModeChanged(int newMode, int oldMode) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.selectionModeChanged(newMode, oldMode);
        }
    }

    private void fireSelectionBoundsChanged(Rectangle newBounds, Rectangle oldBounds) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.selectionBoundsChanged(newBounds, oldBounds);
        }
    }

    private void fireHighlightedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.highlightedItemsChanged(currentItems, addedItems, removedItems);
        }
    }

    private void fireSelectedItemsChanged(List<ItemSelection> currentItems, List<ItemSelection> addedItems, List<ItemSelection> removedItems) {
        if (this.selectionListeners == null) {
            return;
        }
        for (ChartSelectionListener listener : this.selectionListeners) {
            listener.selectedItemsChanged(currentItems, addedItems, removedItems);
        }
    }

    private class ChartListener
    extends ChartConfigurationListener.Adapter {
        private ChartListener() {
        }

        public void contentsWillBeUpdated(long offsetX, long offsetY, double scaleX, double scaleY, long lastOffsetX, long lastOffsetY, double lastScaleX, double lastScaleY) {
            TimelineSelectionManager.this.updateHighlightedItems();
        }
    }

    private class MouseListener
    extends MouseAdapter
    implements MouseMotionListener {
        private MouseListener() {
        }

        @Override
        public void mousePressed(final MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    TimelineSelectionManager.this.mousePanningBackup = TimelineSelectionManager.this.chart.isMousePanningEnabled();
                    TimelineSelectionManager.this.setSelectionMode(TimelineSelectionManager.this.dragMode);
                    if (TimelineSelectionManager.this.selectionMode != 0) {
                        TimelineSelectionManager.this.chart.disableMousePanning();
                        TimelineSelectionManager.this.setSelectionBounds(null);
                        TimelineSelectionManager.this.setSelectionBounds(e.getX(), e.getY(), 0, 0);
                    }
                }
            });
        }

        @Override
        public void mouseReleased(final MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    TimelineSelectionManager.this.setSelectionMode(TimelineSelectionManager.this.moveMode);
                    if (TimelineSelectionManager.this.selectionMode == 0) {
                        TimelineSelectionManager.this.chart.setMousePanningEnabled(TimelineSelectionManager.this.mousePanningBackup);
                    }
                }
            });
        }

        @Override
        public void mouseClicked(final MouseEvent e) {
            if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (TimelineSelectionManager.this.selectionMode != 0) {
                        TimelineSelectionManager.this.setSelectionBounds(e.getX(), e.getY(), 0, 0);
                    }
                }
            });
        }

        @Override
        public void mouseEntered(final MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineSelectionManager.this.inChart = true;
                    TimelineSelectionManager.this.mouseX = e.getX();
                    TimelineSelectionManager.this.mouseY = e.getY();
                }
            });
        }

        @Override
        public void mouseExited(MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineSelectionManager.this.inChart = false;
                    TimelineSelectionManager.this.updateHighlightedItems();
                }
            });
        }

        @Override
        public void mouseDragged(final MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!TimelineSelectionManager.this.enabled || !SwingUtilities.isLeftMouseButton(e)) {
                        return;
                    }
                    if (TimelineSelectionManager.this.selectionMode == 4) {
                        TimelineSelectionManager.this.setSelectionBounds(((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.x, ((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.y, e.getX() - ((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.x, e.getY() - ((TimelineSelectionManager)TimelineSelectionManager.this).selectionBounds.y);
                    }
                }
            });
        }

        @Override
        public void mouseMoved(final MouseEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TimelineSelectionManager.this.mouseX = e.getX();
                    TimelineSelectionManager.this.mouseY = e.getY();
                    if (TimelineSelectionManager.this.selectionMode == 0) {
                        TimelineSelectionManager.this.setSelectionBounds(null);
                    }
                    TimelineSelectionManager.this.updateHighlightedItems();
                }
            });
        }
    }
}

