/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.timeline;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.ChartPanel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.ProbesPanel;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineChart;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSelectionManager;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;

public final class TimelinePanel
extends JPanel {
    private final ChartPanel chartPanel;
    private final RowMouseHandler mouseHandler;

    public TimelinePanel(TimelineSupport support) {
        super(new BorderLayout());
        this.setOpaque(false);
        ProbesPanel probesPanel = new ProbesPanel(support);
        this.chartPanel = new ChartPanel(support.getChart(), support);
        this.add((Component)probesPanel, "West");
        this.add((Component)this.chartPanel, "Center");
        new ProbesWheelHandler(this.chartPanel, probesPanel).register();
        this.mouseHandler = new RowMouseHandler(support, probesPanel);
        this.mouseHandler.register();
    }

    public void reset() {
        this.chartPanel.resetChart();
        this.resetSelection();
    }

    public void resetSelection() {
        this.chartPanel.resetSelection();
    }

    public void updateActions() {
        this.chartPanel.updateActions();
    }

    public Action zoomInAction() {
        return this.chartPanel.zoomInAction();
    }

    public Action zoomOutAction() {
        return this.chartPanel.zoomOutAction();
    }

    public Action toggleViewAction() {
        return this.chartPanel.toggleViewAction();
    }

    public AbstractButton mouseZoom() {
        return this.chartPanel.mouseZoom();
    }

    public AbstractButton mouseHScroll() {
        return this.chartPanel.mouseHScroll();
    }

    public AbstractButton mouseVScroll() {
        return this.chartPanel.mouseVScroll();
    }

    private static class ProbesWheelHandler
    implements MouseWheelListener {
        private final ChartPanel chartPanel;
        private final ProbesPanel probesPanel;

        ProbesWheelHandler(ChartPanel chartPanel, ProbesPanel probesPanel) {
            this.chartPanel = chartPanel;
            this.probesPanel = probesPanel;
        }

        void register() {
            this.probesPanel.addMouseWheelListener(this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.chartPanel.vScroll(e);
        }
    }

    private static class RowMouseHandler
    extends MouseAdapter {
        private static final int RESIZE_RANGE = 3;
        private final TimelineSupport support;
        private final TimelineChart chart;
        private TimelineSelectionManager selection;
        private final ProbesPanel probesPanel;
        private int baseY;
        private int baseHeight;
        private TimelineChart.Row draggingRow;

        RowMouseHandler(TimelineSupport support, ProbesPanel probesPanel) {
            this.support = support;
            this.chart = support.getChart();
            this.selection = (TimelineSelectionManager)this.chart.getSelectionModel();
            this.probesPanel = probesPanel;
        }

        void register() {
            this.chart.addMouseListener(this);
            this.chart.addMouseMotionListener(this);
            this.probesPanel.getMouseTarget().addMouseListener(this);
            this.probesPanel.getMouseTarget().addMouseMotionListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.updateRowState(e, SwingUtilities.isLeftMouseButton(e));
            this.chart.updateSelection(false, this);
            this.selection.setEnabled(this.draggingRow == null);
            this.updateCursor();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            this.chart.updateSelection(true, this);
            if (this.draggingRow == null && e.getSource() == this.chart) {
                this.support.indexSelectionChanged(this.selection.getStartIndex(), this.selection.getEndIndex());
            }
            this.updateRowState(e, false);
            this.updateCursor();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RowMouseHandler.this.selection.setEnabled(true);
                }
            });
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.updateRowState(e, false);
            this.updateCursor();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (!SwingUtilities.isLeftMouseButton(e)) {
                return;
            }
            if (this.draggingRow != null) {
                boolean checkStep = (e.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0;
                this.chart.setRowHeight(this.draggingRow.getIndex(), this.baseHeight + e.getY() - this.baseY, checkStep);
            }
        }

        private void updateRowState(MouseEvent e, boolean updateSelection) {
            this.baseY = e.getY();
            this.draggingRow = this.chart.getNearestRow(this.baseY, 3, true);
            if (this.draggingRow != null) {
                this.baseHeight = this.draggingRow.getHeight();
            }
        }

        private void updateCursor() {
            if (this.draggingRow != null) {
                Cursor resizeCursor = Cursor.getPredefinedCursor(9);
                this.chart.setCursor(resizeCursor);
                this.probesPanel.setCursor(resizeCursor);
            } else {
                Cursor defaultCursor = Cursor.getDefaultCursor();
                this.chart.setCursor(defaultCursor);
                this.probesPanel.setCursor(defaultCursor);
            }
        }
    }
}

