/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Component;
import java.text.NumberFormat;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public abstract class CustomComboRenderer
implements ListCellRenderer {
    private final JComboBox combo;
    private final ListCellRenderer renderer;
    private final JLabel rendererL;

    private CustomComboRenderer(JComboBox combo) {
        this.combo = combo;
        this.renderer = combo.getRenderer();
        this.rendererL = this.renderer instanceof JLabel ? (JLabel)((Object)this.renderer) : null;
        this.combo.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.repaint();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                this.repaint();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.repaint();
            }

            private void repaint() {
                CustomComboRenderer.this.combo.repaint();
            }
        });
    }

    protected void setupRenderer(ListCellRenderer renderer, boolean popupVisible) {
    }

    protected void setupRenderer(JLabel renderer, boolean popupVisible) {
    }

    public abstract java.lang.String value(Object var1);

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (this.rendererL != null) {
            this.setupRenderer(this.rendererL, this.combo.isPopupVisible());
        } else {
            this.setupRenderer(this.renderer, this.combo.isPopupVisible());
        }
        return this.renderer.getListCellRendererComponent(list, this.value(value), index, isSelected, cellHasFocus);
    }

    public static final class Boolean
    extends CustomComboRenderer {
        public Boolean(JComboBox combo) {
            super(combo);
        }

        @Override
        public java.lang.String value(Object value) {
            if (java.lang.Boolean.TRUE.equals(value)) {
                return "enabled";
            }
            if (java.lang.Boolean.FALSE.equals(value)) {
                return "disabled";
            }
            return "default";
        }
    }

    public static final class Number
    extends CustomComboRenderer {
        private final java.lang.String units;
        private final boolean lAlign;

        public Number(JComboBox combo, java.lang.String units, boolean lAlign) {
            super(combo);
            this.units = units;
            this.lAlign = lAlign;
        }

        @Override
        protected void setupRenderer(JLabel renderer, boolean popupVisible) {
            if (popupVisible || !this.lAlign) {
                renderer.setHorizontalAlignment(11);
            } else {
                renderer.setHorizontalAlignment(10);
            }
        }

        @Override
        public java.lang.String value(Object value) {
            java.lang.String sunits = this.units == null ? "" : " " + this.units;
            return Integer.valueOf(-1).equals(value) ? "default" : NumberFormat.getInstance().format(value) + sunits;
        }
    }

    public static final class String
    extends CustomComboRenderer {
        public String(JComboBox combo) {
            super(combo);
        }

        @Override
        public java.lang.String value(Object value) {
            return value == null ? "null" : value.toString();
        }
    }
}

