/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.modules.profiler.CPUSnapshotPanel;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.snaptracer.TracerPackage;
import org.netbeans.modules.profiler.snaptracer.impl.Bundle;
import org.netbeans.modules.profiler.snaptracer.impl.TimelineView;
import org.netbeans.modules.profiler.snaptracer.impl.TracerController;
import org.netbeans.modules.profiler.snaptracer.impl.TracerModel;
import org.netbeans.modules.profiler.snaptracer.impl.TracerSupportImpl;
import org.netbeans.modules.profiler.snaptracer.impl.timeline.TimelineSupport;
import org.openide.util.Exceptions;

final class TracerView {
    private static List<WeakReference<TracerView>> views = new ArrayList<WeakReference<TracerView>>();
    private final TracerModel model;
    private final TracerController controller;
    private LoadedSnapshot lsF;
    private TimelineView timelineView;
    private FindMethodAction findMethod;

    TracerView(TracerModel model, TracerController controller) {
        this.model = model;
        this.controller = controller;
        this.findMethod = new FindMethodAction();
    }

    protected JComponent createComponent() {
        final JPanel component = new JPanel(new BorderLayout());
        this.timelineView = new TimelineView(this.model);
        JPanel timelinePanel = new JPanel(new BorderLayout());
        timelinePanel.add((Component)this.timelineView.getView(), "Center");
        timelinePanel.add((Component)new JSeparator(), "South");
        final JPanel container = new JPanel(null){

            @Override
            public void doLayout() {
                Component[] components;
                for (Component component : components = this.getComponents()) {
                    component.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return this.getComponent(this.getComponentCount() - 1).getPreferredSize();
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMinimumSize();
            }

            @Override
            public Dimension getMaximumSize() {
                return this.getComponent(this.getComponentCount() - 1).getMaximumSize();
            }

            @Override
            public boolean isOptimizedDrawingEnabled() {
                return false;
            }
        };
        JPanel glass = new JPanel(null);
        glass.setOpaque(false);
        glass.setCursor(Cursor.getPredefinedCursor(3));
        glass.addMouseListener(new MouseAdapter(){});
        glass.addMouseMotionListener(new MouseMotionAdapter(){});
        glass.addKeyListener(new KeyAdapter(){});
        container.add(glass);
        container.add(timelinePanel);
        component.add((Component)container, "North");
        TracerSupportImpl.getInstance().perform(new Runnable(){

            @Override
            public void run() {
                TracerView.this.initProbes();
                TracerView.this.initTimeline();
                TracerView.this.initData(component, container);
                TracerView.this.initListeners(component);
            }
        });
        return component;
    }

    private void initProbes() {
        List<TracerPackage> packages = TracerSupportImpl.getInstance().getPackages(this.model.getSnapshot());
        for (TracerPackage p : packages) {
            this.model.addDescriptors(p, p.getProbeDescriptors());
        }
    }

    private void initTimeline() {
        TimelineSupport support = this.model.getTimelineSupport();
        long start = this.model.firstTimestamp();
        if (start == -1L) {
            return;
        }
        long end = this.model.lastTimestamp();
        if (end == -1L) {
            return;
        }
        support.dataLoadingStarted(end - start);
    }

    private void initData(final JPanel component, final JPanel container) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JLabel progress = new JLabel(Bundle.MSG_LoadingSnapshot(), 0);
                progress.setCursor(Cursor.getPredefinedCursor(3));
                TracerView.addContents(component, progress);
                TracerSupportImpl.getInstance().perform(new Runnable(){

                    @Override
                    public void run() {
                        TracerView.this.controller.performSession();
                        TracerView.this.controller.performAfterSession(new Runnable(){

                            @Override
                            public void run() {
                                TimelineSupport support = TracerView.this.model.getTimelineSupport();
                                support.dataLoadingFinished();
                                support.selectAll();
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        TracerView.this.timelineView.updateActions();
                                    }
                                });
                                component.remove(container);
                                component.add(container.getComponent(1), "North");
                                component.revalidate();
                                component.repaint();
                            }
                        });
                    }
                });
            }
        });
    }

    private void initListeners(final JPanel component) {
        final TimelineSupport support = this.model.getTimelineSupport();
        support.addSelectionListener(new TimelineSupport.SelectionListener(){

            @Override
            public void intervalsSelectionChanged() {
            }

            @Override
            public void indexSelectionChanged() {
                final int startIndex = Math.min(support.getStartIndex(), support.getEndIndex());
                final int endIndex = Math.max(support.getStartIndex(), support.getEndIndex());
                JLabel progress = new JLabel(Bundle.MSG_ProcessingSelection(), 0);
                TracerView.addContents(component, progress);
                TracerView.this.controller.performAfterSession(new Runnable(){

                    @Override
                    public void run() {
                        if (startIndex == endIndex) {
                            TracerView.this.displayThreadDump(component, startIndex);
                        } else {
                            TracerView.this.displaySnapshot(component, startIndex, endIndex);
                        }
                    }
                });
            }

            @Override
            public void timeSelectionChanged(boolean timestampsSelected, boolean justHovering) {
            }
        });
    }

    private void displaySnapshot(final JPanel p, int s1, int s2) {
        LoadedSnapshot ls = null;
        try {
            ls = this.model.getSnapshot().getCPUSnapshot(s1, s2);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.lsF = ls;
        if (this.lsF != null) {
            TracerView.register(this);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SnapshotResultsWindow w = new SnapshotResultsWindow(TracerView.this.lsF, 1, false);
                    TracerView.addContents(p, (JComponent)w);
                }
            });
        }
    }

    private void displayThreadDump(final JPanel p, int s) {
        String td = null;
        try {
            td = this.model.getSnapshot().getThreadDump(s);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        final String tdF = td;
        if (tdF != null) {
            this.lsF = null;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HTMLTextArea a = new HTMLTextArea(tdF){

                        protected void showURL(URL url) {
                            if (url == null) {
                                return;
                            }
                            String urls = url.toString();
                            TracerView.this.showURL(urls);
                        }
                    };
                    a.setCaretPosition(0);
                    JScrollPane sp = new JScrollPane((Component)a);
                    sp.setBorder(BorderFactory.createEmptyBorder());
                    sp.setViewportBorder(BorderFactory.createEmptyBorder());
                    TracerView.addContents(p, sp);
                }
            });
        }
    }

    private static void addContents(JComponent container, JComponent contents) {
        BorderLayout layout = (BorderLayout)container.getLayout();
        Component oldContents = layout.getLayoutComponent("Center");
        if (oldContents != null) {
            container.remove(oldContents);
        }
        container.add((Component)contents, "Center");
        container.revalidate();
        container.repaint();
    }

    void showURL(String urls) {
        if (urls.startsWith("file:/stackframe/")) {
            urls = urls.substring("file:/stackframe/".length());
            String[] parts = urls.split("\\|");
            String className = parts[0];
            String method = parts[1];
            int linenumber = Integer.parseInt(parts[2]);
            GoToSource.openSource(null, (String)className, (String)method, (int)linenumber);
        }
    }

    private static void register(TracerView view) {
        views.add(new WeakReference<TracerView>(view));
    }

    private static TracerView getTracerView(LoadedSnapshot ls) {
        Iterator<WeakReference<TracerView>> it = views.iterator();
        while (it.hasNext()) {
            TracerView view = (TracerView)it.next().get();
            if (view == null) {
                it.remove();
                continue;
            }
            if (view.lsF != ls) continue;
            return view;
        }
        return null;
    }

    public static final class CCTEnhancer
    implements CPUSnapshotPanel.CCTPopupEnhancer {
        public void enhancePopup(JPopupMenu popup, LoadedSnapshot snapshot, CCTDisplay cctDisplay) {
            TracerView tv = TracerView.getTracerView(snapshot);
            if (tv != null) {
                tv.findMethod.enhancePopup(popup, cctDisplay);
            }
        }

        public void enableDisablePopup(LoadedSnapshot snapshot, PrestimeCPUCCTNode node) {
            TracerView tv = TracerView.getTracerView(snapshot);
            if (tv != null) {
                tv.findMethod.enableDisablePopup(node);
            }
        }
    }

    private class FindMethodAction
    extends AbstractAction {
        private CCTDisplay cctDisplay;
        private PrestimeCPUCCTNode node;

        private FindMethodAction() {
            super(Bundle.LBL_FindMethod());
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            assert (this.cctDisplay != null);
            try {
                List<Integer> ints = TracerView.this.model.getIntervals(this.node);
                assert (ints.size() % 2 == 0);
                System.out.println("Intervals " + ints.toString());
                TimelineSupport support = TracerView.this.model.getTimelineSupport();
                support.resetSelectedIntervals();
                Iterator<Integer> iter = ints.iterator();
                while (iter.hasNext()) {
                    int start = iter.next();
                    int stop = iter.next();
                    support.selectInterval(start, stop);
                }
                support.selectedIntervalsChanged();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private void enhancePopup(JPopupMenu popup, CCTDisplay cctd) {
            popup.add(new JPopupMenu.Separator());
            popup.add(new JMenuItem(TracerView.this.findMethod));
            this.cctDisplay = cctd;
        }

        private boolean isRegular(PrestimeCPUCCTNode n) {
            return n.getThreadId() != -1 && n.getMethodId() > 0 && !n.isFilteredNode();
        }

        private void enableDisablePopup(PrestimeCPUCCTNode n) {
            this.node = n;
            this.setEnabled(this.isRegular(this.node));
        }
    }
}

