/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.spiimpl.pm;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.java.hints.providers.spi.HintDescription;
import org.netbeans.modules.java.hints.spiimpl.Utilities;
import org.netbeans.modules.java.hints.spiimpl.pm.NFABasedBulkSearch;

public abstract class BulkSearch {
    private static final BulkSearch INSTANCE = new NFABasedBulkSearch();
    private final boolean requiresLightweightVerification;

    public static BulkSearch getDefault() {
        return INSTANCE;
    }

    protected BulkSearch(boolean requiresLightweightVerification) {
        this.requiresLightweightVerification = requiresLightweightVerification;
    }

    public final Map<String, Collection<TreePath>> match(CompilationInfo info, TreePath toSearch, BulkPattern pattern) {
        return this.match(info, toSearch, pattern, null);
    }

    public final boolean requiresLightweightVerification() {
        return this.requiresLightweightVerification;
    }

    public abstract Map<String, Collection<TreePath>> match(CompilationInfo var1, TreePath var2, BulkPattern var3, Map<String, Long> var4);

    public abstract boolean matches(InputStream var1, BulkPattern var2);

    public abstract Map<String, Integer> matchesWithFrequencies(InputStream var1, BulkPattern var2);

    public abstract boolean matches(CompilationInfo var1, TreePath var2, BulkPattern var3);

    public abstract void encode(Tree var1, EncodingContext var2);

    public final BulkPattern create(CompilationInfo info, String ... code) {
        return this.create(info, Arrays.asList(code));
    }

    public final BulkPattern create(CompilationInfo info, Collection<? extends String> code) {
        LinkedList<Tree> patterns = new LinkedList<Tree>();
        LinkedList<HintDescription.AdditionalQueryConstraints> additionalConstraints = new LinkedList<HintDescription.AdditionalQueryConstraints>();
        for (String string : code) {
            patterns.add(Utilities.parseAndAttribute(info, string, null));
            additionalConstraints.add(HintDescription.AdditionalQueryConstraints.empty());
        }
        return this.create(code, patterns, additionalConstraints);
    }

    public abstract BulkPattern create(Collection<? extends String> var1, Collection<? extends Tree> var2, Collection<? extends HintDescription.AdditionalQueryConstraints> var3);

    public static abstract class BulkPattern {
        private final List<? extends String> patterns;
        private final List<? extends Set<? extends String>> identifiers;
        private final List<List<List<String>>> requiredContent;
        private final List<HintDescription.AdditionalQueryConstraints> additionalConstraints;

        public BulkPattern(List<? extends String> patterns, List<? extends Set<? extends String>> identifiers, List<List<List<String>>> requiredContent, List<HintDescription.AdditionalQueryConstraints> additionalConstraints) {
            this.patterns = patterns;
            this.identifiers = identifiers;
            this.requiredContent = requiredContent;
            this.additionalConstraints = additionalConstraints;
        }

        public List<? extends String> getPatterns() {
            return this.patterns;
        }

        public List<? extends Set<? extends String>> getIdentifiers() {
            return this.identifiers;
        }

        public List<List<List<String>>> getRequiredContent() {
            return this.requiredContent;
        }

        public List<HintDescription.AdditionalQueryConstraints> getAdditionalConstraints() {
            return this.additionalConstraints;
        }
    }

    public static final class EncodingContext {
        private final OutputStream out;
        private final boolean forDuplicates;
        private Set<? extends String> identifiers;
        private List<String> content;

        public EncodingContext(OutputStream out, boolean forDuplicates) {
            this.out = out;
            this.forDuplicates = forDuplicates;
        }

        public Set<? extends String> getIdentifiers() {
            return this.identifiers;
        }

        public OutputStream getOut() {
            return this.out;
        }

        public boolean isForDuplicates() {
            return this.forDuplicates;
        }

        public void setIdentifiers(Set<? extends String> identifiers) {
            this.identifiers = identifiers;
        }

        public void setContent(List<String> content) {
            this.content = content;
        }

        public List<String> getContent() {
            return this.content;
        }
    }
}

