/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.code;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.spi.java.hints.CustomizerProvider;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;

public class ReflectiveCustomizerProvider
implements CustomizerProvider {
    private final String hintClassName;
    private final String hintId;
    private final List<OptionDescriptor> options;

    public ReflectiveCustomizerProvider(String hintClassName, String hintId, List<OptionDescriptor> options) {
        this.hintClassName = hintClassName;
        this.hintId = hintId;
        this.options = options;
    }

    @Override
    public JComponent getCustomizer(Preferences prefs) {
        return new CustomizerImpl(prefs, this.hintClassName, this.hintId, this.options);
    }

    private static final class CustomizerImpl
    extends JPanel {
        public CustomizerImpl(Preferences prefs, String hintClassName, String hintId, List<OptionDescriptor> options) {
            try {
                this.setLayout(new GridBagLayout());
                int c = 0;
                for (OptionDescriptor option : options) {
                    JCheckBox checkBox = new JCheckBox();
                    Mnemonics.setLocalizedText((AbstractButton)checkBox, (String)option.displayName);
                    checkBox.setToolTipText(option.tooltip);
                    checkBox.addActionListener(new ActionListenerImpl(checkBox, option.preferencesKey, prefs));
                    checkBox.setSelected(prefs.getBoolean(option.preferencesKey, option.defaultValue));
                    GridBagConstraints constraints = new GridBagConstraints();
                    constraints.anchor = 18;
                    constraints.fill = 2;
                    constraints.gridheight = 1;
                    constraints.gridwidth = 1;
                    constraints.gridx = 0;
                    constraints.gridy = c++;
                    constraints.weightx = 1.0;
                    constraints.weighty = 0.0;
                    this.add((Component)checkBox, constraints);
                }
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.anchor = 18;
                constraints.fill = 1;
                constraints.gridheight = 1;
                constraints.gridwidth = 1;
                constraints.gridx = 0;
                constraints.gridy = c++;
                constraints.weightx = 1.0;
                constraints.weighty = 1.0;
                this.add((Component)new JPanel(), constraints);
            }
            catch (IllegalArgumentException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (SecurityException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }

        private static final class ActionListenerImpl
        implements ActionListener {
            private final JCheckBox checkBox;
            private final String key;
            private final Preferences prefs;

            public ActionListenerImpl(JCheckBox checkBox, String key, Preferences prefs) {
                this.checkBox = checkBox;
                this.key = key;
                this.prefs = prefs;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.prefs.putBoolean(this.key, this.checkBox.isSelected());
            }
        }
    }

    public static final class OptionDescriptor {
        public final String preferencesKey;
        public final boolean defaultValue;
        public final String displayName;
        public final String tooltip;

        public OptionDescriptor(String preferencesKey, boolean defaultValue, String displayName, String tooltip) {
            this.preferencesKey = preferencesKey;
            this.defaultValue = defaultValue;
            this.displayName = displayName;
            this.tooltip = tooltip;
        }
    }
}

