/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.providers.code;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.hints.providers.code.CodeHintProviderImpl;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class FSWrapper {
    private static final Object MARKER = new Object();

    public static Iterable<? extends ClassWrapper> listClasses() {
        ClassLoader loader = FSWrapper.class.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        LinkedList<ClassWrapper> result = new LinkedList<ClassWrapper>();
        FileObject main = FileUtil.getConfigFile((String)"org-netbeans-modules-java-hints/code-hints/");
        if (main != null) {
            for (FileObject c : main.getChildren()) {
                result.add(new ClassWrapper(loader, c));
            }
        }
        return result;
    }

    public static Method resolveMethod(String className, String methodName) throws NoSuchMethodException, ClassNotFoundException {
        Class<?> clazz = CodeHintProviderImpl.findLoader().loadClass(className);
        return clazz.getDeclaredMethod(methodName, HintContext.class);
    }

    private static Object computeAttributeValue(ClassLoader loader, FileObject folder, String attributeName, Class<?> returnType, Object defaulValue) throws ClassNotFoundException {
        Class<?> result = folder.getAttribute(attributeName);
        if (result == null) {
            FileObject embedded = folder.getFileObject(attributeName);
            if (embedded == null) {
                result = defaulValue;
            } else if (returnType.isArray()) {
                Object val;
                LinkedList<Object> items = new LinkedList<Object>();
                int c = 0;
                while ((val = FSWrapper.computeAttributeValue(loader, embedded, "item" + c, returnType.getComponentType(), MARKER)) != MARKER) {
                    items.add(val);
                    ++c;
                }
                Object res = Array.newInstance(returnType.getComponentType(), items.size());
                int ci = 0;
                for (Object e : items) {
                    Array.set(res, ci++, e);
                }
                result = res;
            } else if (returnType.isAnnotation()) {
                result = FSWrapper.loadAnnotation(loader, embedded.getChildren()[0]);
            }
        } else if (returnType.isEnum()) {
            String fqn = (String)((Object)result);
            int lastDot = fqn.lastIndexOf(46);
            Class<?> enumClass = loader.loadClass(fqn.substring(0, lastDot));
            result = Enum.valueOf(enumClass, fqn.substring(lastDot + 1));
        } else if (returnType == Class.class) {
            String fqn = (String)((Object)result);
            try {
                result = loader.loadClass(fqn);
            }
            catch (ClassNotFoundException ex) {
                Logger.getLogger(FSWrapper.class.getName()).log(Level.FINE, null, ex);
                result = CodeHintProviderImpl.findLoader().loadClass(fqn);
            }
        }
        return result;
    }

    private static <T extends Annotation> T loadAnnotation(ClassLoader l, FileObject annotationFolder) throws ClassNotFoundException {
        Class<?> clazz = l.loadClass(annotationFolder.getName().replace('-', '.'));
        return (T)((Annotation)Proxy.newProxyInstance(l, new Class[]{clazz}, (InvocationHandler)new InvocationHandlerImpl(l, annotationFolder)));
    }

    public static class AnnotatableWrapper {
        protected final ClassLoader loader;
        protected final FileObject folder;
        private final Map<Class<? extends Annotation>, Annotation> annotations = new HashMap<Class<? extends Annotation>, Annotation>();

        protected AnnotatableWrapper(ClassLoader loader, FileObject folder) {
            this.loader = loader;
            this.folder = folder;
        }

        public synchronized <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
            if (!this.annotations.containsKey(annotationClass)) {
                FileObject f = this.folder.getFileObject(annotationClass.getName().replace('.', '-') + ".annotation");
                Annotation result = null;
                if (f != null) {
                    try {
                        Annotation a = FSWrapper.loadAnnotation(this.loader, f);
                        result = (Annotation)annotationClass.cast(a);
                    }
                    catch (ClassNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                this.annotations.put(annotationClass, result);
            }
            return (T)((Annotation)annotationClass.cast(this.annotations.get(annotationClass)));
        }
    }

    public static class ClassWrapper
    extends AnnotatableWrapper {
        private final String className;
        private Iterable<? extends MethodWrapper> methods;
        private Iterable<? extends FieldWrapper> fields;
        private Class<?> clazz;

        public ClassWrapper(ClassLoader loader, FileObject folder) {
            super(loader, folder);
            this.className = folder.getName().replace('-', '.');
        }

        public synchronized Iterable<? extends MethodWrapper> getMethods() {
            if (this.methods == null) {
                LinkedList<? extends MethodWrapper> methods = new LinkedList<MethodWrapper>();
                for (FileObject c : this.folder.getChildren()) {
                    if (!c.getExt().equals("method")) continue;
                    methods.add(new MethodWrapper(this.loader, c, this));
                }
                this.methods = methods;
            }
            return this.methods;
        }

        public synchronized Iterable<? extends FieldWrapper> getFields() {
            if (this.fields == null) {
                LinkedList<? extends FieldWrapper> fields = new LinkedList<FieldWrapper>();
                for (FileObject c : this.folder.getChildren()) {
                    if (!c.getExt().equals("field")) continue;
                    fields.add(new FieldWrapper(this.loader, c, this));
                }
                this.fields = fields;
            }
            return this.fields;
        }

        public String getName() {
            return this.className;
        }

        public synchronized Class<?> getDeclaredClass() {
            if (this.clazz != null) {
                return this.clazz;
            }
            try {
                this.clazz = this.loader.loadClass(this.className);
                return this.clazz;
            }
            catch (ClassNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }

    public static class FieldWrapper
    extends AnnotatableWrapper {
        private final ClassWrapper clazz;

        public FieldWrapper(ClassLoader loader, FileObject folder, ClassWrapper clazz) {
            super(loader, folder);
            this.clazz = clazz;
        }

        ClassWrapper getClazz() {
            return this.clazz;
        }

        String getName() {
            return this.folder.getName();
        }

        String getConstantValue() {
            Object constantValue = this.folder.getAttribute("constantValue");
            if (constantValue instanceof String) {
                return (String)constantValue;
            }
            return null;
        }
    }

    private static final class InvocationHandlerImpl
    implements InvocationHandler {
        private final ClassLoader loader;
        private final FileObject folder;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        public InvocationHandlerImpl(ClassLoader loader, FileObject folder) {
            this.loader = loader;
            this.folder = folder;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (!this.attributes.containsKey(method.getName())) {
                Object result = FSWrapper.computeAttributeValue(this.loader, this.folder, method.getName(), method.getReturnType(), method.getDefaultValue());
                this.attributes.put(method.getName(), result);
            }
            return this.attributes.get(method.getName());
        }
    }

    public static class MethodWrapper
    extends AnnotatableWrapper {
        private final ClassWrapper clazz;

        public MethodWrapper(ClassLoader loader, FileObject folder, ClassWrapper clazz) {
            super(loader, folder);
            this.clazz = clazz;
        }

        ClassWrapper getClazz() {
            return this.clazz;
        }

        String getName() {
            return this.folder.getName();
        }
    }
}

