/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans.addproperty;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.netbeans.modules.beans.addproperty.AddPropertyConfig;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class AddPropertyGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generate(AddPropertyConfig addPropertyConfig) {
        FileObject template;
        ScriptEngine scriptEngine = AddPropertyGenerator.getScriptEngine();
        if (scriptEngine != null && (template = AddPropertyGenerator.getTemplateFileObject(addPropertyConfig.getTEMPLATE_PATH())) != null && template.isValid()) {
            String type = addPropertyConfig.getType().trim();
            String name = addPropertyConfig.getName().trim();
            String initializer = addPropertyConfig.getInitializer().trim();
            String access = "";
            switch (addPropertyConfig.getAccess()) {
                case PRIVATE: {
                    access = "private ";
                    break;
                }
                case PROTECTED: {
                    access = "protected ";
                    break;
                }
                case PUBLIC: {
                    access = "public ";
                    break;
                }
                default: {
                    access = "";
                }
            }
            ScriptContext scriptContext = scriptEngine.getContext();
            StringWriter writer = new StringWriter();
            scriptContext.setWriter(writer);
            scriptContext.setAttribute(FileObject.class.getName(), template, 100);
            scriptContext.setAttribute("javax.script.filename", template.getNameExt(), 100);
            scriptContext.setAttribute("access", access, 100);
            scriptContext.setAttribute("type", type, 100);
            scriptContext.setAttribute("className", addPropertyConfig.getClassName(), 100);
            scriptContext.setAttribute("name", name, 100);
            scriptContext.setAttribute("initializer", initializer, 100);
            scriptContext.setAttribute("capitalizedName", AddPropertyGenerator.capitalize(name), 100);
            scriptContext.setAttribute("static", addPropertyConfig.isStatic(), 100);
            scriptContext.setAttribute("final", addPropertyConfig.isFinale(), 100);
            AddPropertyConfig.GENERATE generateGetterSetter = addPropertyConfig.getGenerateGetterSetter();
            scriptContext.setAttribute("generateGetter", generateGetterSetter == AddPropertyConfig.GENERATE.GETTER_AND_SETTER || generateGetterSetter == AddPropertyConfig.GENERATE.GETTER, 100);
            scriptContext.setAttribute("generateSetter", generateGetterSetter == AddPropertyConfig.GENERATE.GETTER_AND_SETTER || generateGetterSetter == AddPropertyConfig.GENERATE.SETTER, 100);
            scriptContext.setAttribute("generateJavadoc", addPropertyConfig.isGenerateJavadoc(), 100);
            scriptContext.setAttribute("bound", addPropertyConfig.isBound(), 100);
            scriptContext.setAttribute("PROP_NAME", addPropertyConfig.getPopName().trim(), 100);
            scriptContext.setAttribute("vetoable", addPropertyConfig.isVetoable(), 100);
            scriptContext.setAttribute("indexed", addPropertyConfig.isIndexed(), 100);
            scriptContext.setAttribute("propertyChangeSupport", addPropertyConfig.getPropertyChangeSupportName(), 100);
            scriptContext.setAttribute("vetoableChangeSupport", addPropertyConfig.getVetoableChangeSupportName(), 100);
            scriptContext.setAttribute("generatePropertyChangeSupport", addPropertyConfig.isGeneratePropertyChangeSupport(), 100);
            scriptContext.setAttribute("generateVetoablePropertyChangeSupport", addPropertyConfig.isGenerateVetoableChangeSupport(), 100);
            InputStreamReader templateReader = null;
            try {
                templateReader = new InputStreamReader(template.getInputStream());
                scriptEngine.eval(templateReader);
                String string = writer.toString();
                return string;
            }
            catch (ScriptException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                if (templateReader != null) {
                    try {
                        ((Reader)templateReader).close();
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
        return "/*Error*/";
    }

    private static FileObject getTemplateFileObject(String templatePath) {
        return FileUtil.getConfigFile((String)templatePath);
    }

    private static ScriptEngine getScriptEngine() {
        return new ScriptEngineManager().getEngineByName("freemarker");
    }

    private static String capitalize(String string) {
        char charAtZero;
        if (string == null) {
            return null;
        }
        if (string.length() > 0 && Character.isLowerCase(charAtZero = string.charAt(0))) {
            string = Character.toUpperCase(charAtZero) + string.substring(1);
        }
        return string;
    }
}

