/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.IntrospectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.beans.BeanPanelUI;
import org.netbeans.modules.beans.BeanUtils;
import org.netbeans.modules.beans.ClassPattern;
import org.netbeans.modules.beans.EventSetPattern;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.Pattern;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.TmpPattern;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class PatternAnalyser {
    private BeanPanelUI ui;
    private FileObject fileObject;
    private ElementHandle<TypeElement> classElementHandle;
    private ArrayList<ClassPattern> currentClassesPatterns = new ArrayList();
    private ArrayList<PropertyPattern> currentPropertyPatterns = new ArrayList();
    private ArrayList<IdxPropertyPattern> currentIdxPropertyPatterns = new ArrayList();
    private ArrayList<EventSetPattern> currentEventSetPatterns = new ArrayList();
    final AtomicBoolean canceled = new AtomicBoolean();
    private boolean deepIntrospection = false;
    static final Logger LOG = Logger.getLogger(PatternAnalyser.class.getName());

    public PatternAnalyser(FileObject fileObject, BeanPanelUI ui) {
        this(fileObject, ui, false);
    }

    public PatternAnalyser(FileObject fileObject, BeanPanelUI ui, boolean deepIntrospection) {
        this.fileObject = fileObject;
        this.ui = ui;
        this.deepIntrospection = deepIntrospection;
    }

    public PatternAnalyser(FileObject fileObject, BeanPanelUI ui, Collection<ClassPattern> classes) {
        this(fileObject, ui);
        this.currentClassesPatterns.addAll(classes);
    }

    public List<PropertyPattern> getPropertyPatterns() {
        return this.currentPropertyPatterns;
    }

    public List<IdxPropertyPattern> getIdxPropertyPatterns() {
        return this.currentIdxPropertyPatterns;
    }

    public List<EventSetPattern> getEventSetPatterns() {
        return this.currentEventSetPatterns;
    }

    public List<Pattern> getPatterns() {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>(this.currentClassesPatterns.size() + this.currentEventSetPatterns.size() + this.currentIdxPropertyPatterns.size() + this.currentIdxPropertyPatterns.size());
        patterns.addAll(this.currentPropertyPatterns);
        patterns.addAll(this.currentIdxPropertyPatterns);
        patterns.addAll(this.currentEventSetPatterns);
        patterns.addAll(this.currentClassesPatterns);
        return patterns;
    }

    public ElementHandle<TypeElement> getClassElementHandle() {
        return this.classElementHandle;
    }

    public BeanPanelUI getUI() {
        return this.ui;
    }

    public FileObject getFileObject() {
        return this.fileObject;
    }

    public void analyzeAll(CompilationInfo ci, TypeElement element) {
        if (this.isCanceled()) {
            return;
        }
        Parameters p = new Parameters(ci, element);
        this.classElementHandle = ElementHandle.create((Element)element);
        this.resolveMethods(p);
        this.resolveFields(p);
        this.resolveTypes(p);
        try {
            this.resolveChangesOfProperties(p);
            this.resolveChangesOfIdxProperties(p);
            this.resolveChangesOfEventSets(p);
        }
        catch (IntrospectionException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCanceled() {
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            return this.canceled.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        AtomicBoolean atomicBoolean = this.canceled;
        synchronized (atomicBoolean) {
            this.canceled.set(true);
        }
    }

    private void resolveTypes(Parameters p) {
        List<TypeElement> types = ElementFilter.typesIn(p.element.getEnclosedElements());
        for (TypeElement typeElement : types) {
            if (typeElement.getKind() != ElementKind.CLASS && typeElement.getKind() != ElementKind.INTERFACE) continue;
            PatternAnalyser pa = new PatternAnalyser(p.ci.getFileObject(), this.ui);
            pa.analyzeAll(p.ci, typeElement);
            ClassPattern cp = new ClassPattern(pa, typeElement.asType(), BeanUtils.nameAsString(typeElement));
            this.currentClassesPatterns.add(cp);
        }
    }

    private void resolveMethods(Parameters p) {
        List<? extends ExecutableElement> methods = this.methodsIn(p.element, p.ci);
        HashMap<String, ExecutableElement> adds = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> removes = new HashMap<String, ExecutableElement>();
        for (ExecutableElement executableElement : methods) {
            TmpPattern.Property pp;
            if (!executableElement.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
            String name = BeanUtils.nameAsString(executableElement);
            int len = name.length();
            if ((name.startsWith("get") && len > "get".length() || name.startsWith("set") && len > "set".length() || name.startsWith("is") && len > "is".length()) && (pp = this.analyseMethodForProperties(p, executableElement)) != null) {
                this.addProperty(p, pp);
            }
            if ((!name.startsWith("add") || len <= "add".length()) && (!name.startsWith("remove") || len <= "remove".length())) continue;
            this.analyseMethodForEventSets(p, executableElement, adds, removes);
        }
        for (String string : adds.keySet()) {
            if (removes.get(string) == null || string.indexOf("Listener:") <= 0) continue;
            ExecutableElement addMethod = (ExecutableElement)adds.get(string);
            ExecutableElement removeMethod = (ExecutableElement)removes.get(string);
            List<? extends VariableElement> params = addMethod.getParameters();
            TypeMirror argType = params.get(0).asType();
            if (argType.getKind() != TypeKind.DECLARED || !p.ci.getTypes().isSubtype(argType, p.ci.getElements().getTypeElement("java.util.EventListener").asType())) continue;
            TmpPattern.EventSet esp = new TmpPattern.EventSet(p.ci, addMethod, removeMethod);
            this.addEventSet(p, esp);
        }
    }

    private List<? extends ExecutableElement> methodsIn(TypeElement clazz, CompilationInfo javac) {
        return this.deepIntrospection ? BeanUtils.methodsIn(clazz, javac) : ElementFilter.methodsIn(clazz.getEnclosedElements());
    }

    private void resolveFields(Parameters p) {
        List<VariableElement> fields = ElementFilter.fieldsIn(p.element.getEnclosedElements());
        String propertyStyle = "this.";
        for (VariableElement field : fields) {
            TypeMirror ppType;
            TmpPattern.Property pp;
            if (field.getModifiers().contains((Object)Modifier.STATIC)) continue;
            String fieldName = BeanUtils.nameAsString(field);
            if (fieldName.startsWith(propertyStyle)) {
                fieldName = fieldName.substring(1);
            }
            if ((pp = (TmpPattern.Property)p.propertyPatterns.get(fieldName)) == null) {
                pp = (TmpPattern.Property)p.idxPropertyPatterns.get(fieldName);
            }
            if (pp == null || (ppType = pp.type) == null || !((Object)ppType).equals(field.asType())) continue;
            pp.estimatedField = field;
        }
    }

    TmpPattern.Property analyseMethodForProperties(Parameters p, ExecutableElement method) {
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            return null;
        }
        String name = BeanUtils.nameAsString(method);
        VariableElement[] params = method.getParameters().toArray(new VariableElement[0]);
        TypeMirror returnType = method.getReturnType();
        TmpPattern.Property pp = null;
        try {
            if (params.length == 0) {
                if (name.startsWith("get")) {
                    pp = new TmpPattern.Property(p.ci, method, null);
                } else if (returnType.getKind() == TypeKind.BOOLEAN && name.startsWith("is")) {
                    pp = new TmpPattern.Property(p.ci, method, null);
                }
            } else if (params.length == 1) {
                if (params[0].asType().getKind() == TypeKind.INT) {
                    if (name.startsWith("get")) {
                        pp = new TmpPattern.IdxProperty(p.ci, null, null, method, null);
                    } else if (returnType.getKind() == TypeKind.BOOLEAN && name.startsWith("is")) {
                        pp = new TmpPattern.IdxProperty(p.ci, null, null, method, null);
                    } else if (returnType.getKind() == TypeKind.VOID && name.startsWith("set")) {
                        pp = new TmpPattern.Property(p.ci, null, method);
                    }
                } else if (returnType.getKind() == TypeKind.VOID && name.startsWith("set")) {
                    pp = new TmpPattern.Property(p.ci, null, method);
                }
            } else if (params.length == 2 && params[0].asType().getKind() == TypeKind.INT && name.startsWith("set")) {
                pp = new TmpPattern.IdxProperty(p.ci, null, null, null, method);
            }
        }
        catch (IntrospectionException ex) {
            LOG.log(Level.INFO, ex.getMessage(), ex);
            pp = null;
        }
        return pp;
    }

    void analyseMethodForEventSets(Parameters p, ExecutableElement method, Map<String, ExecutableElement> adds, Map<String, ExecutableElement> removes) {
        TypeMirror paramType;
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            return;
        }
        String name = BeanUtils.nameAsString(method);
        VariableElement[] params = method.getParameters().toArray(new VariableElement[0]);
        TypeMirror returnType = method.getReturnType();
        if (params.length == 1 && returnType.getKind() == TypeKind.VOID && (paramType = params[0].asType()).getKind() == TypeKind.DECLARED) {
            Element lsnrType = p.ci.getTypes().asElement(paramType);
            String lsnrTypeName = BeanUtils.nameAsString(lsnrType);
            if (name.startsWith("add") && name.substring(3).equals(lsnrTypeName)) {
                String compound = name.substring(3) + ":" + BeanUtils.nameAsString(lsnrType);
                adds.put(compound, method);
            } else if (name.startsWith("remove") && name.substring(6).equals(lsnrTypeName)) {
                String compound = name.substring(6) + ":" + BeanUtils.nameAsString(lsnrType);
                removes.put(compound, method);
            }
        }
    }

    private void addProperty(Parameters p, TmpPattern.Property property) {
        boolean isIndexed = property instanceof TmpPattern.IdxProperty;
        HashMap hm = isIndexed ? p.idxPropertyPatterns : p.propertyPatterns;
        String name = property.name;
        TmpPattern.Property old = (TmpPattern.Property)p.propertyPatterns.get(name);
        if (old == null) {
            old = (TmpPattern.Property)p.idxPropertyPatterns.get(name);
        }
        if (old == null) {
            hm.put(name, property);
            return;
        }
        TypeMirror opt = old.type;
        TypeMirror npt = property.type;
        if (opt != null && npt != null && !p.ci.getTypes().isSameType(opt, npt)) {
            hm.put(name, property);
            return;
        }
        boolean isOldIndexed = old instanceof TmpPattern.IdxProperty;
        if (isIndexed || isOldIndexed) {
            if (isIndexed && !isOldIndexed) {
                p.propertyPatterns.remove(old.name);
            } else if (!isIndexed && isOldIndexed) {
                p.idxPropertyPatterns.remove(old.name);
            }
            TmpPattern.IdxProperty composite = new TmpPattern.IdxProperty(p.ci, old, property);
            p.idxPropertyPatterns.put(name, composite);
        } else {
            TmpPattern.Property composite = new TmpPattern.Property(p.ci, old, property);
            p.propertyPatterns.put(name, composite);
        }
    }

    private void addEventSet(Parameters p, TmpPattern.EventSet eventSet) {
        String key = eventSet.name + p.ci.getTypes().asElement(eventSet.type).getSimpleName();
        TmpPattern.EventSet old = (TmpPattern.EventSet)p.eventSetPatterns.get(key);
        if (old == null) {
            p.eventSetPatterns.put(key, eventSet);
            return;
        }
        TmpPattern.EventSet composite = new TmpPattern.EventSet(old, eventSet);
        p.eventSetPatterns.put(key, composite);
    }

    private void resolveChangesOfProperties(Parameters p) throws IntrospectionException {
        this.currentPropertyPatterns = new ArrayList(p.propertyPatterns.size());
        for (TmpPattern.Property property : p.propertyPatterns.values()) {
            this.currentPropertyPatterns.add(property.createPattern(this));
        }
        Collections.sort(this.currentPropertyPatterns, Pattern.NAME_COMPARATOR);
    }

    private void resolveChangesOfIdxProperties(Parameters p) throws IntrospectionException {
        this.currentIdxPropertyPatterns = new ArrayList(p.idxPropertyPatterns.size());
        for (TmpPattern.IdxProperty property : p.idxPropertyPatterns.values()) {
            this.currentIdxPropertyPatterns.add(property.createPattern(this));
        }
        Collections.sort(this.currentIdxPropertyPatterns, Pattern.NAME_COMPARATOR);
    }

    private void resolveChangesOfEventSets(Parameters p) {
        this.currentEventSetPatterns = new ArrayList(p.eventSetPatterns.size());
        for (TmpPattern.EventSet property : p.eventSetPatterns.values()) {
            this.currentEventSetPatterns.add(property.createPattern(this));
        }
        Collections.sort(this.currentEventSetPatterns, Pattern.NAME_COMPARATOR);
    }

    private static class Parameters {
        private CompilationInfo ci;
        private TypeElement element;
        private HashMap<String, TmpPattern.Property> propertyPatterns;
        private HashMap<String, TmpPattern.IdxProperty> idxPropertyPatterns;
        private HashMap<String, TmpPattern.EventSet> eventSetPatterns;

        Parameters(CompilationInfo ci, TypeElement element) {
            this.ci = ci;
            this.element = element;
            this.propertyPatterns = new HashMap();
            this.idxPropertyPatterns = new HashMap();
            this.eventSetPatterns = new HashMap();
        }
    }
}

