/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.utils.MiscUtils;
import org.netbeans.lib.profiler.utils.formatting.Formattable;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.j2ee.Bundle;
import org.netbeans.modules.profiler.j2ee.WebProjectUtils;
import org.netbeans.modules.profiler.j2ee.impl.ServerJavaPlatform;
import org.netbeans.modules.profiler.nbimpl.project.JavaProjectProfilingSupportProvider;
import org.netbeans.modules.profiler.nbimpl.project.ProjectUtilities;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public final class J2EEProjectProfilingSupportProvider
extends JavaProjectProfilingSupportProvider {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.profiler.j2ee");
    private static int lastAgentID = -1;
    private static int lastAgentPort = 5140;

    public J2EEProjectProfilingSupportProvider(Project project) {
        super(project);
    }

    public static int getLastAgentID() {
        return lastAgentID;
    }

    public static int getLastAgentPort() {
        return lastAgentPort;
    }

    public static void resetLastValues() {
        lastAgentID = -1;
        lastAgentPort = -1;
    }

    public static String getServerInstanceID(Project project) {
        J2eeModuleProvider serverInstanceModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (serverInstanceModuleProvider == null) {
            return null;
        }
        return serverInstanceModuleProvider.getServerInstanceID();
    }

    public org.netbeans.modules.profiler.api.JavaPlatform resolveProjectJavaPlatform() {
        String serverInstanceID = J2EEProjectProfilingSupportProvider.getServerInstanceID(this.getProject());
        if (serverInstanceID == null) {
            return null;
        }
        return ServerJavaPlatform.getPlatform(serverInstanceID);
    }

    private static org.netbeans.modules.profiler.api.JavaPlatform getServerJavaPlatform(String serverInstanceID) {
        J2eePlatform j2eePlatform = J2EEProjectProfilingSupportProvider.getJ2eePlatform(serverInstanceID);
        if (j2eePlatform == null) {
            return null;
        }
        JavaPlatform jp = j2eePlatform.getJavaPlatform();
        if (jp == null) {
            return null;
        }
        return org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)((String)jp.getProperties().get("platform.ant.name")));
    }

    public boolean checkProjectCanBeProfiled(FileObject profiledClassFile) {
        if (!this.isProfilingSupported()) {
            return false;
        }
        J2eePlatform j2eePlatform = J2EEProjectProfilingSupportProvider.getJ2eePlatform(this.getProject());
        if (j2eePlatform == null) {
            ProfilerDialogs.displayError((String)Bundle.J2EEProjectTypeProfiler_NoServerFoundMsg());
            return false;
        }
        if (!j2eePlatform.supportsProfiling()) {
            ProfilerDialogs.displayWarning((String)Bundle.J2EEProjectTypeProfiler_ProfilingNotSupportedMsg());
            return false;
        }
        if (profiledClassFile == null) {
            return true;
        }
        return this.isFileObjectSupported(profiledClassFile);
    }

    public boolean isFileObjectSupported(FileObject file) {
        Project project = this.getProject();
        return WebProjectUtils.isJSP(file) && WebProjectUtils.isWebDocumentSource(file, project) || WebProjectUtils.isHttpServlet(file) && WebProjectUtils.isWebJavaSource(file, project) && WebProjectUtils.isMappedServlet(file, project, true) || super.isFileObjectSupported(file);
    }

    public void configurePropertiesForProfiling(Map<String, String> props, FileObject profiledClassFile) {
        Project project = this.getProject();
        this.initAntPlatform(project, props);
        props.put("profiler.j2ee.serverForceRestart", "true");
        props.put("profiler.j2ee.serverStartupTimeout", "300000");
        props.put("profiler.j2ee.agentID", "-Dnbprofiler.agentid=" + new Integer(J2EEProjectProfilingSupportProvider.generateAgentID()).toString());
    }

    public static int generateAgentID() {
        int newAgentID = J2EEProjectProfilingSupportProvider.generateAgentNumber();
        while (newAgentID == lastAgentID) {
            newAgentID = J2EEProjectProfilingSupportProvider.generateAgentNumber();
        }
        lastAgentID = newAgentID;
        return J2EEProjectProfilingSupportProvider.getLastAgentID();
    }

    public static org.netbeans.modules.profiler.api.JavaPlatform generateAgentJavaPlatform(String serverInstanceID) {
        return ServerJavaPlatform.getPlatform(serverInstanceID);
    }

    public static int generateAgentPort() {
        lastAgentPort = ProfilerIDESettings.getInstance().getPortNo();
        return J2EEProjectProfilingSupportProvider.getLastAgentPort();
    }

    public void setupProjectSessionSettings(SessionSettings ss) {
        Project project = this.getProject();
        PropertyEvaluator pp = this.getProjectProperties(project);
        ss.setMainClass("");
        String appArgs = pp.getProperty("application.args");
        ss.setMainArgs(appArgs != null ? appArgs : "");
        String runCP = pp.getProperty("build.classes.dir");
        ss.setMainClassPath(runCP != null ? MiscUtils.getAbsoluteFilePath((String)runCP, (String)FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath()) : "");
        ss.setJVMArgs("");
        ss.setWorkingDir("");
        super.setupProjectSessionSettings(ss);
    }

    public boolean supportsSettingsOverride() {
        return true;
    }

    public boolean supportsUnintegrate() {
        return true;
    }

    public void unintegrateProfiler() {
        ProjectUtilities.unintegrateProfiler((Project)this.getProject());
    }

    private static J2eePlatform getJ2eePlatform(Project project) {
        String serverInstanceID = J2EEProjectProfilingSupportProvider.getServerInstanceID(project);
        if (serverInstanceID == null) {
            return null;
        }
        return J2EEProjectProfilingSupportProvider.getJ2eePlatform(serverInstanceID);
    }

    private static J2eePlatform getJ2eePlatform(String serverInstanceID) {
        return Deployment.getDefault().getJ2eePlatform(serverInstanceID);
    }

    private static org.netbeans.modules.profiler.api.JavaPlatform getJavaPlatformFromAntName(Project project, Map<String, String> props) {
        String javaPlatformAntName = props.get("profiler.info.javaPlatform");
        if (javaPlatformAntName.equals("default_platform")) {
            return org.netbeans.modules.profiler.api.JavaPlatform.getDefaultPlatform();
        }
        return org.netbeans.modules.profiler.api.JavaPlatform.getJavaPlatformById((String)javaPlatformAntName);
    }

    private static int generateAgentNumber() {
        return (int)(Math.random() * 2.147483648E9);
    }

    private void initAntPlatform(Project project, Map<String, String> props) {
        String javaPlatformAntName = props.get("profiler.info.javaPlatform");
        if (javaPlatformAntName == null) {
            org.netbeans.modules.profiler.api.JavaPlatform platform = this.getProjectJavaPlatform();
            String platformId = platform == null ? org.netbeans.modules.profiler.api.JavaPlatform.getDefaultPlatform().getPlatformId() : platform.getPlatformId();
            props.put("profiler.info.javaPlatform", platformId);
        }
    }

    private PropertyEvaluator getProjectProperties(Project project) {
        final Properties privateProps = new Properties();
        final Properties projectProps = new Properties();
        final Properties userPropsProps = new Properties();
        final FileObject privatePropsFile = project.getProjectDirectory().getFileObject("nbproject/private/private.properties");
        final FileObject projectPropsFile = project.getProjectDirectory().getFileObject("nbproject/project.properties");
        final File userPropsFile = InstalledFileLocator.getDefault().locate("build.properties", null, false);
        ProjectManager.mutex().readAccess(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                InputStream is;
                if (privatePropsFile != null) {
                    try {
                        is = privatePropsFile.getInputStream();
                        try {
                            privateProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (projectPropsFile != null) {
                    try {
                        is = projectPropsFile.getInputStream();
                        try {
                            projectProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
                if (userPropsFile != null) {
                    try {
                        is = new BufferedInputStream(new FileInputStream(userPropsFile));
                        try {
                            userPropsProps.load(is);
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (IOException e) {
                        err.notify(1, (Throwable)e);
                    }
                }
            }
        });
        PropertyEvaluator pe = PropertyUtils.sequentialPropertyEvaluator(null, (PropertyProvider[])new PropertyProvider[]{new MyPropertyProvider(privateProps), new MyPropertyProvider(userPropsProps), new MyPropertyProvider(projectProps)});
        return pe;
    }

    private void addJspMarker(MethodMarker marker, Mark mark, Project project) {
        ClientUtils.SourceCodeSelection[] jspmethods = WebProjectUtils.getJSPRootMethods(project, true);
        if (jspmethods != null) {
            for (int i = 0; i < jspmethods.length; ++i) {
                marker.addMethodMark(jspmethods[i].getClassName(), jspmethods[i].getMethodName(), jspmethods[i].getMethodSignature(), mark);
            }
        }
    }

    private static class JSPNameFormatter
    implements MethodNameFormatter {
        private JSPNameFormatter() {
        }

        public Formattable formatMethodName(final ClientUtils.SourceCodeSelection sourceCodeSelection) {
            return new Formattable(){

                public String toFormatted() {
                    String name = WebProjectUtils.getJSPPath(sourceCodeSelection);
                    return name;
                }
            };
        }

        public Formattable formatMethodName(final String className, final String methodName, final String signature) {
            return new Formattable(){

                public String toFormatted() {
                    ClientUtils.SourceCodeSelection tmpSelection = new ClientUtils.SourceCodeSelection(className, methodName, signature);
                    String name = WebProjectUtils.getJSPPath(tmpSelection);
                    return name;
                }
            };
        }
    }

    private static class MyPropertyProvider
    implements PropertyProvider {
        private Properties props;

        private MyPropertyProvider(Properties props) {
            this.props = props;
        }

        public Map getProperties() {
            return this.props;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

