/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.netbeans.modules.hudson.spi.HudsonSCM;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.actions.Bundle;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

class Hyperlinker {
    private static final Logger LOG = Logger.getLogger(Hyperlinker.class.getName());
    private final HudsonLogger.HudsonLogSession[] sessions;

    public Hyperlinker(HudsonJob job) {
        ArrayList<HudsonLogger.HudsonLogSession> _sessions = new ArrayList<HudsonLogger.HudsonLogSession>();
        for (HudsonLogger logger : Lookup.getDefault().lookupAll(HudsonLogger.class)) {
            _sessions.add(logger.createSession(job));
        }
        this.sessions = _sessions.toArray(new HudsonLogger.HudsonLogSession[_sessions.size()]);
    }

    public void handleLine(String line, OutputWriter stream) {
        for (HudsonLogger.HudsonLogSession session : this.sessions) {
            if (session.handle(line, stream)) break;
        }
    }

    private static class Hyperlink
    implements OutputListener {
        private static final RequestProcessor RP = new RequestProcessor(Hyperlink.class);
        private final HudsonJob job;
        private final String path;
        private final String message;
        private final int row;
        private final int col;

        public Hyperlink(HudsonJob job, String path, String message, int row, int col) {
            this.job = job;
            this.path = path;
            this.message = message;
            this.row = row;
            this.col = col;
        }

        public void outputLineAction(OutputEvent ev) {
            this.acted(true);
        }

        public void outputLineSelected(OutputEvent ev) {
            this.acted(false);
        }

        private void acted(final boolean force) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    FileObject f = null;
                    Project p = ProjectHudsonProvider.getDefault().findAssociatedProject(ProjectHudsonProvider.Association.forJob(Hyperlink.this.job));
                    if (p != null) {
                        String localPath = null;
                        File localRoot = FileUtil.toFile((FileObject)p.getProjectDirectory());
                        if (localRoot != null) {
                            for (HudsonSCM scm : Lookup.getDefault().lookupAll(HudsonSCM.class)) {
                                localPath = scm.translateWorkspacePath(Hyperlink.this.job, Hyperlink.this.path, localRoot);
                                if (localPath == null) continue;
                                LOG.log(Level.FINE, "Translating remote path {0} to {1} using {2}", new Object[]{Hyperlink.this.path, localPath, scm});
                                break;
                            }
                        }
                        if (localPath == null) {
                            LOG.fine("Falling back to guess that remote workspace is a project root");
                            localPath = Hyperlink.this.path;
                        }
                        f = p.getProjectDirectory().getFileObject(localPath);
                        LOG.log(Level.FINE, "Tried to find local file in {0} at {1} using {2}", new Object[]{p, f, localPath});
                    }
                    if (f == null) {
                        StatusDisplayer.getDefault().setStatusText(Bundle.Hyperlinker_looking_for(Hyperlink.this.path));
                        f = Hyperlink.this.job.getRemoteWorkspace().findResource(Hyperlink.this.path);
                        LOG.log(Level.FINE, "Tried to find remote file at {0} using {1}", new Object[]{f, Hyperlink.this.path});
                    }
                    if (f == null) {
                        if (force) {
                            StatusDisplayer.getDefault().setStatusText(Bundle.Hyperlinker_not_found(Hyperlink.this.path));
                            Toolkit.getDefaultToolkit().beep();
                        }
                        return;
                    }
                    StatusDisplayer.getDefault().setStatusText(Hyperlink.this.message);
                    HudsonLogger.Helper.openAt(f, Hyperlink.this.row, Hyperlink.this.col, force);
                }
            });
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public String toString() {
            return this.path + ":" + this.row + ":" + this.col + ":" + this.message;
        }
    }

    public static final class PlainLogger
    implements HudsonLogger {
        @Override
        public HudsonLogger.HudsonLogSession createSession(final HudsonJob job) {
            return new HudsonLogger.HudsonLogSession(){
                final PlainLoggerLogic logic;
                {
                    this.logic = new PlainLoggerLogic(job, job.getName());
                }

                @Override
                public boolean handle(String line, OutputWriter stream) {
                    OutputListener link = this.logic.findHyperlink(line);
                    if (link != null) {
                        try {
                            stream.println(line, link);
                            return true;
                        }
                        catch (IOException x) {
                            LOG.log(Level.INFO, null, x);
                        }
                    }
                    stream.println(line);
                    return true;
                }
            };
        }
    }

    static class PlainLoggerLogic {
        private static final Pattern REMOTE_URL = Pattern.compile("\\b(https?://[^\\s)>]+)");
        private final HudsonJob job;
        private final Pattern hyperlinkable;

        PlainLoggerLogic(HudsonJob job, String jobName) {
            this.job = job;
            String jobNameQ = Pattern.quote(jobName);
            this.hyperlinkable = Pattern.compile("\\s*(?:\\[.+\\] )?/.+?/(?:jobs/" + jobNameQ + "/workspace|workspace/" + jobNameQ + ")/([^:]+):(?:\\[?([0-9]+)[:,](?:([0-9]+)[]:])?)? (?:warning: )?(.+)");
        }

        OutputListener findHyperlink(String line) {
            try {
                Matcher m = this.hyperlinkable.matcher(line);
                if (m.matches()) {
                    String path = m.group(1);
                    int row = m.group(2) != null ? Integer.parseInt(m.group(2)) - 1 : -1;
                    int col = m.group(3) != null ? Integer.parseInt(m.group(3)) - 1 : -1;
                    String message = m.group(4);
                    return new Hyperlink(this.job, path, message, row, col);
                }
                m = REMOTE_URL.matcher(line);
                if (m.matches()) {
                    return new URLHyperlink(new URL(m.group()));
                }
            }
            catch (MalformedURLException x) {
                LOG.log(Level.FINE, null, x);
            }
            return null;
        }
    }

    private static class URLHyperlink
    implements OutputListener {
        private final URL u;

        URLHyperlink(URL u) {
            this.u = u;
        }

        public void outputLineAction(OutputEvent ev) {
            HtmlBrowser.URLDisplayer.getDefault().showURL(this.u);
        }

        public void outputLineSelected(OutputEvent ev) {
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        public String toString() {
            return this.u.toString();
        }
    }
}

