/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.netbeans.modules.hudson.spi.ProjectHudsonProvider;
import org.netbeans.modules.hudson.ui.actions.ProjectRenderer;
import org.netbeans.modules.hudson.ui.wizard.InstanceDialog;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class CreateJobPanel
extends JPanel
implements ChangeListener {
    private Set<String> takenNames;
    private NotificationLineSupport notifications;
    private DialogDescriptor descriptor;
    private Set<Project> manuallyAddedProjects = new HashSet<Project>();
    ProjectHudsonJobCreatorFactory.ProjectHudsonJobCreator creator;
    HudsonInstance instance;
    private JButton addServer;
    private JButton browse;
    private JPanel custom;
    private JLabel explanationLabel;
    private JTextField name;
    private JLabel nameLabel;
    private JComboBox project;
    private JLabel projectLabel;
    private JComboBox server;
    private JLabel serverLabel;

    CreateJobPanel() {
    }

    void init(DialogDescriptor descriptor, HudsonInstance instance) {
        this.descriptor = descriptor;
        this.notifications = descriptor.createNotificationLineSupport();
        this.initComponents();
        this.updateServerModel();
        this.instance = instance;
        this.server.setSelectedItem(instance);
        this.server.setRenderer(new ServerRenderer());
        this.updateProjectModel();
        this.project.setSelectedItem(this.project.getItemCount() > 0 ? this.project.getItemAt(0) : null);
        this.project.setRenderer(new ProjectRenderer());
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                CreateJobPanel.this.check();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                CreateJobPanel.this.check();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.project.requestFocusInWindow();
        this.check();
    }

    private void check() {
        JButton button;
        ProjectHudsonJobCreatorFactory.ConfigurationStatus status;
        this.descriptor.setValid(false);
        this.notifications.clearMessages();
        if (this.instance == null) {
            this.notifications.setInformationMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.pick_server"));
            return;
        }
        Project p = this.selectedProject();
        if (p == null) {
            this.notifications.setInformationMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.pick_project"));
            return;
        }
        if (this.creator == null) {
            this.notifications.setErrorMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.unknown_project_type"));
            return;
        }
        if (this.takenNames.contains(this.name())) {
            this.notifications.setErrorMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.name_taken"));
            return;
        }
        if (ProjectHudsonProvider.getDefault().findAssociation(p) != null) {
            this.notifications.setWarningMessage(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.already_associated"));
        }
        if ((status = this.creator.status()).getErrorMessage() != null) {
            this.notifications.setErrorMessage(status.getErrorMessage());
            return;
        }
        if (status.getWarningMessage() != null) {
            this.notifications.setWarningMessage(status.getWarningMessage());
        }
        if ((button = status.getExtraButton()) != null) {
            this.descriptor.setAdditionalOptions(new Object[]{button});
            this.descriptor.setClosingOptions(new Object[]{button, NotifyDescriptor.CANCEL_OPTION});
        } else {
            this.descriptor.setAdditionalOptions(new Object[0]);
            this.descriptor.setClosingOptions(new Object[]{NotifyDescriptor.CANCEL_OPTION});
        }
        this.descriptor.setValid(true);
    }

    String name() {
        return this.name.getText();
    }

    Project selectedProject() {
        return (Project)this.project.getSelectedItem();
    }

    private void updateServerModel() {
        this.server.setModel(new DefaultComboBoxModel<Object>(HudsonManagerImpl.getDefault().getInstances().toArray()));
    }

    private void computeTakenNames() {
        this.takenNames = new HashSet<String>();
        if (this.instance != null) {
            for (HudsonJob job : this.instance.getJobs()) {
                this.takenNames.add(job.getName());
            }
        }
    }

    private void updateProjectModel() {
        TreeSet<Project> projects = new TreeSet<Project>(ProjectRenderer.comparator());
        projects.addAll(Arrays.asList(OpenProjects.getDefault().getOpenProjects()));
        projects.addAll(this.manuallyAddedProjects);
        this.project.setModel(new DefaultComboBoxModel<Project>(projects.toArray(new Project[projects.size()])));
    }

    private void initComponents() {
        this.serverLabel = new JLabel();
        this.server = new JComboBox();
        this.addServer = new JButton();
        this.nameLabel = new JLabel();
        this.name = new JTextField();
        this.projectLabel = new JLabel();
        this.project = new JComboBox();
        this.browse = new JButton();
        this.custom = new JPanel();
        this.explanationLabel = new JLabel();
        this.serverLabel.setLabelFor(this.server);
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.serverLabel.text"));
        this.server.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateJobPanel.this.serverActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.addServer, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.addServer.text"));
        this.addServer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateJobPanel.this.addServerActionPerformed(evt);
            }
        });
        this.nameLabel.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.nameLabel.text"));
        this.projectLabel.setLabelFor(this.project);
        Mnemonics.setLocalizedText((JLabel)this.projectLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.projectLabel.text"));
        this.project.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateJobPanel.this.projectActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.browse.text"));
        this.browse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CreateJobPanel.this.browseActionPerformed(evt);
            }
        });
        this.custom.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((JLabel)this.explanationLabel, (String)NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.explanationLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.explanationLabel, -1, 511, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.serverLabel).addComponent(this.nameLabel).addComponent(this.projectLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, GroupLayout.Alignment.TRAILING, -1, 278, Short.MAX_VALUE).addComponent(this.project, GroupLayout.Alignment.TRAILING, 0, 278, Short.MAX_VALUE).addComponent(this.server, 0, 278, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.addServer, -1, -1, Short.MAX_VALUE).addComponent(this.browse, -1, -1, Short.MAX_VALUE))).addComponent(this.custom, GroupLayout.Alignment.LEADING, -1, 511, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverLabel).addComponent(this.server, -2, -1, -2).addComponent(this.addServer)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.name, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLabel).addComponent(this.project, -2, -1, -2).addComponent(this.browse)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.custom, -2, 241, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.explanationLabel).addContainerGap()));
        this.server.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.server.AccessibleContext.accessibleDescription"));
        this.addServer.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.addServer.AccessibleContext.accessibleDescription"));
        this.name.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.name.AccessibleContext.accessibleDescription"));
        this.project.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.project.AccessibleContext.accessibleDescription"));
        this.browse.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.browse.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CreateJobPanel.class, (String)"CreateJobPanel.AccessibleContext.accessibleDescription"));
    }

    private void browseActionPerformed(ActionEvent evt) {
        FileObject d;
        JFileChooser chooser = ProjectChooser.projectChooser();
        chooser.showOpenDialog(this);
        File dir = chooser.getSelectedFile();
        if (dir != null && (d = FileUtil.toFileObject((File)dir)) != null) {
            try {
                Project p = ProjectManager.getDefault().findProject(d);
                if (p != null) {
                    this.manuallyAddedProjects.add(p);
                    this.updateProjectModel();
                    this.project.setSelectedItem(p);
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
        }
    }

    private void projectActionPerformed(ActionEvent evt) {
        if (this.creator != null) {
            this.creator.removeChangeListener(this);
        }
        this.creator = null;
        Project p = this.selectedProject();
        if (p == null) {
            this.check();
            return;
        }
        if (p.getClass().getName().equals("org.netbeans.modules.project.ui.LazyProject")) {
            this.updateProjectModel();
            this.project.setSelectedItem(null);
            return;
        }
        for (ProjectHudsonJobCreatorFactory factory : Lookup.getDefault().lookupAll(ProjectHudsonJobCreatorFactory.class)) {
            this.creator = factory.forProject(p);
            if (this.creator == null) continue;
            break;
        }
        if (this.creator == null) {
            this.check();
            return;
        }
        this.name.setText(this.creator.jobName());
        this.custom.removeAll();
        this.custom.add(this.creator.customizer());
        this.creator.addChangeListener(this);
        this.check();
    }

    private void serverActionPerformed(ActionEvent evt) {
        this.instance = (HudsonInstance)this.server.getSelectedItem();
        this.computeTakenNames();
        this.check();
    }

    private void addServerActionPerformed(ActionEvent evt) {
        HudsonInstance created = new InstanceDialog().show();
        if (created != null) {
            this.updateServerModel();
            this.instance = created;
            this.server.setSelectedItem(this.instance);
            this.check();
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.check();
    }

    private static class ServerRenderer
    extends DefaultListCellRenderer {
        private ServerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value == null || value instanceof String) {
                return super.getListCellRendererComponent((JList<?>)list, (Object)null, index, isSelected, cellHasFocus);
            }
            return super.getListCellRendererComponent((JList<?>)list, ((HudsonInstance)value).getName(), index, isSelected, cellHasFocus);
        }
    }
}

