/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.apache.commons.net.util.Base64;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.impl.HudsonManagerImpl;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.netbeans.modules.hudson.ui.Bundle;
import org.netbeans.modules.hudson.ui.FormLogin;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class APITokenConnectionAuthenticator
extends JPanel {
    private static final Logger LOG = Logger.getLogger(APITokenConnectionAuthenticator.class.getName());
    private static final Map<String, String> BASIC_AUTH = new HashMap<String, String>();
    private JTextField locationField;
    private JLabel locationLabel;
    private JButton tokButton;
    private JPasswordField tokField;
    private JLabel tokLabel;
    private JTextField userField;
    private JLabel userLabel;

    private APITokenConnectionAuthenticator() {
        this.initComponents();
    }

    private void initComponents() {
        this.locationLabel = new JLabel();
        this.locationField = new JTextField();
        this.userLabel = new JLabel();
        this.userField = new JTextField();
        this.tokLabel = new JLabel();
        this.tokField = new JPasswordField();
        this.tokButton = new JButton();
        this.locationLabel.setLabelFor(this.locationField);
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(APITokenConnectionAuthenticator.class, (String)"APITokenConnectionAuthenticator.locationLabel.text"));
        this.locationField.setEditable(false);
        this.userLabel.setLabelFor(this.userField);
        Mnemonics.setLocalizedText((JLabel)this.userLabel, (String)NbBundle.getMessage(APITokenConnectionAuthenticator.class, (String)"APITokenConnectionAuthenticator.userLabel.text"));
        this.tokLabel.setLabelFor(this.tokField);
        Mnemonics.setLocalizedText((JLabel)this.tokLabel, (String)NbBundle.getMessage(APITokenConnectionAuthenticator.class, (String)"APITokenConnectionAuthenticator.tokLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.tokButton, (String)NbBundle.getMessage(APITokenConnectionAuthenticator.class, (String)"APITokenConnectionAuthenticator.tokButton.text"));
        this.tokButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                APITokenConnectionAuthenticator.this.tokButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.locationLabel).addGap(36, 36, 36).addComponent(this.locationField, -1, 279, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tokLabel).addComponent(this.userLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.userField, -1, 277, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.tokField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tokButton))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.locationLabel).addComponent(this.locationField, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userField, -2, -1, -2).addComponent(this.userLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tokLabel).addComponent(this.tokField, -2, -1, -2).addComponent(this.tokButton)).addContainerGap()));
    }

    private void tokButtonActionPerformed(ActionEvent evt) {
        try {
            HtmlBrowser.URLDisplayer.getDefault().showURLExternal(new URL(this.locationField.getText() + "user/" + Utilities.uriEncode(this.userField.getText()) + "/configure"));
        }
        catch (MalformedURLException x) {
            LOG.log(Level.INFO, null, x);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        (this.userField.getText().length() > 0 ? this.tokField : this.userField).requestFocus();
    }

    public static final class Impl
    implements ConnectionAuthenticator {
        @Override
        public void prepareRequest(URLConnection conn, URL home) {
            String auth = (String)BASIC_AUTH.get(home.toString());
            if (auth != null) {
                LOG.log(Level.FINER, "have basic auth for {0}", home);
                conn.setRequestProperty("Authorization", "Basic " + auth);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public URLConnection forbidden(URLConnection conn, URL home) {
            String version = conn.getHeaderField("X-Jenkins");
            if (version == null) {
                if (conn.getHeaderField("X-Hudson") != null) {
                    LOG.log(Level.FINE, "disabled on non-Jenkins server {0}", home);
                    return null;
                }
                LOG.log(Level.FINE, "neither Hudson nor Jenkins headers on {0}, assuming might be Jenkins", home);
            } else {
                if (new HudsonVersion(version).compareTo(new HudsonVersion("1.426")) < 0) {
                    LOG.log(Level.FINE, "disabled on old ({0}) Jenkins server {1}", new Object[]{version, home});
                    return null;
                }
                LOG.log(Level.FINE, "enabled on {0}", home);
            }
            APITokenConnectionAuthenticator panel = new APITokenConnectionAuthenticator();
            String server = HudsonManagerImpl.simplifyServerLocation(home.toString(), true);
            String key = "tok." + server;
            String username = FormLogin.loginPrefs().get(server, null);
            if (username != null) {
                panel.userField.setText(username);
                char[] savedToken = Keyring.read((String)key);
                if (savedToken != null) {
                    panel.tokField.setText(new String(savedToken));
                }
            }
            panel.locationField.setText(home.toString());
            DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.FormLogin_log_in());
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            username = panel.userField.getText();
            LOG.log(Level.FINE, "trying token for {0} on {1}", new Object[]{username, home});
            FormLogin.loginPrefs().put(server, username);
            String token = new String(panel.tokField.getPassword());
            panel.tokField.setText("");
            Keyring.save((String)key, (char[])token.toCharArray(), (String)Bundle.APITokenConnectionAuthenticator_password_description(home, username));
            BASIC_AUTH.put(home.toString(), new Base64().encodeToString((username + ':' + token).getBytes()).trim());
            try {
                return conn.getURL().openConnection();
            }
            catch (IOException x) {
                LOG.log(Level.FINE, null, x);
                return null;
            }
        }
    }
}

