/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.spi;

import java.awt.BorderLayout;
import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.spi.Bundle;
import org.netbeans.modules.hudson.spi.HudsonJobChangeItem;
import org.netbeans.modules.hudson.spi.ProjectHudsonJobCreatorFactory;
import org.openide.awt.StatusDisplayer;
import org.openide.windows.TopComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public interface HudsonSCM {
    public Configuration forFolder(File var1);

    public String translateWorkspacePath(HudsonJob var1, String var2, File var3);

    public List<? extends HudsonJobChangeItem> parseChangeSet(HudsonJobBuild var1);

    public static interface Configuration {
        public void configure(Document var1);

        public ProjectHudsonJobCreatorFactory.ConfigurationStatus problems();
    }

    public static class Helper {
        private static final Logger LOG = Logger.getLogger(HudsonSCM.class.getName());

        private Helper() {
        }

        public static void addTrigger(Document configXml) {
            Element root = configXml.getDocumentElement();
            root.appendChild(configXml.createElement("triggers")).appendChild(configXml.createElement("hudson.triggers.SCMTrigger")).appendChild(configXml.createElement("spec")).appendChild(configXml.createTextNode("@hourly"));
        }

        @Deprecated
        public static String xpath(String expr, Element xml) {
            return Utilities.xpath(expr, xml);
        }

        public static void noteWillShowDiff(String path) {
            StatusDisplayer.getDefault().setStatusText(Bundle.HudsonSCM_loading_diff(path));
        }

        public static void showDiff(final StreamSource before, final StreamSource after, final String path) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        DiffView view = Diff.getDefault().createDiff(before, after);
                        DiffTopComponent tc = new DiffTopComponent(view);
                        tc.setName(path);
                        tc.setDisplayName(Bundle.HudsonSCM_diffing(path.replaceFirst(".+/", "")));
                        tc.open();
                        tc.requestActive();
                    }
                    catch (IOException x) {
                        LOG.log(Level.INFO, null, x);
                    }
                }
            });
        }

        private static class DiffTopComponent
        extends TopComponent {
            DiffTopComponent(DiffView view) {
                this.setLayout(new BorderLayout());
                this.add(view.getComponent(), "Center");
            }

            public int getPersistenceType() {
                return 2;
            }

            protected String preferredID() {
                return "DiffTopComponent";
            }
        }
    }
}

