/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.netbeans.modules.hudson.spi.PasswordAuthorizer;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

public class ServletConnectionAuthenticator
implements ConnectionAuthenticator {
    private static final Logger LOGGER = Logger.getLogger(ServletConnectionAuthenticator.class.getName());
    private final Map<String, String[]> crumbs = Collections.synchronizedMap(new HashMap());

    @Override
    public void prepareRequest(URLConnection conn, URL home) {
        String[] fieldCrumb = this.crumbs.get(home.toString());
        if (fieldCrumb != null) {
            conn.setRequestProperty(fieldCrumb[0], fieldCrumb[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URLConnection forbidden(URLConnection conn, URL home) {
        for (PasswordAuthorizer aa : Lookup.getDefault().lookupAll(PasswordAuthorizer.class)) {
            String[] auth = aa.authorize(home);
            if (auth == null) continue;
            LOGGER.log(Level.FINE, "Got authorization for {0} on {1} from {2}", new Object[]{auth[0], home, aa});
            for (String realmURI : new String[]{"j_spring_security_check", "j_acegi_security_check", "j_security_check"}) {
                try {
                    LOGGER.log(Level.FINER, "Posting authentication to {0}", realmURI);
                    if (realmURI.equals("j_security_check")) {
                        new ConnectionBuilder().url(new URL(home, "loginEntry")).homeURL(home).authentication(false).connection();
                    }
                    new ConnectionBuilder().url(new URL(home, realmURI)).postData(("j_username=" + URLEncoder.encode(auth[0], "UTF-8") + "&j_password=" + URLEncoder.encode(auth[1], "UTF-8")).getBytes("UTF-8")).homeURL(home).authentication(false).connection();
                    LOGGER.log(Level.FINER, "Posted authentication to {0} worked", realmURI);
                    try {
                        InputStream is = new ConnectionBuilder().url(new URL(home, "crumbIssuer/api/xml?xpath=concat(//crumbRequestField,'=',//crumb)")).homeURL(home).connection().getInputStream();
                        try {
                            ByteArrayOutputStream baos = new ByteArrayOutputStream();
                            FileUtil.copy((InputStream)is, (OutputStream)baos);
                            String crumb = baos.toString("UTF-8");
                            String[] crumbA = crumb.split("=", 2);
                            if (crumbA.length == 2 && crumbA[0].indexOf(10) == -1) {
                                LOGGER.log(Level.FINER, "Received crumb: {0}", crumb);
                                this.crumbs.put(home.toString(), crumbA);
                            } else {
                                LOGGER.log(Level.WARNING, "Bad crumb response: {0}", crumb);
                            }
                        }
                        finally {
                            is.close();
                        }
                    }
                    catch (FileNotFoundException x) {
                        LOGGER.finer("not using crumbs");
                    }
                    return conn.getURL().openConnection();
                }
                catch (IOException x) {
                    LOGGER.log(Level.FINE, null, x);
                }
            }
        }
        return null;
    }
}

