/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.api.HudsonView;
import org.netbeans.modules.hudson.api.Utilities;
import org.netbeans.modules.hudson.impl.Bundle;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.impl.HudsonJobBuildImpl;
import org.netbeans.modules.hudson.impl.HudsonJobImpl;
import org.netbeans.modules.hudson.impl.HudsonViewImpl;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class HudsonConnector {
    private static final Logger LOG = Logger.getLogger(HudsonConnector.class.getName());
    private HudsonInstanceImpl instance;
    private HudsonVersion version;
    private boolean connected = false;
    boolean forbidden;
    private Map<String, HudsonView> cache = new HashMap<String, HudsonView>();
    private static final Map<String, Pattern> tailPatterns = new HashMap<String, Pattern>();

    public HudsonConnector(HudsonInstanceImpl instance) {
        this.instance = instance;
    }

    private boolean canUseTree(boolean authentication) {
        HudsonVersion v = this.getHudsonVersion(authentication);
        return v != null && v.compareTo(new HudsonVersion("1.367")) >= 0;
    }

    public synchronized Collection<HudsonJob> getAllJobs(boolean authentication) {
        Document docInstance = this.getDocument(this.instance.getUrl() + "api/xml" + (this.canUseTree(authentication) ? "?tree=primaryView[name],views[name,url,jobs[name]],jobs[name,url,color,displayName,buildable,inQueue,lastBuild[number],lastFailedBuild[number],lastStableBuild[number],lastSuccessfulBuild[number],lastCompletedBuild[number],modules[name,displayName,url,color]],securedJobs[name,url]" : "?depth=1&xpath=/&exclude=//assignedLabel&exclude=//primaryView/job&exclude=//view/job/url&exclude=//view/job/color&exclude=//description&exclude=//job/build&exclude=//healthReport&exclude=//firstBuild&exclude=//keepDependencies&exclude=//nextBuildNumber&exclude=//property&exclude=//action&exclude=//upstreamProject&exclude=//downstreamProject&exclude=//queueItem&exclude=//scm&exclude=//concurrentBuild&exclude=//job/lastUnstableBuild&exclude=//job/lastUnsuccessfulBuild"), authentication);
        if (null == docInstance) {
            return new ArrayList<HudsonJob>();
        }
        this.cache.clear();
        this.configureViews(this.instance, docInstance);
        return this.getJobs(docInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startJob(HudsonJob job) {
        ProgressHandle handle = ProgressHandleFactory.createHandle((String)Bundle.MSG_Starting(job.getName()));
        handle.start();
        try {
            new ConnectionBuilder().instance(this.instance).url(job.getUrl() + "build").postData("delay=0sec".getBytes("UTF-8")).followRedirects(false).connection();
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Could not start {0}: {1}", new Object[]{job, e});
        }
        finally {
            handle.finish();
        }
        this.instance.synchronize(false);
    }

    Collection<? extends HudsonJobBuild> getBuilds(HudsonJobImpl job) {
        Document docBuild = this.getDocument(job.getUrl() + "api/xml" + (this.canUseTree(true) ? "?tree=builds[number,result,building]" : "?xpath=/*/build&wrapper=root&exclude=//url"), true);
        if (docBuild == null) {
            return Collections.emptySet();
        }
        ArrayList<HudsonJobBuildImpl> builds = new ArrayList<HudsonJobBuildImpl>();
        NodeList buildNodes = docBuild.getElementsByTagName("build");
        for (int i = 0; i < buildNodes.getLength(); ++i) {
            Node build = buildNodes.item(i);
            int number = 0;
            boolean building = false;
            HudsonJobBuild.Result result = null;
            NodeList details = build.getChildNodes();
            for (int j = 0; j < details.getLength(); ++j) {
                Node detail = details.item(j);
                if (detail.getNodeType() != 1) continue;
                String nodeName = detail.getNodeName();
                Node firstChild = detail.getFirstChild();
                if (firstChild == null) {
                    LOG.log(Level.WARNING, "#170267: unexpected empty <build> child: {0}", nodeName);
                    continue;
                }
                String text = firstChild.getTextContent();
                if (nodeName.equals("number")) {
                    number = Integer.parseInt(text);
                    continue;
                }
                if (nodeName.equals("building")) {
                    building = Boolean.valueOf(text);
                    continue;
                }
                if (nodeName.equals("result")) {
                    result = HudsonJobBuild.Result.valueOf(text);
                    continue;
                }
                LOG.log(Level.WARNING, "unexpected <build> child: {0}", nodeName);
            }
            builds.add(new HudsonJobBuildImpl(this, job, number, building, result));
        }
        return builds;
    }

    void loadResult(HudsonJobBuildImpl build, AtomicBoolean building, AtomicReference<HudsonJobBuild.Result> result) {
        Element buildingEl;
        Document doc = this.getDocument(build.getUrl() + "api/xml" + "?xpath=/*/*[name()='result'%20or%20name()='building']&wrapper=root", true);
        if (doc == null) {
            return;
        }
        Element docEl = doc.getDocumentElement();
        Element resultEl = XMLUtil.findElement((Element)docEl, (String)"result", null);
        if (resultEl != null) {
            result.set(HudsonJobBuild.Result.valueOf(XMLUtil.findText((Node)resultEl)));
        }
        if ((buildingEl = XMLUtil.findElement((Element)docEl, (String)"building", null)) != null) {
            building.set(Boolean.parseBoolean(XMLUtil.findText((Node)buildingEl)));
        }
    }

    @CheckForNull
    protected synchronized HudsonVersion getHudsonVersion(boolean authentication) {
        if (this.version == null) {
            this.version = this.retrieveHudsonVersion(authentication);
        }
        return this.version;
    }

    protected boolean isConnected() {
        return this.connected;
    }

    private void configureViews(HudsonInstanceImpl instance, Document doc) {
        Element nameEl;
        String primaryViewName = null;
        Element primaryViewEl = XMLUtil.findElement((Element)doc.getDocumentElement(), (String)"primaryView", null);
        if (primaryViewEl != null && (nameEl = XMLUtil.findElement((Element)primaryViewEl, (String)"name", null)) != null) {
            primaryViewName = XMLUtil.findText((Node)nameEl);
        }
        ArrayList<HudsonView> views = new ArrayList<HudsonView>();
        HudsonViewImpl primaryView = null;
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!n.getNodeName().equals("view")) continue;
            String name = null;
            String url = null;
            boolean isPrimary = false;
            for (int j = 0; j < n.getChildNodes().getLength(); ++j) {
                Node o = n.getChildNodes().item(j);
                if (o.getNodeType() != 1) continue;
                if (o.getNodeName().equals("name")) {
                    name = o.getFirstChild().getTextContent();
                    isPrimary = name.equals(primaryViewName);
                    continue;
                }
                if (!o.getNodeName().equals("url")) continue;
                url = this.normalizeUrl(o.getFirstChild().getTextContent(), isPrimary ? "" : "view/[^/]+/");
            }
            if (null == name || null == url) continue;
            Element docView = (Element)n;
            HudsonViewImpl view = new HudsonViewImpl(instance, name, url);
            NodeList jobsList = docView.getElementsByTagName("job");
            for (int k = 0; k < jobsList.getLength(); ++k) {
                Node d = jobsList.item(k);
                for (int l = 0; l < d.getChildNodes().getLength(); ++l) {
                    Node e = d.getChildNodes().item(l);
                    if (e.getNodeType() != 1) continue;
                    String nodeName = e.getNodeName();
                    if (nodeName.equals("name")) {
                        this.cache.put(view.getName() + "/" + e.getFirstChild().getTextContent(), view);
                        continue;
                    }
                    LOG.log(Level.FINE, "unexpected view <job> child: {0}", nodeName);
                }
            }
            views.add(view);
            if (!isPrimary) continue;
            primaryView = view;
        }
        instance.setViews(views, primaryView);
    }

    private Collection<HudsonJob> getJobs(Document doc) {
        ArrayList<HudsonJob> jobs = new ArrayList<HudsonJob>();
        NodeList nodes = doc.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            boolean secured = n.getNodeName().equals("securedJob");
            if (!n.getNodeName().equals("job") && !secured) continue;
            HudsonJobImpl job = new HudsonJobImpl(this.instance);
            if (secured) {
                job.putProperty("job_color", (Object)HudsonJob.Color.secured);
            }
            NodeList jobDetails = n.getChildNodes();
            for (int k = 0; k < jobDetails.getLength(); ++k) {
                Node d = jobDetails.item(k);
                if (d.getNodeType() != 1) continue;
                String nodeName = d.getNodeName();
                if (nodeName.equals("name")) {
                    job.putProperty("job_name", d.getFirstChild().getTextContent());
                    continue;
                }
                if (nodeName.equals("url")) {
                    job.putProperty("job_url", this.normalizeUrl(d.getFirstChild().getTextContent(), "job/[^/]+/"));
                    continue;
                }
                if (nodeName.equals("color")) {
                    job.putProperty("job_color", (Object)HudsonJob.Color.find(d.getFirstChild().getTextContent().trim()));
                    continue;
                }
                if (nodeName.equals("displayName")) {
                    job.putProperty("job_display_name", d.getFirstChild().getTextContent());
                    continue;
                }
                if (nodeName.equals("buildable")) {
                    job.putProperty("job_buildable", Boolean.valueOf(d.getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("inQueue")) {
                    job.putProperty("job_in_queue", Boolean.valueOf(d.getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastBuild")) {
                    job.putProperty("job_last_build", Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastFailedBuild")) {
                    job.putProperty("job_last_failed_build", Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastStableBuild")) {
                    job.putProperty("job_last_stable_build", Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastSuccessfulBuild")) {
                    job.putProperty("job_last_successful_build", Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("lastCompletedBuild")) {
                    job.putProperty("job_last_completed_build", Integer.valueOf(d.getFirstChild().getFirstChild().getTextContent()));
                    continue;
                }
                if (nodeName.equals("module")) {
                    String name = null;
                    String displayName = null;
                    String url = null;
                    HudsonJob.Color color = null;
                    NodeList moduleDetails = d.getChildNodes();
                    for (int j = 0; j < moduleDetails.getLength(); ++j) {
                        Node n2 = moduleDetails.item(j);
                        if (n2.getNodeType() != 1) continue;
                        String nodeName2 = n2.getNodeName();
                        Node firstChild = n2.getFirstChild();
                        if (firstChild != null) {
                            String text = firstChild.getTextContent();
                            if (nodeName2.equals("name")) {
                                name = text;
                                continue;
                            }
                            if (nodeName2.equals("displayName")) {
                                displayName = text;
                                continue;
                            }
                            if (nodeName2.equals("url")) {
                                url = this.normalizeUrl(text, "job/[^/]+/[^/]+/");
                                continue;
                            }
                            if (nodeName2.equals("color")) {
                                color = HudsonJob.Color.find(text);
                                continue;
                            }
                            LOG.log(Level.FINE, "unexpected <module> child: {0}", nodeName);
                            continue;
                        }
                        LOG.log(Level.FINE, "#178360: unexpected empty <module> child: {0}", nodeName);
                    }
                    if (name != null && url != null && color != null) {
                        if (displayName == null) {
                            LOG.log(Level.FINE, "#202671: missing displayName in {0}", job);
                            displayName = name;
                        }
                        job.addModule(name, displayName, color, url);
                        continue;
                    }
                    LOG.log(Level.FINE, "#202671: missing name/url/color in {0}", job);
                    continue;
                }
                LOG.log(Level.FINE, "unexpected global <job> child: {0}", nodeName);
            }
            for (HudsonView v : this.instance.getViews()) {
                if (!secured && null == this.cache.get(v.getName() + "/" + job.getName())) continue;
                job.addView(v);
            }
            jobs.add(job);
        }
        return jobs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String normalizeUrl(String suggested, String relativePattern) {
        Pattern tailPattern;
        Map<String, Pattern> map = tailPatterns;
        synchronized (map) {
            tailPattern = tailPatterns.get(relativePattern);
            if (tailPattern == null) {
                tailPattern = Pattern.compile(".+/(" + relativePattern + ")");
                tailPatterns.put(relativePattern, tailPattern);
            }
        }
        Matcher m = tailPattern.matcher(suggested);
        if (m.matches()) {
            String result = this.instance.getUrl() + m.group(1);
            if (!result.equals(suggested)) {
                LOG.log(Level.FINER, "Normalizing {0} -> {1}", new Object[]{suggested, result});
            }
            return result;
        }
        LOG.log(Level.WARNING, "Anomalous URL {0} not ending with {1} from {2}", new Object[]{suggested, relativePattern, this.instance});
        return suggested;
    }

    @CheckForNull
    private synchronized HudsonVersion retrieveHudsonVersion(boolean authentication) {
        HudsonVersion v = null;
        try {
            String sVersion = new ConnectionBuilder().instance(this.instance).url(this.instance.getUrl()).authentication(authentication).httpConnection().getHeaderField("X-Hudson");
            if (sVersion != null) {
                v = new HudsonVersion(sVersion);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return v;
    }

    Document getDocument(String url, boolean authentication) {
        Document doc;
        block6: {
            this.forbidden = false;
            doc = null;
            try {
                HttpURLConnection conn = new ConnectionBuilder().instance(this.instance).url(url).authentication(authentication).httpConnection();
                if (!this.isConnected()) {
                    this.connected = true;
                    this.version = this.retrieveHudsonVersion(authentication);
                }
                InputStream stream = conn.getInputStream();
                InputSource source = new InputSource(stream);
                source.setSystemId(url);
                doc = XMLUtil.parse((InputSource)source, (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
                if (!Utilities.isSupportedVersion(this.getHudsonVersion(authentication))) {
                    HudsonVersion v = this.retrieveHudsonVersion(authentication);
                    if (!Utilities.isSupportedVersion(v)) {
                        return null;
                    }
                    this.version = v;
                }
                conn.disconnect();
            }
            catch (SAXParseException x) {
            }
            catch (Exception x) {
                LOG.log(Level.FINE, url, x);
                if (authentication || !(x instanceof HttpRetryException) || ((HttpRetryException)x).responseCode() != 403) break block6;
                this.forbidden = true;
            }
        }
        return doc;
    }
}

