/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.awt.EventQueue;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpRetryException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.hudson.api.Bundle;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.ConnectionAuthenticator;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class ConnectionBuilder {
    private static final Logger LOG = Logger.getLogger(ConnectionBuilder.class.getName());
    private static final RequestProcessor TIMER = new RequestProcessor(ConnectionBuilder.class.getName() + ".TIMER");
    private static final Set<String> authenticationRejected = new HashSet<String>();
    private static final Map<String, String[]> COOKIES = new HashMap<String, String[]>();
    private URL home;
    private URL url;
    private final Map<String, String> requestHeaders = new LinkedHashMap<String, String>();
    private byte[] postData;
    private int timeout;
    private boolean auth = true;
    private boolean followRedirects = true;

    public ConnectionBuilder url(URL url) {
        this.url = url;
        return this;
    }

    public ConnectionBuilder url(String url) throws MalformedURLException {
        return this.url(new URL(url));
    }

    public ConnectionBuilder homeURL(URL url) {
        this.home = url;
        return this;
    }

    public ConnectionBuilder instance(HudsonInstance instance) {
        try {
            this.home = new URL(instance.getUrl());
        }
        catch (MalformedURLException x) {
            LOG.warning(x.toString());
        }
        return this;
    }

    public ConnectionBuilder job(HudsonJob job) {
        HudsonInstance instance = job.getInstance();
        if (instance != null) {
            this.instance(instance);
        }
        return this;
    }

    public ConnectionBuilder header(String key, String value) {
        this.requestHeaders.put(key, value);
        return this;
    }

    @SuppressWarnings(value={"EI_EXPOSE_REP2"})
    public ConnectionBuilder postData(byte[] data) {
        this.postData = data;
        return this;
    }

    public ConnectionBuilder timeout(int milliseconds) {
        this.timeout = milliseconds;
        return this;
    }

    public ConnectionBuilder authentication(boolean a) {
        this.auth = a;
        return this;
    }

    public ConnectionBuilder followRedirects(boolean fr) {
        this.followRedirects = fr;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URLConnection connection() throws IOException {
        if (this.url == null) {
            throw new IllegalArgumentException("You must call the url method!");
        }
        if (this.url.getProtocol().matches("https?") && EventQueue.isDispatchThread()) {
            throw new IOException("#184196: refusing to open " + this.url + " from EQ");
        }
        if (this.timeout == 0) {
            return this.doConnection();
        }
        final Thread curr = Thread.currentThread();
        RequestProcessor.Task task = TIMER.post(new Runnable(){

            @Override
            public void run() {
                curr.interrupt();
            }
        }, this.timeout);
        try {
            URLConnection uRLConnection = this.doConnection();
            return uRLConnection;
        }
        finally {
            task.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private URLConnection doConnection() throws IOException {
        URLConnection conn = this.url.openConnection();
        block17: while (true) {
            List<String> cookies;
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setInstanceFollowRedirects(false);
            }
            if (conn instanceof HttpsURLConnection) {
                try {
                    SSLContext sc = SSLContext.getInstance("SSL");
                    sc.init(null, new TrustManager[]{new X509TrustManager(){

                        @Override
                        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                        }

                        @Override
                        public X509Certificate[] getAcceptedIssuers() {
                            return new X509Certificate[0];
                        }
                    }}, new SecureRandom());
                    ((HttpsURLConnection)conn).setSSLSocketFactory(sc.getSocketFactory());
                    ((HttpsURLConnection)conn).setHostnameVerifier(new HostnameVerifier(){

                        @Override
                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                catch (Exception x) {
                    LOG.log(Level.FINE, "could not disable SSL verification", x);
                }
            }
            URL curr = conn.getURL();
            LOG.log(Level.FINER, "Trying to open {0}", curr);
            if (this.home != null) {
                for (ConnectionAuthenticator connectionAuthenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                    connectionAuthenticator.prepareRequest(conn, this.home);
                }
                if (COOKIES.containsKey(this.home.toString())) {
                    for (String cookie : COOKIES.get(this.home.toString())) {
                        String cookieBare = cookie.replaceFirst(";.*", "");
                        LOG.log(Level.FINER, "Setting cookie {0} for {1}", new Object[]{cookieBare, conn.getURL()});
                        conn.setRequestProperty("Cookie", cookieBare);
                    }
                }
            }
            if (this.postData != null) {
                conn.setDoOutput(true);
            }
            for (Map.Entry entry : this.requestHeaders.entrySet()) {
                conn.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            try {
                conn.connect();
            }
            catch (IOException x) {
                throw x;
            }
            catch (Exception x) {
                throw new IOException("Connecting to " + curr + ": " + x, x);
            }
            if (this.postData != null) {
                OutputStream os = conn.getOutputStream();
                try {
                    os.write(this.postData);
                }
                finally {
                    os.close();
                }
            }
            if (!(conn instanceof HttpURLConnection)) break;
            if (this.home != null && (cookies = conn.getHeaderFields().get("Set-Cookie")) != null) {
                LOG.log(Level.FINE, "Cookies set for domain {0}: {1}", new Object[]{this.home, cookies});
                COOKIES.put(this.home.toString(), cookies.toArray(new String[cookies.size()]));
            }
            int responseCode = ((HttpURLConnection)conn).getResponseCode();
            LOG.log(Level.FINER, "  => {0}", responseCode);
            switch (responseCode) {
                case 301: 
                case 302: {
                    if (!this.followRedirects) break block17;
                    URL uRL = new URL(conn.getHeaderField("Location"));
                    conn = uRL.openConnection();
                    continue block17;
                }
                case 403: {
                    if (this.auth && this.home != null) {
                        Set<String> i$ = authenticationRejected;
                        synchronized (i$) {
                            if (!authenticationRejected.contains(this.home.toString())) {
                                for (ConnectionAuthenticator authenticator : Lookup.getDefault().lookupAll(ConnectionAuthenticator.class)) {
                                    URLConnection retry = authenticator.forbidden(conn, this.home);
                                    if (retry == null) continue;
                                    LOG.log(Level.FINER, "Retrying after auth from {0}", authenticator);
                                    conn = retry;
                                    // MONITOREXIT @DISABLED, blocks:[17, 3, 4, 21, 5, 22, 23, 7] lbl79 : MonitorExitStatement: MONITOREXIT : i$
                                    continue block17;
                                }
                                authenticationRejected.add(this.home.toString());
                            }
                        }
                    }
                    HttpRetryException x = new HttpRetryException("403 on " + this.url, responseCode);
                    Exceptions.attachLocalizedMessage((Throwable)x, (String)Bundle.ConnectionBuilder_log_in(this.url));
                    throw x;
                }
                case 404: {
                    throw new FileNotFoundException(curr.toString());
                }
                case 200: {
                    break block17;
                }
                default: {
                    throw new HttpRetryException("Server rejected connection to " + curr + " with code " + responseCode, responseCode);
                }
            }
            break;
        }
        return conn;
    }

    public HttpURLConnection httpConnection() throws IOException {
        URLConnection c = this.connection();
        if (c instanceof HttpURLConnection) {
            return (HttpURLConnection)c;
        }
        throw new IOException("Not an HTTP connection: " + c);
    }

    public Document parseXML() throws IOException {
        URLConnection c = this.connection();
        InputSource source = new InputSource(this.url.toString());
        source.setByteStream(c.getInputStream());
        try {
            return XMLUtil.parse((InputSource)source, (boolean)false, (boolean)false, (ErrorHandler)XMLUtil.defaultErrorHandler(), null);
        }
        catch (SAXException x) {
            throw new IOException(x);
        }
    }
}

