/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.completion;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.text.JTextComponent;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.netbeans.modules.db.metadata.model.api.Tuple;
import org.netbeans.modules.db.metadata.model.api.View;
import org.netbeans.modules.db.sql.analyzer.QualIdent;
import org.netbeans.modules.db.sql.editor.api.completion.SQLCompletionResultSet;
import org.netbeans.modules.db.sql.editor.api.completion.SubstitutionHandler;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;

public class SQLCompletionItems
implements Iterable<SQLCompletionItem> {
    private final List<SQLCompletionItem> items = new ArrayList<SQLCompletionItem>();
    private final SQLIdentifiers.Quoter quoter;
    private final SubstitutionHandler substitutionHandler;

    public SQLCompletionItems(SQLIdentifiers.Quoter quoter, SubstitutionHandler substitutionHandler) {
        this.quoter = quoter;
        this.substitutionHandler = substitutionHandler;
    }

    public void addKeywords(String prefix, int substitutionOffset, String ... keywords) {
        for (String keyword : keywords) {
            if (!SQLCompletionItems.filter(keyword, prefix)) continue;
            this.items.add(SQLCompletionItem.keyword(keyword, substitutionOffset, this.substitutionHandler));
        }
    }

    public Set<String> addCatalogs(Metadata metadata, Set<String> restrict, String prefix, final boolean quote, final int substitutionOffset) {
        TreeSet<String> result = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(metadata.getCatalogs(), restrict, prefix, new Handler<Catalog>(){

            @Override
            public void handle(Catalog catalog) {
                String catalogName = catalog.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.catalog(catalogName, SQLCompletionItems.this.doQuote(catalogName, quote), substitutionOffset, SQLCompletionItems.this.substitutionHandler));
            }
        });
        return result;
    }

    public Set<String> addSchemas(Catalog catalog, Set<String> restrict, String prefix, final boolean quote, final int substitutionOffset) {
        TreeSet<String> result = new TreeSet<String>();
        SQLCompletionItems.filterMetadata(catalog.getSchemas(), restrict, prefix, new Handler<Schema>(){

            @Override
            public void handle(Schema schema) {
                if (!schema.isSynthetic()) {
                    String schemaName = schema.getName();
                    SQLCompletionItems.this.items.add(SQLCompletionItem.schema(schemaName, SQLCompletionItems.this.doQuote(schemaName, quote), substitutionOffset, SQLCompletionItems.this.substitutionHandler));
                }
            }
        });
        return result;
    }

    public void addTables(Schema schema, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addTables(schema, null, restrict, prefix, quote, substitutionOffset, false);
    }

    public void addTablesAtInsertInto(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addTables(schema, fullyTypedIdent, restrict, prefix, quote, substitutionOffset, true);
    }

    private void addTables(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, final boolean quote, int substitutionOffset, final boolean ownHandler) {
        final String schema4display = fullyTypedIdent == null ? "" : fullyTypedIdent.getSimpleName() + '.';
        final int ownOffset = fullyTypedIdent == null ? substitutionOffset : substitutionOffset - (fullyTypedIdent.getSimpleName().length() + 1);
        SQLCompletionItems.filterMetadata(schema.getTables(), restrict, prefix, new Handler<Table>(){

            @Override
            public void handle(Table table) {
                String tableName = table.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.table(tableName, SQLCompletionItems.this.doQuote(tableName, quote), ownOffset, ownHandler ? new ExtendedSubstitutionHandler(SQLCompletionItems.this.substitutionHandler, schema4display, " (") : SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void addViews(Schema schema, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addViews(schema, null, restrict, prefix, quote, substitutionOffset, false);
    }

    public void addViewsAtInsertInto(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, boolean quote, int substitutionOffset) {
        this.addViews(schema, fullyTypedIdent, restrict, prefix, quote, substitutionOffset, true);
    }

    private void addViews(Schema schema, QualIdent fullyTypedIdent, Set<String> restrict, String prefix, final boolean quote, int substitutionOffset, final boolean ownHandler) {
        final String schema4display = fullyTypedIdent == null ? "" : fullyTypedIdent.getSimpleName() + '.';
        final int ownOffset = fullyTypedIdent == null ? substitutionOffset : substitutionOffset - (fullyTypedIdent.getSimpleName().length() + 1);
        SQLCompletionItems.filterMetadata(schema.getViews(), restrict, prefix, new Handler<View>(){

            @Override
            public void handle(View view) {
                String viewName = view.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.view(viewName, SQLCompletionItems.this.doQuote(viewName, quote), ownOffset, ownHandler ? new ExtendedSubstitutionHandler(SQLCompletionItems.this.substitutionHandler, schema4display, " (") : SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void addAliases(Map<String, QualIdent> aliases, String prefix, boolean quote, final int substitutionOffset) {
        SQLCompletionItems.filterMap(aliases, null, prefix, new ParamHandler<String, QualIdent>(){

            @Override
            public void handle(String alias, QualIdent tableName) {
                SQLCompletionItems.this.items.add(SQLCompletionItem.alias(alias, tableName, alias, substitutionOffset, SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void addColumnsWithTupleName(Tuple tuple, QualIdent fullyTypedIdent, String prefix, boolean quote, int substitutionOffset) {
        this.addColumns(tuple, fullyTypedIdent, prefix, quote, substitutionOffset, true);
    }

    public void addColumns(Tuple tuple, String prefix, boolean quote, int substitutionOffset) {
        this.addColumns(tuple, null, prefix, quote, substitutionOffset, false);
    }

    private void addColumns(final Tuple tuple, QualIdent fullyTypedIdent, String prefix, final boolean quote, int substitutionOffset, final boolean ownHandler) {
        Schema schema = tuple.getParent();
        Catalog catalog = schema.getParent();
        ArrayList<String> parts = new ArrayList<String>(3);
        if (!catalog.isDefault()) {
            parts.add(catalog.getName());
        }
        if (!schema.isSynthetic() && !schema.isDefault()) {
            parts.add(schema.getName());
        }
        parts.add(tuple.getName());
        final QualIdent qualTableName = new QualIdent(parts);
        final String table4display = fullyTypedIdent == null ? tuple.getName() : fullyTypedIdent.getFirstQualifier() + '.' + fullyTypedIdent.getSecondQualifier();
        final int ownOffset = fullyTypedIdent == null ? substitutionOffset : substitutionOffset - (fullyTypedIdent.getFirstQualifier().length() + fullyTypedIdent.getSecondQualifier().length() + 2);
        SQLCompletionItems.filterMetadata(tuple.getColumns(), null, prefix, new Handler<Column>(){

            @Override
            public void handle(Column column) {
                String columnName = column.getName();
                SQLCompletionItems.this.items.add(SQLCompletionItem.column(tuple instanceof View, qualTableName, columnName, SQLCompletionItems.this.doQuote(columnName, quote), ownOffset, ownHandler ? new ExtendedSubstitutionHandler(SQLCompletionItems.this.substitutionHandler, table4display + " (", null) : SQLCompletionItems.this.substitutionHandler));
            }
        });
    }

    public void fill(CompletionResultSet resultSet) {
        resultSet.addAllItems(this.items);
    }

    public void fill(SQLCompletionResultSet resultSet) {
        resultSet.addAllItems(this.items);
    }

    @Override
    public Iterator<SQLCompletionItem> iterator() {
        return this.items.iterator();
    }

    private String doQuote(String identifier, boolean always) {
        if (always) {
            return this.quoter.quoteAlways(identifier);
        }
        return this.quoter.quoteIfNeeded(identifier);
    }

    private static boolean startsWithIgnoreCase(String text, String prefix) {
        return text.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private static boolean filter(String string, String prefix) {
        return prefix == null || SQLCompletionItems.startsWithIgnoreCase(string, prefix);
    }

    private static <P> void filterMap(Map<String, P> strings, Set<String> restrict, String prefix, ParamHandler<String, P> handler) {
        for (Map.Entry<String, P> entry : strings.entrySet()) {
            String string = entry.getKey();
            if (restrict != null && !restrict.contains(string) || !SQLCompletionItems.filter(string, prefix)) continue;
            handler.handle(string, entry.getValue());
        }
    }

    private static <T extends MetadataElement> void filterMetadata(Collection<T> elements, Set<String> restrict, String prefix, Handler<T> handler) {
        for (MetadataElement element : elements) {
            String name = element.getName();
            if (name == null || restrict != null && !restrict.contains(name) || !SQLCompletionItems.filter(name, prefix)) continue;
            handler.handle(element);
        }
    }

    private static final class ExtendedSubstitutionHandler
    implements SubstitutionHandler {
        private final SubstitutionHandler original;
        private final String prefix;
        private final String postfix;

        public ExtendedSubstitutionHandler(SubstitutionHandler handler, String prefix, String postfix) {
            this.original = handler;
            this.prefix = prefix == null ? "" : prefix;
            this.postfix = postfix == null ? "" : postfix;
        }

        @Override
        public void substituteText(JTextComponent component, int offset, String text) {
            this.original.substituteText(component, offset, this.prefix + text + this.postfix);
        }
    }

    private static interface Handler<T> {
        public void handle(T var1);
    }

    private static interface ParamHandler<T, P> {
        public void handle(T var1, P var2);
    }
}

