/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.db.sql.editor.completion.SQLCompletionEnv;
import org.netbeans.modules.db.sql.lexer.SQLLexer;
import org.netbeans.modules.db.sql.lexer.SQLTokenId;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class SQLTypedTextInterceptor
implements TypedTextInterceptor {
    public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
        return false;
    }

    public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
    }

    public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
        final Document doc = context.getDocument();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Character nextChar;
                int caretOffset = context.getOffset();
                String str = context.getText();
                try {
                    nextChar = Character.valueOf(doc.getText(caretOffset + str.length(), 1).charAt(0));
                }
                catch (BadLocationException ex) {
                    nextChar = null;
                }
                if (!str.isEmpty()) {
                    char insertedChar = str.charAt(str.length() - 1);
                    if (SQLLexer.isStartIdentifierQuoteChar(insertedChar) && (nextChar == null || Character.isWhitespace(nextChar.charValue()) || nextChar.equals(Character.valueOf('.'))) || SQLLexer.isStartStringQuoteChar(insertedChar) && (nextChar == null || Character.isWhitespace(nextChar.charValue()))) {
                        if (SQLTypedTextInterceptor.canCompleteQuote(doc, caretOffset)) {
                            try {
                                doc.insertString(caretOffset + str.length(), String.valueOf((char)SQLLexer.getMatchingQuote(insertedChar)), null);
                                context.getComponent().getCaret().setDot(caretOffset + str.length());
                            }
                            catch (BadLocationException ex) {}
                        }
                    } else if (insertedChar == '(' && (nextChar == null || Character.isWhitespace(nextChar.charValue())) && SQLTypedTextInterceptor.canCompleteBrace(doc, caretOffset)) {
                        try {
                            doc.insertString(caretOffset + str.length(), ")", null);
                            context.getComponent().getCaret().setDot(caretOffset + str.length());
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).runAtomic(r);
        } else {
            r.run();
        }
    }

    private static boolean canCompleteQuote(Document doc, int caretOffset) {
        SQLCompletionEnv env = SQLCompletionEnv.forDocument(doc, caretOffset);
        TokenSequence<SQLTokenId> seq = env.getTokenSequence();
        if (seq.move(caretOffset) == 0 && seq.movePrevious()) {
            switch ((SQLTokenId)seq.token().id()) {
                case WHITESPACE: 
                case DOT: {
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean canCompleteBrace(Document doc, int caretOffset) {
        SQLCompletionEnv env = SQLCompletionEnv.forDocument(doc, caretOffset);
        TokenSequence<SQLTokenId> seq = env.getTokenSequence();
        if (seq.move(caretOffset) == 0 && seq.movePrevious()) {
            switch ((SQLTokenId)seq.token().id()) {
                case WHITESPACE: {
                    return true;
                }
            }
        }
        return false;
    }

    public void cancelled(TypedTextInterceptor.Context context) {
    }

    public static class Factory
    implements TypedTextInterceptor.Factory {
        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return new SQLTypedTextInterceptor();
        }
    }
}

